/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client.relationships;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.AbstractSubjectAreaRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationshipClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationshipClients;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOfDeprecated;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.reflections.Reflections;

public class SubjectAreaRelationship
implements SubjectAreaRelationshipClients {
    private static final String HAS_A = "has-as";
    private static final String RELATED_TERM = "related-terms";
    private static final String SYNONYM = "synonyms";
    private static final String ANTONYM = "antonyms";
    private static final String TRANSLATION = "translations";
    private static final String USED_IN_CONTEXT = "used-in-contexts";
    private static final String PREFERRED_TERM = "preferred-terms";
    private static final String VALID_VALUE = "valid-values";
    private static final String REPLACEMENT_TERM = "replacement-terms";
    private static final String TYPED_BY = "typed-bys";
    private static final String IS_A = "is-as";
    private static final String IS_A_TYPE_OF_DEPRECATED = "is-a-type-of-deprecateds";
    private static final String IS_A_TYPE_OF = "is-a-type-ofs";
    private static final String TERM_CATEGORIZATION = "term-categorizations";
    private static final String SEMANTIC_ASSIGNMENT = "semantic-assignments";
    private static final String TERM_ANCHOR = "term-anchor";
    private static final String CATEGORY_ANCHOR = "category-anchor";
    private static final String PROJECT_SCOPE = "project-scopes";
    private static final String CATEGORY_HIERARCHY_LINK = "category-hierarchy-link";
    private final Map<Class<?>, org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient> cache = new HashMap();
    private static final String DEFAULT_SCAN_PACKAGE = SubjectAreaRelationship.class.getPackage().getName();

    public SubjectAreaRelationship(SubjectAreaRestClient subjectAreaRestClient, String ... packagesToScan) {
        HashSet<String> packages = new HashSet<String>(Arrays.asList(packagesToScan));
        packages.add(DEFAULT_SCAN_PACKAGE);
        Reflections reflections = new Reflections(new Object[]{packages});
        Set clientClasses = reflections.getTypesAnnotatedWith(SubjectAreaRelationshipClient.class);
        for (Class declaredClass : clientClasses) {
            try {
                if (!AbstractSubjectAreaRelationship.class.isAssignableFrom(declaredClass)) continue;
                Constructor ctor = declaredClass.getDeclaredConstructor(SubjectAreaRestClient.class);
                ctor.setAccessible(true);
                AbstractSubjectAreaRelationship newInstance = (AbstractSubjectAreaRelationship)ctor.newInstance(new Object[]{subjectAreaRestClient});
                this.cache.put(newInstance.resultType(), newInstance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExceptionInInitializerError("During initialization `SubjectArearelationship` an error has occurred - " + e.getMessage());
            }
        }
    }

    public SubjectAreaRelationship(SubjectAreaRestClient subjectAreaRestClient) {
        this(subjectAreaRestClient, DEFAULT_SCAN_PACKAGE);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient hasA() {
        return this.getClient(HasA.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient relatedTerm() {
        return this.getClient(RelatedTerm.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient termAnchor() {
        return this.getClient(TermAnchor.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient projectScope() {
        return this.getClient(ProjectScope.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient synonym() {
        return this.getClient(Synonym.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient antonym() {
        return this.getClient(Antonym.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient translation() {
        return this.getClient(Translation.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient usedInContext() {
        return this.getClient(UsedInContext.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient preferredTerm() {
        return this.getClient(PreferredTerm.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient validValue() {
        return this.getClient(ValidValue.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient replacementTerm() {
        return this.getClient(ReplacementTerm.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient typedBy() {
        return this.getClient(TypedBy.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient isA() {
        return this.getClient(IsA.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient isaTypeOfDeprecated() {
        return this.getClient(IsATypeOfDeprecated.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient isATypeOf() {
        return this.getClient(IsATypeOf.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient termCategorization() {
        return this.getClient(Categorization.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient semanticAssignment() {
        return this.getClient(SemanticAssignment.class);
    }

    @Override
    public SubjectAreaClient<CategoryHierarchyLink> categoryHierarchyLink() {
        return this.getClient(CategoryHierarchyLink.class);
    }

    public org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient categoryAnchor() {
        return this.getClient(CategoryAnchor.class);
    }

    public <T extends Relationship> org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRelationshipClient getClient(Class<T> clazz) {
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.NOT_FOUND_CLIENT.getMessageDefinition(new String[]{clazz.getName()});
        SubjectAreaCheckedException exc = new SubjectAreaCheckedException(messageDefinition, this.getClass().getName(), messageDefinition.getSystemAction());
        throw new IllegalArgumentException((Throwable)exc);
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaProjectScopeClient
    extends AbstractSubjectAreaRelationship<ProjectScope> {
        protected SubjectAreaProjectScopeClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.PROJECT_SCOPE);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaIsATypeOfClient
    extends AbstractSubjectAreaRelationship<IsATypeOf> {
        protected SubjectAreaIsATypeOfClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.IS_A_TYPE_OF);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaIsaTypeOfDeprecatedClient
    extends AbstractSubjectAreaRelationship<IsATypeOfDeprecated> {
        protected SubjectAreaIsaTypeOfDeprecatedClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.IS_A_TYPE_OF_DEPRECATED);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaIsaClient
    extends AbstractSubjectAreaRelationship<IsA> {
        protected SubjectAreaIsaClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.IS_A);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaTypedByClient
    extends AbstractSubjectAreaRelationship<TypedBy> {
        protected SubjectAreaTypedByClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.TYPED_BY);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaSemanticAssignmentClient
    extends AbstractSubjectAreaRelationship<SemanticAssignment> {
        protected SubjectAreaSemanticAssignmentClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.SEMANTIC_ASSIGNMENT);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaReplacementTermClient
    extends AbstractSubjectAreaRelationship<ReplacementTerm> {
        protected SubjectAreaReplacementTermClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.REPLACEMENT_TERM);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaValidValueClient
    extends AbstractSubjectAreaRelationship<ValidValue> {
        protected SubjectAreaValidValueClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.VALID_VALUE);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaPreferredTermClient
    extends AbstractSubjectAreaRelationship<PreferredTerm> {
        protected SubjectAreaPreferredTermClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.PREFERRED_TERM);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaUsedInContextClient
    extends AbstractSubjectAreaRelationship<UsedInContext> {
        protected SubjectAreaUsedInContextClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.USED_IN_CONTEXT);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaTranslationClient
    extends AbstractSubjectAreaRelationship<Translation> {
        protected SubjectAreaTranslationClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.TRANSLATION);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaCategorizationClient
    extends AbstractSubjectAreaRelationship<Categorization> {
        protected SubjectAreaCategorizationClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.TERM_CATEGORIZATION);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaCategoryAnchorClient
    extends AbstractSubjectAreaRelationship<CategoryAnchor> {
        protected SubjectAreaCategoryAnchorClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.CATEGORY_ANCHOR);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaAntonymClient
    extends AbstractSubjectAreaRelationship<Antonym> {
        protected SubjectAreaAntonymClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.ANTONYM);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaSynonymClient
    extends AbstractSubjectAreaRelationship<Synonym> {
        protected SubjectAreaSynonymClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.SYNONYM);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaHasaClient
    extends AbstractSubjectAreaRelationship<HasA> {
        protected SubjectAreaHasaClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.HAS_A);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaRelatedTermClient
    extends AbstractSubjectAreaRelationship<RelatedTerm> {
        protected SubjectAreaRelatedTermClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.RELATED_TERM);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaTermAnchorClient
    extends AbstractSubjectAreaRelationship<TermAnchor> {
        protected SubjectAreaTermAnchorClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.TERM_ANCHOR);
        }
    }

    @SubjectAreaRelationshipClient
    static class SubjectAreaCategoryHierarchyLinkClient
    extends AbstractSubjectAreaRelationship<CategoryHierarchyLink> {
        protected SubjectAreaCategoryHierarchyLinkClient(SubjectAreaRestClient subjectAreaRestClient) {
            super(subjectAreaRestClient, SubjectAreaRelationship.CATEGORY_HIERARCHY_LINK);
        }
    }
}

