/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryParams;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResponseParameterization;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public abstract class AbstractSubjectArea<T>
implements SubjectAreaClient<T>,
ResponseParameterization<T> {
    public static final String SUBJECT_AREA_BASE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/";
    public static final String BASE_RELATIONSHIPS_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships";
    protected final String BASE_URL;
    protected final SubjectAreaRestClient client;

    protected AbstractSubjectArea(SubjectAreaRestClient client, String baseUrl) {
        this.BASE_URL = baseUrl;
        this.client = client;
    }

    @Override
    public T getByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = this.BASE_URL + "/%s";
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, this.getMethodInfo("getByGUID"), this.getParameterizedType(), urlTemplate);
        return response.head().get();
    }

    @Override
    public T create(String userId, T supplied) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GenericResponse<T> response = this.client.postRESTCall(userId, this.getMethodInfo("create"), this.BASE_URL, this.getParameterizedType(), supplied);
        return response.head().get();
    }

    @Override
    public List<T> find(String userId, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.find(userId, findRequest, false, true);
    }

    @Override
    public List<T> find(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.find(userId, findRequest, exactValue, ignoreCase, null);
    }

    @Override
    public List<T> find(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase, Integer maximumPageSizeOnRestCall) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        QueryParams queryParams = new QueryParams().setExactValue(exactValue).setIgnoreCase(ignoreCase);
        GenericResponse response = this.client.findRESTCall(userId, this.getMethodInfo("find"), this.BASE_URL, this.getParameterizedType(), findRequest, queryParams, maximumPageSizeOnRestCall);
        return response.results();
    }

    @Override
    public T update(String userId, String guid, T supplied, boolean isReplace) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = this.BASE_URL + "/%s?isReplace=" + Boolean.toString(isReplace);
        String methodInfo = this.getMethodInfo("update(isReplace=" + isReplace + ")");
        GenericResponse<T> response = this.client.putRESTCall(userId, guid, methodInfo, urlTemplate, this.getParameterizedType(), supplied);
        return response.head().get();
    }

    @Override
    public void delete(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = this.BASE_URL + "/%s";
        this.client.deleteRESTCall(userId, guid, this.getMethodInfo("delete()"), this.getParameterizedType(), urlTemplate);
    }

    @Override
    public T restore(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = this.BASE_URL + "/%s";
        GenericResponse response = this.client.restoreRESTCall(userId, guid, this.getMethodInfo("restore"), this.getParameterizedType(), urlTemplate);
        return response.head().get();
    }

    public Class<? extends GenericResponse> responseType() {
        return SubjectAreaOMASAPIResponse.class;
    }

    protected String getMethodInfo(String methodName) {
        return methodName + " for " + this.resultType().getSimpleName();
    }
}

