/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.samples.definition;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaImpl;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.categories.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.glossaries.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class SubjectAreaDefinitionSample {
    private static final String ORGANIZATION = "Organization";
    private static final String HOSPITAL = "Hospital";
    private static final String SUPPLIER = "Supplier";
    private static final String PERSON = "Person";
    private static final String PATIENT = "Patient";
    private static final String CLINICIAN = "Clinician";
    private static final String EMPLOYEE = "Employee";
    private static final String COLLABORATOR = "Collaborator";
    private static final String CLINICAL = "Clinical";
    private static final String SYMPTOM = "Symptom";
    private static final String MEASUREMENT = "Measurement";
    private static final String PRESCRIPTION = "Prescription";
    private static final String OUTCOME = "Outcome";
    private static final String TREATMENT = "Treatment";
    private static final String PRODUCT = "Product";
    private static final String ORDER = "Order";
    private static final String RECIPE = "Recipe";
    private static final String SERVICE_QUALITY = "Service Quality";
    private static final String CONTRACT = "Contract";
    private static final String STOCK = "Stock";
    private static final String DISTRIBUTION = "Distribution";
    private static final String INVOICE = "Invoice";
    private static final String GLOSSARY_NAME = "Coco Pharmaceuticals Subject Area Definitions";
    private static final String GLOSSARY_DESCRIPTION = "Coco Pharmaceuticals Core Subject Areas for Personalized Medicine.";
    private static final String DEFAULT_SERVER_NAME = "cocoMDS4";
    private static final String DEFAULT_USERID = "erinoverview";
    private static final String DEFAULT_URL = "https://localhost:9443";
    private String serverURLRoot;
    private String clientUserId;
    private String serverName;
    private SubjectAreaGlossary subjectAreaGlossary = null;
    private SubjectAreaCategory subjectAreaCategory = null;

    private SubjectAreaDefinitionSample(String serverURLRoot, String serverName, String clientUserId) {
        this.serverURLRoot = serverURLRoot;
        this.serverName = serverName;
        this.clientUserId = clientUserId;
    }

    private void run() throws SubjectAreaCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaImpl subjectArea = new SubjectAreaImpl(this.serverName, this.serverURLRoot);
        this.subjectAreaGlossary = subjectArea.getSubjectAreaGlossary();
        this.subjectAreaCategory = subjectArea.getSubjectAreaCategory();
        System.out.println("----------------------------");
        System.out.println("Creating the Coco Pharmaceutical Glossary for Subject Area Definitions : ");
        Glossary glossary = this.createGlossary(this.clientUserId, GLOSSARY_NAME, GLOSSARY_DESCRIPTION);
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        SubjectAreaDefinition organisation = this.createTopSubjectAreaDefinition(ORGANIZATION, glossaryGuid);
        SubjectAreaDefinition hospital = this.createChildSubjectAreaDefinition(HOSPITAL, organisation, glossaryGuid);
        SubjectAreaDefinition supplier = this.createChildSubjectAreaDefinition(SUPPLIER, organisation, glossaryGuid);
        SubjectAreaDefinition person = this.createTopSubjectAreaDefinition(PERSON, glossaryGuid);
        SubjectAreaDefinition patient = this.createChildSubjectAreaDefinition(PATIENT, person, glossaryGuid);
        SubjectAreaDefinition clinician = this.createChildSubjectAreaDefinition(CLINICIAN, person, glossaryGuid);
        SubjectAreaDefinition employee = this.createChildSubjectAreaDefinition(EMPLOYEE, person, glossaryGuid);
        SubjectAreaDefinition collaborator = this.createChildSubjectAreaDefinition(COLLABORATOR, person, glossaryGuid);
        SubjectAreaDefinition clinical = this.createTopSubjectAreaDefinition(CLINICAL, glossaryGuid);
        SubjectAreaDefinition symptom = this.createChildSubjectAreaDefinition(SYMPTOM, clinical, glossaryGuid);
        SubjectAreaDefinition measurement = this.createChildSubjectAreaDefinition(MEASUREMENT, clinical, glossaryGuid);
        SubjectAreaDefinition prescription = this.createChildSubjectAreaDefinition(PRESCRIPTION, clinical, glossaryGuid);
        SubjectAreaDefinition outcome = this.createChildSubjectAreaDefinition(OUTCOME, clinical, glossaryGuid);
        SubjectAreaDefinition treatment = this.createTopSubjectAreaDefinition(TREATMENT, glossaryGuid);
        SubjectAreaDefinition product = this.createChildSubjectAreaDefinition(PRODUCT, treatment, glossaryGuid);
        SubjectAreaDefinition order = this.createChildSubjectAreaDefinition(ORDER, treatment, glossaryGuid);
        SubjectAreaDefinition recipe = this.createChildSubjectAreaDefinition(RECIPE, treatment, glossaryGuid);
        SubjectAreaDefinition serviceQuality = this.createTopSubjectAreaDefinition(SERVICE_QUALITY, glossaryGuid);
        SubjectAreaDefinition contract = this.createChildSubjectAreaDefinition(CONTRACT, serviceQuality, glossaryGuid);
        SubjectAreaDefinition stock = this.createChildSubjectAreaDefinition(STOCK, serviceQuality, glossaryGuid);
        SubjectAreaDefinition distribution = this.createChildSubjectAreaDefinition(DISTRIBUTION, serviceQuality, glossaryGuid);
        SubjectAreaDefinition invoice = this.createChildSubjectAreaDefinition(INVOICE, serviceQuality, glossaryGuid);
    }

    private SubjectAreaDefinition createTopSubjectAreaDefinition(String name, String glossaryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("----------------------------");
        System.out.println("Creating a top level Subject Area Definition called " + name);
        SubjectAreaDefinition subjectAreaDefinition = new SubjectAreaDefinition();
        subjectAreaDefinition.setName(name);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        subjectAreaDefinition.setGlossary(glossarySummary);
        return (SubjectAreaDefinition)this.subjectAreaCategory.subjectAreaDefinition().create(this.clientUserId, (Object)subjectAreaDefinition);
    }

    private SubjectAreaDefinition createChildSubjectAreaDefinition(String name, SubjectAreaDefinition parent, String glossaryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaDefinition subjectAreaDefinition = new SubjectAreaDefinition();
        subjectAreaDefinition.setName(name);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        subjectAreaDefinition.setGlossary(glossarySummary);
        CategorySummary parentCategorysummary = new CategorySummary();
        parentCategorysummary.setGuid(parent.getSystemAttributes().getGUID());
        subjectAreaDefinition.setParentCategory(parentCategorysummary);
        SubjectAreaDefinition newSubjectAreaDefinition = (SubjectAreaDefinition)this.subjectAreaCategory.subjectAreaDefinition().create(this.clientUserId, (Object)subjectAreaDefinition);
        if (newSubjectAreaDefinition != null) {
            System.out.println("Created Subject Area Definition " + newSubjectAreaDefinition.getName() + " with guid " + newSubjectAreaDefinition.getSystemAttributes().getGUID() + ", parent SubjectArea Definition is " + parent.getName());
        }
        return newSubjectAreaDefinition;
    }

    private Glossary createGlossary(String userId, String glossaryName, String glossaryDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = new Glossary();
        glossary.setName(glossaryName);
        glossary.setDescription(glossaryDescription);
        return (Glossary)this.subjectAreaGlossary.glossary().create(userId, (Object)glossary);
    }

    public static void main(String[] args) throws IOException {
        String serverURLRoot = SubjectAreaDefinitionSample.getUrl(args);
        String serverName = SubjectAreaDefinitionSample.getServerName(args);
        String clientUserId = SubjectAreaDefinitionSample.getUserId(args);
        System.out.println("===============================");
        System.out.println("Subject Area Definition Sample ");
        System.out.println("===============================");
        System.out.println("Running against OMAG server platform: " + serverURLRoot);
        System.out.println("OMAG server platform: " + serverName);
        System.out.println("Using userId: " + clientUserId);
        try {
            SubjectAreaDefinitionSample sample = new SubjectAreaDefinitionSample(serverURLRoot, serverName, clientUserId);
            sample.run();
        }
        catch (Throwable error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }

    public static String getUrl(String[] args) throws IOException {
        String url = null;
        if (args.length > 0) {
            url = args[0];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter the OMAG Server platform URL. Press enter to get the default (https://localhost:9443)):");
            url = br.readLine();
            if (url.equals("")) {
                url = DEFAULT_URL;
            }
        }
        return url;
    }

    public static String getServerName(String[] args) throws IOException {
        String name = null;
        if (args.length > 1) {
            name = args[1];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a OMAG Server Name. Press enter to get the default (cocoMDS4)):");
            name = br.readLine();
            if (name.equals("")) {
                name = DEFAULT_SERVER_NAME;
            }
        }
        return name;
    }

    public static String getUserId(String[] args) throws IOException {
        String userId = null;
        if (args.length > 1) {
            userId = args[1];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a userId. Press enter to get the default (erinoverview)):");
            userId = br.readLine();
            if (userId.equals("")) {
                userId = DEFAULT_USERID;
            }
        }
        return userId;
    }
}

