/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import java.util.Date;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGraph;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaBaseImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGraphImpl
extends SubjectAreaBaseImpl
implements SubjectAreaGraph {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGraphImpl.class);
    private static final String className = SubjectAreaGraphImpl.class.getName();
    private static final String BASE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/nodes";

    public SubjectAreaGraphImpl(String omasServerURL, String serverName) {
        super(omasServerURL, serverName);
    }

    @Override
    public Graph getGraph(String serverName, String userId, String guid, Date asOfTime, Set<NodeType> nodeFilter, Set<LineType> lineFilter, StatusFilter statusFilter, Integer level) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "getGraph";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGraph,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "getGraph", userId);
        InputValidator.validateGUIDNotNull(className, "getGraph", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, serverName, userId, guid);
        StringBuffer nodeFilterSB = new StringBuffer();
        if (nodeFilter != null && !nodeFilter.isEmpty()) {
            for (NodeType nodeType : nodeFilter) {
                nodeFilterSB.append(nodeType.name());
                nodeFilterSB.append(",");
            }
            nodeFilterSB.deleteCharAt(nodeFilterSB.lastIndexOf(","));
        }
        StringBuffer lineFilterSB = new StringBuffer();
        if (lineFilter != null && !lineFilter.isEmpty()) {
            for (LineType lineType : lineFilter) {
                lineFilterSB.append(lineType.name());
                lineFilterSB.append(",");
            }
            lineFilterSB.deleteCharAt(lineFilterSB.lastIndexOf(","));
        }
        StringBuffer stringBuffer = new StringBuffer();
        QueryUtils.addCharacterToQuery(stringBuffer);
        if (asOfTime != null) {
            QueryUtils.addCharacterToQuery(stringBuffer);
            stringBuffer.append("asOfTime=" + asOfTime);
        }
        if (nodeFilter != null) {
            QueryUtils.addCharacterToQuery(stringBuffer);
            stringBuffer.append("nodeFilter=" + nodeFilterSB);
        }
        if (lineFilter != null) {
            QueryUtils.addCharacterToQuery(stringBuffer);
            stringBuffer.append("lineFilter=" + lineFilterSB);
        }
        if (statusFilter != null) {
            QueryUtils.addCharacterToQuery(stringBuffer);
            stringBuffer.append("statusFilter=" + statusFilter);
        }
        if (level != null) {
            QueryUtils.addCharacterToQuery(stringBuffer);
            stringBuffer.append("level=" + level);
        }
        if (stringBuffer.length() > 1) {
            url = url + stringBuffer.toString();
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getGraph", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("getGraph", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("getGraph", restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException("getGraph", restResponse);
        Graph graph = DetectUtils.detectAndReturnGraph("getGraph", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGraph,userId=" + userId);
        }
        return graph;
    }
}

