/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScopeRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermCategorizationRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaRelationshipImpl
implements SubjectAreaRelationship {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRelationshipImpl.class);
    private static final String className = SubjectAreaRelationshipImpl.class.getName();
    private static final String BASE_RELATIONSHIPS_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships";
    private static final String HASA = "/has-as";
    private static final String RELATED_TERM = "/related-terms";
    private static final String SYNONYM = "/synonyms";
    private static final String ANTONYM = "/antonyms";
    private static final String TRANSLATION = "/translations";
    private static final String USED_IN_CONTEXT = "/used-in-contexts";
    private static final String PREFERRED_TERM = "/preferred-terms";
    private static final String VALID_VALUE = "/valid-values";
    private static final String REPLACEMENT_TERM = "/replacement-terms";
    private static final String TYPED_BY = "/typed-bys";
    private static final String IS_A = "/is-as";
    private static final String IS_A_TYPE_OF = "/is-a-type-ofs";
    private static final String TERM_CATEGORIZATION = "/term-categorizations";
    private static final String SEMANTIC_ASSIGNMENT = "/semantic-assignments";
    private static final String TERM_ANCHOR = "/term-anchor";
    private static final String CATEGORY_ANCHOR = "/category-anchor";
    private static final String PROJECT_SCOPE = "/project-scopes";
    private static final String BASE_RELATIONSHIPS_HASA_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/has-as";
    private static final String BASE_RELATIONSHIPS_RELATEDTERM_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/related-terms";
    private static final String BASE_RELATIONSHIPS_SYNONYM_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/synonyms";
    private static final String BASE_RELATIONSHIPS_ANTONYM_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/antonyms";
    private static final String BASE_RELATIONSHIPS_TRANSLATION_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/translations";
    private static final String BASE_RELATIONSHIPS_USED_IN_CONTEXT_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/used-in-contexts";
    private static final String BASE_RELATIONSHIPS_PREFERRED_TERM_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/preferred-terms";
    private static final String BASE_RELATIONSHIPS_VALID_VALUE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/valid-values";
    private static final String BASE_RELATIONSHIPS_REPLACEMENT_TERM_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/replacement-terms";
    private static final String BASE_RELATIONSHIPS_TYPED_BY_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/typed-bys";
    private static final String BASE_RELATIONSHIPS_IS_A_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/is-as";
    private static final String BASE_RELATIONSHIPS_IS_A_TYPE_OF_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/is-a-type-ofs";
    private static final String BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/term-categorizations";
    private static final String BASE_RELATIONSHIPS_SEMANTIC_ASSIGNMENT_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/semantic-assignments";
    private static final String BASE_RELATIONSHIPS_TERM_ANCHOR_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/term-anchor";
    private static final String BASE_RELATIONSHIPS_CATEGORY_ANCHOR_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/category-anchor";
    private static final String BASE_RELATIONSHIPS_PROJECT_SCOPE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/relationships/project-scopes";
    private String omasServerURL = null;
    private String serverName;

    public SubjectAreaRelationshipImpl(String omasServerURL, String serverName) {
        this.omasServerURL = omasServerURL;
        this.serverName = serverName;
    }

    @Override
    public TermHASARelationship createTermHASARelationship(String serverName, String userId, TermHASARelationship termHASARelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createTermHASARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTermHASARelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createTermHASARelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_HASA_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termHASARelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTermHASARelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTermHASARelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createTermHASARelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createTermHASARelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createTermHASARelationship", restResponse);
        TermHASARelationship createdTermHASARelationship = DetectUtils.detectAndReturnTermHASARelationship("createTermHASARelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTermHASARelationship,userId=" + userId);
        }
        return createdTermHASARelationship;
    }

    @Override
    public TermHASARelationship getTermHASARelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getTermHASARelationship";
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_HASA_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getTermHASARelationship", urlTemplate);
        TermHASARelationship gotTermHASARelationship = DetectUtils.detectAndReturnTermHASARelationship("getTermHASARelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermHASARelationship,userId=" + userId);
        }
        return gotTermHASARelationship;
    }

    @Override
    public TermHASARelationship updateTermHASARelationship(String serverName, String userId, TermHASARelationship termHASARelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateTermHASARelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(termHASARelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTermHASARelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_HASA_URL, requestBody, false);
        TermHASARelationship updatedTermHASARelationship = DetectUtils.detectAndReturnTermHASARelationship("updateTermHASARelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermHASARelationship,userId=" + userId);
        }
        return updatedTermHASARelationship;
    }

    @Override
    public TermHASARelationship replaceTermHASARelationship(String serverName, String userId, TermHASARelationship termHASARelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "replaceTermHASARelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(termHASARelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "replaceTermHASARelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_HASA_URL, requestBody, true);
        TermHASARelationship updatedTermHASARelationship = DetectUtils.detectAndReturnTermHASARelationship("replaceTermHASARelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceTermHASARelationship,userId=" + userId);
        }
        return updatedTermHASARelationship;
    }

    @Override
    public TermHASARelationship deleteTermHASARelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteTermHASARelationship";
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_HASA_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteTermHASARelationship", urlTemplate);
        TermHASARelationship termHASARelationship = DetectUtils.detectAndReturnTermHASARelationship("deleteTermHASARelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTermHASARelationship,userId=" + userId);
        }
        return termHASARelationship;
    }

    @Override
    public void purgeTermHASARelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeTermHASARelationship";
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_HASA_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeTermHASARelationship", urlTemplate);
    }

    @Override
    public TermHASARelationship restoreTermHASARelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreTermHASARelationship";
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_HASA_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreTermHASARelationship", urlTemplate);
        TermHASARelationship termHASARelationship = DetectUtils.detectAndReturnTermHASARelationship("restoreTermHASARelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTermHASARelationship,userId=" + userId);
        }
        return termHASARelationship;
    }

    @Override
    public RelatedTerm createRelatedTerm(String serverName, String userId, RelatedTerm relatedTermRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createTermRelatedARelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTermRelatedARelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createTermRelatedARelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_RELATEDTERM_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(relatedTermRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTermRelatedARelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTermRelatedARelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createTermRelatedARelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createTermRelatedARelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createTermRelatedARelationship", restResponse);
        RelatedTerm createdRelatedTerm = DetectUtils.detectAndReturnRelatedTerm("createTermRelatedARelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTermRelatedARelationship,userId=" + userId);
        }
        return createdRelatedTerm;
    }

    @Override
    public RelatedTerm getRelatedTerm(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getRelatedTerm";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_RELATEDTERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getRelatedTerm", url);
        RelatedTerm gotRelatedTerm = DetectUtils.detectAndReturnRelatedTerm("getRelatedTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelatedTerm,userId=" + userId);
        }
        return gotRelatedTerm;
    }

    @Override
    public RelatedTerm updateRelatedTerm(String serverName, String userId, RelatedTerm termRelatedTerm) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateRelatedTerm";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(termRelatedTerm);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateRelatedTerm", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_RELATEDTERM_URL, requestBody, false);
        RelatedTerm relatedTermRelationship = DetectUtils.detectAndReturnRelatedTerm("updateRelatedTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateRelatedTerm,userId=" + userId);
        }
        return relatedTermRelationship;
    }

    @Override
    public RelatedTerm replaceRelatedTerm(String serverName, String userId, RelatedTerm termRelatedTerm) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "replaceRelatedTerm";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(termRelatedTerm);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "replaceRelatedTerm", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_RELATEDTERM_URL, requestBody, true);
        RelatedTerm relatedTermRelationship = DetectUtils.detectAndReturnRelatedTerm("replaceRelatedTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceRelatedTerm,userId=" + userId);
        }
        return relatedTermRelationship;
    }

    @Override
    public RelatedTerm restoreRelatedTerm(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreRelatedTerm";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_RELATEDTERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreRelatedTerm", url);
        RelatedTerm gotRelatedTerm = DetectUtils.detectAndReturnRelatedTerm("restoreRelatedTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreRelatedTerm,userId=" + userId);
        }
        return gotRelatedTerm;
    }

    @Override
    public RelatedTerm deleteRelatedTerm(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteRelatedTerm";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_RELATEDTERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteRelatedTerm", url);
        RelatedTerm gotRelatedTerm = DetectUtils.detectAndReturnRelatedTerm("deleteRelatedTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteRelatedTerm,userId=" + userId);
        }
        return gotRelatedTerm;
    }

    @Override
    public void purgeRelatedTerm(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeRelatedTerm";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_RELATEDTERM_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeRelatedTerm", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeRelatedTerm,userId=" + userId);
        }
    }

    @Override
    public RelatedTerm restoreRelatedTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreRelatedTerm";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_RELATEDTERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreRelatedTerm", url);
        RelatedTerm gotRelatedTerm = DetectUtils.detectAndReturnRelatedTerm("restoreRelatedTerm", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreRelatedTerm,userId=" + userId);
        }
        return gotRelatedTerm;
    }

    @Override
    public Synonym createSynonymRelationship(String serverName, String userId, Synonym synonym) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createSynonymRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createSynonymRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createSynonymRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_SYNONYM_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(synonym);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createSynonymRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createSynonymRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createSynonymRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createSynonymRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createSynonymRelationship", restResponse);
        Synonym createdSynonym = DetectUtils.detectAndReturnSynonym("createSynonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createSynonymRelationship,userId=" + userId);
        }
        return createdSynonym;
    }

    @Override
    public Synonym getSynonymRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getSynonymRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_SYNONYM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getSynonymRelationship", url);
        Synonym gotSynonym = DetectUtils.detectAndReturnSynonym("getSynonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSynonymRelationship,userId=" + userId);
        }
        return gotSynonym;
    }

    @Override
    public Synonym updateSynonymRelationship(String serverName, String userId, Synonym synonymRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateSynonymRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(synonymRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateSynonymRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_SYNONYM_URL, requestBody, false);
        Synonym updatedSynonymRelationship = DetectUtils.detectAndReturnSynonym("updateSynonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateSynonymRelationship,userId=" + userId);
        }
        return updatedSynonymRelationship;
    }

    @Override
    public Synonym replaceSynonymRelationship(String serverName, String userId, Synonym synonymRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateSynonymRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(synonymRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateSynonymRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_SYNONYM_URL, requestBody, true);
        Synonym updatedSynonymRelationship = DetectUtils.detectAndReturnSynonym("updateSynonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateSynonymRelationship,userId=" + userId);
        }
        return updatedSynonymRelationship;
    }

    @Override
    public Synonym deleteSynonymRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UnrecognizedGUIDException, UserNotAuthorizedException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteSynonymRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_SYNONYM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteSynonymRelationship", url);
        Synonym gotSynonym = DetectUtils.detectAndReturnSynonym("deleteSynonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteSynonymRelationship,userId=" + userId);
        }
        return gotSynonym;
    }

    @Override
    public void purgeSynonymRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeSynonymRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_SYNONYM_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeSynonymRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeSynonymRelationship,userId=" + userId);
        }
    }

    @Override
    public Synonym restoreSynonymRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreSynonymRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_SYNONYM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreSynonymRelationship", url);
        Synonym gotSynonym = DetectUtils.detectAndReturnSynonym("restoreSynonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreSynonymRelationship,userId=" + userId);
        }
        return gotSynonym;
    }

    @Override
    public Antonym createAntonymRelationship(String serverName, String userId, Antonym antonym) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createAntonymRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createAntonymRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createAntonymRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_ANTONYM_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(antonym);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createAntonymRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createAntonymRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createAntonymRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createAntonymRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createAntonymRelationship", restResponse);
        Antonym createdAntonym = DetectUtils.detectAndReturnAntonym("createAntonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createAntonymRelationship,userId=" + userId);
        }
        return createdAntonym;
    }

    @Override
    public Antonym getAntonymRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getAntonymRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_ANTONYM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getAntonymRelationship", url);
        Antonym gotAntonym = DetectUtils.detectAndReturnAntonym("getAntonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getAntonymRelationship,userId=" + userId);
        }
        return gotAntonym;
    }

    @Override
    public Antonym updateAntonymRelationship(String serverName, String userId, Antonym antonymRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateAntonymRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(antonymRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateAntonymRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_ANTONYM_URL, requestBody, false);
        Antonym updatedAntonymRelationship = DetectUtils.detectAndReturnAntonym("updateAntonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateAntonymRelationship,userId=" + userId);
        }
        return updatedAntonymRelationship;
    }

    @Override
    public Antonym replaceAntonymRelationship(String serverName, String userId, Antonym antonymRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateAntonymRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(antonymRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateAntonymRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_ANTONYM_URL, requestBody, true);
        Antonym updatedAntonymRelationship = DetectUtils.detectAndReturnAntonym("updateAntonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateAntonymRelationship,userId=" + userId);
        }
        return updatedAntonymRelationship;
    }

    @Override
    public Antonym deleteAntonymRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteAntonymRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_ANTONYM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteAntonymRelationship", url);
        Antonym gotAntonym = DetectUtils.detectAndReturnAntonym("deleteAntonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteAntonymRelationship,userId=" + userId);
        }
        return gotAntonym;
    }

    @Override
    public void purgeAntonymRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeAntonymRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_ANTONYM_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeAntonymRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeAntonymRelationship,userId=" + userId);
        }
    }

    @Override
    public Antonym restoreAntonymRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreAntonymRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_ANTONYM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreAntonymRelationship", url);
        Antonym gotAntonym = DetectUtils.detectAndReturnAntonym("restoreAntonymRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreAntonymRelationship,userId=" + userId);
        }
        return gotAntonym;
    }

    @Override
    public Translation createTranslationRelationship(String serverName, String userId, Translation translation) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createTranslationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTranslationRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createTranslationRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_TRANSLATION_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(translation);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTranslationRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTranslationRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createTranslationRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createTranslationRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createTranslationRelationship", restResponse);
        Translation createdTranslation = DetectUtils.detectAndReturnTranslation("createTranslationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTranslationRelationship,userId=" + userId);
        }
        return createdTranslation;
    }

    @Override
    public Translation getTranslationRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getTranslationRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TRANSLATION_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getTranslationRelationship", url);
        Translation gotTranslation = DetectUtils.detectAndReturnTranslation("getTranslationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTranslationRelationship,userId=" + userId);
        }
        return gotTranslation;
    }

    @Override
    public Translation updateTranslationRelationship(String serverName, String userId, Translation translationRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateTranslationRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(translationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTranslationRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_TRANSLATION_URL, requestBody, false);
        Translation updatedTranslationRelationship = DetectUtils.detectAndReturnTranslation("updateTranslationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTranslationRelationship,userId=" + userId);
        }
        return updatedTranslationRelationship;
    }

    @Override
    public Translation replaceTranslationRelationship(String serverName, String userId, Translation translationRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateTranslationRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(translationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTranslationRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_TRANSLATION_URL, requestBody, true);
        Translation updatedTranslationRelationship = DetectUtils.detectAndReturnTranslation("updateTranslationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTranslationRelationship,userId=" + userId);
        }
        return updatedTranslationRelationship;
    }

    @Override
    public Translation deleteTranslationRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteTranslationRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TRANSLATION_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteTranslationRelationship", url);
        Translation gotTranslation = DetectUtils.detectAndReturnTranslation("deleteTranslationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTranslationRelationship,userId=" + userId);
        }
        return gotTranslation;
    }

    @Override
    public void purgeTranslationRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeTranslationRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TRANSLATION_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeTranslationRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeTranslationRelationship,userId=" + userId);
        }
    }

    @Override
    public Translation restoreTranslationRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreTranslationRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TRANSLATION_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreTranslationRelationship", url);
        Translation gotTranslation = DetectUtils.detectAndReturnTranslation("restoreTranslationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTranslationRelationship,userId=" + userId);
        }
        return gotTranslation;
    }

    @Override
    public UsedInContext createUsedInContextRelationship(String serverName, String userId, UsedInContext usedInContext) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createUsedInContextRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createUsedInContextRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createUsedInContextRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_USED_IN_CONTEXT_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(usedInContext);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createUsedInContextRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createUsedInContextRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createUsedInContextRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createUsedInContextRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createUsedInContextRelationship", restResponse);
        UsedInContext createdUsedInContext = DetectUtils.detectAndReturnUsedInContext("createUsedInContextRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createUsedInContextRelationship,userId=" + userId);
        }
        return createdUsedInContext;
    }

    @Override
    public UsedInContext getUsedInContextRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getUsedInContextRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_USED_IN_CONTEXT_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getUsedInContextRelationship", url);
        UsedInContext gotUsedInContext = DetectUtils.detectAndReturnUsedInContext("getUsedInContextRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getUsedInContextRelationship,userId=" + userId);
        }
        return gotUsedInContext;
    }

    @Override
    public UsedInContext updateUsedInContextRelationship(String serverName, String userId, UsedInContext usedInContextRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateUsedInContextRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(usedInContextRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateUsedInContextRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_USED_IN_CONTEXT_URL, requestBody, false);
        UsedInContext updatedUsedInContextRelationship = DetectUtils.detectAndReturnUsedInContext("updateUsedInContextRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateUsedInContextRelationship,userId=" + userId);
        }
        return updatedUsedInContextRelationship;
    }

    @Override
    public UsedInContext replaceUsedInContextRelationship(String serverName, String userId, UsedInContext usedInContextRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateUsedInContextRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(usedInContextRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateUsedInContextRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_USED_IN_CONTEXT_URL, requestBody, true);
        UsedInContext updatedUsedInContextRelationship = DetectUtils.detectAndReturnUsedInContext("updateUsedInContextRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateUsedInContextRelationship,userId=" + userId);
        }
        return updatedUsedInContextRelationship;
    }

    @Override
    public UsedInContext deleteUsedInContextRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteUsedInContextRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_USED_IN_CONTEXT_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteUsedInContextRelationship", url);
        UsedInContext gotUsedInContext = DetectUtils.detectAndReturnUsedInContext("deleteUsedInContextRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteUsedInContextRelationship,userId=" + userId);
        }
        return gotUsedInContext;
    }

    @Override
    public void purgeUsedInContextRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeUsedInContextRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_USED_IN_CONTEXT_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeUsedInContextRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeUsedInContextRelationship,userId=" + userId);
        }
    }

    @Override
    public UsedInContext restoreUsedInContextRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreUsedInContextRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_USED_IN_CONTEXT_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreUsedInContextRelationship", url);
        UsedInContext gotUsedInContext = DetectUtils.detectAndReturnUsedInContext("restoreUsedInContextRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreUsedInContextRelationship,userId=" + userId);
        }
        return gotUsedInContext;
    }

    @Override
    public PreferredTerm createPreferredTermRelationship(String serverName, String userId, PreferredTerm preferredTerm) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createPreferredTermRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createPreferredTermRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createPreferredTermRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_PREFERRED_TERM_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(preferredTerm);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createPreferredTermRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createPreferredTermRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createPreferredTermRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createPreferredTermRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createPreferredTermRelationship", restResponse);
        PreferredTerm createdPreferredTerm = DetectUtils.detectAndReturnPreferredTerm("createPreferredTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createPreferredTermRelationship,userId=" + userId);
        }
        return createdPreferredTerm;
    }

    @Override
    public PreferredTerm getPreferredTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getPreferredTermRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_PREFERRED_TERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getPreferredTermRelationship", url);
        PreferredTerm gotPreferredTerm = DetectUtils.detectAndReturnPreferredTerm("getPreferredTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getPreferredTermRelationship,userId=" + userId);
        }
        return gotPreferredTerm;
    }

    @Override
    public PreferredTerm updatePreferredTermRelationship(String serverName, String userId, PreferredTerm preferredTermRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updatePreferredTermRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(preferredTermRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updatePreferredTermRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_PREFERRED_TERM_URL, requestBody, false);
        PreferredTerm updatedPreferredTermRelationship = DetectUtils.detectAndReturnPreferredTerm("updatePreferredTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updatePreferredTermRelationship,userId=" + userId);
        }
        return updatedPreferredTermRelationship;
    }

    @Override
    public PreferredTerm replacePreferredTermRelationship(String serverName, String userId, PreferredTerm preferredTermRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updatePreferredTermRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(preferredTermRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updatePreferredTermRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_PREFERRED_TERM_URL, requestBody, true);
        PreferredTerm updatedPreferredTermRelationship = DetectUtils.detectAndReturnPreferredTerm("updatePreferredTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updatePreferredTermRelationship,userId=" + userId);
        }
        return updatedPreferredTermRelationship;
    }

    @Override
    public PreferredTerm deletePreferredTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deletePreferredTermRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_PREFERRED_TERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deletePreferredTermRelationship", url);
        PreferredTerm gotPreferredTerm = DetectUtils.detectAndReturnPreferredTerm("deletePreferredTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deletePreferredTermRelationship,userId=" + userId);
        }
        return gotPreferredTerm;
    }

    @Override
    public void purgePreferredTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgePreferredTermRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_PREFERRED_TERM_URL;
        this.purgeRelationship(serverName, userId, guid, "purgePreferredTermRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgePreferredTermRelationship,userId=" + userId);
        }
    }

    @Override
    public PreferredTerm restorePreferredTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restorePreferredTermRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_PREFERRED_TERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restorePreferredTermRelationship", url);
        PreferredTerm gotPreferredTerm = DetectUtils.detectAndReturnPreferredTerm("restorePreferredTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restorePreferredTermRelationship,userId=" + userId);
        }
        return gotPreferredTerm;
    }

    @Override
    public ValidValue createValidValueRelationship(String serverName, String userId, ValidValue validValue) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createValidValueRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createValidValueRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createValidValueRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_VALID_VALUE_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(validValue);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createValidValueRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createValidValueRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createValidValueRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createValidValueRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createValidValueRelationship", restResponse);
        ValidValue createdValidValue = DetectUtils.detectAndReturnValidValue("createValidValueRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createValidValueRelationship,userId=" + userId);
        }
        return createdValidValue;
    }

    @Override
    public ValidValue getValidValueRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getValidValueRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_VALID_VALUE_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getValidValueRelationship", url);
        ValidValue gotValidValue = DetectUtils.detectAndReturnValidValue("getValidValueRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getValidValueRelationship,userId=" + userId);
        }
        return gotValidValue;
    }

    @Override
    public ValidValue updateValidValueRelationship(String serverName, String userId, ValidValue validValueRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateValidValueRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(validValueRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateValidValueRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_VALID_VALUE_URL, requestBody, false);
        ValidValue updatedValidValueRelationship = DetectUtils.detectAndReturnValidValue("updateValidValueRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateValidValueRelationship,userId=" + userId);
        }
        return updatedValidValueRelationship;
    }

    @Override
    public ValidValue replaceValidValueRelationship(String serverName, String userId, ValidValue validValueRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateValidValueRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(validValueRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateValidValueRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_VALID_VALUE_URL, requestBody, true);
        ValidValue updatedValidValueRelationship = DetectUtils.detectAndReturnValidValue("updateValidValueRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateValidValueRelationship,userId=" + userId);
        }
        return updatedValidValueRelationship;
    }

    @Override
    public ValidValue deleteValidValueRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteValidValueRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_VALID_VALUE_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteValidValueRelationship", url);
        ValidValue gotValidValue = DetectUtils.detectAndReturnValidValue("deleteValidValueRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteValidValueRelationship,userId=" + userId);
        }
        return gotValidValue;
    }

    @Override
    public void purgeValidValueRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeValidValueRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_VALID_VALUE_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeValidValueRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeValidValueRelationship,userId=" + userId);
        }
    }

    @Override
    public ValidValue restoreValidValueRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreValidValueRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_VALID_VALUE_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreValidValueRelationship", url);
        ValidValue gotValidValue = DetectUtils.detectAndReturnValidValue("restoreValidValueRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreValidValueRelationship,userId=" + userId);
        }
        return gotValidValue;
    }

    @Override
    public ReplacementTerm createReplacementTermRelationship(String serverName, String userId, ReplacementTerm replacementTerm) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createReplacementTermRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createReplacementTermRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createReplacementTermRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_REPLACEMENT_TERM_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(replacementTerm);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createReplacementTermRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createReplacementTermRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createReplacementTermRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createReplacementTermRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createReplacementTermRelationship", restResponse);
        ReplacementTerm createdReplacementTerm = DetectUtils.detectAndReturnReplacementTerm("createReplacementTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createReplacementTermRelationship,userId=" + userId);
        }
        return createdReplacementTerm;
    }

    @Override
    public ReplacementTerm getReplacementTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getReplacementTermRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_REPLACEMENT_TERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getReplacementTermRelationship", url);
        ReplacementTerm gotReplacementTerm = DetectUtils.detectAndReturnReplacementTerm("getReplacementTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getReplacementTermRelationship,userId=" + userId);
        }
        return gotReplacementTerm;
    }

    @Override
    public ReplacementTerm updateReplacementTermRelationship(String serverName, String userId, ReplacementTerm replacementTermRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateReplacementTermRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(replacementTermRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateReplacementTermRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_REPLACEMENT_TERM_URL, requestBody, false);
        ReplacementTerm updatedReplacementTermRelationship = DetectUtils.detectAndReturnReplacementTerm("updateReplacementTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateReplacementTermRelationship,userId=" + userId);
        }
        return updatedReplacementTermRelationship;
    }

    @Override
    public ReplacementTerm replaceReplacementTermRelationship(String serverName, String userId, ReplacementTerm replacementTermRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateReplacementTermRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(replacementTermRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateReplacementTermRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_REPLACEMENT_TERM_URL, requestBody, true);
        ReplacementTerm updatedReplacementTermRelationship = DetectUtils.detectAndReturnReplacementTerm("updateReplacementTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateReplacementTermRelationship,userId=" + userId);
        }
        return updatedReplacementTermRelationship;
    }

    @Override
    public ReplacementTerm deleteReplacementTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteReplacementTermRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_REPLACEMENT_TERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteReplacementTermRelationship", url);
        ReplacementTerm gotReplacementTerm = DetectUtils.detectAndReturnReplacementTerm("deleteReplacementTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteReplacementTermRelationship,userId=" + userId);
        }
        return gotReplacementTerm;
    }

    @Override
    public void purgeReplacementTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeReplacementTermRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_REPLACEMENT_TERM_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeReplacementTermRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeReplacementTermRelationship,userId=" + userId);
        }
    }

    @Override
    public ReplacementTerm restoreReplacementTermRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreReplacementTermRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_REPLACEMENT_TERM_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreReplacementTermRelationship", url);
        ReplacementTerm gotReplacementTerm = DetectUtils.detectAndReturnReplacementTerm("restoreReplacementTermRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreReplacementTermRelationship,userId=" + userId);
        }
        return gotReplacementTerm;
    }

    @Override
    public TermTYPEDBYRelationship createTermTYPEDBYRelationship(String serverName, String userId, TermTYPEDBYRelationship termTYPEDBYRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createTermTYPEDBYRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTermTYPEDBYRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createTermTYPEDBYRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_TYPED_BY_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termTYPEDBYRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTermTYPEDBYRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTermTYPEDBYRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createTermTYPEDBYRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createTermTYPEDBYRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createTermTYPEDBYRelationship", restResponse);
        TermTYPEDBYRelationship createdTermTYPEDBYRelationship = DetectUtils.detectAndReturnTermTYPEDBYRelationship("createTermTYPEDBYRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTermTYPEDBYRelationship,userId=" + userId);
        }
        return createdTermTYPEDBYRelationship;
    }

    @Override
    public TermTYPEDBYRelationship getTermTYPEDBYRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getTermTYPEDBYRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TYPED_BY_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getTermTYPEDBYRelationship", url);
        TermTYPEDBYRelationship gotTermTYPEDBYRelationship = DetectUtils.detectAndReturnTermTYPEDBYRelationship("getTermTYPEDBYRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermTYPEDBYRelationship,userId=" + userId);
        }
        return gotTermTYPEDBYRelationship;
    }

    @Override
    public TermTYPEDBYRelationship updateTermTYPEDBYRelationship(String serverName, String userId, TermTYPEDBYRelationship termTYPEDBYRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateTermTYPEDBYRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(termTYPEDBYRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTermTYPEDBYRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_TYPED_BY_URL, requestBody, false);
        TermTYPEDBYRelationship updatedTermTYPEDBYRelationship = DetectUtils.detectAndReturnTermTYPEDBYRelationship("updateTermTYPEDBYRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermTYPEDBYRelationship,userId=" + userId);
        }
        return updatedTermTYPEDBYRelationship;
    }

    @Override
    public TermTYPEDBYRelationship replaceTermTYPEDBYRelationship(String serverName, String userId, TermTYPEDBYRelationship termTYPEDBYRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateTermTYPEDBYRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(termTYPEDBYRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTermTYPEDBYRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_TYPED_BY_URL, requestBody, true);
        TermTYPEDBYRelationship updatedTermTYPEDBYRelationship = DetectUtils.detectAndReturnTermTYPEDBYRelationship("updateTermTYPEDBYRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermTYPEDBYRelationship,userId=" + userId);
        }
        return updatedTermTYPEDBYRelationship;
    }

    @Override
    public TermTYPEDBYRelationship deleteTermTYPEDBYRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteTermTYPEDBYRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TYPED_BY_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteTermTYPEDBYRelationship", url);
        TermTYPEDBYRelationship gotTermTYPEDBYRelationship = DetectUtils.detectAndReturnTermTYPEDBYRelationship("deleteTermTYPEDBYRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTermTYPEDBYRelationship,userId=" + userId);
        }
        return gotTermTYPEDBYRelationship;
    }

    @Override
    public void purgeTermTYPEDBYRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeTermTYPEDBYRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TYPED_BY_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeTermTYPEDBYRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeTermTYPEDBYRelationship,userId=" + userId);
        }
    }

    @Override
    public TermTYPEDBYRelationship restoreTypedByRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreeTermTYPEDBYRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TYPED_BY_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreeTermTYPEDBYRelationship", url);
        TermTYPEDBYRelationship gotTermTYPEDBYRelationship = DetectUtils.detectAndReturnTermTYPEDBYRelationship("restoreeTermTYPEDBYRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreeTermTYPEDBYRelationship,userId=" + userId);
        }
        return gotTermTYPEDBYRelationship;
    }

    @Override
    public ISARelationship createIsaRelationship(String serverName, String userId, ISARelationship isa) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createIsaRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createIsaRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createIsaRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(isa);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createIsaRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createIsaRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createIsaRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createIsaRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createIsaRelationship", restResponse);
        ISARelationship createdIsa = DetectUtils.detectAndReturnISARelationship("createIsaRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createIsaRelationship,userId=" + userId);
        }
        return createdIsa;
    }

    @Override
    public ISARelationship getIsaRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getIsaRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getIsaRelationship", url);
        ISARelationship gotIsa = DetectUtils.detectAndReturnISARelationship("getIsaRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getIsaRelationship,userId=" + userId);
        }
        return gotIsa;
    }

    @Override
    public ISARelationship updateIsaRelationship(String serverName, String userId, ISARelationship isaRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateIsaRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(isaRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateIsaRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_IS_A_URL, requestBody, false);
        ISARelationship updatedIsaRelationship = DetectUtils.detectAndReturnISARelationship("updateIsaRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateIsaRelationship,userId=" + userId);
        }
        return updatedIsaRelationship;
    }

    @Override
    public ISARelationship replaceIsaRelationship(String serverName, String userId, ISARelationship isaRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateIsaRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(isaRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateIsaRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_IS_A_URL, requestBody, true);
        ISARelationship updatedIsaRelationship = DetectUtils.detectAndReturnISARelationship("updateIsaRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateIsaRelationship,userId=" + userId);
        }
        return updatedIsaRelationship;
    }

    @Override
    public ISARelationship deleteIsaRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteIsaRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteIsaRelationship", url);
        ISARelationship gotIsa = DetectUtils.detectAndReturnISARelationship("deleteIsaRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteIsaRelationship,userId=" + userId);
        }
        return gotIsa;
    }

    @Override
    public void purgeIsaRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeIsaRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeIsaRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeIsaRelationship,userId=" + userId);
        }
    }

    @Override
    public ISARelationship restoreIsaRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreIsaRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreIsaRelationship", url);
        ISARelationship gotIsa = DetectUtils.detectAndReturnISARelationship("restoreIsaRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreIsaRelationship,userId=" + userId);
        }
        return gotIsa;
    }

    @Override
    public TermISATypeOFRelationship createTermISATypeOFRelationship(String serverName, String userId, TermISATypeOFRelationship TermISATypeOFRelationship2) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createTermISATypeOFRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTermISATypeOFRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createTermISATypeOFRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_TYPE_OF_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(TermISATypeOFRelationship2);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTermISATypeOFRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTermISATypeOFRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createTermISATypeOFRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createTermISATypeOFRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createTermISATypeOFRelationship", restResponse);
        TermISATypeOFRelationship createdTermISATypeOFRelationship = DetectUtils.detectAndReturnTermISATypeOFRelationship("createTermISATypeOFRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTermISATypeOFRelationship,userId=" + userId);
        }
        return createdTermISATypeOFRelationship;
    }

    @Override
    public TermISATypeOFRelationship getTermISATypeOFRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getTermISATypeOFRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_TYPE_OF_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getTermISATypeOFRelationship", url);
        TermISATypeOFRelationship gotTermISATypeOFRelationship = DetectUtils.detectAndReturnTermISATypeOFRelationship("getTermISATypeOFRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermISATypeOFRelationship,userId=" + userId);
        }
        return gotTermISATypeOFRelationship;
    }

    @Override
    public TermISATypeOFRelationship updateTermISATypeOFRelationship(String serverName, String userId, TermISATypeOFRelationship TermISATypeOFRelationship2) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateTermISATypeOFRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(TermISATypeOFRelationship2);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTermISATypeOFRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_IS_A_TYPE_OF_URL, requestBody, false);
        TermISATypeOFRelationship updatedTermISATypeOFRelationship = DetectUtils.detectAndReturnTermISATypeOFRelationship("updateTermISATypeOFRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermISATypeOFRelationship,userId=" + userId);
        }
        return updatedTermISATypeOFRelationship;
    }

    @Override
    public TermISATypeOFRelationship replaceTermISATypeOFRelationship(String serverName, String userId, TermISATypeOFRelationship TermISATypeOFRelationship2) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateTermISATypeOFRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(TermISATypeOFRelationship2);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTermISATypeOFRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_IS_A_TYPE_OF_URL, requestBody, true);
        TermISATypeOFRelationship updatedTermISATypeOFRelationship = DetectUtils.detectAndReturnTermISATypeOFRelationship("updateTermISATypeOFRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermISATypeOFRelationship,userId=" + userId);
        }
        return updatedTermISATypeOFRelationship;
    }

    @Override
    public TermISATypeOFRelationship deleteTermISATypeOFRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteTermISATypeOFRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_TYPE_OF_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteTermISATypeOFRelationship", url);
        TermISATypeOFRelationship gotTermISATypeOFRelationship = DetectUtils.detectAndReturnTermISATypeOFRelationship("deleteTermISATypeOFRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTermISATypeOFRelationship,userId=" + userId);
        }
        return gotTermISATypeOFRelationship;
    }

    @Override
    public void purgeTermISATypeOFRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeTermISATypeOFRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_TYPE_OF_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeTermISATypeOFRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeTermISATypeOFRelationship,userId=" + userId);
        }
    }

    @Override
    public TermISATypeOFRelationship restoreIsaTypeOfRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreTermISATypeOFRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_IS_A_TYPE_OF_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreTermISATypeOFRelationship", url);
        TermISATypeOFRelationship gotTermISATypeOFRelationship = DetectUtils.detectAndReturnTermISATypeOFRelationship("restoreTermISATypeOFRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTermISATypeOFRelationship,userId=" + userId);
        }
        return gotTermISATypeOFRelationship;
    }

    private SubjectAreaOMASAPIResponse getRelationship(String serverName, String userId, String guid, String methodName, String base_url) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        String urlTemplate = base_url + "/%s";
        InputValidator.validateUserIdNotNull(className, methodName, userId);
        InputValidator.validateGUIDNotNull(className, methodName, guid, "guid");
        String url = String.format(urlTemplate, serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, methodName, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(methodName, restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(methodName, restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(methodName, restResponse);
        return restResponse;
    }

    private SubjectAreaOMASAPIResponse deleteRelationship(String serverName, String userId, String guid, String methodName, String base_url) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, RelationshipNotDeletedException, UnrecognizedGUIDException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, methodName, userId);
        InputValidator.validateGUIDNotNull(className, methodName, guid, "guid");
        String urlTemplate = base_url + "/%s?isPurge=false";
        String url = String.format(urlTemplate, serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, methodName, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(methodName, restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(methodName, restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(methodName, restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(methodName, restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(methodName, restResponse);
        DetectUtils.detectAndThrowRelationshipNotDeletedException(methodName, restResponse);
        return restResponse;
    }

    private SubjectAreaOMASAPIResponse restoreRelationship(String serverName, String userId, String guid, String methodName, String base_url) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, methodName, userId);
        InputValidator.validateGUIDNotNull(className, methodName, guid, "guid");
        String urlTemplate = base_url + "/%s";
        String url = String.format(urlTemplate, serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePostNoBody(className, methodName, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(methodName, restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(methodName, restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(methodName, restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(methodName, restResponse);
        return restResponse;
    }

    private void purgeRelationship(String serverName, String userId, String guid, String methodName, String base_url) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, GUIDNotPurgedException, UnexpectedResponseException, UnrecognizedGUIDException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, methodName, userId);
        InputValidator.validateGUIDNotNull(className, methodName, guid, "guid");
        String urlTemplate = base_url + "/%s?isPurge=true";
        String url = String.format(urlTemplate, serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, methodName, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(methodName, restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(methodName, restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(methodName, restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(methodName, restResponse);
        DetectUtils.detectAndThrowGUIDNotPurgedException(methodName, restResponse);
        DetectUtils.detectVoid(methodName, restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
    }

    @Override
    public TermCategorizationRelationship createTermCategorizationRelationship(String serverName, String userId, TermCategorizationRelationship termCategorizationRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTermCategorizationRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createTermCategorizationRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termCategorizationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTermCategorizationRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTermCategorizationRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createTermCategorizationRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createTermCategorizationRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createTermCategorizationRelationship", restResponse);
        TermCategorizationRelationship createdTermCategorizationRelationship = DetectUtils.detectAndReturnTermCategorizationRelationship("createTermCategorizationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTermCategorizationRelationship,userId=" + userId);
        }
        return createdTermCategorizationRelationship;
    }

    @Override
    public TermCategorizationRelationship getTermCategorizationRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getTermCategorizationRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getTermCategorizationRelationship", url);
        TermCategorizationRelationship gotTermCategorizationRelationship = DetectUtils.detectAndReturnTermCategorizationRelationship("getTermCategorizationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermCategorizationRelationship,userId=" + userId);
        }
        return gotTermCategorizationRelationship;
    }

    @Override
    public TermCategorizationRelationship updateTermCategorizationRelationship(String serverName, String userId, TermCategorizationRelationship termCategorizationRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTermCategorizationRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "updateTermCategorizationRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termCategorizationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateTermCategorizationRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL, requestBody, false);
        TermCategorizationRelationship updatedTermCategorizationRelationship = DetectUtils.detectAndReturnTermCategorizationRelationship("updateTermCategorizationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTermCategorizationRelationship,userId=" + userId);
        }
        return updatedTermCategorizationRelationship;
    }

    @Override
    public TermCategorizationRelationship replaceTermCategorizationRelationship(String serverName, String userId, TermCategorizationRelationship termCategorizationRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "replaceTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceTermCategorizationRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "replaceTermCategorizationRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL;
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termCategorizationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "replaceTermCategorizationRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL, requestBody, true);
        TermCategorizationRelationship updatedTermCategorizationRelationship = DetectUtils.detectAndReturnTermCategorizationRelationship("replaceTermCategorizationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceTermCategorizationRelationship,userId=" + userId);
        }
        return updatedTermCategorizationRelationship;
    }

    @Override
    public TermCategorizationRelationship deleteTermCategorizationRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTermCategorizationRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteTermCategorizationRelationship", url);
        TermCategorizationRelationship gotTermCategorizationRelationship = DetectUtils.detectAndReturnTermCategorizationRelationship("deleteTermCategorizationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTermCategorizationRelationship,userId=" + userId);
        }
        return gotTermCategorizationRelationship;
    }

    @Override
    public void purgeTermCategorizationRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeTermCategorizationRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeTermCategorizationRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeTermCategorizationRelationship,userId=" + userId);
        }
    }

    @Override
    public TermCategorizationRelationship restoreTermCategorizationRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreTermCategorizationRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTermCategorizationRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TERM_CATEGORIZATION_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreTermCategorizationRelationship", url);
        TermCategorizationRelationship gotTermCategorizationRelationship = DetectUtils.detectAndReturnTermCategorizationRelationship("restoreTermCategorizationRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTermCategorizationRelationship,userId=" + userId);
        }
        return gotTermCategorizationRelationship;
    }

    @Override
    public TermAnchorRelationship createTermAnchorRelationship(String serverName, String userId, TermAnchorRelationship termCategorizationRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createTermAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTermAnchorRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createTermAnchorRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_TERM_ANCHOR_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termCategorizationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createTermAnchorRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createTermAnchorRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createTermAnchorRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createTermAnchorRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createTermAnchorRelationship", restResponse);
        TermAnchorRelationship createdTermAnchorRelationship = DetectUtils.detectAndReturnTermAnchorRelationship("createTermAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTermAnchorRelationship,userId=" + userId);
        }
        return createdTermAnchorRelationship;
    }

    @Override
    public TermAnchorRelationship getTermAnchorRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getTermAnchorRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TERM_ANCHOR_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getTermAnchorRelationship", url);
        TermAnchorRelationship gotTermAnchorRelationship = DetectUtils.detectAndReturnTermAnchorRelationship("getTermAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermAnchorRelationship,userId=" + userId);
        }
        return gotTermAnchorRelationship;
    }

    @Override
    public TermAnchorRelationship replaceTermAnchorRelationship(String serverName, String userId, TermAnchorRelationship termCategorizationRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "replaceTermAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceTermAnchorRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "replaceTermAnchorRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_TERM_ANCHOR_URL;
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termCategorizationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "replaceTermAnchorRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_TERM_ANCHOR_URL, requestBody, true);
        TermAnchorRelationship updatedTermAnchorRelationship = DetectUtils.detectAndReturnTermAnchorRelationship("replaceTermAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceTermAnchorRelationship,userId=" + userId);
        }
        return updatedTermAnchorRelationship;
    }

    @Override
    public TermAnchorRelationship deleteTermAnchorRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteTermAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTermAnchorRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TERM_ANCHOR_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteTermAnchorRelationship", url);
        TermAnchorRelationship gotTermAnchorRelationship = DetectUtils.detectAndReturnTermAnchorRelationship("deleteTermAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTermAnchorRelationship,userId=" + userId);
        }
        return gotTermAnchorRelationship;
    }

    @Override
    public void purgeTermAnchorRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeTermAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeTermAnchorRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TERM_ANCHOR_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeTermAnchorRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeTermAnchorRelationship,userId=" + userId);
        }
    }

    @Override
    public TermAnchorRelationship restoreTermAnchorRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreTermAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTermAnchorRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_TERM_ANCHOR_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreTermAnchorRelationship", url);
        TermAnchorRelationship gotTermAnchorRelationship = DetectUtils.detectAndReturnTermAnchorRelationship("restoreTermAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTermAnchorRelationship,userId=" + userId);
        }
        return gotTermAnchorRelationship;
    }

    @Override
    public CategoryAnchorRelationship createCategoryAnchorRelationship(String serverName, String userId, CategoryAnchorRelationship termCategorizationRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createCategoryAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCategoryAnchorRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createCategoryAnchorRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_CATEGORY_ANCHOR_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termCategorizationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createCategoryAnchorRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createCategoryAnchorRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createCategoryAnchorRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createCategoryAnchorRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createCategoryAnchorRelationship", restResponse);
        CategoryAnchorRelationship createdCategoryAnchorRelationship = DetectUtils.detectAndReturnCategoryAnchorRelationship("createCategoryAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCategoryAnchorRelationship,userId=" + userId);
        }
        return createdCategoryAnchorRelationship;
    }

    @Override
    public CategoryAnchorRelationship getCategoryAnchorRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getCategoryAnchorRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_CATEGORY_ANCHOR_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getCategoryAnchorRelationship", url);
        CategoryAnchorRelationship gotCategoryAnchorRelationship = DetectUtils.detectAndReturnCategoryAnchorRelationship("getCategoryAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategoryAnchorRelationship,userId=" + userId);
        }
        return gotCategoryAnchorRelationship;
    }

    @Override
    public CategoryAnchorRelationship replaceCategoryAnchorRelationship(String serverName, String userId, CategoryAnchorRelationship termCategorizationRelationship) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "replaceCategoryAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceCategoryAnchorRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "replaceCategoryAnchorRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_CATEGORY_ANCHOR_URL;
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(termCategorizationRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "replaceCategoryAnchorRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_CATEGORY_ANCHOR_URL, requestBody, true);
        CategoryAnchorRelationship updatedCategoryAnchorRelationship = DetectUtils.detectAndReturnCategoryAnchorRelationship("replaceCategoryAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceCategoryAnchorRelationship,userId=" + userId);
        }
        return updatedCategoryAnchorRelationship;
    }

    @Override
    public CategoryAnchorRelationship deleteCategoryAnchorRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnrecognizedGUIDException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteCategoryAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCategoryAnchorRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_CATEGORY_ANCHOR_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteCategoryAnchorRelationship", url);
        CategoryAnchorRelationship gotCategoryAnchorRelationship = DetectUtils.detectAndReturnCategoryAnchorRelationship("deleteCategoryAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteCategoryAnchorRelationship,userId=" + userId);
        }
        return gotCategoryAnchorRelationship;
    }

    @Override
    public void purgeCategoryAnchorRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeCategoryAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeCategoryAnchorRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_CATEGORY_ANCHOR_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeCategoryAnchorRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeCategoryAnchorRelationship,userId=" + userId);
        }
    }

    @Override
    public CategoryAnchorRelationship restoreCategoryAnchorRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreCategoryAnchorRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCategoryAnchorRelationship,userId=" + userId);
        }
        String url = this.omasServerURL + BASE_RELATIONSHIPS_CATEGORY_ANCHOR_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreCategoryAnchorRelationship", url);
        CategoryAnchorRelationship gotCategoryAnchorRelationship = DetectUtils.detectAndReturnCategoryAnchorRelationship("restoreCategoryAnchorRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreCategoryAnchorRelationship,userId=" + userId);
        }
        return gotCategoryAnchorRelationship;
    }

    @Override
    public ProjectScopeRelationship createProjectScopeRelationship(String serverName, String userId, ProjectScopeRelationship projectScope) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "createProjectScopeRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createProjectScopeRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createProjectScopeRelationship", userId);
        String urlTemplate = this.omasServerURL + BASE_RELATIONSHIPS_PROJECT_SCOPE_URL;
        String url = String.format(urlTemplate, serverName, userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(projectScope);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createProjectScopeRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createProjectScopeRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("createProjectScopeRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("createProjectScopeRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("createProjectScopeRelationship", restResponse);
        ProjectScopeRelationship createdProjectScope = DetectUtils.detectAndReturnProjectScope("createProjectScopeRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createProjectScopeRelationship,userId=" + userId);
        }
        return createdProjectScope;
    }

    @Override
    public ProjectScopeRelationship getProjectScopeRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getProjectScopeRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_PROJECT_SCOPE_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getProjectScopeRelationship", url);
        ProjectScopeRelationship gotProjectScope = DetectUtils.detectAndReturnProjectScope("getProjectScopeRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectScopeRelationship,userId=" + userId);
        }
        return gotProjectScope;
    }

    @Override
    public ProjectScopeRelationship updateProjectScopeRelationship(String serverName, String userId, ProjectScopeRelationship projectScopeRelationship) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateProjectScopeRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(projectScopeRelationship);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateProjectScopeRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_PROJECT_SCOPE_URL, requestBody, false);
        ProjectScopeRelationship updatedProjectScopeRelationship = DetectUtils.detectAndReturnProjectScope("updateProjectScopeRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProjectScopeRelationship,userId=" + userId);
        }
        return updatedProjectScopeRelationship;
    }

    @Override
    public ProjectScopeRelationship replaceProjectScopeRelationship(String serverName, String userId, ProjectScopeRelationship ProjectScopeRelationship2) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateProjectScopeRelationship";
        String requestBody = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            requestBody = mapper.writeValueAsString(ProjectScopeRelationship2);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateProjectScopeRelationship", error);
        }
        SubjectAreaOMASAPIResponse restResponse = this.updateRelationship(serverName, userId, this.omasServerURL + BASE_RELATIONSHIPS_PROJECT_SCOPE_URL, requestBody, true);
        ProjectScopeRelationship updatedProjectScopeRelationship = DetectUtils.detectAndReturnProjectScope("updateProjectScopeRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProjectScopeRelationship,userId=" + userId);
        }
        return updatedProjectScopeRelationship;
    }

    @Override
    public ProjectScopeRelationship deleteProjectScopeRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UnrecognizedGUIDException, UserNotAuthorizedException, FunctionNotSupportedException, RelationshipNotDeletedException, UnexpectedResponseException {
        String methodName = "deleteProjectScopeRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_PROJECT_SCOPE_URL;
        SubjectAreaOMASAPIResponse restResponse = this.deleteRelationship(serverName, userId, guid, "deleteProjectScopeRelationship", url);
        ProjectScopeRelationship gotProjectScope = DetectUtils.detectAndReturnProjectScope("deleteProjectScopeRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteProjectScopeRelationship,userId=" + userId);
        }
        return gotProjectScope;
    }

    @Override
    public void purgeProjectScopeRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, GUIDNotPurgedException, UnrecognizedGUIDException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "purgeProjectScopeRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_PROJECT_SCOPE_URL;
        this.purgeRelationship(serverName, userId, guid, "purgeProjectScopeRelationship", url);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeProjectScopeRelationship,userId=" + userId);
        }
    }

    @Override
    public ProjectScopeRelationship restoreProjectScopeRelationship(String serverName, String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "restoreProjectScopeRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_PROJECT_SCOPE_URL;
        SubjectAreaOMASAPIResponse restResponse = this.restoreRelationship(serverName, userId, guid, "restoreProjectScopeRelationship", url);
        ProjectScopeRelationship gotProjectScope = DetectUtils.detectAndReturnProjectScope("restoreProjectScopeRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreProjectScopeRelationship,userId=" + userId);
        }
        return gotProjectScope;
    }

    @Override
    public SemanticAssignment getSemanticAssignmentRelationship(String serverName, String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "getSemanticAssignmentRelationship";
        String url = this.omasServerURL + BASE_RELATIONSHIPS_SEMANTIC_ASSIGNMENT_URL;
        SubjectAreaOMASAPIResponse restResponse = this.getRelationship(serverName, userId, guid, "getSemanticAssignmentRelationship", url);
        SemanticAssignment gotSemanticAssignmentRelationship = DetectUtils.detectAndReturnSemanticAssignmentRelationship("getSemanticAssignmentRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSemanticAssignmentRelationship,userId=" + userId);
        }
        return gotSemanticAssignmentRelationship;
    }

    private SubjectAreaOMASAPIResponse updateRelationship(String serverName, String userId, String baseUrl, String requestBody, boolean isReplace) throws UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException, UnexpectedResponseException, UnrecognizedGUIDException {
        String methodName = "updateRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateRelationship,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "updateRelationship", userId);
        String urlTemplate = baseUrl + "?isReplace=%b";
        String url = String.format(urlTemplate, serverName, userId, isReplace);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePut(className, "updateRelationship", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException("updateRelationship", restResponse);
        DetectUtils.detectAndThrowInvalidParameterException("updateRelationship", restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException("updateRelationship", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateRelationship,userId=" + userId);
        }
        return restResponse;
    }
}

