/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.FVTUtils;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;

public class GlossaryFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Testglossary1";
    private static final String DEFAULT_TEST_GLOSSARY_NAME2 = "Testglossary2";
    private static final String DEFAULT_TEST_GLOSSARY_NAME3 = "Testglossary3";
    private SubjectAreaGlossary subjectAreaGlossary = null;
    private String serverName = null;
    private String userId = null;

    public GlossaryFVT(String url, String serverName, String userId) throws InvalidParameterException {
        this.subjectAreaGlossary = new SubjectAreaImpl(serverName, url).getSubjectAreaGlossary();
        this.serverName = serverName;
        this.userId = userId;
    }

    public static void runWith2Servers(String url) throws SubjectAreaCheckedExceptionBase {
        GlossaryFVT fvt = new GlossaryFVT(url, "Server1", "Fred");
        fvt.run();
        GlossaryFVT fvt2 = new GlossaryFVT(url, "Server2", "Fred");
        fvt2.run();
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVT.getUrl(args);
            GlossaryFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            System.out.println("ERROR: " + e.getErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runIt(String url, String serverName, String userId) throws SubjectAreaCheckedExceptionBase {
        GlossaryFVT fvt = new GlossaryFVT(url, serverName, userId);
        fvt.run();
    }

    public void run() throws SubjectAreaCheckedExceptionBase {
        System.out.println("Create a glossary");
        Glossary glossary = this.createGlossary(this.serverName + " " + DEFAULT_TEST_GLOSSARY_NAME);
        FVTUtils.validateNode(glossary);
        Glossary glossary2 = this.createGlossary(this.serverName + " " + DEFAULT_TEST_GLOSSARY_NAME2);
        FVTUtils.validateNode(glossary2);
        List<Glossary> results = this.findGlossaries(null);
        if (results.size() != 2) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 2 back on the find got " + results.size(), "", "");
        }
        Glossary glossaryForUpdate = new Glossary();
        glossaryForUpdate.setName(this.serverName + " " + DEFAULT_TEST_GLOSSARY_NAME3);
        System.out.println("Get the glossary");
        String guid = glossary.getSystemAttributes().getGUID();
        Glossary gotGlossary = this.getGlossaryByGUID(guid);
        System.out.println("Update the glossary");
        Glossary updatedGlossary = this.updateGlossary(guid, glossaryForUpdate);
        FVTUtils.validateNode(updatedGlossary);
        System.out.println("Get the glossary again");
        gotGlossary = this.getGlossaryByGUID(guid);
        FVTUtils.validateNode(gotGlossary);
        System.out.println("Delete the glossary");
        gotGlossary = this.deleteGlossary(guid);
        FVTUtils.validateNode(gotGlossary);
        System.out.println("restore the glossary");
        gotGlossary = this.restoreGlossary(guid);
        FVTUtils.validateNode(gotGlossary);
        System.out.println("Delete the glossary again");
        gotGlossary = this.deleteGlossary(guid);
        FVTUtils.validateNode(gotGlossary);
        System.out.println("Purge a glossary");
        this.purgeGlossary(guid);
        System.out.println("Create glossary with the same name as a deleted one");
        glossary = this.createGlossary(this.serverName + " " + DEFAULT_TEST_GLOSSARY_NAME);
        FVTUtils.validateNode(glossary);
        System.out.println("create glossaries to find");
        Glossary glossaryForFind1 = this.getGlossaryForInput("abc");
        glossaryForFind1.setQualifiedName("yyy");
        glossaryForFind1 = this.issueCreateGlossary(glossaryForFind1);
        FVTUtils.validateNode(glossaryForFind1);
        Glossary glossaryForFind2 = this.createGlossary("yyy");
        FVTUtils.validateNode(glossaryForFind2);
        Glossary glossaryForFind3 = this.createGlossary("zzz");
        FVTUtils.validateNode(glossaryForFind3);
        Glossary glossaryForFind4 = this.createGlossary("This is a Glossary with spaces in name");
        FVTUtils.validateNode(glossaryForFind4);
        results = this.findGlossaries("zzz");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 1 back on the find got " + results.size(), "", "");
        }
        results = this.findGlossaries("yyy");
        if (results.size() != 2) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 2 back on the find got " + results.size(), "", "");
        }
        Glossary deleted4 = this.deleteGlossary(glossaryForFind2.getSystemAttributes().getGUID());
        FVTUtils.validateNode(deleted4);
        results = this.findGlossaries("yyy");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 1 back on the find got " + results.size(), "", "");
        }
        results = this.findGlossaries("This is a Glossary with spaces in name");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 1 back on the find got " + results.size(), "", "");
        }
    }

    public Glossary createGlossary(String glossaryName) throws SubjectAreaCheckedExceptionBase {
        Glossary glossary = this.getGlossaryForInput(glossaryName);
        return this.issueCreateGlossary(glossary);
    }

    public Glossary issueCreateGlossary(Glossary glossary) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException, UnrecognizedGUIDException {
        Glossary newGlossary = this.subjectAreaGlossary.createGlossary(this.serverName, this.userId, glossary);
        if (newGlossary != null) {
            System.out.println("Created Glossary " + newGlossary.getName() + " with guid " + newGlossary.getSystemAttributes().getGUID());
        }
        return newGlossary;
    }

    public Glossary getGlossaryForInput(String glossaryName) {
        Glossary glossary = new Glossary();
        glossary.setName(glossaryName);
        return glossary;
    }

    public Taxonomy getTaxonomyForInput(String glossaryName) {
        Taxonomy taxonomy = new Taxonomy();
        taxonomy.setName(glossaryName);
        return taxonomy;
    }

    public Glossary createPastToGlossary(String name) throws SubjectAreaCheckedExceptionBase {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveToTime(new Date(now - 10L));
        Glossary newGlossary = this.subjectAreaGlossary.createGlossary(this.serverName, this.userId, glossary);
        FVTUtils.validateNode(newGlossary);
        System.out.println("Created Glossary " + newGlossary.getName() + " with guid " + newGlossary.getSystemAttributes().getGUID());
        return newGlossary;
    }

    public Glossary createPastFromGlossary(String name) throws SubjectAreaCheckedExceptionBase {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveFromTime(new Date(now - 10L));
        return this.subjectAreaGlossary.createGlossary(this.serverName, this.userId, glossary);
    }

    public Glossary createInvalidEffectiveDateGlossary(String name) throws SubjectAreaCheckedExceptionBase {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveFromTime(new Date(now - 10L));
        glossary.setEffectiveToTime(new Date(now - 11L));
        return this.subjectAreaGlossary.createGlossary(this.serverName, this.userId, glossary);
    }

    public Glossary createFutureGlossary(String name) throws SubjectAreaCheckedExceptionBase {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveFromTime(new Date(now + 86400000L));
        glossary.setEffectiveToTime(new Date(now + 172800000L));
        Glossary newGlossary = this.subjectAreaGlossary.createGlossary(this.serverName, this.userId, glossary);
        FVTUtils.validateNode(newGlossary);
        System.out.println("Created Glossary " + newGlossary.getName() + " with guid " + newGlossary.getSystemAttributes().getGUID());
        return newGlossary;
    }

    public List<Glossary> findGlossaries(String criteria) throws SubjectAreaCheckedExceptionBase {
        List<Glossary> glossaries = this.subjectAreaGlossary.findGlossary(this.serverName, this.userId, criteria, null, 0, 0, null, null);
        return glossaries;
    }

    public Glossary getGlossaryByGUID(String guid) throws SubjectAreaCheckedExceptionBase {
        Glossary glossary = this.subjectAreaGlossary.getGlossaryByGuid(this.serverName, this.userId, guid);
        FVTUtils.validateNode(glossary);
        System.out.println("Got Glossary " + glossary.getName() + " with guid " + glossary.getSystemAttributes().getGUID() + " and status " + glossary.getSystemAttributes().getStatus());
        return glossary;
    }

    public Glossary updateGlossary(String guid, Glossary glossary) throws SubjectAreaCheckedExceptionBase {
        Glossary updatedGlossary = this.subjectAreaGlossary.updateGlossary(this.serverName, this.userId, guid, glossary);
        FVTUtils.validateNode(updatedGlossary);
        System.out.println("Updated Glossary name to " + updatedGlossary.getName());
        return updatedGlossary;
    }

    public Glossary deleteGlossary(String guid) throws SubjectAreaCheckedExceptionBase {
        Glossary deletedGlossary = this.subjectAreaGlossary.deleteGlossary(this.serverName, this.userId, guid);
        FVTUtils.validateNode(deletedGlossary);
        System.out.println("Deleted Glossary name is " + deletedGlossary.getName());
        return deletedGlossary;
    }

    public Glossary restoreGlossary(String guid) throws SubjectAreaCheckedExceptionBase {
        Glossary restoredGlossary = this.subjectAreaGlossary.restoreGlossary(this.serverName, this.userId, guid);
        FVTUtils.validateNode(restoredGlossary);
        System.out.println("Restored Glossary name is " + restoredGlossary.getName());
        return restoredGlossary;
    }

    public void purgeGlossary(String guid) throws SubjectAreaCheckedExceptionBase {
        this.subjectAreaGlossary.purgeGlossary(this.serverName, this.userId, guid);
        System.out.println("Purge succeeded");
    }

    public List<Line> getGlossaryRelationships(Glossary glossary) throws UserNotAuthorizedException, UnexpectedResponseException, InvalidParameterException, FunctionNotSupportedException, MetadataServerUncontactableException {
        return this.subjectAreaGlossary.getGlossaryRelationships(this.serverName, this.userId, glossary.getSystemAttributes().getGUID(), null, 0, 0, null, null);
    }
}

