/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.CategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.CategoryHierarchyFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GraphFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.ProjectFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RelationshipsFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaDefinitionCategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.TermFVT;

public class RunAllFVT {
    public static void main(String[] args) {
        try {
            String url = RunAllFVT.getUrl(args);
            GlossaryFVT.runWith2Servers(url);
            TermFVT.runWith2Servers(url);
            CategoryFVT.runWith2Servers(url);
            CategoryHierarchyFVT.runWith2Servers(url);
            RelationshipsFVT.runWith2Servers(url);
            SubjectAreaDefinitionCategoryFVT.runWith2Servers(url);
            ProjectFVT.runWith2Servers(url);
            GraphFVT.runWith2Servers(url);
            System.out.println("FVT ran successfully");
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            System.out.println("ERROR: " + e.getErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static String getUrl(String[] args) throws IOException {
        String url = null;
        if (args.length > 0) {
            url = args[0];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a URL. Press enter to get the default (http://localhost:8080.)):");
            url = br.readLine();
            if (url.equals("")) {
                url = "http://localhost:8080";
            }
        }
        return url;
    }
}

