/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetComments;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetInformalTags;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLikes;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRatings;

public class AssetFeedback
extends AssetPropertyBase {
    protected AssetInformalTags informalTags = null;
    protected AssetLikes likes = null;
    protected AssetRatings ratings = null;
    protected AssetComments comments = null;

    protected AssetFeedback(AssetDescriptor parentAsset) {
        super(parentAsset);
    }

    public AssetFeedback(AssetDescriptor parentAsset, AssetInformalTags informalTags, AssetLikes likes, AssetRatings ratings, AssetComments comments) {
        super(parentAsset);
        this.informalTags = informalTags;
        this.likes = likes;
        this.ratings = ratings;
        this.comments = comments;
    }

    public AssetFeedback(AssetDescriptor parentAsset, AssetFeedback templateFeedback) {
        super(parentAsset, templateFeedback);
        if (templateFeedback != null) {
            AssetInformalTags templateInformalTags = templateFeedback.getInformalTags();
            AssetLikes templateLikes = templateFeedback.getLikes();
            AssetRatings templateRatings = templateFeedback.getRatings();
            AssetComments templateComments = templateFeedback.getComments();
            if (templateInformalTags != null) {
                this.informalTags = templateInformalTags.cloneIterator(parentAsset);
            }
            if (templateLikes != null) {
                this.likes = templateLikes.cloneIterator(parentAsset);
            }
            if (templateRatings != null) {
                this.ratings = templateRatings.cloneIterator(parentAsset);
            }
            if (templateComments != null) {
                this.comments = templateComments.cloneIterator(parentAsset);
            }
        }
    }

    public AssetInformalTags getInformalTags() {
        if (this.informalTags == null) {
            return null;
        }
        return this.informalTags.cloneIterator(super.getParentAsset());
    }

    public AssetLikes getLikes() {
        if (this.likes == null) {
            return this.likes;
        }
        return this.likes.cloneIterator(super.getParentAsset());
    }

    public AssetRatings getRatings() {
        if (this.ratings == null) {
            return this.ratings;
        }
        return this.ratings.cloneIterator(super.getParentAsset());
    }

    public AssetComments getComments() {
        if (this.comments == null) {
            return this.comments;
        }
        return this.comments.cloneIterator(super.getParentAsset());
    }

    @Override
    public String toString() {
        return "AssetFeedback{informalTags=" + this.informalTags + ", likes=" + this.likes + ", ratings=" + this.ratings + ", comments=" + this.comments + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetFeedback)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetFeedback that = (AssetFeedback)objectToCompare;
        return Objects.equals(this.getInformalTags(), that.getInformalTags()) && Objects.equals(this.getLikes(), that.getLikes()) && Objects.equals(this.getRatings(), that.getRatings()) && Objects.equals(this.getComments(), that.getComments());
    }
}

