/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationEntityExtension;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataArchiveInstanceStore
extends OpenMetadataArchiveElementHeader {
    private List<EntityDetail> entities = null;
    private List<Relationship> relationships = null;
    private List<ClassificationEntityExtension> classifications = null;

    public OpenMetadataArchiveInstanceStore() {
    }

    public OpenMetadataArchiveInstanceStore(OpenMetadataArchiveInstanceStore template) {
        super(template);
        if (template != null) {
            this.entities = template.getEntities();
            this.relationships = template.getRelationships();
            this.classifications = template.getClassifications();
        }
    }

    public List<EntityDetail> getEntities() {
        if (this.entities == null) {
            return null;
        }
        if (this.entities.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> clonedList = new ArrayList<EntityDetail>();
        for (EntityDetail existingElement : this.entities) {
            clonedList.add(new EntityDetail(existingElement));
        }
        return clonedList;
    }

    public void setEntities(List<EntityDetail> entities) {
        this.entities = entities;
    }

    public List<Relationship> getRelationships() {
        if (this.relationships == null) {
            return null;
        }
        if (this.relationships.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> clonedList = new ArrayList<Relationship>();
        for (Relationship existingElement : this.relationships) {
            clonedList.add(new Relationship(existingElement));
        }
        return clonedList;
    }

    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    public List<ClassificationEntityExtension> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        ArrayList<ClassificationEntityExtension> clonedList = new ArrayList<ClassificationEntityExtension>();
        for (ClassificationEntityExtension existingElement : this.classifications) {
            clonedList.add(new ClassificationEntityExtension(existingElement));
        }
        return clonedList;
    }

    public void setClassifications(List<ClassificationEntityExtension> classifications) {
        this.classifications = classifications;
    }

    public String toString() {
        return "OpenMetadataArchiveInstanceStore{entities=" + this.entities + ", relationships=" + this.relationships + ", classifications=" + this.classifications + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OpenMetadataArchiveInstanceStore that = (OpenMetadataArchiveInstanceStore)objectToCompare;
        return Objects.equals(this.getEntities(), that.getEntities()) && Objects.equals(this.getRelationships(), that.getRelationships()) && Objects.equals(this.getClassifications(), that.getClassifications());
    }

    public int hashCode() {
        return Objects.hash(this.getEntities(), this.getRelationships(), this.getClassifications());
    }
}

