/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.events.OMRSEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventCategory;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1InstanceSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSInstanceEvent
extends OMRSEvent {
    private OMRSInstanceEventType instanceEventType = OMRSInstanceEventType.UNKNOWN_INSTANCE_EVENT;
    private String typeDefGUID = null;
    private String typeDefName = null;
    private String instanceGUID = null;
    private EntityDetail originalEntity = null;
    private EntityDetail entity = null;
    private Relationship originalRelationship = null;
    private Relationship relationship = null;
    private InstanceGraph instanceBatch = null;
    private String homeMetadataCollectionId = null;
    private String originalHomeMetadataCollectionId = null;
    private TypeDefSummary originalTypeDefSummary = null;
    private String originalInstanceGUID = null;
    private OMRSInstanceEventErrorCode errorCode = OMRSInstanceEventErrorCode.NOT_IN_USE;
    private static final Logger log = LoggerFactory.getLogger(OMRSInstanceEvent.class);

    public OMRSInstanceEvent(OMRSEventV1 inboundEvent) {
        super(inboundEvent);
        OMRSEventV1InstanceSection instanceSection = inboundEvent.getInstanceEventSection();
        if (instanceSection != null) {
            this.instanceEventType = instanceSection.getEventType();
            this.typeDefGUID = instanceSection.getTypeDefGUID();
            this.typeDefName = instanceSection.getTypeDefName();
            this.instanceGUID = instanceSection.getInstanceGUID();
            this.originalEntity = instanceSection.getOriginalEntity();
            this.entity = instanceSection.getEntity();
            this.originalRelationship = instanceSection.getOriginalRelationship();
            this.relationship = instanceSection.getRelationship();
            this.homeMetadataCollectionId = instanceSection.getHomeMetadataCollectionId();
            this.originalHomeMetadataCollectionId = instanceSection.getOriginalHomeMetadataCollectionId();
            this.originalTypeDefSummary = instanceSection.getOriginalTypeDefSummary();
            this.originalInstanceGUID = instanceSection.getOriginalInstanceGUID();
            this.instanceBatch = instanceSection.getInstanceBatch();
        }
        if (this.genericErrorCode != null) {
            switch (this.genericErrorCode) {
                case CONFLICTING_INSTANCES: {
                    this.errorCode = OMRSInstanceEventErrorCode.CONFLICTING_INSTANCES;
                    break;
                }
                case CONFLICTING_TYPE: {
                    this.errorCode = OMRSInstanceEventErrorCode.CONFLICTING_TYPE;
                    break;
                }
                default: {
                    this.errorCode = OMRSInstanceEventErrorCode.UNKNOWN_ERROR_CODE;
                }
            }
        }
    }

    public OMRSInstanceEvent(OMRSInstanceEventType instanceEventType, EntityDetail entity) {
        super(OMRSEventCategory.INSTANCE);
        this.instanceEventType = instanceEventType;
        this.entity = entity;
        InstanceType type = entity.getType();
        if (type != null) {
            this.typeDefGUID = type.getTypeDefGUID();
            this.typeDefName = type.getTypeDefName();
        }
    }

    public OMRSInstanceEvent(OMRSInstanceEventType instanceEventType, EntityDetail originalEntity, EntityDetail newEntity) {
        super(OMRSEventCategory.INSTANCE);
        this.instanceEventType = instanceEventType;
        this.originalEntity = originalEntity;
        this.entity = newEntity;
        InstanceType type = newEntity.getType();
        if (type != null) {
            this.typeDefGUID = type.getTypeDefGUID();
            this.typeDefName = type.getTypeDefName();
        }
    }

    public OMRSInstanceEvent(OMRSInstanceEventType instanceEventType, Relationship relationship) {
        super(OMRSEventCategory.INSTANCE);
        this.instanceEventType = instanceEventType;
        this.relationship = relationship;
        InstanceType type = relationship.getType();
        if (type != null) {
            this.typeDefGUID = type.getTypeDefGUID();
            this.typeDefName = type.getTypeDefName();
        }
    }

    public OMRSInstanceEvent(OMRSInstanceEventType instanceEventType, Relationship originalRelationship, Relationship newRelationship) {
        super(OMRSEventCategory.INSTANCE);
        this.instanceEventType = instanceEventType;
        this.originalRelationship = originalRelationship;
        this.relationship = newRelationship;
        InstanceType type = newRelationship.getType();
        if (type != null) {
            this.typeDefGUID = type.getTypeDefGUID();
            this.typeDefName = type.getTypeDefName();
        }
    }

    public OMRSInstanceEvent(OMRSInstanceEventType instanceEventType, String typeDefGUID, String typeDefName, String instanceGUID) {
        super(OMRSEventCategory.INSTANCE);
        this.instanceEventType = instanceEventType;
        this.typeDefGUID = typeDefGUID;
        this.typeDefName = typeDefName;
        this.instanceGUID = instanceGUID;
    }

    public OMRSInstanceEvent(OMRSInstanceEventType instanceEventType, InstanceGraph instances) {
        super(OMRSEventCategory.INSTANCE);
        this.instanceEventType = instanceEventType;
        this.instanceBatch = instances;
    }

    public OMRSInstanceEvent(OMRSInstanceEventErrorCode errorCode, String errorMessage, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDefSummary, String otherInstanceGUID) {
        super(OMRSEventCategory.INSTANCE, errorCode.getEncoding(), errorMessage, targetMetadataCollectionId, targetTypeDefSummary, targetInstanceGUID, otherMetadataCollectionId, otherOrigin, otherTypeDefSummary, otherInstanceGUID);
        this.errorCode = errorCode;
    }

    public OMRSInstanceEvent(OMRSInstanceEventErrorCode errorCode, String errorMessage, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, TypeDefSummary otherTypeDefSummary) {
        super(OMRSEventCategory.INSTANCE, errorCode.getEncoding(), errorMessage, targetMetadataCollectionId, targetTypeDefSummary, targetInstanceGUID, otherTypeDefSummary);
        this.errorCode = errorCode;
    }

    public void setHomeMetadataCollectionId(String homeMetadataCollectionId) {
        this.homeMetadataCollectionId = homeMetadataCollectionId;
    }

    public void setOriginalHomeMetadataCollectionId(String originalHomeMetadataCollectionId) {
        this.originalHomeMetadataCollectionId = originalHomeMetadataCollectionId;
    }

    public void setOriginalTypeDefSummary(TypeDefSummary originalTypeDefSummary) {
        this.originalTypeDefSummary = originalTypeDefSummary;
    }

    public void setOriginalInstanceGUID(String originalInstanceGUID) {
        this.originalInstanceGUID = originalInstanceGUID;
    }

    public OMRSInstanceEventType getInstanceEventType() {
        return this.instanceEventType;
    }

    public String getTypeDefGUID() {
        return this.typeDefGUID;
    }

    public String getTypeDefName() {
        return this.typeDefName;
    }

    public String getInstanceGUID() {
        return this.instanceGUID;
    }

    public EntityDetail getOriginalEntity() {
        return this.originalEntity;
    }

    public EntityDetail getEntity() {
        return this.entity;
    }

    public Relationship getOriginalRelationship() {
        return this.originalRelationship;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public InstanceGraph getInstanceBatch() {
        return this.instanceBatch;
    }

    public String getHomeMetadataCollectionId() {
        return this.homeMetadataCollectionId;
    }

    public String getOriginalHomeMetadataCollectionId() {
        return this.originalHomeMetadataCollectionId;
    }

    public TypeDefSummary getOriginalTypeDefSummary() {
        return this.originalTypeDefSummary;
    }

    public String getOriginalInstanceGUID() {
        return this.originalInstanceGUID;
    }

    public OMRSInstanceEventErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public OMRSEventV1 getOMRSEventV1() {
        OMRSEventV1 omrsEvent = super.getOMRSEventV1();
        OMRSEventV1InstanceSection instanceSection = new OMRSEventV1InstanceSection();
        instanceSection.setEventType(this.instanceEventType);
        instanceSection.setTypeDefGUID(this.typeDefGUID);
        instanceSection.setTypeDefName(this.typeDefName);
        instanceSection.setInstanceGUID(this.instanceGUID);
        instanceSection.setOriginalEntity(this.originalEntity);
        instanceSection.setEntity(this.entity);
        instanceSection.setOriginalRelationship(this.originalRelationship);
        instanceSection.setRelationship(this.relationship);
        instanceSection.setInstanceBatch(this.instanceBatch);
        instanceSection.setHomeMetadataCollectionId(this.homeMetadataCollectionId);
        instanceSection.setOriginalHomeMetadataCollectionId(this.originalHomeMetadataCollectionId);
        instanceSection.setOriginalTypeDefSummary(this.originalTypeDefSummary);
        instanceSection.setOriginalInstanceGUID(this.originalInstanceGUID);
        omrsEvent.setInstanceEventSection(instanceSection);
        return omrsEvent;
    }

    @Override
    public String toString() {
        return "OMRSInstanceEvent{instanceEventType=" + this.instanceEventType + ", typeDefGUID='" + this.typeDefGUID + '\'' + ", typeDefName='" + this.typeDefName + '\'' + ", instanceGUID='" + this.instanceGUID + '\'' + ", originalEntity=" + this.originalEntity + ", entity=" + this.entity + ", originalRelationship=" + this.originalRelationship + ", relationship=" + this.relationship + ", instanceBatch=" + this.instanceBatch + ", homeMetadataCollectionId='" + this.homeMetadataCollectionId + '\'' + ", originalHomeMetadataCollectionId='" + this.originalHomeMetadataCollectionId + '\'' + ", originalTypeDefSummary=" + this.originalTypeDefSummary + ", originalInstanceGUID='" + this.originalInstanceGUID + '\'' + ", errorCode=" + this.errorCode + ", eventTimestamp=" + this.eventTimestamp + ", eventDirection=" + this.eventDirection + ", eventCategory=" + this.eventCategory + ", eventOriginator=" + this.eventOriginator + ", genericErrorCode=" + this.genericErrorCode + ", errorMessage='" + this.errorMessage + '\'' + ", targetMetadataCollectionId='" + this.targetMetadataCollectionId + '\'' + ", targetRemoteConnection=" + this.targetRemoteConnection + ", targetTypeDefSummary=" + this.targetTypeDefSummary + ", targetAttributeTypeDef=" + this.targetAttributeTypeDef + ", targetInstanceGUID='" + this.targetInstanceGUID + '\'' + ", otherOrigin=" + this.otherOrigin + ", otherMetadataCollectionId='" + this.otherMetadataCollectionId + '\'' + ", otherTypeDefSummary=" + this.otherTypeDefSummary + ", otherTypeDef=" + this.otherTypeDef + ", otherAttributeTypeDef=" + this.otherAttributeTypeDef + ", otherInstanceGUID='" + this.otherInstanceGUID + '\'' + ", OMRSEventV1=" + this.getOMRSEventV1() + '}';
    }
}

