/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.FVTUtils;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;

public class CategoryFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for category sample";
    private static final String DEFAULT_TEST_CATEGORY_NAME = "Test category A";
    private static final String DEFAULT_TEST_CATEGORY_NAME_UPDATED = "Test category A updated";
    private static final String DEFAULT_TEST_CATEGORY_NAME2 = "Test category B";
    private static final String DEFAULT_TEST_CATEGORY_NAME3 = "Test category C";
    private SubjectAreaCategory subjectAreaCategory = null;
    private GlossaryFVT glossaryFVT = null;
    private String serverName = null;
    private String userId = null;

    public static void main(String[] args) {
        Object subjectArea = null;
        String url = null;
        try {
            url = RunAllFVT.getUrl(args);
            CategoryFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            System.out.println("ERROR: " + e.getErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runWith2Servers(String url) throws SubjectAreaCheckedExceptionBase {
        CategoryFVT fvt = new CategoryFVT(url, "Server1", "Fred");
        fvt.run();
        CategoryFVT fvt2 = new CategoryFVT(url, "Server2", "Fred");
        fvt2.run();
    }

    public CategoryFVT(String url, String serverName, String userId) throws InvalidParameterException {
        this.subjectAreaCategory = new SubjectAreaImpl(serverName, url).getSubjectAreaCategory();
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.serverName = serverName;
        this.userId = userId;
    }

    public static void runIt(String url, String serverName, String userId) throws SubjectAreaCheckedExceptionBase {
        CategoryFVT fvt = new CategoryFVT(url, serverName, userId);
        fvt.run();
    }

    public void run() throws SubjectAreaCheckedExceptionBase {
        System.out.println("Create a glossary");
        Glossary glossary = this.glossaryFVT.createGlossary(this.serverName + " " + DEFAULT_TEST_GLOSSARY_NAME);
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        System.out.println("Create a category1");
        Category category1 = this.createCategoryWithGlossaryGuid(this.serverName + " " + DEFAULT_TEST_CATEGORY_NAME, glossary.getSystemAttributes().getGUID());
        System.out.println("Create a category2");
        Category category2 = this.createCategoryWithGlossaryGuid(this.serverName + " " + DEFAULT_TEST_CATEGORY_NAME2, glossary.getSystemAttributes().getGUID());
        FVTUtils.validateNode(category1);
        FVTUtils.validateNode(category2);
        Category categoryForUpdate = new Category();
        categoryForUpdate.setName(this.serverName + " " + DEFAULT_TEST_CATEGORY_NAME_UPDATED);
        System.out.println("Get the category1");
        String guid = category1.getSystemAttributes().getGUID();
        Category gotCategory = this.getCategoryByGUID(guid);
        FVTUtils.validateNode(gotCategory);
        System.out.println("Update the category1");
        Category updatedCategory = this.updateCategory(guid, categoryForUpdate);
        FVTUtils.validateNode(updatedCategory);
        System.out.println("Get the category1 again");
        gotCategory = this.getCategoryByGUID(guid);
        FVTUtils.validateNode(gotCategory);
        System.out.println("Delete the category1");
        gotCategory = this.deleteCategory(guid);
        FVTUtils.validateNode(gotCategory);
        System.out.println("Restore the category1");
        gotCategory = this.restoreCategory(guid);
        FVTUtils.validateNode(gotCategory);
        System.out.println("Delete the category1");
        gotCategory = this.deleteCategory(guid);
        FVTUtils.validateNode(gotCategory);
        System.out.println("Purge a category1");
        this.purgeCategory(gotCategory.getSystemAttributes().getGUID());
        System.out.println("Create a category with a parent category");
        Category category3 = this.createCategoryWithParentGlossaryGuid(this.serverName, this.serverName + " " + DEFAULT_TEST_CATEGORY_NAME3, category2.getSystemAttributes().getGUID(), glossary.getSystemAttributes().getGUID());
        FVTUtils.validateNode(category3);
        System.out.println("create categories to find");
        Category categoryForFind1 = this.getCategoryForInput("abc", glossaryGuid);
        categoryForFind1.setQualifiedName("yyy");
        categoryForFind1 = this.issueCreateCategory(categoryForFind1);
        FVTUtils.validateNode(categoryForFind1);
        Category categoryForFind2 = this.createCategory("yyy", glossaryGuid);
        FVTUtils.validateNode(categoryForFind2);
        Category categoryForFind3 = this.createCategory("zzz", glossaryGuid);
        FVTUtils.validateNode(categoryForFind3);
        Category categoryForFind4 = this.createCategory("This is a Category with spaces in name", glossaryGuid);
        FVTUtils.validateNode(categoryForFind4);
        List<Category> results = this.findCategories("zzz");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 1 back on the find got " + results.size(), "", "");
        }
        results = this.findCategories("yyy");
        if (results.size() != 2) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 2 back on the find got " + results.size(), "", "");
        }
        Category deleted4 = this.deleteCategory(categoryForFind2.getSystemAttributes().getGUID());
        FVTUtils.validateNode(deleted4);
        results = this.findCategories("yyy");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 1 back on the find got " + results.size(), "", "");
        }
        results = this.findCategories("This is a Category with spaces in name");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException(0, "", "", "ERROR: Expected 1 back on the find got " + results.size(), "", "");
        }
    }

    private Category createCategoryWithParentGlossaryGuid(String serverName, String subjectAreaName, String parentGuid, String glossaryGuid) throws SubjectAreaCheckedExceptionBase {
        Category category = new Category();
        category.setName(subjectAreaName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        category.setGlossary(glossarySummary);
        CategorySummary parentCategory = new CategorySummary();
        parentCategory.setGuid(parentGuid);
        category.setParentCategory(parentCategory);
        Category newCategory = this.subjectAreaCategory.createCategory(this.userId, category);
        FVTUtils.validateNode(newCategory);
        System.out.println("Created Category " + newCategory.getName() + " with glossaryGuid " + newCategory.getSystemAttributes().getGUID());
        return newCategory;
    }

    public Category createCategoryWithGlossaryGuid(String categoryName, String glossaryGuid) throws SubjectAreaCheckedExceptionBase {
        Category category = new Category();
        category.setName(categoryName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        category.setGlossary(glossarySummary);
        Category newCategory = this.subjectAreaCategory.createCategory(this.userId, category);
        FVTUtils.validateNode(newCategory);
        System.out.println("Created Category " + newCategory.getName() + " with guid " + newCategory.getSystemAttributes().getGUID());
        return newCategory;
    }

    public Category createCategory(String categoryName, String glossaryGuid) throws SubjectAreaCheckedExceptionBase {
        Category category = this.getCategoryForInput(categoryName, glossaryGuid);
        return this.issueCreateCategory(category);
    }

    private Category issueCreateCategory(Category category) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException, UnrecognizedGUIDException {
        Category newCategory = this.subjectAreaCategory.createCategory(this.userId, category);
        if (newCategory != null) {
            System.out.println("Created Category " + newCategory.getName() + " with guid " + newCategory.getSystemAttributes().getGUID());
        }
        return newCategory;
    }

    private Category getCategoryForInput(String categoryName, String glossaryGuid) {
        Category category = new Category();
        category.setName(categoryName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        category.setGlossary(glossarySummary);
        return category;
    }

    public Category getCategoryByGUID(String guid) throws SubjectAreaCheckedExceptionBase {
        Category category = this.subjectAreaCategory.getCategoryByGuid(this.userId, guid);
        FVTUtils.validateNode(category);
        System.out.println("Got Category " + category.getName() + " with guid " + category.getSystemAttributes().getGUID() + " and status " + category.getSystemAttributes().getStatus());
        return category;
    }

    public List<Category> findCategories(String criteria) throws SubjectAreaCheckedExceptionBase {
        List<Category> categories = this.subjectAreaCategory.findCategory(this.userId, criteria, null, 0, 0, null, null);
        return categories;
    }

    public Category updateCategory(String guid, Category category) throws SubjectAreaCheckedExceptionBase {
        Category updatedCategory = this.subjectAreaCategory.updateCategory(this.userId, guid, category);
        FVTUtils.validateNode(updatedCategory);
        System.out.println("Updated Category name to " + updatedCategory.getName());
        return updatedCategory;
    }

    public Category deleteCategory(String guid) throws SubjectAreaCheckedExceptionBase {
        Category deletedCategory = this.subjectAreaCategory.deleteCategory(this.userId, guid);
        System.out.println("Deleted Category name is " + deletedCategory.getName());
        return deletedCategory;
    }

    public Category restoreCategory(String guid) throws SubjectAreaCheckedExceptionBase {
        Category restoredCategory = this.subjectAreaCategory.restoreCategory(this.userId, guid);
        FVTUtils.validateNode(restoredCategory);
        System.out.println("restored Category name is " + restoredCategory.getName());
        return restoredCategory;
    }

    public void purgeCategory(String guid) throws SubjectAreaCheckedExceptionBase {
        this.subjectAreaCategory.purgeCategory(this.userId, guid);
        System.out.println("Purge succeeded");
    }

    public List<Line> getCategoryRelationships(Category category) throws UserNotAuthorizedException, UnexpectedResponseException, InvalidParameterException, FunctionNotSupportedException, MetadataServerUncontactableException {
        return this.subjectAreaCategory.getCategoryRelationships(this.userId, category.getSystemAttributes().getGUID(), null, 0, 0, null, null);
    }
}

