/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.CategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.CategoryHierarchyFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GraphFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RelationshipsFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaDefinitionCategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.TermFVT;

public class RunAllFVTNow {
    public static void main(String[] args) {
        try {
            String url = RunAllFVTNow.getUrl(args);
            String serverName = RunAllFVTNow.getServerName(args);
            String userId = RunAllFVTNow.getUserId(args);
            GlossaryFVT.runIt(url, serverName, userId);
            TermFVT.runIt(url, serverName, userId);
            CategoryFVT.runIt(url, serverName, userId);
            CategoryHierarchyFVT.runIt(url, serverName, userId);
            RelationshipsFVT.runIt(url, serverName, userId);
            SubjectAreaDefinitionCategoryFVT.runIt(url, serverName, userId);
            GraphFVT.runIt(url, serverName, userId);
            System.out.println("FVT ran successfully");
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaCheckedExceptionBase e) {
            System.out.println("ERROR: " + e.getErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static String getServerName(String[] args) throws IOException {
        String name = null;
        if (args.length > 1) {
            name = args[1];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a OMAG Server Name. Press enter to get the default (Server1)) :");
            name = br.readLine();
            if (name.equals("")) {
                name = "Server1";
            }
        }
        return name;
    }

    public static String getUserId(String[] args) throws IOException {
        String userId = null;
        if (args.length > 2) {
            userId = args[2];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a userId. Press enter to get the default (Fred)) :");
            userId = br.readLine();
            if (userId.equals("")) {
                userId = "Fred";
            }
        }
        return userId;
    }

    public static String getUrl(String[] args) throws IOException {
        String url = null;
        if (args.length > 0) {
            url = args[0];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a URL. Press enter to get the default (http://localhost:8080.)) :");
            url = br.readLine();
            if (url.equals("")) {
                url = "http://localhost:8080";
            }
        }
        return url;
    }
}

