/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaImplementationQueries;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DerivedSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;

public class AssetDerivedSchemaAttribute
extends AssetSchemaAttribute {
    protected DerivedSchemaAttribute schemaAttributeBean;
    protected AssetSchemaImplementationQueries queries;

    public AssetDerivedSchemaAttribute(DerivedSchemaAttribute schemaAttributeBean, AssetSchemaType localSchemaType, AssetSchemaImplementationQueries queries) {
        super((SchemaAttribute)schemaAttributeBean, localSchemaType);
        this.schemaAttributeBean = schemaAttributeBean == null ? new DerivedSchemaAttribute() : schemaAttributeBean;
        this.queries = queries;
    }

    public AssetDerivedSchemaAttribute(DerivedSchemaAttribute schemaAttributeBean, AssetSchemaLink externalSchemaLink, AssetSchemaImplementationQueries queries) {
        super((SchemaAttribute)schemaAttributeBean, externalSchemaLink);
        this.schemaAttributeBean = schemaAttributeBean == null ? new DerivedSchemaAttribute() : schemaAttributeBean;
        this.queries = queries;
    }

    public AssetDerivedSchemaAttribute(AssetDescriptor parentAsset, DerivedSchemaAttribute schemaAttributeBean, AssetSchemaType localSchemaType, AssetSchemaImplementationQueries queries) {
        super(parentAsset, (SchemaAttribute)schemaAttributeBean, localSchemaType);
        this.schemaAttributeBean = schemaAttributeBean == null ? new DerivedSchemaAttribute() : schemaAttributeBean;
        this.queries = queries;
    }

    public AssetDerivedSchemaAttribute(AssetDescriptor parentAsset, DerivedSchemaAttribute schemaAttributeBean, AssetSchemaLink externalSchemaLink, AssetSchemaImplementationQueries queries) {
        super(parentAsset, (SchemaAttribute)schemaAttributeBean, externalSchemaLink);
        this.schemaAttributeBean = schemaAttributeBean == null ? new DerivedSchemaAttribute() : schemaAttributeBean;
        this.queries = queries;
    }

    public AssetDerivedSchemaAttribute(AssetDescriptor parentAsset, AssetDerivedSchemaAttribute template) {
        super(parentAsset, template);
        if (template == null) {
            this.schemaAttributeBean = new DerivedSchemaAttribute();
            this.queries = null;
        } else {
            this.schemaAttributeBean = template.getDerivedSchemaAttributeBean();
            AssetSchemaImplementationQueries queries = template.getQueries();
            this.queries = queries == null ? null : queries.cloneIterator(super.getParentAsset());
        }
    }

    protected DerivedSchemaAttribute getDerivedSchemaAttributeBean() {
        return this.schemaAttributeBean;
    }

    public String getFormula() {
        return this.schemaAttributeBean.getFormula();
    }

    public AssetSchemaImplementationQueries getQueries() {
        if (this.queries == null) {
            return null;
        }
        return this.queries.cloneIterator(super.getParentAsset());
    }

    @Override
    public AssetSchemaAttribute cloneAssetSchemaAttribute(AssetDescriptor parentAsset) {
        return new AssetDerivedSchemaAttribute(parentAsset, this);
    }

    @Override
    public String toString() {
        return "AssetDerivedSchemaAttribute{queries=" + this.queries + ", parentAsset=" + this.parentAsset + ", formula='" + this.getFormula() + '\'' + ", attributeName='" + this.getAttributeName() + '\'' + ", elementPosition=" + this.getElementPosition() + ", cardinality='" + this.getCardinality() + '\'' + ", defaultValueOverride='" + this.getDefaultValueOverride() + '\'' + ", localSchemaType=" + this.getLocalSchemaType() + ", externalSchemaLink=" + this.getExternalSchemaLink() + ", attributeRelationships=" + this.getAttributeRelationships() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", assetClassifications=" + this.getAssetClassifications() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetDerivedSchemaAttribute)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetDerivedSchemaAttribute that = (AssetDerivedSchemaAttribute)objectToCompare;
        return Objects.equals(this.getDerivedSchemaAttributeBean(), that.getDerivedSchemaAttributeBean()) && Objects.equals(this.getQueries(), that.getQueries());
    }
}

