/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeRelationship;

public class AssetSchemaAttribute
extends AssetReferenceable {
    protected SchemaAttribute schemaAttributeBean;
    protected AssetSchemaType localSchemaType = null;
    protected AssetSchemaLink externalSchemaLink = null;

    protected AssetSchemaAttribute(SchemaAttribute schemaAttributeBean) {
        super(schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
    }

    public AssetSchemaAttribute(SchemaAttribute schemaAttributeBean, AssetSchemaType localSchemaType) {
        super(schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
        this.localSchemaType = localSchemaType;
    }

    public AssetSchemaAttribute(SchemaAttribute schemaAttributeBean, AssetSchemaLink externalSchemaLink) {
        super(schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
        this.externalSchemaLink = externalSchemaLink;
    }

    protected AssetSchemaAttribute(AssetDescriptor parentAsset, SchemaAttribute schemaAttributeBean) {
        super(parentAsset, schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
    }

    public AssetSchemaAttribute(AssetDescriptor parentAsset, SchemaAttribute schemaAttributeBean, AssetSchemaType localSchemaType) {
        super(parentAsset, schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
        this.localSchemaType = localSchemaType;
    }

    public AssetSchemaAttribute(AssetDescriptor parentAsset, SchemaAttribute schemaAttributeBean, AssetSchemaLink externalSchemaLink) {
        super(parentAsset, schemaAttributeBean);
        this.schemaAttributeBean = schemaAttributeBean == null ? new SchemaAttribute() : schemaAttributeBean;
        this.externalSchemaLink = externalSchemaLink;
    }

    public AssetSchemaAttribute(AssetDescriptor parentAsset, AssetSchemaAttribute template) {
        super(parentAsset, template);
        if (template == null) {
            this.schemaAttributeBean = new SchemaAttribute();
        } else {
            this.schemaAttributeBean = template.getSchemaAttributeBean();
            this.localSchemaType = template.getLocalSchemaType();
            this.externalSchemaLink = template.getExternalSchemaLink();
        }
    }

    public AssetSchemaAttribute cloneAssetSchemaAttribute(AssetDescriptor parentAsset) {
        return new AssetSchemaAttribute(parentAsset, this);
    }

    protected SchemaAttribute getSchemaAttributeBean() {
        return this.schemaAttributeBean;
    }

    public String getAttributeName() {
        return this.schemaAttributeBean.getAttributeName();
    }

    public int getElementPosition() {
        return this.schemaAttributeBean.getElementPosition();
    }

    public String getCardinality() {
        return this.schemaAttributeBean.getCardinality();
    }

    public String getDefaultValueOverride() {
        return this.schemaAttributeBean.getDefaultValueOverride();
    }

    public AssetSchemaType getLocalSchemaType() {
        if (this.localSchemaType == null) {
            return null;
        }
        return this.localSchemaType.cloneAssetSchemaType(super.getParentAsset());
    }

    public AssetSchemaLink getExternalSchemaLink() {
        if (this.externalSchemaLink == null) {
            return null;
        }
        return new AssetSchemaLink(super.getParentAsset(), this.externalSchemaLink);
    }

    public List<SchemaAttributeRelationship> getAttributeRelationships() {
        return this.schemaAttributeBean.getAttributeRelationships();
    }

    @Override
    public String toString() {
        return "AssetSchemaAttribute{schemaAttributeBean=" + this.schemaAttributeBean + ", localSchemaType=" + this.localSchemaType + ", externalSchemaLink=" + this.externalSchemaLink + ", parentAsset=" + this.parentAsset + ", attributeName='" + this.getAttributeName() + '\'' + ", elementPosition=" + this.getElementPosition() + ", cardinality='" + this.getCardinality() + '\'' + ", defaultValueOverride='" + this.getDefaultValueOverride() + '\'' + ", attributeRelationships=" + this.getAttributeRelationships() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", assetClassifications=" + this.getAssetClassifications() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetSchemaAttribute)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetSchemaAttribute that = (AssetSchemaAttribute)objectToCompare;
        return Objects.equals(this.getSchemaAttributeBean(), that.getSchemaAttributeBean()) && Objects.equals(this.localSchemaType, that.localSchemaType);
    }
}

