/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.omrstopic;

import java.util.concurrent.Future;
import org.odpi.openmetadata.repositoryservices.events.future.CompletedFuture;
import org.odpi.openmetadata.repositoryservices.events.future.CompoundFuture;
import org.odpi.openmetadata.repositoryservices.events.future.OMRSFuture;
import org.odpi.openmetadata.repositoryservices.events.future.OMRSFutureImpl;

public class InternalOMRSEventProcessingContext {
    private static final ThreadLocal<InternalOMRSEventProcessingContext> INSTANCE = new ThreadLocal();
    private String currentMessageId;
    private final CompoundFuture processingResult = new CompoundFuture();

    public void addAsyncProcessingResult(Future<?> future) {
        this.processingResult.addFuture(new OMRSFutureImpl(future));
    }

    public void addAsyncProcessingResult(OMRSFuture future) {
        this.processingResult.addFuture(future);
    }

    public OMRSFuture getOverallAsyncProcessingResult() {
        if (this.processingResult.hasChildren()) {
            return this.processingResult;
        }
        return CompletedFuture.INSTANCE;
    }

    public static InternalOMRSEventProcessingContext getInstance() {
        InternalOMRSEventProcessingContext instance = INSTANCE.get();
        if (instance == null) {
            instance = new InternalOMRSEventProcessingContext();
            INSTANCE.set(instance);
        }
        return instance;
    }

    public static void clear() {
        INSTANCE.set(null);
    }

    public String getCurrentMessageId() {
        return this.currentMessageId;
    }

    public void setCurrentMessageId(String messageId) {
        this.currentMessageId = messageId;
    }
}

