/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.omrstopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.auditable.AuditableConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopic;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerWrapper;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventProtocolVersion;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.beans.OMRSEventBean;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSTopicConnector
extends ConnectorBase
implements OMRSTopic,
VirtualConnectorExtension,
OpenMetadataTopicListener,
AuditableConnector {
    private static final Logger log = LoggerFactory.getLogger(OMRSTopicConnector.class);
    private List<Connector> embeddedConnectors = null;
    private List<OMRSTopicListener> internalTopicListeners = new ArrayList<OMRSTopicListener>();
    private List<OpenMetadataTopicConnector> eventBusConnectors = new ArrayList<OpenMetadataTopicConnector>();
    private String connectionName = OMRSAuditingComponent.OMRS_TOPIC_CONNECTOR.getComponentName();
    private String topicName = "<Unknown>";
    private OMRSEventProtocolVersion eventProtocolVersion = OMRSEventProtocolVersion.V1;
    protected OMRSAuditLog auditLog = null;

    @Override
    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    @Override
    public void setAuditLog(OMRSAuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public void setEventProtocolLevel(OMRSEventProtocolVersion eventProtocolVersion) {
        if (eventProtocolVersion != null) {
            this.eventProtocolVersion = eventProtocolVersion;
        }
    }

    @Override
    @Deprecated
    public void registerListener(OMRSTopicListener topicListener) {
        if (topicListener == null) {
            String methodName = "registerListener";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_OPEN_METADATA_TOPIC_LISTENER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "registerListener", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.internalTopicListeners.add(new OMRSTopicListenerWrapper(topicListener, this.auditLog));
    }

    @Override
    public void registerListener(OMRSTopicListener topicListener, String serviceName) {
        if (topicListener == null) {
            String methodName = "registerListener";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_OPEN_METADATA_TOPIC_LISTENER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "registerListener", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.internalTopicListeners.add(new OMRSTopicListenerWrapper(topicListener, serviceName, this.auditLog));
    }

    @Override
    public void start() throws ConnectorCheckedException {
        OMRSAuditCode auditCode;
        super.start();
        String methodName = "start";
        this.connectionName = OMRSAuditingComponent.OMRS_TOPIC_CONNECTOR.getComponentName();
        log.debug("Initializing OMRSTopicConnector: " + this.connectionName);
        if (this.embeddedConnectors != null) {
            log.debug("OMRSTopicConnector: " + this.connectionName + " supplied with " + this.embeddedConnectors.size() + " embedded connectors");
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (embeddedConnector == null || !(embeddedConnector instanceof OpenMetadataTopicConnector)) continue;
                OpenMetadataTopicConnector realTopicConnector = (OpenMetadataTopicConnector)embeddedConnector;
                if (this.auditLog != null) {
                    realTopicConnector.setAuditLog(this.auditLog.createNewAuditLog(OMRSAuditingComponent.OPEN_METADATA_TOPIC_CONNECTOR));
                }
                this.topicName = realTopicConnector.registerListener(this);
                this.eventBusConnectors.add(realTopicConnector);
                if (this.auditLog == null) continue;
                OMRSAuditCode auditCode2 = OMRSAuditCode.OMRS_TOPIC_LISTENER_REGISTERED;
                this.auditLog.logRecord("start", auditCode2.getLogMessageId(), auditCode2.getSeverity(), auditCode2.getFormattedLogMessage(this.topicName), this.getConnection().toString(), auditCode2.getSystemAction(), auditCode2.getUserAction());
            }
        }
        if (this.eventBusConnectors.isEmpty()) {
            if (this.auditLog != null) {
                auditCode = OMRSAuditCode.OMRS_TOPIC_LISTENER_DEAF;
                this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.NO_EVENT_BUS_CONNECTORS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName);
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "start", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.start();
        }
        if (this.auditLog != null) {
            auditCode = OMRSAuditCode.OMRS_TOPIC_LISTENER_STARTED;
            this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.topicName), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void handleUnsupportedEventVersion(String methodName) throws ConnectorCheckedException {
        log.debug("Unsupported Protocol: " + this.eventProtocolVersion);
        OMRSErrorCode errorCode = OMRSErrorCode.OMRS_UNSUPPORTED_EVENT_PROTOCOL;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName, this.eventProtocolVersion.toString());
        throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    @Override
    public void sendRegistryEvent(OMRSRegistryEvent registryEvent) throws ConnectorCheckedException {
        String methodName = "sendRegistryEvent";
        if (this.eventProtocolVersion == OMRSEventProtocolVersion.V1) {
            this.sendEvent(registryEvent.getOMRSEventV1());
        } else {
            this.handleUnsupportedEventVersion("sendRegistryEvent");
        }
    }

    @Override
    public void sendTypeDefEvent(OMRSTypeDefEvent typeDefEvent) throws ConnectorCheckedException {
        String methodName = "sendTypeDefEvent";
        if (this.eventProtocolVersion == OMRSEventProtocolVersion.V1) {
            this.sendEvent(typeDefEvent.getOMRSEventV1());
        } else {
            this.handleUnsupportedEventVersion("sendTypeDefEvent");
        }
    }

    @Override
    public void sendInstanceEvent(OMRSInstanceEvent instanceEvent) throws ConnectorCheckedException {
        String methodName = "sendInstanceEvent";
        if (this.eventProtocolVersion == OMRSEventProtocolVersion.V1) {
            this.sendEvent(instanceEvent.getOMRSEventV1());
        } else {
            this.handleUnsupportedEventVersion("sendInstanceEvent");
        }
    }

    private void sendEvent(OMRSEventV1 event) throws ConnectorCheckedException {
        String methodName = "send";
        if (event != null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
                    if (eventBusConnector == null) continue;
                    eventBusConnector.sendEvent(objectMapper.writeValueAsString(event));
                }
            }
            catch (ConnectorCheckedException exc) {
                log.debug("Unable to send event: " + exc.getMessage());
                throw exc;
            }
            catch (Throwable exc) {
                log.debug("Unexpected error sending event: " + exc.getMessage());
                OMRSErrorCode errorCode = OMRSErrorCode.OMRS_TOPIC_SEND_EVENT_FAILED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName, event.toString(), exc.getMessage());
                throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "send", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), exc);
            }
        } else {
            log.debug("Unable to send null events");
            OMRSErrorCode errorCode = OMRSErrorCode.OMRS_TOPIC_SEND_NULL_EVENT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.connectionName);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "send", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    @Override
    public void processEvent(String event) {
        String actionDescription = "Process an OMRS Event";
        String methodName = "processEvent";
        if (event != null) {
            OMRSEventBean eventBean;
            block6: {
                eventBean = null;
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    eventBean = objectMapper.readValue(event, OMRSEventBean.class);
                }
                catch (Throwable exception) {
                    if (this.auditLog == null) break block6;
                    OMRSAuditCode auditCode = OMRSAuditCode.EVENT_PARSING_ERROR;
                    this.auditLog.logException("Process an OMRS Event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(event, exception.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction(), exception);
                }
            }
            if (eventBean instanceof OMRSEventV1) {
                OMRSEventBean finalEventBean = eventBean;
                this.internalTopicListeners.parallelStream().forEach(topicListener -> {
                    block2: {
                        try {
                            this.processOMRSEvent((OMRSEventV1)finalEventBean, (OMRSTopicListener)topicListener);
                        }
                        catch (Throwable error) {
                            log.debug("Unable to pass event to one of the topic listeners");
                            if (this.auditLog == null) break block2;
                            OMRSAuditCode auditCode = OMRSAuditCode.EVENT_PROCESSING_ERROR;
                            this.auditLog.logException("processEvent", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(event, error.toString(), topicListener.toString()), event, auditCode.getSystemAction(), auditCode.getUserAction(), error);
                        }
                    }
                });
            }
        } else {
            log.debug("Unable to process null events");
            if (this.auditLog != null) {
                OMRSAuditCode auditCode = OMRSAuditCode.NULL_EVENT_TO_PROCESS;
                this.auditLog.logRecord("Process an OMRS Event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.connectionName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
    }

    private void processOMRSEvent(OMRSEventV1 event, OMRSTopicListener topicListener) {
        String actionDescription = "Process Incoming Event";
        if (event != null) {
            switch (event.getEventCategory()) {
                case REGISTRY: {
                    topicListener.processRegistryEvent(new OMRSRegistryEvent(event));
                    break;
                }
                case TYPEDEF: {
                    topicListener.processTypeDefEvent(new OMRSTypeDefEvent(event));
                    break;
                }
                case INSTANCE: {
                    topicListener.processInstanceEvent(new OMRSInstanceEvent(event));
                    break;
                }
                default: {
                    if (this.auditLog != null) {
                        OMRSAuditCode auditCode = OMRSAuditCode.PROCESS_UNKNOWN_EVENT;
                        this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), "event {" + event.toString() + "}", auditCode.getSystemAction(), auditCode.getUserAction());
                    }
                    log.debug("Unknown event received :|");
                    break;
                }
            }
        } else {
            if (this.auditLog != null) {
                OMRSAuditCode auditCode = OMRSAuditCode.NULL_OMRS_EVENT_RECEIVED;
                this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.topicName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
            log.debug("Null OMRS Event received :(");
        }
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        String actionDescription = "Disconnect OMRS Topic Connector";
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.disconnect();
        }
        if (this.auditLog != null) {
            OMRSAuditCode auditCode = OMRSAuditCode.OMRS_TOPIC_LISTENER_DISCONNECTED;
            this.auditLog.logRecord("Disconnect OMRS Topic Connector", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.topicName), this.getConnection().toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }
}

