/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public abstract class OMRSAuditLogStoreConnectorBase
extends ConnectorBase
implements OMRSAuditLogStore {
    protected String destinationName = "<Unknown";
    protected List<String> supportedSeverities = null;

    @Override
    public String getDestinationName() {
        return this.destinationName;
    }

    @Override
    public List<String> getSupportedSeverities() {
        return this.supportedSeverities;
    }

    @Override
    public abstract String storeLogRecord(OMRSAuditLogRecord var1) throws InvalidParameterException, RepositoryErrorException;

    @Override
    public OMRSAuditLogRecord getAuditLogRecord(String logRecordId) throws InvalidParameterException, FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getAuditLogRecord";
        this.throwQueryNotSupported("getAuditLogRecord");
        return null;
    }

    @Override
    public List<OMRSAuditLogRecord> getAuditLogRecordsByTimeStamp(Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsByTimeStamp";
        this.throwQueryNotSupported("getAuditLogRecordsByTimeStamp");
        return null;
    }

    @Override
    public List<OMRSAuditLogRecord> getAuditLogRecordsBySeverity(String severity, Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsBySeverity";
        this.throwQueryNotSupported("getAuditLogRecordsBySeverity");
        return null;
    }

    @Override
    public List<OMRSAuditLogRecord> getAuditLogRecordsByComponent(String component, Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsByComponent";
        this.throwQueryNotSupported("getAuditLogRecordsByComponent");
        return null;
    }

    protected void validateLogRecord(OMRSAuditLogRecord logRecord, String methodName) throws InvalidParameterException {
        if (logRecord == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_LOG_RECORD;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.destinationName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (logRecord.getOriginator() == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_LOG_RECORD_ORIGINATOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.destinationName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (logRecord.getReportingComponent() == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_LOG_RECORD_REPORTING_COMPONENT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.destinationName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    protected boolean isSupportedSeverity(OMRSAuditLogRecord logRecord) {
        String severity;
        if (logRecord != null && (severity = logRecord.getSeverity()) != null) {
            if (this.supportedSeverities == null) {
                return true;
            }
            if (this.supportedSeverities.contains(severity)) {
                return true;
            }
        }
        return false;
    }

    protected String getJSONLogRecord(OMRSAuditLogRecord logRecord, String methodName) throws InvalidParameterException {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(logRecord);
        }
        catch (Throwable exc) {
            OMRSErrorCode errorCode = OMRSErrorCode.AUDIT_LOG_RECORD_NOT_JSON_ENABLED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.destinationName);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), exc);
        }
    }

    protected void throwQueryNotSupported(String methodName) throws FunctionNotSupportedException {
        OMRSErrorCode errorCode = OMRSErrorCode.CAN_NOT_QUERY_AUDIT_LOG_STORE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.destinationName);
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    @Override
    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        if (connectionProperties != null) {
            Object supportedSeveritiesProperty;
            this.destinationName = connectionProperties.getConnectionName();
            Map<String, Object> configurationProperties = connectionProperties.getConfigurationProperties();
            if (configurationProperties != null && (supportedSeveritiesProperty = configurationProperties.get("supportedSeverities")) != null && supportedSeveritiesProperty instanceof List) {
                try {
                    this.supportedSeverities = (List)supportedSeveritiesProperty;
                    if (this.supportedSeverities.isEmpty()) {
                        this.supportedSeverities = null;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

