/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ArrayPropertyValue
extends InstancePropertyValue {
    private static final long serialVersionUID = 1L;
    private int arrayCount = 0;
    private InstanceProperties arrayValues = null;

    public ArrayPropertyValue() {
        super(InstancePropertyCategory.ARRAY);
    }

    public ArrayPropertyValue(ArrayPropertyValue template) {
        super(template);
        if (template != null) {
            this.arrayCount = template.getArrayCount();
            this.arrayValues = template.getArrayValues();
        }
    }

    @Override
    public InstancePropertyValue cloneFromSubclass() {
        return new ArrayPropertyValue(this);
    }

    @Override
    public String valueAsString() {
        return this.mapValuesAsString(this.arrayValues.getInstanceProperties()).toString();
    }

    @Override
    public Object valueAsObject() {
        return this.mapValuesAsObject(this.arrayValues.getInstanceProperties());
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public InstanceProperties getArrayValues() {
        if (this.arrayValues == null) {
            return null;
        }
        return new InstanceProperties(this.arrayValues);
    }

    public void setArrayValue(int elementNumber, InstancePropertyValue propertyValue) {
        if (this.arrayCount > elementNumber) {
            if (this.arrayValues == null) {
                this.arrayValues = new InstanceProperties();
            }
        } else {
            OMRSErrorCode errorCode = OMRSErrorCode.ARRAY_OUT_OF_BOUNDS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.getClass().getSimpleName(), Integer.toString(elementNumber), Integer.toString(this.arrayCount));
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setArrayValue", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.arrayValues.setProperty(Integer.toString(elementNumber), propertyValue);
    }

    public void setArrayValues(InstanceProperties arrayValues) {
        this.arrayValues = arrayValues;
    }

    @Override
    public String toString() {
        return "ArrayPropertyValue{arrayCount=" + this.arrayCount + ", arrayValues=" + this.arrayValues + ", instancePropertyCategory=" + this.getInstancePropertyCategory() + ", typeGUID='" + this.getTypeGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ArrayPropertyValue that = (ArrayPropertyValue)objectToCompare;
        return this.arrayCount == that.arrayCount && Objects.equals(this.arrayValues, that.arrayValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arrayCount, this.arrayValues);
    }
}

