/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventErrorCode;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum OMRSInstanceEventErrorCode implements Serializable
{
    NOT_IN_USE(0, "No Error", "There has been no error detected and so the error code is not in use.", null),
    CONFLICTING_INSTANCES(1, "Conflicting Instances", "There are two metadata instances that have the same unique identifier (guid) but have different types.", OMRSEventErrorCode.CONFLICTING_INSTANCES),
    CONFLICTING_TYPE(2, "Conflicting Type Version", "An instance can not be processed because there is a mismatch in the type definition (TypeDef) version.", OMRSEventErrorCode.CONFLICTING_TYPE),
    UNKNOWN_ERROR_CODE(99, "Unknown Error Code", "Unrecognized error code from incoming event.", null);

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;
    private OMRSEventErrorCode encoding;

    private OMRSInstanceEventErrorCode(int ordinal, String name, String description, OMRSEventErrorCode encoding) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
        this.encoding = encoding;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public OMRSEventErrorCode getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return "OMRSInstanceEventErrorCode{ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", encoding=" + this.encoding + '}';
    }
}

