/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.properties;

import java.io.Serializable;

public enum CohortConnectionStatus implements Serializable
{
    NOT_INITIALIZED(0, "NotInitialized", "The local components for communicating with the cohort are not initialized."),
    INITIALIZING(1, "Initializing", "The local components for communicating with the cohort are initializing."),
    NEW(2, "New", "The local components for communicating with the cohort are initialized but they have not exchanged messages with the other members of cohort."),
    CONFIGURATION_ERROR(3, "ConfigurationError", "There is an error in the configuration and connection is not possible."),
    CONNECTED(4, "Connected", "The server is connected to the metadata highway for this cohort and messages are being exchanged with other members of the cohort."),
    DISCONNECTING(5, "Initializing", "The local components for communicating with the cohort are disconnecting."),
    DISCONNECTED(6, "Disconnected", "The server is disconnected from the metadata highway for this cohort.  This may be because the local server is shutting down or the configuration is being adjusted.");

    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String statusName;
    private String statusDescription;

    private CohortConnectionStatus(int statusCode, String statusName, String statusDescription) {
        this.statusCode = statusCode;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }
}

