/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaBaseImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utils.RestCaller;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaCategoryImpl
extends SubjectAreaBaseImpl
implements SubjectAreaCategory {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaCategoryImpl.class);
    private static final String className = SubjectAreaCategoryImpl.class.getName();
    private static final String BASE_URL = "/servers/%s/open-metadata/access-services/subject-area/users/%s/categories";

    public SubjectAreaCategoryImpl(String omasServerURL, String serverName) {
        super(omasServerURL, serverName);
    }

    @Override
    public Category createCategory(String userId, Category suppliedCategory) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, UnrecognizedGUIDException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "createCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCategory,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createCategory", userId);
        String url = this.omasServerURL + String.format(BASE_URL, this.serverName, userId);
        InputValidator.validateUserIdNotNull(className, "createCategory", userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(suppliedCategory);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createCategory", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createCategory", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowClassificationException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Category category = DetectUtils.detectAndReturnCategory(className, "createCategory", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCategory,userId=" + userId);
        }
        return category;
    }

    @Override
    public Category getCategoryByGuid(String userId, String guid) throws MetadataServerUncontactableException, UnrecognizedGUIDException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getCategoryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategoryByGuid,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "getCategoryByGuid", userId);
        InputValidator.validateGUIDNotNull(className, "getCategoryByGuid", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getCategoryByGuid", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Category category = DetectUtils.detectAndReturnCategory(className, "getCategoryByGuid", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategoryByGuid,userId=" + userId);
        }
        return category;
    }

    @Override
    public List<Line> getCategoryRelationships(String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException, MetadataServerUncontactableException {
        String methodName = "getCategoryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategoryRelationships,userId=" + userId + ",guid=" + guid);
        }
        List<Line> relationships = this.getRelationships(BASE_URL, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategoryRelationships,userId=" + userId);
        }
        return relationships;
    }

    @Override
    public List<Category> findCategory(String userId, String searchCriteria, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) throws MetadataServerUncontactableException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "findCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findCategory,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "findCategory", userId);
        String urlTemplate = this.omasServerURL + BASE_URL;
        String url = String.format(urlTemplate, this.serverName, userId);
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        StringBuffer queryStringSB = new StringBuffer();
        QueryUtils.addCharacterToQuery(queryStringSB);
        queryStringSB.append("sequencingOrder=" + sequencingOrder);
        if (asOfTime != null) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("asOfTime=" + asOfTime);
        }
        if (searchCriteria != null) {
            this.encodeQueryProperty("searchCriteria", searchCriteria, "findCategory", queryStringSB);
        }
        if (offset != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("offset=" + offset);
        }
        if (pageSize != 0) {
            QueryUtils.addCharacterToQuery(queryStringSB);
            queryStringSB.append("pageSize=" + pageSize);
        }
        if (sequencingProperty != null) {
            this.encodeQueryProperty("sequencingProperty", sequencingProperty, "findCategory", queryStringSB);
        }
        if (queryStringSB.length() > 0) {
            url = url + queryStringSB.toString();
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "findCategory", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        List<Category> categories = DetectUtils.detectAndReturnCategories(className, "findCategory", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findCategory,userId=" + userId);
        }
        return categories;
    }

    @Override
    public Category replaceCategory(String userId, String guid, Category suppliedCategory) throws UnexpectedResponseException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "replaceCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceCategory,userId=" + userId + ",guid=" + guid);
        }
        Category category = this.updateCategory(userId, guid, suppliedCategory, true);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceCategory,userId=" + userId);
        }
        return category;
    }

    @Override
    public Category updateCategory(String userId, String guid, Category suppliedCategory) throws UnexpectedResponseException, UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "updateCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCategory,userId=" + userId + ",guid=" + guid);
        }
        Category category = this.updateCategory(userId, guid, suppliedCategory, false);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateCategory,userId=" + userId);
        }
        return category;
    }

    @Override
    public Category deleteCategory(String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, UnexpectedResponseException, EntityNotDeletedException {
        String methodName = "deleteCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCategory,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "deleteCategory", userId);
        InputValidator.validateGUIDNotNull(className, "deleteCategory", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "deleteCategory", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        DetectUtils.detectAndThrowEntityNotDeletedException(restResponse);
        Category category = DetectUtils.detectAndReturnCategory(className, "deleteCategory", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteCategory,userId=" + userId);
        }
        return category;
    }

    @Override
    public void purgeCategory(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, EntityNotPurgedException, FunctionNotSupportedException {
        String methodName = "purgeCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeCategory,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "purgeCategory", userId);
        InputValidator.validateGUIDNotNull(className, "purgeCategory", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=true";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "purgeCategory", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowEntityNotPurgedException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeCategory,userId=" + userId);
        }
    }

    @Override
    public Category restoreCategory(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "restoreCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCategory,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "restoreCategory", userId);
        InputValidator.validateGUIDNotNull(className, "restoreCategory", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePostNoBody(className, "restoreCategory", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Category category = DetectUtils.detectAndReturnCategory(className, "restoreCategory", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreCategory,userId=" + userId);
        }
        return category;
    }

    @Override
    public SubjectAreaDefinition createSubjectAreaDefinition(String userId, SubjectAreaDefinition suppliedSubjectAreaDefinition) throws MetadataServerUncontactableException, InvalidParameterException, UserNotAuthorizedException, UnrecognizedGUIDException, ClassificationException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "createSubjectAreaDefinition";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createSubjectAreaDefinition,userId=" + userId);
        }
        InputValidator.validateUserIdNotNull(className, "createSubjectAreaDefinition", userId);
        String url = this.omasServerURL + String.format(BASE_URL, this.serverName, userId);
        InputValidator.validateUserIdNotNull(className, "createSubjectAreaDefinition", userId);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(suppliedSubjectAreaDefinition);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "createSubjectAreaDefinition", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePost(className, "createSubjectAreaDefinition", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowClassificationException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        SubjectAreaDefinition subjectAreaDefinition = DetectUtils.detectAndReturnSubjectAreaDefinition(className, "createSubjectAreaDefinition", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createSubjectAreaDefinition,userId=" + userId);
        }
        return subjectAreaDefinition;
    }

    @Override
    public SubjectAreaDefinition getSubjectAreaDefinitionByGuid(String userId, String guid) throws MetadataServerUncontactableException, UnrecognizedGUIDException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "getSubjectAreaDefinitionByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getSubjectAreaDefinitionByGuid,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "getSubjectAreaDefinitionByGuid", userId);
        InputValidator.validateGUIDNotNull(className, "getSubjectAreaDefinitionByGuid", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueGet(className, "getSubjectAreaDefinitionByGuid", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        SubjectAreaDefinition subjectAreaDefinition = DetectUtils.detectAndReturnSubjectAreaDefinition(className, "getSubjectAreaDefinitionByGuid", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getSubjectAreaDefinitionByGuid,userId=" + userId);
        }
        return subjectAreaDefinition;
    }

    @Override
    public SubjectAreaDefinition replaceSubjectAreaDefinition(String userId, String guid, SubjectAreaDefinition suppliedSubjectAreaDefinition) throws UnexpectedResponseException, UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "replaceSubjectAreaDefinition";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: replaceSubjectAreaDefinition,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaDefinition subjectAreaDefinition = this.updateSubjectAreaDefinition(userId, guid, suppliedSubjectAreaDefinition, true);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : replaceSubjectAreaDefinition,userId=" + userId);
        }
        return subjectAreaDefinition;
    }

    @Override
    public SubjectAreaDefinition updateSubjectAreaDefinition(String userId, String guid, SubjectAreaDefinition suppliedSubjectAreaDefinition) throws UnexpectedResponseException, UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException {
        String methodName = "updateSubjectAreaDefinition";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSubjectAreaDefinition,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaDefinition subjectAreaDefinition = this.updateSubjectAreaDefinition(userId, guid, suppliedSubjectAreaDefinition, false);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateSubjectAreaDefinition,userId=" + userId);
        }
        return subjectAreaDefinition;
    }

    @Override
    public SubjectAreaDefinition deleteSubjectAreaDefinition(String userId, String guid) throws InvalidParameterException, MetadataServerUncontactableException, UserNotAuthorizedException, FunctionNotSupportedException, UnexpectedResponseException, EntityNotDeletedException {
        String methodName = "deleteSubjectAreaDefinition";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteSubjectAreaDefinition,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "deleteSubjectAreaDefinition", userId);
        InputValidator.validateGUIDNotNull(className, "deleteSubjectAreaDefinition", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "deleteSubjectAreaDefinition", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        DetectUtils.detectAndThrowEntityNotDeletedException(restResponse);
        SubjectAreaDefinition subjectAreaDefinition = DetectUtils.detectAndReturnSubjectAreaDefinition(className, "deleteSubjectAreaDefinition", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteSubjectAreaDefinition,userId=" + userId);
        }
        return subjectAreaDefinition;
    }

    @Override
    public void purgeSubjectAreaDefinition(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, EntityNotPurgedException, UnexpectedResponseException {
        String methodName = "purgeSubjectAreaDefinition";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: purgeSubjectAreaDefinition,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "purgeSubjectAreaDefinition", userId);
        InputValidator.validateGUIDNotNull(className, "purgeSubjectAreaDefinition", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isPurge=false";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issueDelete(className, "purgeSubjectAreaDefinition", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowEntityNotPurgedException(restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : purgeSubjectAreaDefinition,userId=" + userId);
        }
    }

    @Override
    public SubjectAreaDefinition restoreSubjectAreaDefinition(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, MetadataServerUncontactableException, UnrecognizedGUIDException, FunctionNotSupportedException, UnexpectedResponseException {
        String methodName = "restoreSubjectArea";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreSubjectArea,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "restoreSubjectArea", userId);
        InputValidator.validateGUIDNotNull(className, "restoreSubjectArea", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s";
        String url = String.format(urlTemplate, this.serverName, userId, guid);
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePostNoBody(className, "restoreSubjectArea", url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowUnrecognizedGUIDException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        SubjectAreaDefinition subjectArea = DetectUtils.detectAndReturnSubjectAreaDefinition(className, "restoreSubjectArea", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreSubjectArea,userId=" + userId);
        }
        return subjectArea;
    }

    private Category updateCategory(String userId, String guid, Category suppliedCategory, boolean isReplace) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "updateCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCategory,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "updateCategory", userId);
        InputValidator.validateGUIDNotNull(className, "updateCategory", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isReplace=%b";
        String url = String.format(urlTemplate, this.serverName, userId, guid, isReplace);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(suppliedCategory);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateCategory", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePut(className, "updateCategory", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        DetectUtils.detectAndThrowFunctionNotSupportedException(restResponse);
        Category category = DetectUtils.detectAndReturnCategory(className, "updateCategory", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateCategory,userId=" + userId);
        }
        return category;
    }

    private SubjectAreaDefinition updateSubjectAreaDefinition(String userId, String guid, SubjectAreaDefinition suppliedSubjectAreaDefinition, boolean isReplace) throws UserNotAuthorizedException, InvalidParameterException, MetadataServerUncontactableException, UnexpectedResponseException {
        String methodName = "updateSubjectAreaDefinition";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateSubjectAreaDefinition,userId=" + userId + ",guid=" + guid);
        }
        InputValidator.validateUserIdNotNull(className, "updateSubjectAreaDefinition", userId);
        InputValidator.validateGUIDNotNull(className, "updateSubjectAreaDefinition", guid, "guid");
        String urlTemplate = this.omasServerURL + BASE_URL + "/%s?isReplace=%b";
        String url = String.format(urlTemplate, this.serverName, userId, guid, isReplace);
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = null;
        try {
            requestBody = mapper.writeValueAsString(suppliedSubjectAreaDefinition);
        }
        catch (JsonProcessingException error) {
            RestCaller.throwJsonParseError(className, "updateSubjectAreaDefinition", error);
        }
        SubjectAreaOMASAPIResponse restResponse = RestCaller.issuePut(className, "updateSubjectAreaDefinition", requestBody, url);
        DetectUtils.detectAndThrowUserNotAuthorizedException(restResponse);
        DetectUtils.detectAndThrowInvalidParameterException(restResponse);
        SubjectAreaDefinition subjectAreaDefinition = DetectUtils.detectAndReturnSubjectAreaDefinition(className, "updateSubjectAreaDefinition", restResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateSubjectAreaDefinition,userId=" + userId);
        }
        return subjectAreaDefinition;
    }
}

