/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.FVTUtils;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;

public class CategoryHierarchyFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for category hierarchy FVT";
    private static final String DEFAULT_TEST_CATEGORY_NAME_BASE = "Test hierarchy category ";
    private static final int WIDTH = 3;
    private static final int DEPTH = 4;
    private static int depth_counter = 0;
    private static SubjectAreaCategory subjectAreaCategory = null;
    private GlossaryFVT glossaryFVT = null;
    private String url = null;
    private String glossaryGuid = null;
    private String userId = null;
    private String serverName = null;

    public static void main(String[] args) {
        Object subjectArea = null;
        String url = null;
        try {
            url = RunAllFVT.getUrl(args);
            CategoryHierarchyFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaCheckedException e) {
            System.out.println("ERROR: " + e.getErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
        catch (SubjectAreaFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public static void runWith2Servers(String url) throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        CategoryHierarchyFVT fvt = new CategoryHierarchyFVT(url, "Server1", "Fred");
        fvt.run();
    }

    public CategoryHierarchyFVT(String url, String serverName, String userId) throws InvalidParameterException {
        subjectAreaCategory = new SubjectAreaImpl(serverName, url).getSubjectAreaCategory();
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.url = url;
        this.userId = userId;
        this.serverName = serverName;
    }

    public static void runIt(String url, String serverName, String userId) throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        CategoryHierarchyFVT fvt = new CategoryHierarchyFVT(url, serverName, userId);
        fvt.run();
    }

    public void run() throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        Object subjectArea = null;
        System.out.println("Create a glossary");
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        FVTUtils.validateNode(glossary);
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        System.out.println("Create category hierarchy");
        Set<Category> categories = this.createTopCategories(glossaryGuid);
        while (depth_counter < 4) {
            ++depth_counter;
            Set<Category> childrenCategories = new HashSet<Category>();
            for (Category category : categories) {
                FVTUtils.validateNode(category);
                childrenCategories = this.createChildrenCategories(category, glossaryGuid);
            }
            categories = childrenCategories;
        }
    }

    private Set<Category> createTopCategories(String glossaryGuid) throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        HashSet<Category> categories = new HashSet<Category>();
        for (int width_counter = 0; width_counter < 3; ++width_counter) {
            String categoryName = CategoryHierarchyFVT.createName(0, width_counter);
            Category category = this.createCategoryWithGlossaryGuid(categoryName, glossaryGuid);
            FVTUtils.validateNode(category);
            System.out.println("Created category with name  " + categoryName + " with no parent");
            categories.add(category);
        }
        return categories;
    }

    private static String createName(int depth, int width) {
        return "Test hierarchy category d" + depth + "w" + width;
    }

    private Set<Category> createChildrenCategories(Category parent, String glossaryGuid) throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        HashSet<Category> categories = new HashSet<Category>();
        for (int width_counter = 0; width_counter < 3; ++width_counter) {
            String categoryName = CategoryHierarchyFVT.createName(depth_counter, width_counter);
            Category category = this.createCategoryWithParentGlossary(categoryName, parent, glossaryGuid);
            FVTUtils.validateNode(category);
            System.out.println("Created category with name  " + categoryName + " with parent " + parent.getName());
            categories.add(category);
        }
        return categories;
    }

    private Category createCategoryWithParentGlossary(String categoryName, Category parent, String glossaryGuid) throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        Category category = new Category();
        category.setName(categoryName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        category.setGlossary(glossarySummary);
        CategorySummary parentCategorysummary = new CategorySummary();
        parentCategorysummary.setGuid(parent.getSystemAttributes().getGUID());
        category.setParentCategory(parentCategorysummary);
        Category newCategory = subjectAreaCategory.createCategory(this.userId, category);
        FVTUtils.validateNode(newCategory);
        System.out.println("Created Category " + newCategory.getName() + " with userId " + newCategory.getSystemAttributes().getGUID());
        return newCategory;
    }

    public Category createCategoryWithGlossaryGuid(String categoryName, String glossaryGuid) throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        Category category = new Category();
        category.setName(categoryName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        category.setGlossary(glossarySummary);
        Category newCategory = subjectAreaCategory.createCategory(this.userId, category);
        FVTUtils.validateNode(newCategory);
        System.out.println("Created Category " + newCategory.getName() + " with userId " + newCategory.getSystemAttributes().getGUID());
        return newCategory;
    }
}

