/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGraph;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaImpl;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.CategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RelationshipsFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaDefinitionCategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.TermFVT;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;

public class GraphFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for Graph FVT";
    private static final String DEFAULT_TEST_TERM_NAME1 = "Test term 1";
    private static final String DEFAULT_TEST_TERM_NAME2 = "Test term 2";
    private static final String DEFAULT_TEST_TERM_NAME3 = "Test term 3";
    private static final String DEFAULT_TEST_CATEGORY_NAME = "Test category 1";
    private SubjectAreaGraph subjectAreaGraph = null;
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;
    private RelationshipsFVT relationshipFVT = null;
    private CategoryFVT categoryFVT = null;
    private SubjectAreaDefinitionCategoryFVT subjectAreaFVT = null;
    private String serverName = null;
    private String userId = null;

    public static void main(String[] args) {
        try {
            String url = RunAllFVT.getUrl(args);
            GraphFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaCheckedException e) {
            System.out.println("ERROR: " + e.getErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
        catch (SubjectAreaFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public GraphFVT(String url, String serverName, String userId) throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        this.subjectAreaGraph = new SubjectAreaImpl(serverName, url).getSubjectAreaGraph();
        System.out.println("Create a glossary");
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.termFVT = new TermFVT(url, serverName, userId);
        this.categoryFVT = new CategoryFVT(url, serverName, userId);
        this.relationshipFVT = new RelationshipsFVT(url, serverName, userId);
        this.subjectAreaFVT = new SubjectAreaDefinitionCategoryFVT(url, serverName, userId);
        this.serverName = serverName;
        this.userId = userId;
    }

    public static void runWith2Servers(String url) throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        GraphFVT fvt = new GraphFVT(url, "Server1", "Fred");
        fvt.run();
        GraphFVT fvt2 = new GraphFVT(url, "Server2", "Fred");
        fvt2.run();
    }

    public static void runIt(String url, String serverName, String userId) {
    }

    public void run() throws SubjectAreaCheckedException, SubjectAreaFVTCheckedException {
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        Graph graph = this.getGraph(glossaryGuid, null, null, null, null, null);
        this.checkGraphContent(graph, 1, 0);
        Term term1 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME1, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, null, null, null, null);
        this.checkGraphContent(graph, 2, 1);
        Term term2 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME2, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, null, null, null, null);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null, 1);
        this.checkGraphContent(graph, 2, 1);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null, 2);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null, null);
        this.checkGraphContent(graph, 3, 2);
        this.relationshipFVT.createSynonym(term1, term2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null, null);
        this.checkGraphContent(graph, 3, 3);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, new HashSet<LineType>(Arrays.asList(LineType.Synonym)), null, null);
        this.checkGraphContent(graph, 2, 1);
        Term term3 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME3, glossaryGuid);
        this.relationshipFVT.createSynonym(term1, term3);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, new HashSet<LineType>(Arrays.asList(LineType.Synonym)), null, null);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(glossaryGuid, null, null, null, null, null);
        this.checkGraphContent(graph, 4, 5);
        graph = this.getGraph(term3.getSystemAttributes().getGUID(), null, null, new HashSet<LineType>(Arrays.asList(LineType.Synonym)), null, 1);
        this.checkGraphContent(graph, 2, 1);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term)), null, null, 1);
        this.checkGraphContent(graph, 4, 3);
        Category category = this.categoryFVT.createCategory(DEFAULT_TEST_CATEGORY_NAME, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term)), null, null, 1);
        this.checkGraphContent(graph, 4, 3);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term, NodeType.Category)), null, null, 1);
        this.checkGraphContent(graph, 5, 4);
        Taxonomy taxonomy = this.glossaryFVT.getTaxonomyForInput(DEFAULT_TEST_GLOSSARY_NAME);
        Glossary createdTaxonomy = this.glossaryFVT.issueCreateGlossary(taxonomy);
        String taxonomyGuid = createdTaxonomy.getSystemAttributes().getGUID();
        SubjectAreaDefinition subjectAreaDefinition = this.subjectAreaFVT.createSubjectAreaDefinitionWithGlossaryGuid("Subject area 1", taxonomyGuid);
        graph = this.getGraph(taxonomyGuid, null, null, null, null, null);
        this.checkGraphContent(graph, 2, 1);
        this.checkNodesContainNodeType(graph.getNodes(), NodeType.Taxonomy);
        this.checkNodesContainNodeType(graph.getNodes(), NodeType.SubjectAreaDefinition);
    }

    private void checkNodesContainNodeType(Set<Node> nodes, NodeType nodeTypeToCheck) throws SubjectAreaFVTCheckedException {
        boolean found = false;
        for (Node node : nodes) {
            if (node.getNodeType() != nodeTypeToCheck) continue;
            found = true;
        }
        if (!found) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected to find " + nodeTypeToCheck.name() + "but it did not exist");
        }
    }

    private void checkGraphContent(Graph graph, int expectedNodesSize, int expectedLinesSize) throws SubjectAreaFVTCheckedException {
        System.err.println("CheckGraphContent expected " + expectedNodesSize + " Nodes and " + expectedLinesSize + " Lines");
        if (graph.getNodes().size() != expectedNodesSize) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + expectedNodesSize + " nodes, got " + graph.getNodes().size());
        }
        if (expectedLinesSize == 0 && graph.getLines() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 0 and graph.getLines() to be null ");
        }
        if (expectedLinesSize != 0 && graph.getLines() == null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + expectedLinesSize + " and graph.getLines() is null ");
        }
        if (graph.getLines() != null && graph.getLines().size() != expectedLinesSize) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + expectedLinesSize + " Lines, got " + graph.getLines().size());
        }
    }

    private Graph getGraph(String guid, Date asOfTime, Set<NodeType> nodeFilter, Set<LineType> lineFilter, StatusFilter statusFilter, Integer level) throws UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, MetadataServerUncontactableException, UnexpectedResponseException {
        return this.subjectAreaGraph.getGraph(this.userId, guid, asOfTime, nodeFilter, lineFilter, statusFilter, level);
    }
}

