/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utils;

import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Hasa;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Isa;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsaTypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.AntonymRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoriesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryAnchorRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ClassificationExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.EntityNotDeletedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.EntityNotPurgedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.FunctionNotSupportedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossariesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GraphResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.MetadataServerUncontactableExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.PreferredTermRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectScopeRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelatedTermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelationshipNotDeletedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelationshipNotPurgedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ReplacementRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SemanticAssignementRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.StatusNotsupportedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SynonymRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermAnchorRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermCategorizationRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermHASARelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermISARelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermISATYPEOFRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermTYPEDBYRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TranslationRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnexpectedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnrecognizedGUIDExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UsedInContextRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UserNotAuthorizedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ValidValueRelationshipResponse;

public class DetectUtils {
    public static void detectAndThrowInvalidParameterException(SubjectAreaOMASAPIResponse restResponse) throws InvalidParameterException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.InvalidParameterException) {
            InvalidParameterExceptionResponse response = (InvalidParameterExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new InvalidParameterException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription(), response.getInvalidPropertyName(), response.getInvalidPropertyValue());
        }
    }

    public static void detectAndThrowUnrecognizedGUIDException(SubjectAreaOMASAPIResponse restResponse) throws UnrecognizedGUIDException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.UnrecognizedGUIDException) {
            UnrecognizedGUIDExceptionResponse response = (UnrecognizedGUIDExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new UnrecognizedGUIDException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription(), response.getGuid());
        }
    }

    public static void detectAndThrowClassificationException(SubjectAreaOMASAPIResponse restResponse) throws ClassificationException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.ClassificationException) {
            ClassificationExceptionResponse response = (ClassificationExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new ClassificationException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription());
        }
    }

    public static void detectAndThrowEntityNotDeletedException(SubjectAreaOMASAPIResponse restResponse) throws EntityNotDeletedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.EntityNotDeletedException) {
            EntityNotDeletedExceptionResponse response = (EntityNotDeletedExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new EntityNotDeletedException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription(), response.getGuid());
        }
    }

    public static void detectAndThrowFunctionNotSupportedException(SubjectAreaOMASAPIResponse restResponse) throws FunctionNotSupportedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.FunctionNotSupportedException) {
            FunctionNotSupportedExceptionResponse response = (FunctionNotSupportedExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new FunctionNotSupportedException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription());
        }
    }

    public static void detectAndThrowEntityNotPurgedException(SubjectAreaOMASAPIResponse restResponse) throws EntityNotPurgedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.EntityNotPurgedException) {
            EntityNotPurgedExceptionResponse response = (EntityNotPurgedExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new EntityNotPurgedException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription(), response.getGuid());
        }
    }

    public static void detectAndThrowRelationshipNotDeletedException(SubjectAreaOMASAPIResponse restResponse) throws RelationshipNotDeletedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.RelationshipNotDeletedException) {
            RelationshipNotDeletedExceptionResponse response = (RelationshipNotDeletedExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new RelationshipNotDeletedException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription(), response.getGuid());
        }
    }

    public static void detectAndThrowRelationshipNotPurgedException(SubjectAreaOMASAPIResponse restResponse) throws RelationshipNotPurgedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.RelationshipNotPurgedException) {
            RelationshipNotPurgedExceptionResponse response = (RelationshipNotPurgedExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new RelationshipNotPurgedException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription(), response.getGuid());
        }
    }

    public static void detectAndThrowStatusNotSupportedException(SubjectAreaOMASAPIResponse restResponse) throws StatusNotSupportedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.StatusNotSupportedException) {
            StatusNotsupportedExceptionResponse response = (StatusNotsupportedExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new StatusNotSupportedException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription());
        }
    }

    public static void detectAndThrowUserNotAuthorizedException(SubjectAreaOMASAPIResponse restResponse) throws UserNotAuthorizedException {
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.UserNotAuthorizedException) {
            UserNotAuthorizedExceptionResponse response = (UserNotAuthorizedExceptionResponse)restResponse;
            SubjectAreaErrorCode subjectAreaErrorCode = SubjectAreaErrorCode.valueOf(response.getMessageId());
            throw new UserNotAuthorizedException(subjectAreaErrorCode.getMessageDefinition(), response.getExceptionClassName(), response.getActionDescription(), response.getUserId());
        }
    }

    public static void detectVoid(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        if (restResponse == null || restResponse.getResponseCategory() != ResponseCategory.Void) {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
    }

    public static Glossary detectAndReturnGlossary(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Glossary glossary = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Glossary) {
            GlossaryResponse glossaryResponse = (GlossaryResponse)restResponse;
            glossary = glossaryResponse.getGlossary();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return glossary;
    }

    public static List<Glossary> detectAndReturnGlossaries(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List<Glossary> glossaries = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Glossaries) {
            GlossariesResponse glossariesResponse = (GlossariesResponse)restResponse;
            glossaries = glossariesResponse.getGlossaries();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return glossaries;
    }

    public static Project detectAndReturnProject(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Project project = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Project) {
            ProjectResponse projectResponse = (ProjectResponse)restResponse;
            project = projectResponse.getProject();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return project;
    }

    public static List<Project> detectAndReturnProjects(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List<Project> projects = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Projects) {
            ProjectsResponse projectsResponse = (ProjectsResponse)restResponse;
            projects = projectsResponse.getProjects();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return projects;
    }

    public static Term detectAndReturnTerm(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Term term = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Term) {
            TermResponse termResponse = (TermResponse)restResponse;
            term = termResponse.getTerm();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return term;
    }

    public static List<Term> detectAndReturnTerms(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List<Term> terms = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Terms) {
            TermsResponse termsResponse = (TermsResponse)restResponse;
            terms = termsResponse.getTerms();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return terms;
    }

    public static Graph detectAndReturnGraph(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Graph graph = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Graph) {
            GraphResponse GraphResponse2 = (GraphResponse)restResponse;
            graph = GraphResponse2.getGraph();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return graph;
    }

    public static List<Line> detectAndReturnLines(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List<Line> lines = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Lines) {
            LinesResponse linesResponse = (LinesResponse)restResponse;
            lines = linesResponse.getLines();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return lines;
    }

    public static Category detectAndReturnCategory(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Category category = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Category) {
            CategoryResponse categoryResponse = (CategoryResponse)restResponse;
            category = categoryResponse.getCategory();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return category;
    }

    public static List<Category> detectAndReturnCategories(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        List<Category> categories = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.Categories) {
            CategoriesResponse categoriesResponse = (CategoriesResponse)restResponse;
            categories = categoriesResponse.getCategories();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return categories;
    }

    public static SubjectAreaDefinition detectAndReturnSubjectAreaDefinition(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        SubjectAreaDefinition subjectAreaDefinition = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.SubjectAreaDefinition) {
            SubjectAreaDefinitionResponse subjectAreaDefinitionResponse = (SubjectAreaDefinitionResponse)restResponse;
            subjectAreaDefinition = subjectAreaDefinitionResponse.getSubjectAreaDefinition();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return subjectAreaDefinition;
    }

    private static void CategoryErrorResponse(String className, String actionDescription, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLIENT_RECEIVED_AN_UNEXPECTED_RESPONSE_ERROR;
        String unexpectedResponseCategory = ResponseCategory.Unknown.name();
        if (restResponse != null) {
            unexpectedResponseCategory = restResponse.getResponseCategory().name();
        }
        throw new UnexpectedResponseException(errorCode.getMessageDefinition(), className, actionDescription, unexpectedResponseCategory);
    }

    public static Hasa detectAndReturnTermHASARelationship(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Hasa termHASARelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermHASARelationship) {
            TermHASARelationshipResponse termHASARelationshipResponse = (TermHASARelationshipResponse)restResponse;
            termHASARelationship = termHASARelationshipResponse.getTermHASARelationship();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return termHASARelationship;
    }

    public static RelatedTerm detectAndReturnRelatedTerm(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        RelatedTerm relatedTermRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.RelatedTerm) {
            RelatedTermResponse relatedTermResponse = (RelatedTermResponse)restResponse;
            relatedTermRelationship = relatedTermResponse.getRelatedTerm();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return relatedTermRelationship;
    }

    public static Synonym detectAndReturnSynonym(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Synonym synonym = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.SynonymRelationship) {
            SynonymRelationshipResponse synonymResponse = (SynonymRelationshipResponse)restResponse;
            synonym = synonymResponse.getSynonym();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return synonym;
    }

    public static Antonym detectAndReturnAntonym(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Antonym antonym = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.AntonymRelationship) {
            AntonymRelationshipResponse antonymResponse = (AntonymRelationshipResponse)restResponse;
            antonym = antonymResponse.getAntonym();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return antonym;
    }

    public static Translation detectAndReturnTranslation(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Translation translation = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TranslationRelationship) {
            TranslationRelationshipResponse translationResponse = (TranslationRelationshipResponse)restResponse;
            translation = translationResponse.getTranslation();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return translation;
    }

    public static UsedInContext detectAndReturnUsedInContext(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        UsedInContext usedInContext = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermUsedInContextRelationship) {
            UsedInContextRelationshipResponse usedInContextResponse = (UsedInContextRelationshipResponse)restResponse;
            usedInContext = usedInContextResponse.getUsedInContext();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return usedInContext;
    }

    public static PreferredTerm detectAndReturnPreferredTerm(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        PreferredTerm preferredTerm = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.PreferredTermRelationship) {
            PreferredTermRelationshipResponse preferredTermResponse = (PreferredTermRelationshipResponse)restResponse;
            preferredTerm = preferredTermResponse.getPreferredTerm();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return preferredTerm;
    }

    public static ValidValue detectAndReturnValidValue(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        ValidValue validValue = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.ValidValueRelationship) {
            ValidValueRelationshipResponse validValueResponse = (ValidValueRelationshipResponse)restResponse;
            validValue = validValueResponse.getValidValue();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return validValue;
    }

    public static ReplacementTerm detectAndReturnReplacementTerm(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        ReplacementTerm replacementTerm = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermReplacementRelationship) {
            ReplacementRelationshipResponse replacementTermResponse = (ReplacementRelationshipResponse)restResponse;
            replacementTerm = replacementTermResponse.getTermReplacementRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return replacementTerm;
    }

    public static TypedBy detectAndReturnTermTYPEDBYRelationship(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        TypedBy termTYPEDBYRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermTYPEDBYRelationship) {
            TermTYPEDBYRelationshipResponse termTYPEDBYRelationshipResponse = (TermTYPEDBYRelationshipResponse)restResponse;
            termTYPEDBYRelationship = termTYPEDBYRelationshipResponse.getTermTYPEDBYRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return termTYPEDBYRelationship;
    }

    public static Isa detectAndReturnISARelationship(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Isa isa = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermISARelationship) {
            TermISARelationshipResponse isaResponse = (TermISARelationshipResponse)restResponse;
            isa = isaResponse.getTermISARelationship();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return isa;
    }

    public static IsaTypeOf detectAndReturnTermISATypeOFRelationship(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        IsaTypeOf termISATypeOFRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermISATYPEOFRelationship) {
            TermISATYPEOFRelationshipResponse TermISATypeOFRelationshipResponse = (TermISATYPEOFRelationshipResponse)restResponse;
            termISATypeOFRelationship = TermISATypeOFRelationshipResponse.getTermISATYPEOFRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return termISATypeOFRelationship;
    }

    public static SemanticAssignment detectAndReturnSemanticAssignmentRelationship(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        SemanticAssignment semanticAssignment = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.SemanticAssignmentRelationship) {
            SemanticAssignementRelationshipResponse relationshipResponse = (SemanticAssignementRelationshipResponse)restResponse;
            semanticAssignment = relationshipResponse.getSemanticAssignment();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return semanticAssignment;
    }

    public static Categorization detectAndReturnTermCategorizationRelationship(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        Categorization termCategorizationRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermCategorizationRelationship) {
            TermCategorizationRelationshipResponse relationshipResponse = (TermCategorizationRelationshipResponse)restResponse;
            termCategorizationRelationship = relationshipResponse.getTermCategorization();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return termCategorizationRelationship;
    }

    public static TermAnchor detectAndReturnTermAnchorRelationship(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        TermAnchor termAnchorRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.TermAnchorRelationship) {
            TermAnchorRelationshipResponse relationshipResponse = (TermAnchorRelationshipResponse)restResponse;
            termAnchorRelationship = relationshipResponse.getTermAnchorRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return termAnchorRelationship;
    }

    public static CategoryAnchor detectAndReturnCategoryAnchorRelationship(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        CategoryAnchor categoryAnchorRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.CategoryAnchorRelationship) {
            CategoryAnchorRelationshipResponse relationshipResponse = (CategoryAnchorRelationshipResponse)restResponse;
            categoryAnchorRelationship = relationshipResponse.getCategoryAnchorRelationship();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return categoryAnchorRelationship;
    }

    public static ProjectScope detectAndReturnProjectScope(String className, String methodName, SubjectAreaOMASAPIResponse restResponse) throws UnexpectedResponseException {
        ProjectScope projectScopeRelationship = null;
        if (restResponse != null && restResponse.getResponseCategory() == ResponseCategory.ProjectScopeRelationship) {
            ProjectScopeRelationshipResponse relationshipResponse = (ProjectScopeRelationshipResponse)restResponse;
            projectScopeRelationship = relationshipResponse.getProjectScope();
        } else {
            DetectUtils.CategoryErrorResponse(className, methodName, restResponse);
        }
        return projectScopeRelationship;
    }

    public static SubjectAreaOMASAPIResponse getResponseFromException(SubjectAreaCheckedException e) {
        SubjectAreaOMASAPIResponse response = null;
        if (e instanceof MetadataServerUncontactableException) {
            response = new MetadataServerUncontactableExceptionResponse(e);
        } else if (e instanceof InvalidParameterException) {
            response = new InvalidParameterExceptionResponse(e);
        } else if (e instanceof UserNotAuthorizedException) {
            response = new UserNotAuthorizedExceptionResponse(e);
        } else if (e instanceof UnrecognizedGUIDException) {
            response = new UnrecognizedGUIDExceptionResponse(e);
        } else if (e instanceof ClassificationException) {
            response = new ClassificationExceptionResponse(e);
        } else if (e instanceof FunctionNotSupportedException) {
            response = new FunctionNotSupportedExceptionResponse(e);
        } else if (e instanceof UnexpectedResponseException) {
            response = new UnexpectedExceptionResponse(e);
        } else if (e instanceof EntityNotDeletedException) {
            response = new EntityNotDeletedExceptionResponse(e);
        } else if (e instanceof EntityNotPurgedException) {
            response = new EntityNotPurgedExceptionResponse(e);
        } else if (e instanceof RelationshipNotDeletedException) {
            response = new RelationshipNotDeletedExceptionResponse(e);
        } else if (e instanceof RelationshipNotPurgedException) {
            response = new RelationshipNotPurgedExceptionResponse(e);
        }
        return response;
    }
}

