/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.auditlog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuditLogReportingComponent
implements Serializable,
ComponentDescription {
    private static final long serialVersionUID = 1L;
    private int componentId;
    private String componentName;
    private String componentDescription;
    private String componentWikiURL;

    public AuditLogReportingComponent() {
    }

    public AuditLogReportingComponent(ComponentDescription template) {
        if (template != null) {
            this.componentId = template.getComponentId();
            this.componentName = template.getComponentName();
            this.componentDescription = template.getComponentType();
            this.componentWikiURL = template.getComponentWikiURL();
        }
    }

    public AuditLogReportingComponent(int componentId, String componentName, String componentDescription, String componentWikiURL) {
        this.componentId = componentId;
        this.componentName = componentName;
        this.componentDescription = componentDescription;
        this.componentWikiURL = componentWikiURL;
    }

    @Override
    public int getComponentId() {
        return this.componentId;
    }

    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public String getComponentType() {
        return this.componentDescription;
    }

    public void setComponentDescription(String componentDescription) {
        this.componentDescription = componentDescription;
    }

    @Override
    public String getComponentWikiURL() {
        return this.componentWikiURL;
    }

    public void setComponentWikiURL(String componentWikiURL) {
        this.componentWikiURL = componentWikiURL;
    }

    public String toString() {
        return "AuditLogReportingComponent{componentId=" + this.componentId + ", componentName='" + this.componentName + '\'' + ", componentDescription='" + this.componentDescription + '\'' + ", componentWikiURL='" + this.componentWikiURL + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        AuditLogReportingComponent that = (AuditLogReportingComponent)objectToCompare;
        return this.getComponentId() == that.getComponentId() && Objects.equals(this.getComponentName(), that.getComponentName()) && Objects.equals(this.getComponentType(), that.getComponentType()) && Objects.equals(this.getComponentWikiURL(), that.getComponentWikiURL());
    }

    public int hashCode() {
        return Objects.hash(this.getComponentId(), this.getComponentName(), this.getComponentType(), this.getComponentWikiURL());
    }
}

