/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.omrstopic;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;

public class OMRSTopicListenerWrapper
implements OMRSTopicListener {
    private final String THREAD_NAME_DESCRIPTION = " OMRSTopicListener";
    private OMRSTopicListener realListener;
    private AuditLog auditLog;
    private String serviceName = "<Unknown Service>";

    OMRSTopicListenerWrapper(OMRSTopicListener realListener, String serviceName, AuditLog auditLog) {
        this.realListener = realListener;
        this.serviceName = serviceName;
        this.auditLog = auditLog;
    }

    @Deprecated
    OMRSTopicListenerWrapper(OMRSTopicListener realListener, AuditLog auditLog) {
        this.realListener = realListener;
        this.auditLog = auditLog;
    }

    private void logUnhandledException(Throwable error, String methodName) {
        this.auditLog.logException(methodName, OMRSAuditCode.UNHANDLED_EXCEPTION_FROM_SERVICE_LISTENER.getMessageDefinition(this.serviceName, error.getClass().getName(), error.getMessage()), error);
    }

    @Override
    public void processRegistryEvent(OMRSRegistryEvent event) {
        String methodName = "processRegistryEvent";
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.serviceName + " OMRSTopicListener");
        try {
            this.realListener.processRegistryEvent(event);
        }
        catch (Throwable error) {
            this.logUnhandledException(error, "processRegistryEvent");
        }
        Thread.currentThread().setName(currentThreadName);
    }

    @Override
    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        String methodName = "processTypeDefEvent";
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.serviceName + " OMRSTopicListener");
        try {
            this.realListener.processTypeDefEvent(event);
        }
        catch (Throwable error) {
            this.logUnhandledException(error, "processTypeDefEvent");
        }
        Thread.currentThread().setName(currentThreadName);
    }

    @Override
    public void processInstanceEvent(OMRSInstanceEvent event) {
        String methodName = "processInstanceEvent";
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.serviceName + " OMRSTopicListener");
        try {
            this.realListener.processInstanceEvent(event);
        }
        catch (Throwable error) {
            this.logUnhandledException(error, "processInstanceEvent");
        }
        Thread.currentThread().setName(currentThreadName);
    }
}

