/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ArrayPropertyValue.class, name="ArrayPropertyValue"), @JsonSubTypes.Type(value=EnumPropertyValue.class, name="EnumPropertyValue"), @JsonSubTypes.Type(value=MapPropertyValue.class, name="MapPropertyValue"), @JsonSubTypes.Type(value=PrimitivePropertyValue.class, name="PrimitivePropertyValue"), @JsonSubTypes.Type(value=StructPropertyValue.class, name="StructPropertyValue")})
public abstract class InstancePropertyValue
extends InstanceElementHeader {
    private static final long serialVersionUID = 1L;
    private InstancePropertyCategory instancePropertyCategory = null;
    private String typeGUID = null;
    private String typeName = null;

    protected InstancePropertyValue() {
    }

    protected InstancePropertyValue(InstancePropertyCategory instancePropertyCategory) {
        this.instancePropertyCategory = instancePropertyCategory;
    }

    protected InstancePropertyValue(InstancePropertyValue template) {
        super(template);
        if (template != null) {
            this.instancePropertyCategory = template.getInstancePropertyCategory();
            this.typeGUID = template.getTypeGUID();
            this.typeName = template.getTypeName();
        }
    }

    public abstract InstancePropertyValue cloneFromSubclass();

    public abstract String valueAsString();

    public abstract Object valueAsObject();

    protected <K, V extends InstancePropertyValue> Map<K, Object> mapValuesAsObject(Map<K, V> valMap) {
        return this.convertValues(valMap, entry -> ((InstancePropertyValue)entry.getValue()).valueAsObject());
    }

    protected <K, V extends InstancePropertyValue> Map<K, String> mapValuesAsString(Map<K, V> valMap) {
        return this.convertValues(valMap, entry -> ((InstancePropertyValue)entry.getValue()).valueAsString());
    }

    private <K, V extends InstancePropertyValue, R> Map<K, R> convertValues(Map<K, V> valMap, Function<Map.Entry<K, V>, R> mapper) {
        return Optional.ofNullable(valMap).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.toMap(Map.Entry::getKey, mapper));
    }

    public InstancePropertyCategory getInstancePropertyCategory() {
        return this.instancePropertyCategory;
    }

    public void setInstancePropertyCategory(InstancePropertyCategory instancePropertyCategory) {
        this.instancePropertyCategory = instancePropertyCategory;
    }

    public String getTypeGUID() {
        return this.typeGUID;
    }

    public void setTypeGUID(String typeGUID) {
        this.typeGUID = typeGUID;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return "InstancePropertyValue{instancePropertyCategory=" + this.instancePropertyCategory + ", typeGUID='" + this.typeGUID + '\'' + ", typeName='" + this.typeName + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstancePropertyValue)) {
            return false;
        }
        InstancePropertyValue that = (InstancePropertyValue)objectToCompare;
        return this.getInstancePropertyCategory() == that.getInstancePropertyCategory() && Objects.equals(this.getTypeGUID(), that.getTypeGUID()) && Objects.equals(this.getTypeName(), that.getTypeName());
    }

    public int hashCode() {
        return Objects.hash(this.getInstancePropertyCategory(), this.getTypeGUID(), this.getTypeName());
    }
}

