/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogReport;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuditLogReportResponse
extends OMRSAPIResponse {
    private static final long serialVersionUID = 1L;
    private OMRSAuditLogReport report = null;

    public AuditLogReportResponse() {
    }

    public AuditLogReportResponse(AuditLogReportResponse template) {
        super(template);
        if (template != null) {
            this.report = template.getReport();
        }
    }

    public OMRSAuditLogReport getReport() {
        if (this.report == null) {
            return null;
        }
        return new OMRSAuditLogReport(this.report);
    }

    public void setReport(OMRSAuditLogReport report) {
        this.report = report;
    }

    @Override
    public String toString() {
        return "AuditLogReportResponse{report=" + this.report + ", relatedHTTPCode=" + this.relatedHTTPCode + ", actionDescription='" + this.actionDescription + '\'' + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionCausedBy='" + this.exceptionCausedBy + '\'' + ", exceptionErrorMessage='" + this.exceptionErrorMessage + '\'' + ", exceptionErrorMessageId='" + this.exceptionErrorMessageId + '\'' + ", exceptionErrorMessageParameters=" + Arrays.toString(this.exceptionErrorMessageParameters) + ", exceptionSystemAction='" + this.exceptionSystemAction + '\'' + ", exceptionUserAction='" + this.exceptionUserAction + '\'' + ", exceptionProperties=" + this.exceptionProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AuditLogReportResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AuditLogReportResponse that = (AuditLogReportResponse)objectToCompare;
        return Objects.equals(this.getReport(), that.getReport());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getReport());
    }
}

