/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.projects.SubjectAreaProjectClient;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.FVTUtils;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RelationshipsFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.TermFVT;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.GlossaryProject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ProjectFVT {
    private static final String DEFAULT_TEST_PROJECT_NAME = "Testproject1";
    private static final String DEFAULT_TEST_PROJECT_NAME2 = "Testproject2";
    private static final String DEFAULT_TEST_PROJECT_NAME3 = "Testproject3";
    private static final String DEFAULT_TEST_PROJECT_NAME4 = "Testproject4";
    private static final String DEFAULT_TEST_PROJECT_NAME5 = "Testproject5";
    private static final String DEFAULT_TEST_PROJECT_NAME6 = "Testproject6";
    private static final String DEFAULT_TEST_PROJECT_NAME7 = "Testproject7";
    private SubjectAreaProjectClient<Project> subjectAreaProject = null;
    private SubjectAreaProjectClient subjectAreaProjectClient = null;
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;
    private RelationshipsFVT relationshipsFVT = null;
    private String serverName = null;
    private String userId = null;
    private int existingProjectCount = 0;
    private Set<String> createdProjectsSet = new HashSet<String>();

    public ProjectFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaRestClient client = new SubjectAreaRestClient(serverName, url);
        this.subjectAreaProject = new SubjectAreaProjectClient(client);
        this.serverName = serverName;
        this.userId = userId;
        this.existingProjectCount = this.findProjects("").size();
        System.out.println("existingProjectCount " + this.existingProjectCount);
    }

    public static void runWith2Servers(String url) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ProjectFVT.runIt(url, "cocoMDS4", "erinoverview");
        ProjectFVT.runIt(url, "cocoMDS1", "erinoverview");
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            ProjectFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runIt(String url, String serverName, String userId) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("ProjectFVT runIt started");
        ProjectFVT fvt = new ProjectFVT(url, serverName, userId);
        fvt.run();
        fvt.deleteRemainingProjects();
        System.out.println("ProjectFVT runIt stopped");
    }

    public static int getProjectCount(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, SubjectAreaFVTCheckedException {
        ProjectFVT fvt = new ProjectFVT(url, serverName, userId);
        return fvt.findProjects(".*").size();
    }

    public void run() throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("Create a project");
        Project project = this.createProject(this.serverName + " Testproject1");
        FVTUtils.validateNode((Node)project);
        Project project2 = this.createProject(this.serverName + " Testproject2");
        FVTUtils.validateNode((Node)project2);
        if (this.getProjectTerms(project.getSystemAttributes().getGUID()).size() != 0) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected no terms to be in the project. Got " + this.getProjectTerms(project.getSystemAttributes().getGUID()).size());
        }
        List<Project> results = this.findProjects(null);
        if (results.size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 back on the find got " + results.size());
        }
        Project projectForUpdate = new Project();
        projectForUpdate.setName(this.serverName + " Testproject3");
        System.out.println("Get the project");
        String guid = project.getSystemAttributes().getGUID();
        Project gotProject = this.getProjectByGUID(guid);
        FVTUtils.validateNode((Node)gotProject);
        System.out.println("Update the project");
        Project updatedProject = this.updateProject(guid, projectForUpdate);
        FVTUtils.validateNode((Node)updatedProject);
        System.out.println("Get the project again");
        gotProject = this.getProjectByGUID(guid);
        FVTUtils.validateNode((Node)gotProject);
        System.out.println("Delete the project");
        this.deleteProject(guid);
        System.out.println("restore the project");
        gotProject = this.restoreProject(guid);
        FVTUtils.validateNode((Node)gotProject);
        System.out.println("Delete the project again");
        this.deleteProject(guid);
        System.out.println("Purge a project");
        this.purgeProject(guid);
        System.out.println("Create project with the same name as a deleted one");
        project = this.createProject(this.serverName + " Testproject1");
        FVTUtils.validateNode((Node)project);
        System.out.println("create projects to find");
        Project projectForFind1 = this.getProjectForInput(DEFAULT_TEST_PROJECT_NAME7);
        projectForFind1.setQualifiedName(DEFAULT_TEST_PROJECT_NAME6);
        projectForFind1 = this.issueCreateProject(projectForFind1);
        FVTUtils.validateNode((Node)projectForFind1);
        Project projectForFind2 = this.createProject(DEFAULT_TEST_PROJECT_NAME6);
        FVTUtils.validateNode((Node)projectForFind2);
        Project projectForFind3 = this.createProject(DEFAULT_TEST_PROJECT_NAME5);
        FVTUtils.validateNode((Node)projectForFind3);
        Project projectForFind4 = this.createProject("This is a Project with spaces in name");
        FVTUtils.validateNode((Node)projectForFind4);
        results = this.findProjects(DEFAULT_TEST_PROJECT_NAME5);
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        results = this.findProjects(DEFAULT_TEST_PROJECT_NAME6);
        if (results.size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 back on the find got " + results.size());
        }
        this.deleteProject(projectForFind2.getSystemAttributes().getGUID());
        results = this.findProjects(DEFAULT_TEST_PROJECT_NAME6);
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        results = this.findProjects("This is a Project with spaces in name");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        Project projectForGraph = this.createProject(DEFAULT_TEST_PROJECT_NAME4);
        FindRequest findRequest = new FindRequest();
        List<Term> terms = this.getProjectTerms(projectForGraph.getSystemAttributes().getGUID(), findRequest, true, false);
        if (terms != null && terms.size() > 0) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected null or empty got " + terms.size());
        }
        this.createProject(DEFAULT_TEST_PROJECT_NAME);
        Project projectForUniqueQFN2 = this.createProject(DEFAULT_TEST_PROJECT_NAME);
        if (projectForUniqueQFN2 == null || projectForUniqueQFN2.equals((Object)"")) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected qualified name to be set");
        }
    }

    public Project createProject(String projectName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Project project = this.getProjectForInput(projectName);
        return this.issueCreateProject(project);
    }

    public Project issueCreateProject(Project project) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Project newProject = (Project)this.subjectAreaProject.create(this.userId, (Object)project);
        if (newProject != null) {
            this.createdProjectsSet.add(newProject.getSystemAttributes().getGUID());
            System.out.println("Created Project " + newProject.getName() + " with userId " + newProject.getSystemAttributes().getGUID());
        }
        return newProject;
    }

    public Project getProjectForInput(String projectName) {
        Project project = new Project();
        project.setName(projectName);
        return project;
    }

    public GlossaryProject getGlossaryProjectForInput(String projectName) {
        GlossaryProject glossaryProject = new GlossaryProject();
        glossaryProject.setName(projectName);
        return glossaryProject;
    }

    public List<Project> findProjects(String criteria) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria(criteria);
        List projects = this.subjectAreaProject.find(this.userId, findRequest);
        return projects;
    }

    public Project getProjectByGUID(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Project project = (Project)this.subjectAreaProject.getByGUID(this.userId, guid);
        FVTUtils.validateNode((Node)project);
        System.out.println("Got Project " + project.getName() + " with userId " + project.getSystemAttributes().getGUID() + " and status " + project.getSystemAttributes().getStatus());
        return project;
    }

    public List<Term> getProjectTerms(String guid, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List terms = this.subjectAreaProject.getProjectTerms(this.userId, guid, findRequest, exactValue, ignoreCase, null);
        System.out.println("Got terms from project with userId " + guid);
        return terms;
    }

    public Project updateProject(String guid, Project project) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Project updatedProject = (Project)this.subjectAreaProject.update(this.userId, guid, (Object)project);
        FVTUtils.validateNode((Node)updatedProject);
        System.out.println("Updated Project name to " + updatedProject.getName());
        return updatedProject;
    }

    public void deleteProject(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.subjectAreaProject.delete(this.userId, guid);
        this.createdProjectsSet.remove(guid);
        System.out.println("Deleted Project succeeded");
    }

    public Project restoreProject(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Project restoredProject = (Project)this.subjectAreaProject.restore(this.userId, guid);
        FVTUtils.validateNode((Node)restoredProject);
        this.createdProjectsSet.add(restoredProject.getSystemAttributes().getGUID());
        System.out.println("Restored Project name is " + restoredProject.getName());
        return restoredProject;
    }

    public void purgeProject(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.subjectAreaProject.purge(this.userId, guid);
        System.out.println("Purge succeeded");
    }

    public List<Relationship> getProjectRelationships(Project project) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.subjectAreaProject.getAllRelationships(this.userId, project.getSystemAttributes().getGUID());
    }

    void deleteRemainingProjects() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Iterator<String> iter = this.createdProjectsSet.iterator();
        while (iter.hasNext()) {
            String guid = iter.next();
            iter.remove();
            this.deleteProject(guid);
        }
        List<Project> projects = this.findProjects("");
        if (projects.size() != this.existingProjectCount) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + this.existingProjectCount + " Projects to be found, got " + projects.size());
        }
    }

    public List<Term> getProjectTerms(String projectGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.subjectAreaProject.getProjectTerms(this.userId, projectGuid, new FindRequest(), false, true, null);
    }
}

