/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.FVTUtils;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.TermFVT;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class EffectiveDatesFVT {
    private static final String DEFAULT_TEST_PAST_GLOSSARY_NAME = "Test past Glossary for term FVT";
    private static final String DEFAULT_TEST_FUTURE_GLOSSARY_NAME = "Test future Glossary for term FVT";
    private static final String DEFAULT_TEST_TERM_NAME = "Test term A";
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            EffectiveDatesFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public EffectiveDatesFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("Create a glossary");
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.termFVT = new TermFVT(url, serverName, userId);
    }

    public void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        this.termFVT.deleteRemainingTerms();
        this.glossaryFVT.deleteRemainingGlossaries();
    }

    public static void runWith2Servers(String url) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EffectiveDatesFVT.runIt(url, "cocoMDS4", "erinoverview");
        EffectiveDatesFVT.runIt(url, "cocoMDS1", "erinoverview");
    }

    public static synchronized void runIt(String url, String serverName, String userId) throws InvalidParameterException, SubjectAreaFVTCheckedException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("EffectiveDatesFVT runIt started");
        EffectiveDatesFVT fvt = new EffectiveDatesFVT(url, serverName, userId);
        fvt.run();
        fvt.deleteRemaining();
        System.out.println("EffectiveDatesFVT runIt stopped");
    }

    public void run() throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            this.glossaryFVT.createPastToGlossary(DEFAULT_TEST_PAST_GLOSSARY_NAME);
        }
        catch (InvalidParameterException e) {
            System.out.println("Expected creation of a Glossary with to in the past failed");
        }
        try {
            this.glossaryFVT.createPastFromGlossary(DEFAULT_TEST_PAST_GLOSSARY_NAME);
        }
        catch (InvalidParameterException e) {
            System.out.println("Expected creation of a Glossary with from in the past failed");
        }
        try {
            this.glossaryFVT.createInvalidEffectiveDateGlossary(DEFAULT_TEST_PAST_GLOSSARY_NAME);
        }
        catch (InvalidParameterException e) {
            System.out.println("Expected creation of a Glossary with invalid Effectivity dates failed");
        }
        Glossary futureGloss = this.glossaryFVT.createFutureGlossary(DEFAULT_TEST_FUTURE_GLOSSARY_NAME);
        FVTUtils.validateNode((Node)futureGloss);
        Term term5 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME, futureGloss.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)term5);
        this.checkTermGlossaryEffectivity(futureGloss, term5);
        Term gotTerm5 = this.termFVT.getTermByGUID(term5.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)gotTerm5);
        this.checkTermGlossaryEffectivity(futureGloss, gotTerm5);
        Term futureTerm = this.termFVT.updateTermToFuture(gotTerm5.getSystemAttributes().getGUID(), term5);
        FVTUtils.validateNode((Node)futureTerm);
        this.checkTermGlossaryEffectivity(futureGloss, futureTerm);
        futureTerm = this.termFVT.getTermByGUID(term5.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)futureTerm);
        this.checkTermGlossaryEffectivity(futureGloss, futureTerm);
    }

    private void checkTermGlossaryEffectivity(Glossary glossary, Term term) throws SubjectAreaFVTCheckedException {
        if (term.getGlossary() == null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Term expected associated future Glossary");
        }
        Long glossaryFrom = glossary.getEffectiveFromTime();
        Long termGlossaryFrom = term.getGlossary().getFromEffectivityTime();
        Long glossaryTo = glossary.getEffectiveToTime();
        Long termGlossaryTo = term.getGlossary().getToEffectivityTime();
        if (glossaryFrom == null && termGlossaryFrom != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Term's Glossary fromTime not null but glossaries is null");
        }
        if (glossaryFrom != null && termGlossaryFrom == null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Term's Glossary fromTime  null but glossaries is not null");
        }
        if (glossaryTo == null && termGlossaryTo != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Term's Glossary toTime not null but glossaries is null");
        }
        if (glossaryTo != null && termGlossaryTo == null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Term's Glossary toTime null but glossaries is not null");
        }
        if (glossaryFrom != null && termGlossaryFrom != null && glossaryFrom.longValue() != termGlossaryFrom.longValue()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Term's Glossary fromTime " + termGlossaryFrom + " does not match the glossaries " + glossaryFrom);
        }
        if (glossaryTo != null && termGlossaryTo != null && glossaryTo.longValue() != termGlossaryTo.longValue()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Term's Glossary toTime " + termGlossaryTo + " does not match the glossaries " + glossaryTo);
        }
    }
}

