/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.categories.SubjectAreaCategoryClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.terms.SubjectAreaTermClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationshipClients;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.CategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.FVTUtils;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.ProjectFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.TermFVT;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOfDeprecated;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;

public class RelationshipsFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for relationships FVT";
    private static final String DEFAULT_TEST_TERM_NAME = "Test term A1";
    private static final String DEFAULT_TEST_TERM_NAME2 = "Test term B1";
    private static final String DEFAULT_TEST_TERM_NAME3 = "Test term C1";
    private static final String DEFAULT_TEST_CAT_NAME1 = "Test cat A1";
    private static final String DEFAULT_TEST_CAT_NAME2 = "Test cat B1";
    private static final String DEFAULT_TEST_CAT_NAME3 = "Test cat C1";
    private static final String DEFAULT_TEST_CAT_NAME4 = "Test cat D1";
    private static final String DEFAULT_TEST_PROJECT_NAME = "Test Project for relationships FVT";
    private SubjectAreaRelationshipClients subjectAreaRelationship = null;
    private SubjectAreaNodeClient<Category> subjectAreaCategory = null;
    private SubjectAreaNodeClient<Term> subjectAreaTerm = null;
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;
    private CategoryFVT catFVT = null;
    private ProjectFVT projectFVT = null;
    private String url = null;
    private String serverName = null;
    private String userId = null;

    public RelationshipsFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.url = url;
        SubjectAreaRestClient client = new SubjectAreaRestClient(serverName, url);
        this.subjectAreaRelationship = new SubjectAreaRelationship(client);
        this.subjectAreaCategory = new SubjectAreaCategoryClient(client);
        this.subjectAreaTerm = new SubjectAreaTermClient(client);
        this.termFVT = new TermFVT(url, serverName, userId);
        this.catFVT = new CategoryFVT(url, serverName, userId);
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.projectFVT = new ProjectFVT(url, serverName, userId);
        this.serverName = serverName;
        this.userId = userId;
    }

    void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        this.catFVT.deleteRemainingCategories();
        this.termFVT.deleteRemainingTerms();
        this.glossaryFVT.deleteRemainingGlossaries();
        this.projectFVT.deleteRemainingProjects();
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            RelationshipsFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runWith2Servers(String url) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelationshipsFVT.runIt(url, "cocoMDS4", "erinoverview");
        RelationshipsFVT.runIt(url, "cocoMDS1", "erinoverview");
    }

    public static void runIt(String url, String serverName, String userId) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("relationshipFVT runIt started");
        RelationshipsFVT fvt = new RelationshipsFVT(url, serverName, userId);
        fvt.run();
        fvt.deleteRemaining();
        System.out.println("relationshipFVT runIt stopped");
    }

    public void run() throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("Create a glossary");
        int term1relationshipcount = 0;
        int term2relationshipcount = 0;
        int term3relationshipcount = 0;
        int glossaryRelationshipCount = 0;
        int cat1RelationshipCount = 0;
        int cat2RelationshipCount = 0;
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        System.out.println("Create a term called Test term A1 using glossary userId");
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        Term term1 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforTerm(++term1relationshipcount, term1);
        FVTUtils.validateNode((Node)term1);
        System.out.println("Create a term called Test term B1 using glossary userId");
        Term term2 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME2, glossaryGuid);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforTerm(++term2relationshipcount, term2);
        FVTUtils.validateNode((Node)term2);
        System.out.println("Create a term called Test term C1 using glossary userId");
        Term term3 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME3, glossaryGuid);
        FVTUtils.validateNode((Node)term3);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforTerm(++term3relationshipcount, term3);
        Category cat1 = this.catFVT.createCategory(DEFAULT_TEST_CAT_NAME1, glossaryGuid);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforCategory(++cat1RelationshipCount, cat1);
        Category cat2 = this.catFVT.createCategory(DEFAULT_TEST_CAT_NAME2, glossaryGuid);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforCategory(++cat2RelationshipCount, cat1);
        this.synonymFVT(term1, term2);
        this.antonymFVT(term1, term3);
        this.relatedtermFVT(term1, term3);
        this.hasaFVT(term1, term3);
        this.translationFVT(term1, term2);
        this.usedincontextFVT(term1, term2);
        this.preferredtermFVT(term1, term2);
        this.validvalueFVT(term1, term2);
        this.replacementTermFVT(term1, term2);
        this.typedByFVT(term1, term2);
        this.isaFVT(term1, term2);
        this.isatypeofFVT(term1, term2);
        this.isATypeOfFVT(term1, term2);
        this.termCategorizationFVT(term1, cat1);
        this.createSomeTermRelationships(term1, term2, term3);
        this.checkRelationshipNumberforTerm(term1relationshipcount += 13, term1);
        this.checkRelationshipNumberforTerm(term2relationshipcount += 12, term2);
        this.checkRelationshipNumberforTerm(++term3relationshipcount, term3);
        FVTUtils.validateRelationship((Relationship)this.createTermCategorization(term1, cat1));
        ++term1relationshipcount;
        this.checkRelationshipNumberforCategory(++cat1RelationshipCount, cat1);
        FVTUtils.validateRelationship((Relationship)this.createTermCategorization(term1, cat2));
        ++term1relationshipcount;
        this.checkRelationshipNumberforCategory(++cat2RelationshipCount, cat1);
        FVTUtils.validateRelationship((Relationship)this.createTermCategorization(term2, cat1));
        this.checkRelationshipNumberforCategory(++cat1RelationshipCount, cat1);
        FVTUtils.validateRelationship((Relationship)this.createTermCategorization(term3, cat1));
        this.checkRelationshipNumberforCategory(++cat1RelationshipCount, cat1);
        this.checkRelationshipNumberforTerm(term1relationshipcount, term1);
        this.checkRelationshipNumberforTerm(++term2relationshipcount, term2);
        this.checkRelationshipNumberforTerm(++term3relationshipcount, term3);
        System.out.println("get term relationships");
        List<Relationship> term1Relationships = this.termFVT.getTermRelationships(term1);
        System.out.println("Get paged term relationships");
        int numberofrelationships = 0;
        for (int offset = 0; offset < term1relationshipcount; offset += 3) {
            System.out.println("Get paged term relationships offset = " + offset + ",pageSize=3");
            List<Relationship> term1PagedRelationships = this.termFVT.getTermRelationships(term1, null, offset, 3, SequencingOrder.GUID, null);
            numberofrelationships += term1PagedRelationships.size();
        }
        if (term1relationshipcount != numberofrelationships) {
            throw new SubjectAreaFVTCheckedException("Expected " + term1Relationships.size() + " got " + numberofrelationships);
        }
        Project project = this.projectFVT.createProject(DEFAULT_TEST_PROJECT_NAME);
        this.projectScopeFVT(project, term1);
        this.projectFVT.deleteProject(project.getSystemAttributes().getGUID());
        Category cat3 = this.catFVT.createCategory(DEFAULT_TEST_CAT_NAME3, glossaryGuid);
        Category cat4 = this.catFVT.createCategory(DEFAULT_TEST_CAT_NAME4, glossaryGuid);
        this.categoryHierarchyLinkFVT(cat3, cat4);
    }

    private void checkRelationshipNumberforTerm(int expectedrelationshipcount, Term term) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int actualCount = this.termFVT.getTermRelationships(term).size();
        if (expectedrelationshipcount != actualCount) {
            throw new SubjectAreaFVTCheckedException("ERROR: expected " + expectedrelationshipcount + " for " + term.getName() + " got " + actualCount);
        }
    }

    private void checkRelationshipNumberforGlossary(int expectedrelationshipcount, Glossary glossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        int actualCount = this.glossaryFVT.getGlossaryRelationships(glossary).size();
        if (expectedrelationshipcount != actualCount) {
            throw new SubjectAreaFVTCheckedException("ERROR: expected " + expectedrelationshipcount + " for " + glossary.getName() + " got " + actualCount);
        }
    }

    private void checkRelationshipNumberforCategory(int expectedrelationshipcount, Category category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        int actualCount = this.catFVT.getCategoryRelationships(category).size();
        if (expectedrelationshipcount != actualCount) {
            throw new SubjectAreaFVTCheckedException("ERROR: expected " + expectedrelationshipcount + " for " + category.getName() + " got " + actualCount);
        }
    }

    private void createSomeTermRelationships(Term term1, Term term2, Term term3) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        FVTUtils.validateRelationship((Relationship)this.createValidValue(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createAntonym(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createIsaRelationship(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createPreferredTerm(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createRelatedTerm(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createHasA(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createSynonym(term1, term3));
        FVTUtils.validateRelationship((Relationship)this.createReplacementTerm(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createTermTYPEDBYRelationship(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createTranslation(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createUsedInContext(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createIsATypeOfDeprecated(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createIsATypeOf(term1, term2));
    }

    private void isatypeofFVT(Term term1, Term term2) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        IsATypeOfDeprecated createdisATypeOfDeprecated = this.createIsATypeOfDeprecated(term1, term2);
        String guid = createdisATypeOfDeprecated.getGuid();
        IsATypeOfDeprecated gotisATypeOfDeprecated = (IsATypeOfDeprecated)this.subjectAreaRelationship.isaTypeOfDeprecated().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotisATypeOfDeprecated);
        System.out.println("Got IsaTypeOf " + createdisATypeOfDeprecated);
        IsATypeOfDeprecated updateisATypeOfDeprecated = new IsATypeOfDeprecated();
        updateisATypeOfDeprecated.setDescription("ddd2");
        IsATypeOfDeprecated updatedisATypeOfDeprecated = (IsATypeOfDeprecated)this.subjectAreaRelationship.isaTypeOfDeprecated().update(this.userId, guid, (Object)updateisATypeOfDeprecated);
        FVTUtils.validateRelationship((Relationship)updatedisATypeOfDeprecated);
        if (!updatedisATypeOfDeprecated.getDescription().equals(updateisATypeOfDeprecated.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: IsaTypeOf update description not as expected");
        }
        if (!updatedisATypeOfDeprecated.getSource().equals(createdisATypeOfDeprecated.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: IsaTypeOf update source not as expected");
        }
        if (!updatedisATypeOfDeprecated.getSteward().equals(createdisATypeOfDeprecated.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: IsaTypeOf update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedisATypeOfDeprecated, (Relationship)createdisATypeOfDeprecated, "IsATypeOf", "update");
        System.out.println("Updated IsaTypeOf " + createdisATypeOfDeprecated);
        IsATypeOfDeprecated replaceisATypeOfDeprecated = new IsATypeOfDeprecated();
        replaceisATypeOfDeprecated.setDescription("ddd3");
        IsATypeOfDeprecated replacedisATypeOfDeprecated = (IsATypeOfDeprecated)this.subjectAreaRelationship.isaTypeOfDeprecated().replace(this.userId, guid, (Object)replaceisATypeOfDeprecated);
        FVTUtils.validateRelationship((Relationship)replacedisATypeOfDeprecated);
        if (!replacedisATypeOfDeprecated.getDescription().equals(replaceisATypeOfDeprecated.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: IsaTypeOf replace description not as expected");
        }
        if (replacedisATypeOfDeprecated.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: IsaTypeOf replace source not as expected");
        }
        if (replacedisATypeOfDeprecated.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: IsaTypeOf replace steward not as expected");
        }
        if (!replacedisATypeOfDeprecated.getEnd1().getNodeGuid().equals(createdisATypeOfDeprecated.getEnd1().getNodeGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: IsaTypeOf replace end 1 not as expected");
        }
        if (!replacedisATypeOfDeprecated.getEnd2().getNodeGuid().equals(createdisATypeOfDeprecated.getEnd2().getNodeGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: IsaTypeOf replace end 2 not as expected");
        }
        System.out.println("Replaced IsaTypeOf " + createdisATypeOfDeprecated);
        this.subjectAreaRelationship.isaTypeOfDeprecated().delete(this.userId, guid);
        System.out.println("Deleted IsaTypeOf with userId=" + guid);
        gotisATypeOfDeprecated = (IsATypeOfDeprecated)this.subjectAreaRelationship.isaTypeOfDeprecated().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotisATypeOfDeprecated);
        System.out.println("Restored IsaTypeOf with userId=" + guid);
        this.subjectAreaRelationship.isaTypeOfDeprecated().delete(this.userId, guid);
        System.out.println("Deleted IsaTypeOf with userId=" + guid);
    }

    private void isATypeOfFVT(Term term1, Term term2) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        IsATypeOf createdisATypeOf = this.createIsATypeOf(term1, term2);
        String guid = createdisATypeOf.getGuid();
        IsATypeOf gotisATypeOf = (IsATypeOf)this.subjectAreaRelationship.isATypeOf().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotisATypeOf);
        System.out.println("Got isATypeOf " + createdisATypeOf);
        IsATypeOf updateisATypeOf = new IsATypeOf();
        updateisATypeOf.setDescription("ddd2");
        IsATypeOf updatedisATypeOf = (IsATypeOf)this.subjectAreaRelationship.isATypeOf().update(this.userId, guid, (Object)updateisATypeOf);
        FVTUtils.validateRelationship((Relationship)updatedisATypeOf);
        if (!updatedisATypeOf.getDescription().equals(updateisATypeOf.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isATypeOf update description not as expected");
        }
        if (!updatedisATypeOf.getSource().equals(createdisATypeOf.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isATypeOf update source not as expected");
        }
        if (!updatedisATypeOf.getSteward().equals(createdisATypeOf.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isATypeOf update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedisATypeOf, (Relationship)createdisATypeOf, "isATypeOf", "update");
        System.out.println("Updated isATypeOf " + createdisATypeOf);
        IsATypeOf replaceisATypeOf = new IsATypeOf();
        replaceisATypeOf.setDescription("ddd3");
        IsATypeOf replacedisATypeOf = (IsATypeOf)this.subjectAreaRelationship.isATypeOf().replace(this.userId, guid, (Object)replaceisATypeOf);
        FVTUtils.validateRelationship((Relationship)replacedisATypeOf);
        if (!replacedisATypeOf.getDescription().equals(replaceisATypeOf.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isATypeOf replace description not as expected");
        }
        if (replacedisATypeOf.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: isATypeOf replace source not as expected");
        }
        if (replacedisATypeOf.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: isATypeOf replace steward not as expected");
        }
        if (!replacedisATypeOf.getEnd1().getNodeGuid().equals(createdisATypeOf.getEnd1().getNodeGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isATypeOf replace end 1 not as expected");
        }
        if (!replacedisATypeOf.getEnd2().getNodeGuid().equals(createdisATypeOf.getEnd2().getNodeGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isATypeOf replace end 2 not as expected");
        }
        System.out.println("Replaced isATypeOf " + createdisATypeOf);
        this.subjectAreaRelationship.isATypeOf().delete(this.userId, guid);
        System.out.println("Deleted isATypeOf with userId=" + guid);
        gotisATypeOf = (IsATypeOf)this.subjectAreaRelationship.isATypeOf().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotisATypeOf);
        System.out.println("Restored isATypeOf with userId=" + guid);
        this.subjectAreaRelationship.isATypeOf().delete(this.userId, guid);
        System.out.println("Deleted isATypeOf with userId=" + guid);
    }

    private void isaFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        IsA createdIsA = this.createIsaRelationship(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdIsA);
        System.out.println("Created Isa " + createdIsA);
        String guid = createdIsA.getGuid();
        IsA gotIsA = (IsA)this.subjectAreaRelationship.isA().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotIsA);
        System.out.println("Got Isa " + createdIsA);
        IsA updateIsA = new IsA();
        updateIsA.setDescription("ddd2");
        IsA updatedIsA = (IsA)this.subjectAreaRelationship.isA().update(this.userId, guid, (Object)updateIsA);
        if (!updatedIsA.getDescription().equals(updateIsA.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa update description not as expected");
        }
        if (!updatedIsA.getSource().equals(createdIsA.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa update source not as expected");
        }
        if (!updatedIsA.getExpression().equals(createdIsA.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa update expression not as expected");
        }
        if (!updatedIsA.getSteward().equals(createdIsA.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa update steward not as expected");
        }
        if (!updatedIsA.getEnd1().getNodeGuid().equals(createdIsA.getEnd1().getNodeGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa update end 1 not as expected");
        }
        if (!updatedIsA.getEnd2().getNodeGuid().equals(createdIsA.getEnd2().getNodeGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa update end 2 not as expected");
        }
        System.out.println("Updated Isa " + createdIsA);
        IsA replaceIsA = new IsA();
        replaceIsA.setDescription("ddd3");
        IsA replacedIsA = (IsA)this.subjectAreaRelationship.isA().replace(this.userId, guid, (Object)replaceIsA);
        FVTUtils.validateRelationship((Relationship)replacedIsA);
        if (!replacedIsA.getDescription().equals(replaceIsA.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa replace description not as expected");
        }
        if (replacedIsA.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa replace source not as expected");
        }
        if (replacedIsA.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa replace expression not as expected");
        }
        if (replacedIsA.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa replace steward not as expected");
        }
        if (!replacedIsA.getEnd1().getNodeGuid().equals(createdIsA.getEnd1().getNodeGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa replace end 1 not as expected");
        }
        if (!replacedIsA.getEnd2().getNodeGuid().equals(createdIsA.getEnd2().getNodeGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: isa replace end 2 not as expected");
        }
        System.out.println("Replaced Isa " + createdIsA);
        this.subjectAreaRelationship.isA().delete(this.userId, guid);
        System.out.println("Deleted Isa with userId=" + guid);
        gotIsA = (IsA)this.subjectAreaRelationship.isA().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotIsA);
        System.out.println("Restored Isa with userId=" + guid);
        this.subjectAreaRelationship.isA().delete(this.userId, guid);
        System.out.println("Deleted Isa with userId=" + guid);
    }

    private IsA createIsaRelationship(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        IsA isa = new IsA();
        isa.setDescription("ddd");
        isa.setExpression("Ex");
        isa.setSource("source");
        isa.setSteward("Stew");
        isa.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        isa.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        IsA createdIsA = (IsA)this.subjectAreaRelationship.isA().create(this.userId, (Object)isa);
        FVTUtils.validateRelationship((Relationship)createdIsA);
        FVTUtils.checkEnds((Relationship)isa, (Relationship)createdIsA, "isa", "create");
        return createdIsA;
    }

    private void typedByFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        TypedBy createdTermTYPEDBYRelationship = this.createTermTYPEDBYRelationship(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdTermTYPEDBYRelationship);
        System.out.println("Created TypedBy " + createdTermTYPEDBYRelationship);
        String guid = createdTermTYPEDBYRelationship.getGuid();
        TypedBy gotTermTYPEDBYRelationship = (TypedBy)this.subjectAreaRelationship.typedBy().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotTermTYPEDBYRelationship);
        System.out.println("Got TypedBy " + createdTermTYPEDBYRelationship);
        TypedBy updateTermTYPEDBYRelationship = new TypedBy();
        updateTermTYPEDBYRelationship.setDescription("ddd2");
        TypedBy updatedTermTYPEDBYRelationship = (TypedBy)this.subjectAreaRelationship.typedBy().update(this.userId, guid, (Object)updateTermTYPEDBYRelationship);
        FVTUtils.validateRelationship((Relationship)updatedTermTYPEDBYRelationship);
        if (!updatedTermTYPEDBYRelationship.getDescription().equals(updateTermTYPEDBYRelationship.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: termTYPEDBYRelationship update description not as expected");
        }
        if (!updatedTermTYPEDBYRelationship.getSource().equals(createdTermTYPEDBYRelationship.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: termTYPEDBYRelationship update source not as expected");
        }
        if (!updatedTermTYPEDBYRelationship.getSteward().equals(createdTermTYPEDBYRelationship.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: termTYPEDBYRelationship update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedTermTYPEDBYRelationship, (Relationship)createdTermTYPEDBYRelationship, "TYPEDBY", "update");
        System.out.println("Updated TypedBy " + createdTermTYPEDBYRelationship);
        TypedBy replaceTermTYPEDBYRelationship = new TypedBy();
        replaceTermTYPEDBYRelationship.setDescription("ddd3");
        TypedBy replacedTermTYPEDBYRelationship = (TypedBy)this.subjectAreaRelationship.typedBy().replace(this.userId, guid, (Object)replaceTermTYPEDBYRelationship);
        FVTUtils.validateRelationship((Relationship)replacedTermTYPEDBYRelationship);
        if (!replacedTermTYPEDBYRelationship.getDescription().equals(replaceTermTYPEDBYRelationship.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: termTYPEDBYRelationship replace description not as expected");
        }
        if (replacedTermTYPEDBYRelationship.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: termTYPEDBYRelationship replace source not as expected");
        }
        if (replacedTermTYPEDBYRelationship.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: termTYPEDBYRelationship replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedTermTYPEDBYRelationship, (Relationship)createdTermTYPEDBYRelationship, "TYPEDBY", "replace");
        System.out.println("Replaced TypedBy " + createdTermTYPEDBYRelationship);
        this.subjectAreaRelationship.typedBy().delete(this.userId, guid);
        System.out.println("Deleted TypedBy with userId=" + guid);
        gotTermTYPEDBYRelationship = (TypedBy)this.subjectAreaRelationship.typedBy().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotTermTYPEDBYRelationship);
        System.out.println("Restored TypedBy with userId=" + guid);
        this.subjectAreaRelationship.typedBy().delete(this.userId, guid);
        System.out.println("Deleted TypedBy with userId=" + guid);
    }

    private TypedBy createTermTYPEDBYRelationship(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        TypedBy termTYPEDBYRelationship = new TypedBy();
        termTYPEDBYRelationship.setDescription("ddd");
        termTYPEDBYRelationship.setSource("source");
        termTYPEDBYRelationship.setSteward("Stew");
        termTYPEDBYRelationship.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        termTYPEDBYRelationship.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        TypedBy createdTermTYPEDBYRelationship = (TypedBy)this.subjectAreaRelationship.typedBy().create(this.userId, (Object)termTYPEDBYRelationship);
        FVTUtils.validateRelationship((Relationship)createdTermTYPEDBYRelationship);
        FVTUtils.checkEnds((Relationship)termTYPEDBYRelationship, (Relationship)createdTermTYPEDBYRelationship, "TypedBy", "create");
        return createdTermTYPEDBYRelationship;
    }

    private void replacementTermFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        ReplacementTerm createdReplacementTerm = this.createReplacementTerm(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdReplacementTerm);
        System.out.println("Created ReplacementTerm " + createdReplacementTerm);
        String guid = createdReplacementTerm.getGuid();
        ReplacementTerm gotReplacementTerm = (ReplacementTerm)this.subjectAreaRelationship.replacementTerm().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotReplacementTerm);
        System.out.println("Got ReplacementTerm " + createdReplacementTerm);
        ReplacementTerm updateReplacementTerm = new ReplacementTerm();
        updateReplacementTerm.setDescription("ddd2");
        ReplacementTerm updatedReplacementTerm = (ReplacementTerm)this.subjectAreaRelationship.replacementTerm().update(this.userId, guid, (Object)updateReplacementTerm);
        FVTUtils.validateRelationship((Relationship)updatedReplacementTerm);
        if (!updatedReplacementTerm.getDescription().equals(updateReplacementTerm.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: replacementTerm update description not as expected");
        }
        if (!updatedReplacementTerm.getSource().equals(createdReplacementTerm.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: replacementTerm update source not as expected");
        }
        if (!updatedReplacementTerm.getExpression().equals(createdReplacementTerm.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: replacementTerm update expression not as expected");
        }
        if (!updatedReplacementTerm.getSteward().equals(createdReplacementTerm.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: replacementTerm update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedReplacementTerm, (Relationship)createdReplacementTerm, "replacementTerm", "update");
        System.out.println("Updated ReplacementTerm " + createdReplacementTerm);
        ReplacementTerm replaceReplacementTerm = new ReplacementTerm();
        replaceReplacementTerm.setDescription("ddd3");
        ReplacementTerm replacedReplacementTerm = (ReplacementTerm)this.subjectAreaRelationship.replacementTerm().replace(this.userId, guid, (Object)replaceReplacementTerm);
        FVTUtils.validateRelationship((Relationship)replacedReplacementTerm);
        if (!replacedReplacementTerm.getDescription().equals(replaceReplacementTerm.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: replacementTerm replace description not as expected");
        }
        if (replacedReplacementTerm.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: replacementTerm replace source not as expected");
        }
        if (replacedReplacementTerm.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: replacementTerm replace expression not as expected");
        }
        if (replacedReplacementTerm.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: replacementTerm replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedReplacementTerm, (Relationship)createdReplacementTerm, "replacementTerm", "replace");
        System.out.println("Replaced ReplacementTerm " + createdReplacementTerm);
        this.subjectAreaRelationship.replacementTerm().delete(this.userId, guid);
        System.out.println("Deleted ReplacementTerm with userId=" + guid);
        gotReplacementTerm = (ReplacementTerm)this.subjectAreaRelationship.replacementTerm().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotReplacementTerm);
        System.out.println("Restored ReplacementTerm with userId=" + guid);
        this.subjectAreaRelationship.replacementTerm().delete(this.userId, guid);
        System.out.println("Deleted ReplacementTerm with userId=" + guid);
    }

    private ReplacementTerm createReplacementTerm(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ReplacementTerm replacementTerm = new ReplacementTerm();
        replacementTerm.setDescription("ddd");
        replacementTerm.setExpression("Ex");
        replacementTerm.setSource("source");
        replacementTerm.setSteward("Stew");
        replacementTerm.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        replacementTerm.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ReplacementTerm createdReplacementTerm = (ReplacementTerm)this.subjectAreaRelationship.replacementTerm().create(this.userId, (Object)replacementTerm);
        FVTUtils.validateRelationship((Relationship)createdReplacementTerm);
        FVTUtils.checkEnds((Relationship)replacementTerm, (Relationship)createdReplacementTerm, "ReplacementTerm", "create");
        return createdReplacementTerm;
    }

    private void validvalueFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        ValidValue createdValidValue = this.createValidValue(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdValidValue);
        System.out.println("Created ValidValue " + createdValidValue);
        String guid = createdValidValue.getGuid();
        ValidValue gotValidValue = (ValidValue)this.subjectAreaRelationship.validValue().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotValidValue);
        System.out.println("Got ValidValue " + createdValidValue);
        ValidValue updateValidValue = new ValidValue();
        updateValidValue.setDescription("ddd2");
        ValidValue updatedValidValue = (ValidValue)this.subjectAreaRelationship.validValue().update(this.userId, guid, (Object)updateValidValue);
        if (!updatedValidValue.getDescription().equals(updateValidValue.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: validValue update description not as expected");
        }
        if (!updatedValidValue.getSource().equals(createdValidValue.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: validValue update source not as expected");
        }
        if (!updatedValidValue.getExpression().equals(createdValidValue.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: validValue update expression not as expected");
        }
        if (!updatedValidValue.getSteward().equals(createdValidValue.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: validValue update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedValidValue, (Relationship)createdValidValue, "ValidValue", "update");
        System.out.println("Updated ValidValue " + createdValidValue);
        ValidValue replaceValidValue = new ValidValue();
        replaceValidValue.setDescription("ddd3");
        replaceValidValue.setGuid(createdValidValue.getGuid());
        ValidValue replacedValidValue = (ValidValue)this.subjectAreaRelationship.validValue().replace(this.userId, guid, (Object)replaceValidValue);
        if (!replacedValidValue.getDescription().equals(replaceValidValue.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: validValue replace description not as expected");
        }
        if (replacedValidValue.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: validValue replace source not as expected");
        }
        if (replacedValidValue.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: validValue replace expression not as expected");
        }
        if (replacedValidValue.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: validValue replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedValidValue, (Relationship)createdValidValue, "ValidValue", "replace");
        System.out.println("Replaced ValidValue " + createdValidValue);
        this.subjectAreaRelationship.validValue().delete(this.userId, guid);
        System.out.println("Deleted ValidValue with userId=" + guid);
        gotValidValue = (ValidValue)this.subjectAreaRelationship.validValue().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotValidValue);
        System.out.println("Restored ValidValue with userId=" + guid);
        this.subjectAreaRelationship.validValue().delete(this.userId, guid);
        System.out.println("Deleted ValidValue with userId=" + guid);
    }

    private ValidValue createValidValue(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ValidValue validValue = new ValidValue();
        validValue.setDescription("ddd");
        validValue.setExpression("Ex");
        validValue.setSource("source");
        validValue.setSteward("Stew");
        validValue.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        validValue.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ValidValue createdValidValue = (ValidValue)this.subjectAreaRelationship.validValue().create(this.userId, (Object)validValue);
        FVTUtils.validateRelationship((Relationship)createdValidValue);
        FVTUtils.checkEnds((Relationship)validValue, (Relationship)createdValidValue, "ValidValue", "create");
        return createdValidValue;
    }

    private void preferredtermFVT(Term term1, Term term2) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        PreferredTerm createdPreferredTerm = this.createPreferredTerm(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdPreferredTerm);
        System.out.println("Created PreferredTerm " + createdPreferredTerm);
        String guid = createdPreferredTerm.getGuid();
        PreferredTerm gotPreferredTerm = (PreferredTerm)this.subjectAreaRelationship.preferredTerm().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotPreferredTerm);
        System.out.println("Got PreferredTerm " + createdPreferredTerm);
        PreferredTerm updatePreferredTerm = new PreferredTerm();
        updatePreferredTerm.setDescription("ddd2");
        PreferredTerm updatedPreferredTerm = (PreferredTerm)this.subjectAreaRelationship.preferredTerm().update(this.userId, guid, (Object)updatePreferredTerm);
        FVTUtils.validateRelationship((Relationship)updatedPreferredTerm);
        if (!updatedPreferredTerm.getDescription().equals(updatePreferredTerm.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: preferredTerm update description not as expected");
        }
        if (!updatedPreferredTerm.getSource().equals(createdPreferredTerm.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: preferredTerm update source not as expected");
        }
        if (!updatedPreferredTerm.getExpression().equals(createdPreferredTerm.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: preferredTerm update expression not as expected");
        }
        if (!updatedPreferredTerm.getSteward().equals(createdPreferredTerm.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: preferredTerm update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedPreferredTerm, (Relationship)createdPreferredTerm, "PreferredTerm", "update");
        System.out.println("Updated PreferredTerm " + createdPreferredTerm);
        PreferredTerm replacePreferredTerm = new PreferredTerm();
        replacePreferredTerm.setDescription("ddd3");
        PreferredTerm replacedPreferredTerm = (PreferredTerm)this.subjectAreaRelationship.preferredTerm().replace(this.userId, guid, (Object)replacePreferredTerm);
        FVTUtils.validateRelationship((Relationship)replacedPreferredTerm);
        if (!replacedPreferredTerm.getDescription().equals(replacePreferredTerm.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: preferredTerm replace description not as expected");
        }
        if (replacedPreferredTerm.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: preferredTerm replace source not as expected");
        }
        if (replacedPreferredTerm.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: preferredTerm replace expression not as expected");
        }
        if (replacedPreferredTerm.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: preferredTerm replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedPreferredTerm, (Relationship)createdPreferredTerm, "PreferredTerm", "replace");
        System.out.println("Replaced PreferredTerm " + createdPreferredTerm);
        this.subjectAreaRelationship.preferredTerm().delete(this.userId, guid);
        System.out.println("Deleted PreferredTerm with userId=" + guid);
        gotPreferredTerm = (PreferredTerm)this.subjectAreaRelationship.preferredTerm().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotPreferredTerm);
        System.out.println("restored PreferredTerm with userId=" + guid);
        this.subjectAreaRelationship.preferredTerm().delete(this.userId, guid);
        System.out.println("Deleted PreferredTerm with userId=" + guid);
    }

    private PreferredTerm createPreferredTerm(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        PreferredTerm preferredTerm = new PreferredTerm();
        preferredTerm.setDescription("ddd");
        preferredTerm.setExpression("Ex");
        preferredTerm.setSource("source");
        preferredTerm.setSteward("Stew");
        preferredTerm.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        preferredTerm.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        PreferredTerm createdPreferredTerm = (PreferredTerm)this.subjectAreaRelationship.preferredTerm().create(this.userId, (Object)preferredTerm);
        FVTUtils.validateRelationship((Relationship)createdPreferredTerm);
        FVTUtils.checkEnds((Relationship)preferredTerm, (Relationship)createdPreferredTerm, "PreferredTerm", "create");
        return createdPreferredTerm;
    }

    private void usedincontextFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        UsedInContext createdUsedInContext = this.createUsedInContext(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdUsedInContext);
        System.out.println("Created UsedInContext " + createdUsedInContext);
        String guid = createdUsedInContext.getGuid();
        UsedInContext gotUsedInContext = (UsedInContext)this.subjectAreaRelationship.usedInContext().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotUsedInContext);
        System.out.println("Got UsedInContext " + createdUsedInContext);
        UsedInContext updateUsedInContext = new UsedInContext();
        updateUsedInContext.setDescription("ddd2");
        UsedInContext updatedUsedInContext = (UsedInContext)this.subjectAreaRelationship.usedInContext().update(this.userId, guid, (Object)updateUsedInContext);
        FVTUtils.validateRelationship((Relationship)updatedUsedInContext);
        if (!updatedUsedInContext.getDescription().equals(updateUsedInContext.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: usedInContext update description not as expected");
        }
        if (!updatedUsedInContext.getSource().equals(createdUsedInContext.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: usedInContext update source not as expected");
        }
        if (!updatedUsedInContext.getExpression().equals(createdUsedInContext.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: usedInContext update expression not as expected");
        }
        if (!updatedUsedInContext.getSteward().equals(createdUsedInContext.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: usedInContext update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedUsedInContext, (Relationship)createdUsedInContext, "UsedInContext", "update");
        System.out.println("Updated UsedInContext " + createdUsedInContext);
        UsedInContext replaceUsedInContext = new UsedInContext();
        replaceUsedInContext.setDescription("ddd3");
        UsedInContext replacedUsedInContext = (UsedInContext)this.subjectAreaRelationship.usedInContext().replace(this.userId, guid, (Object)replaceUsedInContext);
        FVTUtils.validateRelationship((Relationship)replacedUsedInContext);
        if (!replacedUsedInContext.getDescription().equals(replaceUsedInContext.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: usedInContext replace description not as expected");
        }
        if (replacedUsedInContext.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: usedInContext replace source not as expected");
        }
        if (replacedUsedInContext.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: usedInContext replace expression not as expected");
        }
        if (replacedUsedInContext.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: usedInContext replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedUsedInContext, (Relationship)createdUsedInContext, "UsedInContext", "replace");
        System.out.println("Replaced UsedInContext " + createdUsedInContext);
        this.subjectAreaRelationship.usedInContext().delete(this.userId, guid);
        System.out.println("Deleted UsedInContext with userId=" + guid);
        gotUsedInContext = (UsedInContext)this.subjectAreaRelationship.usedInContext().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotUsedInContext);
        System.out.println("Restored UsedInContext with userId=" + guid);
        this.subjectAreaRelationship.usedInContext().delete(this.userId, guid);
        System.out.println("Deleted UsedInContext with userId=" + guid);
    }

    private UsedInContext createUsedInContext(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        UsedInContext usedInContext = new UsedInContext();
        usedInContext.setDescription("ddd");
        usedInContext.setExpression("Ex");
        usedInContext.setSource("source");
        usedInContext.setSteward("Stew");
        usedInContext.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        usedInContext.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        UsedInContext createdUsedInContext = (UsedInContext)this.subjectAreaRelationship.usedInContext().create(this.userId, (Object)usedInContext);
        FVTUtils.validateRelationship((Relationship)createdUsedInContext);
        FVTUtils.checkEnds((Relationship)usedInContext, (Relationship)createdUsedInContext, "UsedInContext", "create");
        return createdUsedInContext;
    }

    private void translationFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        Translation createdTranslation = this.createTranslation(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdTranslation);
        System.out.println("Created Translation " + createdTranslation);
        String guid = createdTranslation.getGuid();
        Translation gotTranslation = (Translation)this.subjectAreaRelationship.translation().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotTranslation);
        System.out.println("Got Translation " + createdTranslation);
        Translation updateTranslation = new Translation();
        updateTranslation.setDescription("ddd2");
        Translation updatedTranslation = (Translation)this.subjectAreaRelationship.translation().update(this.userId, guid, (Object)updateTranslation);
        FVTUtils.validateRelationship((Relationship)updatedTranslation);
        if (!updatedTranslation.getDescription().equals(updateTranslation.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: translation update description not as expected");
        }
        if (!updatedTranslation.getSource().equals(createdTranslation.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: translation update source not as expected");
        }
        if (!updatedTranslation.getExpression().equals(createdTranslation.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: translation update expression not as expected");
        }
        if (!updatedTranslation.getSteward().equals(createdTranslation.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: translation update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedTranslation, (Relationship)createdTranslation, "translation", "update");
        System.out.println("Updated Translation " + createdTranslation);
        Translation replaceTranslation = new Translation();
        replaceTranslation.setDescription("ddd3");
        Translation replacedTranslation = (Translation)this.subjectAreaRelationship.translation().replace(this.userId, guid, (Object)replaceTranslation);
        FVTUtils.validateRelationship((Relationship)replacedTranslation);
        if (!replacedTranslation.getDescription().equals(replaceTranslation.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: translation replace description not as expected");
        }
        if (replacedTranslation.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: translation replace source not as expected");
        }
        if (replacedTranslation.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: translation replace expression not as expected");
        }
        if (replacedTranslation.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: translation replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedTranslation, (Relationship)updatedTranslation, "translation", "replace");
        System.out.println("Replaced Translation " + createdTranslation);
        this.subjectAreaRelationship.translation().delete(this.userId, guid);
        System.out.println("Deleted Translation with userId=" + guid);
        gotTranslation = (Translation)this.subjectAreaRelationship.translation().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotTranslation);
        System.out.println("Restored Translation with userId=" + guid);
        this.subjectAreaRelationship.translation().delete(this.userId, guid);
        System.out.println("Deleted Translation with userId=" + guid);
    }

    private Translation createTranslation(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Translation translation = new Translation();
        translation.setDescription("ddd");
        translation.setExpression("Ex");
        translation.setSource("source");
        translation.setSteward("Stew");
        translation.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        translation.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        Translation createdTranslation = (Translation)this.subjectAreaRelationship.translation().create(this.userId, (Object)translation);
        FVTUtils.validateRelationship((Relationship)createdTranslation);
        FVTUtils.checkEnds((Relationship)translation, (Relationship)createdTranslation, "translations", "create");
        return createdTranslation;
    }

    private void hasaFVT(Term term1, Term term3) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        HasA createdHasA = this.createHasA(term1, term3);
        FVTUtils.validateRelationship((Relationship)createdHasA);
        System.out.println("Created Hasa " + createdHasA);
        String guid = createdHasA.getGuid();
        HasA gotHasATerm = (HasA)this.subjectAreaRelationship.hasA().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotHasATerm);
        System.out.println("Got Hasa " + createdHasA);
        HasA updateHasATerm = new HasA();
        updateHasATerm.setDescription("ddd2");
        HasA updatedHasATerm = (HasA)this.subjectAreaRelationship.hasA().update(this.userId, guid, (Object)updateHasATerm);
        FVTUtils.validateRelationship((Relationship)updatedHasATerm);
        if (!updatedHasATerm.getDescription().equals(updateHasATerm.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: HASARelationship update description not as expected");
        }
        if (!updatedHasATerm.getSource().equals(createdHasA.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: HASARelationship update source not as expected");
        }
        if (!updatedHasATerm.getSteward().equals(createdHasA.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: HASARelationship update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedHasATerm, (Relationship)createdHasA, "has-a", "update");
        System.out.println("Updated HASARelationship " + createdHasA);
        HasA replaceHasA = new HasA();
        replaceHasA.setDescription("ddd3");
        HasA replacedHasA = (HasA)this.subjectAreaRelationship.hasA().replace(this.userId, guid, (Object)replaceHasA);
        FVTUtils.validateRelationship((Relationship)replacedHasA);
        if (!replacedHasA.getDescription().equals(replaceHasA.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: HASARelationship replace description not as expected");
        }
        if (replacedHasA.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: HASARelationship replace source not as expected");
        }
        if (replacedHasA.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: HASARelationship replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedHasATerm, (Relationship)replacedHasA, "has-a", "replace");
        System.out.println("Replaced HASARelationship " + createdHasA);
        Term term1PostCreate = this.termFVT.getTermByGUID(term1.getSystemAttributes().getGUID());
        if (!term1PostCreate.isSpineObject()) {
            throw new SubjectAreaFVTCheckedException("ERROR: expect term 1 to be a Spine Object");
        }
        Term term3PostCreate = this.termFVT.getTermByGUID(term3.getSystemAttributes().getGUID());
        if (!term3PostCreate.isSpineAttribute()) {
            throw new SubjectAreaFVTCheckedException("ERROR: expect term 3 to be a Spine Attribute");
        }
        this.subjectAreaRelationship.hasA().delete(this.userId, guid);
        System.out.println("Deleted Hasa with userId=" + guid);
        gotHasATerm = (HasA)this.subjectAreaRelationship.hasA().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotHasATerm);
        System.out.println("Restored Hasa with userId=" + guid);
        this.subjectAreaRelationship.hasA().delete(this.userId, guid);
        System.out.println("Deleted Hasa with userId=" + guid);
    }

    private HasA createHasA(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        HasA hasA = new HasA();
        hasA.setDescription("ddd");
        hasA.setSource("source");
        hasA.setSteward("Stew");
        hasA.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        hasA.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        HasA createdTermHasARelationship = (HasA)this.subjectAreaRelationship.hasA().create(this.userId, (Object)hasA);
        FVTUtils.validateRelationship((Relationship)createdTermHasARelationship);
        FVTUtils.checkEnds((Relationship)hasA, (Relationship)createdTermHasARelationship, "Has-a", "create");
        return createdTermHasARelationship;
    }

    private void relatedtermFVT(Term term1, Term term3) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        RelatedTerm createdRelatedTerm = this.createRelatedTerm(term1, term3);
        FVTUtils.validateRelationship((Relationship)createdRelatedTerm);
        System.out.println("Created RelatedTerm " + createdRelatedTerm);
        String guid = createdRelatedTerm.getGuid();
        RelatedTerm gotRelatedTerm = (RelatedTerm)this.subjectAreaRelationship.relatedTerm().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotRelatedTerm);
        System.out.println("Got RelatedTerm " + createdRelatedTerm);
        RelatedTerm updateRelatedTerm = new RelatedTerm();
        updateRelatedTerm.setDescription("ddd2");
        updateRelatedTerm.setGuid(createdRelatedTerm.getGuid());
        RelatedTerm updatedRelatedTerm = (RelatedTerm)this.subjectAreaRelationship.relatedTerm().update(this.userId, guid, (Object)updateRelatedTerm);
        FVTUtils.validateRelationship((Relationship)updatedRelatedTerm);
        if (!updatedRelatedTerm.getDescription().equals(updateRelatedTerm.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: RelatedTerm update description not as expected");
        }
        if (!updatedRelatedTerm.getSource().equals(createdRelatedTerm.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: RelatedTerm update source not as expected");
        }
        if (!updatedRelatedTerm.getExpression().equals(createdRelatedTerm.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: RelatedTerm update expression not as expected");
        }
        if (!updatedRelatedTerm.getSteward().equals(createdRelatedTerm.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: RelatedTerm update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedRelatedTerm, (Relationship)createdRelatedTerm, "RelatedTerm", "update");
        System.out.println("Updated RelatedTerm " + createdRelatedTerm);
        RelatedTerm replaceRelatedTerm = new RelatedTerm();
        replaceRelatedTerm.setDescription("ddd3");
        replaceRelatedTerm.setGuid(createdRelatedTerm.getGuid());
        RelatedTerm replacedRelatedTerm = (RelatedTerm)this.subjectAreaRelationship.relatedTerm().replace(this.userId, guid, (Object)replaceRelatedTerm);
        FVTUtils.validateRelationship((Relationship)replacedRelatedTerm);
        if (!replacedRelatedTerm.getDescription().equals(replaceRelatedTerm.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: RelatedTerm replace description not as expected");
        }
        if (replacedRelatedTerm.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: RelatedTerm replace source not as expected");
        }
        if (replacedRelatedTerm.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: RelatedTerm replace expression not as expected");
        }
        if (replacedRelatedTerm.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: RelatedTerm replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedRelatedTerm, (Relationship)createdRelatedTerm, "RelatedTerm", "replace");
        System.out.println("Replaced RelatedTerm " + createdRelatedTerm);
        this.subjectAreaRelationship.relatedTerm().delete(this.userId, guid);
        System.out.println("Deleted RelatedTerm with userId=" + guid);
        gotRelatedTerm = (RelatedTerm)this.subjectAreaRelationship.relatedTerm().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotRelatedTerm);
        System.out.println("Restored RelatedTerm with userId=" + guid);
        this.subjectAreaRelationship.relatedTerm().delete(this.userId, guid);
        System.out.println("Deleted RelatedTerm with userId=" + guid);
    }

    private RelatedTerm createRelatedTerm(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedTerm relatedterm = new RelatedTerm();
        relatedterm.setDescription("ddd");
        relatedterm.setExpression("Ex");
        relatedterm.setSource("source");
        relatedterm.setSteward("Stew");
        relatedterm.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        relatedterm.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        RelatedTerm createdRelatedTerm = (RelatedTerm)this.subjectAreaRelationship.relatedTerm().create(this.userId, (Object)relatedterm);
        FVTUtils.validateRelationship((Relationship)createdRelatedTerm);
        FVTUtils.checkEnds((Relationship)relatedterm, (Relationship)createdRelatedTerm, "RelatedTerm", "create");
        return createdRelatedTerm;
    }

    private void antonymFVT(Term term1, Term term3) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        Antonym createdAntonym = this.createAntonym(term1, term3);
        FVTUtils.validateRelationship((Relationship)createdAntonym);
        System.out.println("Created Antonym " + createdAntonym);
        String guid = createdAntonym.getGuid();
        Antonym gotAntonym = (Antonym)this.subjectAreaRelationship.antonym().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotAntonym);
        System.out.println("Got Antonym " + createdAntonym);
        Antonym updateAntonym = new Antonym();
        updateAntonym.setDescription("ddd2");
        Antonym updatedAntonym = (Antonym)this.subjectAreaRelationship.antonym().update(this.userId, guid, (Object)updateAntonym);
        FVTUtils.validateRelationship((Relationship)updatedAntonym);
        if (!updatedAntonym.getDescription().equals(updateAntonym.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Antonym update description not as expected");
        }
        if (!updatedAntonym.getSource().equals(createdAntonym.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Antonym update source not as expected");
        }
        if (!updatedAntonym.getExpression().equals(createdAntonym.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Antonym update expression not as expected");
        }
        if (!updatedAntonym.getSteward().equals(createdAntonym.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Antonym update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedAntonym, (Relationship)createdAntonym, "Antonym", "update");
        System.out.println("Updated Antonym " + createdAntonym);
        Antonym replaceAntonym = new Antonym();
        replaceAntonym.setDescription("ddd3");
        replaceAntonym.setGuid(createdAntonym.getGuid());
        Antonym replacedAntonym = (Antonym)this.subjectAreaRelationship.antonym().replace(this.userId, guid, (Object)replaceAntonym);
        FVTUtils.validateRelationship((Relationship)replacedAntonym);
        if (!replacedAntonym.getDescription().equals(replaceAntonym.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Antonym replace description not as expected");
        }
        if (replacedAntonym.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Antonym replace source not as expected");
        }
        if (replacedAntonym.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Antonym replace expression not as expected");
        }
        if (replacedAntonym.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Antonym replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedAntonym, (Relationship)createdAntonym, "Antonym", "replace");
        System.out.println("Replaced Antonym " + createdAntonym);
        this.subjectAreaRelationship.antonym().delete(this.userId, guid);
        System.out.println("Deleted Antonym with userId=" + guid);
        gotAntonym = (Antonym)this.subjectAreaRelationship.antonym().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotAntonym);
        System.out.println("Restored Antonym with userId=" + guid);
        this.subjectAreaRelationship.antonym().delete(this.userId, guid);
        System.out.println("Deleted Antonym with userId=" + guid);
    }

    private Antonym createAntonym(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Antonym antonym = new Antonym();
        antonym.setDescription("ddd");
        antonym.setExpression("Ex");
        antonym.setSource("source");
        antonym.setSteward("Stew");
        antonym.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        antonym.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        Antonym createdAntonym = (Antonym)this.subjectAreaRelationship.antonym().create(this.userId, (Object)antonym);
        FVTUtils.validateRelationship((Relationship)createdAntonym);
        FVTUtils.checkEnds((Relationship)antonym, (Relationship)createdAntonym, "Antonym", "create");
        return createdAntonym;
    }

    private void synonymFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, SubjectAreaFVTCheckedException, UserNotAuthorizedException {
        Synonym createdSynonym = this.createSynonym(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdSynonym);
        System.out.println("Created Synonym " + createdSynonym);
        String guid = createdSynonym.getGuid();
        Synonym gotSynonym = (Synonym)this.subjectAreaRelationship.synonym().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotSynonym);
        System.out.println("Got Synonym " + createdSynonym);
        Synonym updateSynonym = new Synonym();
        updateSynonym.setDescription("ddd2");
        Synonym updatedSynonym = (Synonym)this.subjectAreaRelationship.synonym().update(this.userId, guid, (Object)updateSynonym);
        FVTUtils.validateRelationship((Relationship)updatedSynonym);
        if (!updatedSynonym.getDescription().equals(updateSynonym.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: synonym update description not as expected");
        }
        if (!updatedSynonym.getSource().equals(createdSynonym.getSource())) {
            throw new SubjectAreaFVTCheckedException("ERROR: synonym update source not as expected");
        }
        if (!updatedSynonym.getExpression().equals(createdSynonym.getExpression())) {
            throw new SubjectAreaFVTCheckedException("ERROR: synonym update expression not as expected");
        }
        if (!updatedSynonym.getSteward().equals(createdSynonym.getSteward())) {
            throw new SubjectAreaFVTCheckedException("ERROR: synonym update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedSynonym, (Relationship)createdSynonym, "synonym", "update");
        System.out.println("Updated Synonym " + createdSynonym);
        Synonym replaceSynonym = new Synonym();
        replaceSynonym.setDescription("ddd3");
        Synonym replacedSynonym = (Synonym)this.subjectAreaRelationship.synonym().replace(this.userId, guid, (Object)replaceSynonym);
        FVTUtils.validateRelationship((Relationship)replacedSynonym);
        if (!replacedSynonym.getDescription().equals(replaceSynonym.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: synonym replace description not as expected");
        }
        if (replacedSynonym.getSource() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: synonym replace source not as expected");
        }
        if (replacedSynonym.getExpression() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: synonym replace expression not as expected");
        }
        if (replacedSynonym.getSteward() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: synonym replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedSynonym, (Relationship)replacedSynonym, "synonym", "replace");
        System.out.println("Replaced Synonym " + createdSynonym);
        this.subjectAreaRelationship.synonym().delete(this.userId, guid);
        System.out.println("Deleted Synonym with userId=" + guid);
        gotSynonym = (Synonym)this.subjectAreaRelationship.synonym().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotSynonym);
        System.out.println("Restored Synonym with userId=" + guid);
        this.subjectAreaRelationship.synonym().delete(this.userId, guid);
        System.out.println("Hard deleted Synonym with userId=" + guid);
    }

    public Synonym createSynonym(Term term1, Term term2) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Synonym synonym = new Synonym();
        synonym.setDescription("ddd");
        synonym.setExpression("Ex");
        synonym.setSource("source");
        synonym.setSteward("Stew");
        synonym.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        synonym.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        Synonym createdSynonym = (Synonym)this.subjectAreaRelationship.synonym().create(this.userId, (Object)synonym);
        FVTUtils.validateRelationship((Relationship)createdSynonym);
        FVTUtils.checkEnds((Relationship)synonym, (Relationship)createdSynonym, "synonym", "create");
        return createdSynonym;
    }

    public IsATypeOfDeprecated createIsATypeOfDeprecated(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        IsATypeOfDeprecated isATypeOfDeprecated = new IsATypeOfDeprecated();
        isATypeOfDeprecated.setDescription("ddd");
        isATypeOfDeprecated.setSource("source");
        isATypeOfDeprecated.setSteward("Stew");
        isATypeOfDeprecated.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        isATypeOfDeprecated.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        IsATypeOfDeprecated createdisATypeOfDeprecated = (IsATypeOfDeprecated)this.subjectAreaRelationship.isaTypeOfDeprecated().create(this.userId, (Object)isATypeOfDeprecated);
        FVTUtils.validateRelationship((Relationship)createdisATypeOfDeprecated);
        FVTUtils.checkEnds((Relationship)isATypeOfDeprecated, (Relationship)createdisATypeOfDeprecated, "IsaTypeOfDeprecated", "create");
        System.out.println("Created isATypeOfDeprecated " + createdisATypeOfDeprecated);
        return createdisATypeOfDeprecated;
    }

    public IsATypeOf createIsATypeOf(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        IsATypeOf isATypeOf = new IsATypeOf();
        isATypeOf.setDescription("ddd");
        isATypeOf.setSource("source");
        isATypeOf.setSteward("Stew");
        isATypeOf.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        isATypeOf.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        IsATypeOf createdisATypeOf = (IsATypeOf)this.subjectAreaRelationship.isATypeOf().create(this.userId, (Object)isATypeOf);
        FVTUtils.validateRelationship((Relationship)createdisATypeOf);
        FVTUtils.checkEnds((Relationship)isATypeOf, (Relationship)createdisATypeOf, "isATypeOf", "create");
        System.out.println("Created isATypeOf Relationship " + createdisATypeOf);
        return createdisATypeOf;
    }

    private void termCategorizationFVT(Term term, Category category) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        Categorization createdTermCategorizationRelationship = this.createTermCategorization(term, category);
        FVTUtils.validateRelationship((Relationship)createdTermCategorizationRelationship);
        System.out.println("Created TermCategorizationRelationship " + createdTermCategorizationRelationship);
        String guid = createdTermCategorizationRelationship.getGuid();
        Categorization gotTermCategorizationRelationship = (Categorization)this.subjectAreaRelationship.termCategorization().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotTermCategorizationRelationship);
        System.out.println("Got TermCategorizationRelationship " + createdTermCategorizationRelationship);
        Categorization updateTermCategorizationRelationship = new Categorization();
        updateTermCategorizationRelationship.setDescription("ddd2");
        Categorization updatedTermCategorizationRelationship = (Categorization)this.subjectAreaRelationship.termCategorization().update(this.userId, guid, (Object)updateTermCategorizationRelationship);
        FVTUtils.validateRelationship((Relationship)updatedTermCategorizationRelationship);
        FVTUtils.checkEnds((Relationship)updatedTermCategorizationRelationship, (Relationship)createdTermCategorizationRelationship, "TermCategorization", "update");
        if (!updatedTermCategorizationRelationship.getDescription().equals(updateTermCategorizationRelationship.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: TermCategorization update description not as expected");
        }
        if (updatedTermCategorizationRelationship.getStatus() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: TermCategorization update status not as expected");
        }
        System.out.println("Updated TermCategorizationRelationship " + createdTermCategorizationRelationship);
        Categorization replaceTermCategorizationRelationship = new Categorization();
        replaceTermCategorizationRelationship.setDescription("ddd3");
        Categorization replacedTermCategorizationRelationship = (Categorization)this.subjectAreaRelationship.termCategorization().replace(this.userId, guid, (Object)replaceTermCategorizationRelationship);
        FVTUtils.validateRelationship((Relationship)replacedTermCategorizationRelationship);
        if (!replacedTermCategorizationRelationship.getDescription().equals(replaceTermCategorizationRelationship.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: TermCategorization replace description not as expected");
        }
        if (replacedTermCategorizationRelationship.getStatus() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: TermCategorization replace source not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedTermCategorizationRelationship, (Relationship)createdTermCategorizationRelationship, "TermCategorization", "replace");
        System.out.println("Replaced TermCategorizationRelationship " + createdTermCategorizationRelationship);
        this.subjectAreaRelationship.termCategorization().delete(this.userId, guid);
        System.out.println("Deleted TermCategorizationRelationship with userId=" + guid);
        gotTermCategorizationRelationship = (Categorization)this.subjectAreaRelationship.termCategorization().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotTermCategorizationRelationship);
        System.out.println("Restored TermCategorizationRelationship with userId=" + guid);
        this.subjectAreaRelationship.termCategorization().delete(this.userId, guid);
        System.out.println("Deleted TermCategorization with userId=" + guid);
    }

    public Categorization createTermCategorization(Term term, Category category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Categorization termCategorization = new Categorization();
        termCategorization.getEnd1().setNodeGuid(category.getSystemAttributes().getGUID());
        termCategorization.getEnd2().setNodeGuid(term.getSystemAttributes().getGUID());
        Categorization createdTermCategorization = (Categorization)this.subjectAreaRelationship.termCategorization().create(this.userId, (Object)termCategorization);
        FVTUtils.validateRelationship((Relationship)createdTermCategorization);
        FVTUtils.checkEnds((Relationship)termCategorization, (Relationship)createdTermCategorization, "TermCategorizationRelationship", "create");
        System.out.println("Created TermCategorizationRelationship " + createdTermCategorization);
        return createdTermCategorization;
    }

    private void projectScopeFVT(Project project, Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        ProjectScope createdProjectScope = this.createProjectScope(project, term);
        FVTUtils.validateRelationship((Relationship)createdProjectScope);
        System.out.println("Created ProjectScopeRelationship " + createdProjectScope);
        String guid = createdProjectScope.getGuid();
        ProjectScope gotProjectScopeRelationship = (ProjectScope)this.subjectAreaRelationship.projectScope().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotProjectScopeRelationship);
        System.out.println("Got ProjectScopeRelationship " + gotProjectScopeRelationship);
        ProjectScope updateProjectScope = new ProjectScope();
        updateProjectScope.setDescription("ddd2");
        updateProjectScope.setGuid(createdProjectScope.getGuid());
        ProjectScope updatedProjectScope = (ProjectScope)this.subjectAreaRelationship.projectScope().update(this.userId, guid, (Object)updateProjectScope);
        FVTUtils.validateRelationship((Relationship)updatedProjectScope);
        if (!updatedProjectScope.getDescription().equals(updateProjectScope.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Project scope  update scopeDescription not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedProjectScope, (Relationship)createdProjectScope, "ProjectScope", "update");
        System.out.println("Updated ProjectScopeRelationship " + createdProjectScope);
        ProjectScope replaceProjectScope = new ProjectScope();
        replaceProjectScope.setDescription("ddd3");
        ProjectScope replacedProjectScope = (ProjectScope)this.subjectAreaRelationship.projectScope().replace(this.userId, guid, (Object)replaceProjectScope);
        FVTUtils.validateRelationship((Relationship)replacedProjectScope);
        if (!replacedProjectScope.getDescription().equals(replaceProjectScope.getDescription())) {
            throw new SubjectAreaFVTCheckedException("ERROR: project scope replace scope description not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedProjectScope, (Relationship)createdProjectScope, "ProjectScope", "replace");
        System.out.println("Replaced ProjectScopeRelationship " + createdProjectScope);
        this.subjectAreaRelationship.projectScope().delete(this.userId, guid);
        System.out.println("Deleted ProjectScopeRelationship with userId=" + guid);
        gotProjectScopeRelationship = (ProjectScope)this.subjectAreaRelationship.projectScope().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotProjectScopeRelationship);
        System.out.println("Restored ProjectScopeRelationship with userId=" + guid);
        this.subjectAreaRelationship.projectScope().delete(this.userId, guid);
        System.out.println("Hard deleted ProjectScopeRelationship with userId=" + guid);
    }

    protected ProjectScope createProjectScope(Project project, Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        ProjectScope projectScope = new ProjectScope();
        projectScope.getEnd1().setNodeGuid(project.getSystemAttributes().getGUID());
        projectScope.getEnd2().setNodeGuid(term.getSystemAttributes().getGUID());
        ProjectScope createdProjectScope = (ProjectScope)this.subjectAreaRelationship.projectScope().create(this.userId, (Object)projectScope);
        FVTUtils.validateRelationship((Relationship)createdProjectScope);
        System.out.println("CreatedProjectScopeRelationship " + createdProjectScope);
        return createdProjectScope;
    }

    private void categoryHierarchyLinkFVT(Category parent, Category child) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        CategoryHierarchyLink categoryHierarchyLink = this.createCategoryHierarchyLink(parent, child);
        String guid = categoryHierarchyLink.getGuid();
        CategoryHierarchyLink gotCategoryHierarchyLink = (CategoryHierarchyLink)this.subjectAreaRelationship.categoryHierarchyLink().getByGUID(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotCategoryHierarchyLink);
        System.out.println("Got CategoryHierarchyLink " + categoryHierarchyLink);
        Category gotChild = (Category)this.subjectAreaCategory.getByGUID(this.userId, child.getSystemAttributes().getGUID());
        this.checkParent(parent, gotChild);
        this.subjectAreaRelationship.categoryHierarchyLink().delete(this.userId, guid);
        System.out.println("Deleted CategoryHierarchyLink with userId=" + guid);
        gotCategoryHierarchyLink = (CategoryHierarchyLink)this.subjectAreaRelationship.categoryHierarchyLink().restore(this.userId, guid);
        FVTUtils.validateRelationship((Relationship)gotCategoryHierarchyLink);
        System.out.println("Restored CategoryHierarchyLink with userId=" + guid);
        this.subjectAreaRelationship.categoryHierarchyLink().delete(this.userId, guid);
        System.out.println("Deleted CategoryHierarchyLink with userId=" + guid);
    }

    public CategoryHierarchyLink createCategoryHierarchyLink(Category parent, Category child) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        CategoryHierarchyLink categoryHierarchyLink = new CategoryHierarchyLink();
        categoryHierarchyLink.getEnd1().setNodeGuid(parent.getSystemAttributes().getGUID());
        categoryHierarchyLink.getEnd2().setNodeGuid(child.getSystemAttributes().getGUID());
        CategoryHierarchyLink createdCategoryHierarchyLink = (CategoryHierarchyLink)this.subjectAreaRelationship.categoryHierarchyLink().create(this.userId, (Object)categoryHierarchyLink);
        FVTUtils.validateRelationship((Relationship)createdCategoryHierarchyLink);
        FVTUtils.checkEnds((Relationship)categoryHierarchyLink, (Relationship)createdCategoryHierarchyLink, "CategoryHierarchyLink", "create");
        System.out.println("Created CategoryHierarchyLink " + createdCategoryHierarchyLink);
        return createdCategoryHierarchyLink;
    }

    public void checkParent(Category parent, Category gotChildCategory) throws SubjectAreaFVTCheckedException {
        if (gotChildCategory.getParentCategory() != null) {
            String parentGuidFromChild;
            CategorySummary categorySummary = gotChildCategory.getParentCategory();
            String parentGuid = parent.getSystemAttributes().getGUID();
            if (!parentGuid.equals(parentGuidFromChild = categorySummary.getGuid())) {
                throw new SubjectAreaFVTCheckedException("ERROR parent category guid - " + parentGuid + " no equal parent guid " + parentGuidFromChild + " from child.");
            }
        } else {
            throw new SubjectAreaFVTCheckedException("ERROR parent category is null");
        }
    }
}

