/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.terms.SubjectAreaTermClient;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.CategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.FVTUtils;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaDefinitionCategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.ConfidenceLevel;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.CriticalityLevel;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.RetentionBasis;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceClassifications;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;

public class TermFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for term FVT";
    private static final String DEFAULT_TEST_TERM_NAME = "Test term A";
    private static final String DEFAULT_TEST_TERM_NAME_UPDATED = "Test term A updated";
    private SubjectAreaNodeClient<Term> subjectAreaTerm = null;
    private SubjectAreaTermClient subjectAreaTermClient = null;
    private GlossaryFVT glossaryFVT = null;
    private CategoryFVT categoryFVT = null;
    private SubjectAreaDefinitionCategoryFVT subjectAreaFVT = null;
    private String userId = null;
    private int existingTermCount = 0;
    private Set<String> createdTermsSet = new HashSet<String>();

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            TermFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public TermFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaRestClient client = new SubjectAreaRestClient(serverName, url);
        this.subjectAreaTerm = new SubjectAreaTermClient(client);
        this.subjectAreaTermClient = (SubjectAreaTermClient)this.subjectAreaTerm;
        System.out.println("Create a glossary");
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.categoryFVT = new CategoryFVT(url, serverName, userId);
        this.subjectAreaFVT = new SubjectAreaDefinitionCategoryFVT(url, serverName, userId);
        this.userId = userId;
        this.existingTermCount = this.findTerms("").size();
        System.out.println("existingTermCount " + this.existingTermCount);
    }

    public static void runWith2Servers(String url) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        TermFVT.runIt(url, "cocoMDS4", "erinoverview");
        TermFVT.runIt(url, "cocoMDS1", "erinoverview");
    }

    public static void runIt(String url, String serverName, String userId) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("TermFVT runIt started");
        TermFVT fvt = new TermFVT(url, serverName, userId);
        fvt.run();
        fvt.deleteRemaining();
        System.out.println("TermFVT runIt stopped");
    }

    public static int getTermCount(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, SubjectAreaFVTCheckedException {
        TermFVT fvt = new TermFVT(url, serverName, userId);
        return fvt.findTerms("").size();
    }

    public void run() throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        System.out.println("Create a term1");
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        Term term1 = this.createTerm(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        FVTUtils.validateNode((Node)term1);
        System.out.println("Create a term1 using glossary userId");
        Term term2 = this.createTerm(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        FVTUtils.validateNode((Node)term2);
        System.out.println("Create a term2 using glossary userId");
        FindRequest findRequest = new FindRequest();
        List<Term> results = this.glossaryFVT.getTerms(glossaryGuid, findRequest);
        if (results.size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 back on getGlossaryTerms " + results.size());
        }
        findRequest.setPageSize(Integer.valueOf(1));
        results = this.glossaryFVT.getTerms(glossaryGuid, findRequest);
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 back on getGlossaryTerms with page size 1, got " + results.size());
        }
        Term termForUpdate = new Term();
        termForUpdate.setName(DEFAULT_TEST_TERM_NAME_UPDATED);
        System.out.println("Get term1");
        String guid = term1.getSystemAttributes().getGUID();
        Term gotTerm = this.getTermByGUID(guid);
        FVTUtils.validateNode((Node)gotTerm);
        System.out.println("Update term1");
        Term updatedTerm = this.updateTerm(guid, termForUpdate);
        FVTUtils.validateNode((Node)updatedTerm);
        System.out.println("Get term1 again");
        gotTerm = this.getTermByGUID(guid);
        FVTUtils.validateNode((Node)gotTerm);
        System.out.println("Delete term1");
        this.deleteTerm(guid);
        System.out.println("Restore term1");
        gotTerm = this.restoreTerm(guid);
        FVTUtils.validateNode((Node)gotTerm);
        System.out.println("Delete term1 again");
        this.deleteTerm(guid);
        System.out.println("Create term3 with governance actions");
        GovernanceClassifications governanceClassifications = this.createGovernanceClassifications();
        Term term3 = this.createTermWithGovernanceClassifications(DEFAULT_TEST_TERM_NAME, glossaryGuid, governanceClassifications);
        FVTUtils.validateNode((Node)term3);
        if (!governanceClassifications.getConfidence().getLevel().equals((Object)term3.getGovernanceClassifications().getConfidence().getLevel())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Governance actions confidence not returned as expected");
        }
        if (!governanceClassifications.getConfidentiality().getLevel().equals(term3.getGovernanceClassifications().getConfidentiality().getLevel())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Governance actions confidentiality not returned as expected");
        }
        if (!governanceClassifications.getRetention().getBasis().equals((Object)term3.getGovernanceClassifications().getRetention().getBasis())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Governance actions retention not returned as expected");
        }
        if (!governanceClassifications.getCriticality().getLevel().equals((Object)term3.getGovernanceClassifications().getCriticality().getLevel())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Governance actions criticality not returned  as expected. ");
        }
        GovernanceClassifications governanceClassifications2 = this.create2ndGovernanceClassifications();
        System.out.println("Update term3 with and change governance actions");
        Term term3ForUpdate = new Term();
        term3ForUpdate.setName(DEFAULT_TEST_TERM_NAME_UPDATED);
        term3ForUpdate.setGovernanceClassifications(governanceClassifications2);
        Term updatedTerm3 = this.updateTerm(term3.getSystemAttributes().getGUID(), term3ForUpdate);
        FVTUtils.validateNode((Node)updatedTerm3);
        if (!governanceClassifications2.getConfidence().getLevel().equals((Object)updatedTerm3.getGovernanceClassifications().getConfidence().getLevel())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Governance actions confidence not returned  as expected");
        }
        if (!governanceClassifications2.getConfidentiality().getLevel().equals(updatedTerm3.getGovernanceClassifications().getConfidentiality().getLevel())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Governance actions confidentiality not returned  as expected");
        }
        if (updatedTerm3.getGovernanceClassifications().getRetention() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Governance actions retention not null as expected");
        }
        String spacedTermName = "This is a Term with spaces in name";
        int allcount = this.subjectAreaTerm.findAll(this.userId).size();
        int yyycount = this.findTerms("yyy").size();
        int zzzcount = this.findTerms("zzz").size();
        int spacedTermcount = this.findTerms(spacedTermName).size();
        System.out.println("create terms to find");
        Term termForFind1 = this.getTermForInput("abc", glossaryGuid);
        termForFind1.setDescription("yyy");
        termForFind1 = this.issueCreateTerm(termForFind1);
        FVTUtils.validateNode((Node)termForFind1);
        Term termForFind2 = this.createTerm("yyy", glossaryGuid);
        FVTUtils.validateNode((Node)termForFind2);
        Term termForFind3 = this.createTerm("zzz", glossaryGuid);
        FVTUtils.validateNode((Node)termForFind3);
        Term termForFind4 = this.createTerm("This is a Term with spaces in name", glossaryGuid);
        FVTUtils.validateNode((Node)termForFind4);
        results = this.findTerms("zzz");
        if (results.size() != zzzcount + 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: zzz Expected " + zzzcount + "1 back on the find got " + results.size());
        }
        results = this.findTerms("yyy");
        if (results.size() != yyycount + 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: yyy Expected " + yyycount + "1 back on the find got " + results.size());
        }
        results = this.findTerms(null);
        if (results.size() != allcount + 4) {
            throw new SubjectAreaFVTCheckedException("ERROR: allcount Expected " + allcount + "4 back on the find got " + results.size());
        }
        results = this.subjectAreaTerm.findAll(this.userId);
        if (results.size() != allcount + 4) {
            throw new SubjectAreaFVTCheckedException("ERROR: allcount2 Expected " + allcount + "4 back on the find got " + results.size());
        }
        this.deleteTerm(termForFind2.getSystemAttributes().getGUID());
        results = this.findTerms("yyy");
        if (results.size() != yyycount + 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: yyy2 Expected " + yyycount + "1 back on the find got " + results.size());
        }
        results = this.findTerms(spacedTermName);
        if (results.size() != spacedTermcount + 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected spaced " + spacedTermcount + "1 back on the find got " + results.size());
        }
        Term term = termForFind4;
        long now = new Date().getTime();
        Long fromTermTime = new Date(now + 518400000L).getTime();
        Long toTermTime = new Date(now + 604800000L).getTime();
        term.setEffectiveFromTime(fromTermTime);
        term.setEffectiveToTime(toTermTime);
        Term updatedFutureTerm = this.updateTerm(term.getSystemAttributes().getGUID(), term);
        if (updatedFutureTerm.getEffectiveFromTime().longValue() != fromTermTime.longValue()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected term from time to update");
        }
        if (updatedFutureTerm.getEffectiveToTime().longValue() != toTermTime.longValue()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected term to time to update");
        }
        Long fromGlossaryTime = new Date(now + 691200000L).getTime();
        Long toGlossaryTime = new Date(now + 777600000L).getTime();
        glossary.setEffectiveFromTime(fromGlossaryTime);
        glossary.setEffectiveToTime(toGlossaryTime);
        Glossary updatedFutureGlossary = this.glossaryFVT.updateGlossary(glossaryGuid, glossary);
        if (updatedFutureGlossary.getEffectiveFromTime().longValue() != fromGlossaryTime.longValue()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected glossary from time to update");
        }
        if (updatedFutureGlossary.getEffectiveToTime().longValue() != toGlossaryTime.longValue()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected glossary to time to update");
        }
        Term newTerm = this.getTermByGUID(term.getSystemAttributes().getGUID());
        GlossarySummary glossarySummary = newTerm.getGlossary();
        if (glossarySummary.getFromEffectivityTime().longValue() != fromGlossaryTime.longValue()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected from glossary summary time " + glossarySummary.getFromEffectivityTime() + " to equal " + fromGlossaryTime);
        }
        if (glossarySummary.getToEffectivityTime().longValue() != toGlossaryTime.longValue()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected to glossary summary time " + glossarySummary.getToEffectivityTime() + " to equal " + toGlossaryTime);
        }
        if (glossarySummary.getRelationshipguid() == null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected glossary summary non null relationship");
        }
        if (glossarySummary.getFromRelationshipEffectivityTime() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected glossary summary null relationship from time");
        }
        if (glossarySummary.getToRelationshipEffectivityTime() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected glossary summary null relationship to time");
        }
        Term term5 = new Term();
        term5.setSpineObject(true);
        term5.setName("Term5");
        glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        term5.setGlossary(glossarySummary);
        Term createdTerm5 = this.issueCreateTerm(term5);
        if (!createdTerm5.isSpineObject()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected isSpineObject to be true ");
        }
        Term term6 = new Term();
        term6.setSpineAttribute(true);
        term6.setName("Term6");
        glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        term6.setGlossary(glossarySummary);
        Term createdTerm6 = this.issueCreateTerm(term6);
        if (!createdTerm6.isSpineAttribute()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected isSpineAttribute to be true ");
        }
        Term term7 = new Term();
        term7.setObjectIdentifier(true);
        term7.setName("Term7");
        glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        term7.setGlossary(glossarySummary);
        Term createdTerm7 = this.issueCreateTerm(term7);
        if (!createdTerm7.isObjectIdentifier()) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected isObjectIdentifier to be true ");
        }
        this.createTerm(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        Term termForUniqueQFN2 = this.createTerm(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        if (termForUniqueQFN2 == null || termForUniqueQFN2.equals((Object)"")) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected qualified name to be set");
        }
        Category cat1 = this.categoryFVT.createCategoryWithGlossaryGuid("cat1", glossaryGuid);
        SubjectAreaDefinition cat2 = this.subjectAreaFVT.createSubjectAreaDefinitionWithGlossaryGuid("cat2", glossaryGuid);
        Category cat3 = this.categoryFVT.createCategoryWithGlossaryGuid("cat3", glossaryGuid);
        CategorySummary cat1Summary = new CategorySummary();
        cat1Summary.setGuid(cat1.getSystemAttributes().getGUID());
        CategorySummary cat2Summary = new CategorySummary();
        cat2Summary.setGuid(cat2.getSystemAttributes().getGUID());
        CategorySummary cat3Summary = new CategorySummary();
        cat3Summary.setGuid(cat3.getSystemAttributes().getGUID());
        ArrayList<CategorySummary> suppliedCategories = new ArrayList<CategorySummary>();
        suppliedCategories.add(cat1Summary);
        Term term4cats = this.getTermForInput(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        Term createdTerm4cats = this.issueCreateTerm(term4cats);
        if (createdTerm4cats.getCategories() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected null categories created when none were requested");
        }
        term4cats = this.getTermForInput(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        term4cats.setCategories(suppliedCategories);
        createdTerm4cats = this.issueCreateTerm(term4cats);
        if (createdTerm4cats.getCategories().size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 categories returned");
        }
        if (!((CategorySummary)createdTerm4cats.getCategories().get(0)).getGuid().equals(cat1Summary.getGuid())) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected response category guid to match the requested category guid.");
        }
        if (this.categoryFVT.getTerms(cat1.getSystemAttributes().getGUID()).size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected the category to have 1 term.");
        }
        suppliedCategories.add(cat2Summary);
        term4cats.setCategories(suppliedCategories);
        Term createdTerm4cats2 = this.issueCreateTerm(term4cats);
        if (createdTerm4cats2.getCategories().size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 categories returned");
        }
        List<Category> categories = this.getCategoriesAPI(createdTerm4cats2.getSystemAttributes().getGUID(), 0, 5);
        if (categories.size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 categories returned on get Categories API call");
        }
        createdTerm4cats2.setCategories(null);
        Term updatedTerm4cats2 = this.updateTerm(createdTerm4cats2.getSystemAttributes().getGUID(), createdTerm4cats2);
        if (updatedTerm4cats2.getCategories().size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 categories returned");
        }
        if (this.getCategoriesAPI(updatedTerm4cats2.getSystemAttributes().getGUID(), 0, 5).size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 categories returned on get Categories API call after update");
        }
        if (this.getCategoriesAPI(updatedTerm4cats2.getSystemAttributes().getGUID(), 1, 5).size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 categories returned on get Categories API call after update startingFrom 1");
        }
        if (this.getCategoriesAPI(updatedTerm4cats2.getSystemAttributes().getGUID(), 0, 1).size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 categories returned on get Categories API call after update pageSize 1");
        }
        createdTerm4cats.setCategories(null);
        Term replacedTerm4cats = this.replaceTerm(createdTerm4cats.getSystemAttributes().getGUID(), createdTerm4cats);
        if (replacedTerm4cats.getCategories() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected replace with null to get rid of the categorizations.");
        }
        List<Category> cats = this.getCategoriesAPI(replacedTerm4cats.getSystemAttributes().getGUID(), 0, 5);
        if (cats == null || cats.size() != 0) {
            throw new SubjectAreaFVTCheckedException("ERROR: Use API call to check replace with null to get rid of the categorizations.");
        }
        createdTerm4cats.setCategories(suppliedCategories);
        updatedTerm4cats2 = this.updateTerm(createdTerm4cats.getSystemAttributes().getGUID(), createdTerm4cats);
        if (updatedTerm4cats2.getCategories().size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected update to gain 2 categorizations.");
        }
        if (this.getCategoriesAPI(updatedTerm4cats2.getSystemAttributes().getGUID(), 0, 5).size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Use API call to check update to gain 2 categorizations");
        }
        this.testCategorizedTermsWithSearchCriteria();
        ArrayList<CategorySummary> supplied3Categories = new ArrayList<CategorySummary>();
        supplied3Categories.add(cat1Summary);
        supplied3Categories.add(cat2Summary);
        supplied3Categories.add(cat3Summary);
        updatedTerm4cats2.setCategories(supplied3Categories);
        updatedTerm4cats2 = this.updateTerm(createdTerm4cats.getSystemAttributes().getGUID(), updatedTerm4cats2);
        if (updatedTerm4cats2.getCategories().size() != 3) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected update to have 3 categorizations.");
        }
        this.categoryFVT.deleteCategory(cat1Summary.getGuid());
        this.categoryFVT.deleteCategory(cat2Summary.getGuid());
        this.categoryFVT.deleteCategory(cat3Summary.getGuid());
        this.deleteTerm(createdTerm4cats.getSystemAttributes().getGUID());
        this.deleteTerm(createdTerm4cats2.getSystemAttributes().getGUID());
    }

    public Term createTerm(String termName, String glossaryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Term term = this.getTermForInput(termName, glossaryGuid);
        return this.issueCreateTerm(term);
    }

    public Term issueCreateTerm(Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Term newTerm = (Term)this.subjectAreaTerm.create(this.userId, (Object)term);
        if (newTerm != null) {
            String guid = newTerm.getSystemAttributes().getGUID();
            System.out.println("Created Term " + newTerm.getName() + " with guid " + guid);
            this.createdTermsSet.add(guid);
        }
        return newTerm;
    }

    public Term getTermForInput(String termName, String glossaryGuid) {
        Term term = new Term();
        term.setName(termName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        term.setGlossary(glossarySummary);
        return term;
    }

    public Term createTermWithGovernanceClassifications(String termName, String glossaryGuid, GovernanceClassifications governanceClassifications) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Term term = this.getTermForInput(termName, glossaryGuid);
        term.setGovernanceClassifications(governanceClassifications);
        Term newTerm = this.issueCreateTerm(term);
        return newTerm;
    }

    private GovernanceClassifications createGovernanceClassifications() {
        GovernanceClassifications governanceClassifications = new GovernanceClassifications();
        Confidentiality confidentiality = new Confidentiality();
        confidentiality.setLevel(Integer.valueOf(6));
        governanceClassifications.setConfidentiality(confidentiality);
        Confidence confidence = new Confidence();
        confidence.setLevel(ConfidenceLevel.Authoritative);
        governanceClassifications.setConfidence(confidence);
        Criticality criticality = new Criticality();
        criticality.setLevel(CriticalityLevel.Catastrophic);
        governanceClassifications.setCriticality(criticality);
        Retention retention = new Retention();
        retention.setBasis(RetentionBasis.ProjectLifetime);
        governanceClassifications.setRetention(retention);
        return governanceClassifications;
    }

    private GovernanceClassifications create2ndGovernanceClassifications() {
        GovernanceClassifications governanceClassifications = new GovernanceClassifications();
        Confidentiality confidentiality = new Confidentiality();
        confidentiality.setLevel(Integer.valueOf(5));
        governanceClassifications.setConfidentiality(confidentiality);
        Confidence confidence = new Confidence();
        confidence.setLevel(ConfidenceLevel.AdHoc);
        governanceClassifications.setConfidence(confidence);
        Criticality criticality = new Criticality();
        criticality.setLevel(null);
        governanceClassifications.setCriticality(criticality);
        governanceClassifications.setRetention(null);
        return governanceClassifications;
    }

    public Term getTermByGUID(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Term term = (Term)this.subjectAreaTerm.getByGUID(this.userId, guid);
        if (term != null) {
            System.out.println("Got Term " + term.getName() + " with userId " + term.getSystemAttributes().getGUID() + " and status " + term.getSystemAttributes().getStatus());
        }
        return term;
    }

    public List<Term> findTerms(String criteria) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria(criteria);
        List terms = this.subjectAreaTerm.find(this.userId, findRequest);
        return terms;
    }

    public Term updateTerm(String guid, Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Term updatedTerm = (Term)this.subjectAreaTerm.update(this.userId, guid, (Object)term);
        if (updatedTerm != null) {
            System.out.println("Updated Term name to " + updatedTerm.getName());
        }
        return updatedTerm;
    }

    public Term replaceTerm(String guid, Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Term updatedTerm = (Term)this.subjectAreaTerm.replace(this.userId, guid, (Object)term);
        if (updatedTerm != null) {
            System.out.println("Replaced Term name to " + updatedTerm.getName());
        }
        return updatedTerm;
    }

    public Term restoreTerm(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Term restoredTerm = (Term)this.subjectAreaTerm.restore(this.userId, guid);
        if (restoredTerm != null) {
            System.out.println("Restored Term " + restoredTerm.getName());
            this.createdTermsSet.add(guid);
        }
        return restoredTerm;
    }

    public Term updateTermToFuture(String guid, Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        long now = new Date().getTime();
        term.setEffectiveFromTime(Long.valueOf(new Date(now + 518400000L).getTime()));
        term.setEffectiveToTime(Long.valueOf(new Date(now + 604800000L).getTime()));
        Term updatedTerm = (Term)this.subjectAreaTerm.update(this.userId, guid, (Object)term);
        if (updatedTerm != null) {
            System.out.println("Updated Term name to " + updatedTerm.getName());
        }
        return updatedTerm;
    }

    public void deleteTerm(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.subjectAreaTerm.delete(this.userId, guid);
        this.createdTermsSet.remove(guid);
        System.out.println("Delete succeeded");
    }

    public List<Relationship> getTermRelationships(Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.subjectAreaTerm.getAllRelationships(this.userId, term.getSystemAttributes().getGUID());
    }

    public List<Relationship> getTermRelationships(Term term, Date asOfTime, int offset, int pageSize, SequencingOrder sequenceOrder, String sequenceProperty) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setAsOfTime(asOfTime);
        findRequest.setStartingFrom(offset);
        findRequest.setPageSize(Integer.valueOf(pageSize));
        findRequest.setSequencingOrder(sequenceOrder);
        findRequest.setSequencingProperty(sequenceProperty);
        return this.subjectAreaTerm.getRelationships(this.userId, term.getSystemAttributes().getGUID(), findRequest);
    }

    void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        this.deleteRemainingTerms();
        this.glossaryFVT.deleteRemainingGlossaries();
    }

    void deleteRemainingTerms() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Iterator<String> iter = this.createdTermsSet.iterator();
        while (iter.hasNext()) {
            String guid = iter.next();
            iter.remove();
            this.deleteTerm(guid);
        }
        List<Term> terms = this.findTerms("");
        if (terms.size() != this.existingTermCount) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + this.existingTermCount + " Terms to be found, got " + terms.size());
        }
    }

    public List<Category> getCategoriesAPI(String termGuid, int startingFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setPageSize(Integer.valueOf(pageSize));
        findRequest.setStartingFrom(startingFrom);
        return this.subjectAreaTermClient.getCategories(this.userId, termGuid, findRequest);
    }

    private void testCategorizedTermsWithSearchCriteria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        System.out.println("Create a glossary");
        Glossary glossary = this.glossaryFVT.createGlossary("Glossary name for CategorizedTermsWithSearchCriteria");
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        System.out.println("Create a ttt");
        Category category = this.categoryFVT.createCategoryWithGlossaryGuid("ttt", glossary.getSystemAttributes().getGUID());
        String parentGuid = category.getSystemAttributes().getGUID();
        ArrayList<CategorySummary> categories = new ArrayList<CategorySummary>();
        CategorySummary catSummary = new CategorySummary();
        catSummary.setGuid(parentGuid);
        categories.add(catSummary);
        HashSet<String> termGuids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            Term term1 = this.getTermForInput("tt" + i, glossaryGuid);
            term1.setCategories(categories);
            Term createdTerm1 = this.issueCreateTerm(term1);
            termGuids.add(createdTerm1.getSystemAttributes().getGUID());
            if (createdTerm1.getCategories().size() != 1) {
                throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 category created");
            }
            Term term2 = this.getTermForInput("ss" + i, glossaryGuid);
            term2.setCategories(categories);
            Term createdTerm2 = this.issueCreateTerm(term2);
            termGuids.add(createdTerm2.getSystemAttributes().getGUID());
            if (createdTerm2.getCategories().size() == 1) continue;
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 category created");
        }
        FindRequest findRequest = new FindRequest();
        if (this.categoryFVT.getTerms(parentGuid, findRequest).size() != 20) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 20 terms associated with the category ");
        }
        if (this.glossaryFVT.getTerms(glossaryGuid, findRequest).size() != 20) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 20 terms associated with the category ");
        }
        findRequest.setSearchCriteria("tt3");
        int count = this.categoryFVT.getTerms(parentGuid, findRequest).size();
        if (count != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 categorized term, got " + count);
        }
        count = this.glossaryFVT.getTerms(glossaryGuid, findRequest).size();
        if (count != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 glossary term, got " + count);
        }
        findRequest.setSearchCriteria("tt");
        count = this.categoryFVT.getTerms(parentGuid, findRequest).size();
        if (count != 10) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 10 category terms, got " + count);
        }
        count = this.glossaryFVT.getTerms(glossaryGuid, findRequest).size();
        if (count != 10) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 10 glossary terms, got " + count);
        }
        findRequest.setPageSize(Integer.valueOf(5));
        List<Term> terms = this.categoryFVT.getTerms(parentGuid, findRequest);
        count = terms.size();
        if (count != 5) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 5 terms with tt,got " + count);
        }
        count = this.glossaryFVT.getTerms(glossaryGuid, findRequest).size();
        if (count != 5) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 5 glossary terms with tt, got " + count);
        }
        findRequest.setSearchCriteria("ss");
        findRequest.setPageSize(Integer.valueOf(20));
        if (this.categoryFVT.getTerms(parentGuid, findRequest).size() != 10) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 10 terms for ss");
        }
        List<Term> tenTerms = this.glossaryFVT.getTerms(glossaryGuid, findRequest);
        count = tenTerms.size();
        if (count != 10) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 10 glossary terms for ss, got " + count);
        }
        Set tenTermNames = tenTerms.stream().map(term -> term.getName()).collect(Collectors.toSet());
        count = tenTermNames.size();
        if (count != 10) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 10 glossary terms distinct names ss, got " + count);
        }
        findRequest.setPageSize(Integer.valueOf(5));
        List<Term> firstFiveCategoryTerms = this.categoryFVT.getTerms(parentGuid, findRequest);
        count = firstFiveCategoryTerms.size();
        if (count != 5) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 5 terms for ss, got " + count);
        }
        Set firstFiveCategoryTermsNames = firstFiveCategoryTerms.stream().map(term -> term.getName()).collect(Collectors.toSet());
        count = firstFiveCategoryTermsNames.size();
        if (count != 5) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 5 distinct term names for ss, got " + count);
        }
        findRequest.setStartingFrom(5);
        List<Term> secondFiveCategoryTerms = this.categoryFVT.getTerms(parentGuid, findRequest);
        count = secondFiveCategoryTerms.size();
        if (count != 5) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 5 category terms for ss for 2nd page, got " + count);
        }
        Set secondFiveCategoryTermsNames = secondFiveCategoryTerms.stream().map(term -> term.getName()).collect(Collectors.toSet());
        count = secondFiveCategoryTermsNames.size();
        if (count != 5) {
            throw new SubjectAreaFVTCheckedException("ERROR:  Expected 5 category term names for ss for 2nd page " + count);
        }
        Set totalFiveCategoryTermsNames = firstFiveCategoryTermsNames;
        totalFiveCategoryTermsNames.addAll(secondFiveCategoryTermsNames);
        count = totalFiveCategoryTermsNames.size();
        if (count != 10) {
            throw new SubjectAreaFVTCheckedException("ERROR:  Expected 10 different category term names for ss from first 2 pages " + count);
        }
        for (String termGuid : termGuids) {
            this.deleteTerm(termGuid);
        }
        this.categoryFVT.deleteCategory(parentGuid);
        this.glossaryFVT.deleteGlossary(glossaryGuid);
    }
}

