/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaGraph;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaGraphClient;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.CategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.GlossaryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RelationshipsFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaDefinitionCategoryFVT;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.TermFVT;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for Graph FVT";
    private static final String DEFAULT_TEST_TERM_NAME1 = "Test term 1";
    private static final String DEFAULT_TEST_TERM_NAME2 = "Test term 2";
    private static final String DEFAULT_TEST_TERM_NAME3 = "Test term 3";
    private static final String DEFAULT_TEST_CATEGORY_NAME = "Test category 1";
    private SubjectAreaGraph subjectAreaGraph = null;
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;
    private RelationshipsFVT relationshipFVT = null;
    private CategoryFVT categoryFVT = null;
    private SubjectAreaDefinitionCategoryFVT subjectAreaFVT = null;
    private static Logger log = LoggerFactory.getLogger(GraphFVT.class);
    private String serverName = null;
    private String userId = null;

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            GraphFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaFVTCheckedException e) {
            log.error("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public GraphFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaRestClient client = new SubjectAreaRestClient(serverName, url);
        this.subjectAreaGraph = new SubjectAreaGraphClient(client);
        log.debug("Create a glossary");
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.termFVT = new TermFVT(url, serverName, userId);
        this.categoryFVT = new CategoryFVT(url, serverName, userId);
        this.relationshipFVT = new RelationshipsFVT(url, serverName, userId);
        this.subjectAreaFVT = new SubjectAreaDefinitionCategoryFVT(url, serverName, userId);
        this.serverName = serverName;
        this.userId = userId;
    }

    public void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaFVTCheckedException {
        this.termFVT.deleteRemainingTerms();
        this.subjectAreaFVT.deleteRemainingSubjectAreas();
        this.categoryFVT.deleteRemainingCategories();
        this.relationshipFVT.deleteRemaining();
        this.glossaryFVT.deleteRemainingGlossaries();
    }

    public static void runWith2Servers(String url) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GraphFVT.runIt(url, "cocoMDS4", "erinoverview");
        GraphFVT.runIt(url, "cocoMDS1", "erinoverview");
    }

    public static void runIt(String url, String serverName, String userId) throws InvalidParameterException, SubjectAreaFVTCheckedException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("GraphFVT runIt started");
            GraphFVT fvt = new GraphFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemaining();
            System.out.println("GraphFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void run() throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        Graph graph = this.getGraph(glossaryGuid, null, null, null, null, 3);
        this.checkGraphContent(graph, 1, 0);
        Term term1 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME1, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, null, null, null, 3);
        this.checkGraphContent(graph, 2, 1);
        Term term2 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME2, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, null, null, null, 3);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null, 1);
        this.checkGraphContent(graph, 2, 1);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null, 2);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null, 3);
        this.checkGraphContent(graph, 3, 2);
        this.relationshipFVT.createSynonym(term1, term2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null, 3);
        this.checkGraphContent(graph, 3, 3);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, new HashSet<RelationshipType>(Arrays.asList(RelationshipType.Synonym)), null, 3);
        this.checkGraphContent(graph, 2, 1);
        Term term3 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME3, glossaryGuid);
        this.relationshipFVT.createSynonym(term1, term3);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, new HashSet<RelationshipType>(Arrays.asList(RelationshipType.Synonym)), null, 3);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(glossaryGuid, null, null, null, null, 3);
        this.checkGraphContent(graph, 4, 5);
        graph = this.getGraph(term3.getSystemAttributes().getGUID(), null, null, new HashSet<RelationshipType>(Arrays.asList(RelationshipType.Synonym)), null, 1);
        this.checkGraphContent(graph, 2, 1);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term)), null, null, 1);
        this.checkGraphContent(graph, 4, 3);
        Category category = this.categoryFVT.createCategory(DEFAULT_TEST_CATEGORY_NAME, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term)), null, null, 1);
        this.checkGraphContent(graph, 4, 3);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term, NodeType.Category)), null, null, 1);
        this.checkGraphContent(graph, 5, 4);
        Taxonomy taxonomy = this.glossaryFVT.getTaxonomyForInput(DEFAULT_TEST_GLOSSARY_NAME);
        Glossary createdTaxonomy = this.glossaryFVT.issueCreateGlossary((Glossary)taxonomy);
        String taxonomyGuid = createdTaxonomy.getSystemAttributes().getGUID();
        SubjectAreaDefinition subjectAreaDefinition = this.subjectAreaFVT.createSubjectAreaDefinitionWithGlossaryGuid("Subject area 1", taxonomyGuid);
        graph = this.getGraph(taxonomyGuid, null, null, null, null, 3);
        this.checkGraphContent(graph, 2, 1);
        this.checkNodesContainNodeType(graph, NodeType.Taxonomy);
        this.checkNodesContainNodeType(graph, NodeType.SubjectAreaDefinition);
        this.subjectAreaFVT.deleteSubjectAreaDefinition(subjectAreaDefinition.getSystemAttributes().getGUID());
        this.categoryFVT.deleteCategory(category.getSystemAttributes().getGUID());
        this.termFVT.deleteTerm(term1.getSystemAttributes().getGUID());
        this.termFVT.deleteTerm(term2.getSystemAttributes().getGUID());
        this.termFVT.deleteTerm(term3.getSystemAttributes().getGUID());
        this.glossaryFVT.deleteGlossary(taxonomyGuid);
        this.glossaryFVT.deleteGlossary(glossaryGuid);
    }

    private void checkNodesContainNodeType(Graph graph, NodeType nodeTypeToCheck) throws SubjectAreaFVTCheckedException {
        boolean found = false;
        if (graph == null || graph.getNodes() == null || graph.getNodes().size() == 0) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected to find " + nodeTypeToCheck.name() + "but there were no nodes in the graph");
        }
        Map nodes = graph.getNodes();
        Set guids = nodes.keySet();
        for (String guid : guids) {
            Node node = (Node)nodes.get(guid);
            if (node.getNodeType() != nodeTypeToCheck) continue;
            found = true;
        }
        if (!found) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected to find " + nodeTypeToCheck.name() + "but it did not exist");
        }
    }

    private void checkGraphContent(Graph graph, int expectedNodesSize, int expectedRelationshipsSize) throws SubjectAreaFVTCheckedException {
        log.debug("CheckGraphContent expected " + expectedNodesSize + " Nodes and " + expectedRelationshipsSize + " Relationships");
        if (graph.getNodes().size() != expectedNodesSize) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + expectedNodesSize + " nodes, got " + graph.getNodes().size());
        }
        if (expectedRelationshipsSize == 0 && graph.getRelationships() != null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 0 and graph.getRelationships() to be null ");
        }
        if (expectedRelationshipsSize != 0 && graph.getRelationships() == null) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + expectedRelationshipsSize + " and graph.getRelationships() is null ");
        }
        if (graph.getRelationships() != null && graph.getRelationships().size() != expectedRelationshipsSize) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + expectedRelationshipsSize + " relationships, got " + graph.getRelationships().size());
        }
    }

    private Graph getGraph(String guid, Date asOfTime, Set<NodeType> nodeFilter, Set<RelationshipType> relationshipFilter, StatusFilter statusFilter, int level) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.subjectAreaGraph.getGraph(this.userId, guid, asOfTime, nodeFilter, relationshipFilter, statusFilter, level);
    }
}

