/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.glossaries.SubjectAreaGlossaryClient;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.FVTUtils;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GlossaryFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Testglossary1";
    private static final String DEFAULT_TEST_GLOSSARY_NAME2 = "Testglossary2";
    private static final String DEFAULT_TEST_GLOSSARY_NAME3 = "Testglossary3";
    private SubjectAreaNodeClient<Glossary> subjectAreaGlossary = null;
    private SubjectAreaGlossaryClient subjectAreaGlossaryClient = null;
    private String serverName = null;
    private String userId = null;
    private int existingGlossaryCount = 0;
    private Set<String> createdGlossariesSet;

    public GlossaryFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaRestClient client = new SubjectAreaRestClient(serverName, url);
        this.subjectAreaGlossary = new SubjectAreaGlossaryClient(client);
        this.subjectAreaGlossaryClient = (SubjectAreaGlossaryClient)this.subjectAreaGlossary;
        this.serverName = serverName;
        this.userId = userId;
        this.createdGlossariesSet = new HashSet<String>();
        this.existingGlossaryCount = this.findGlossaries("").size();
        System.out.println("existingGlossaryCount " + this.existingGlossaryCount);
    }

    public static void runWith2Servers(String url) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, SubjectAreaFVTCheckedException {
        GlossaryFVT.runIt(url, "cocoMDS4", "erinoverview");
        GlossaryFVT.runIt(url, "cocoMDS1", "erinoverview");
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            GlossaryFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
        catch (SubjectAreaFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public static void runIt(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, SubjectAreaFVTCheckedException {
        try {
            System.out.println("GlossaryFVT runIt started");
            GlossaryFVT fvt = new GlossaryFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemainingGlossaries();
            System.out.println("GlossaryFVT runIt finished");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public static int getGlossaryCount(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, SubjectAreaFVTCheckedException {
        GlossaryFVT fvt = new GlossaryFVT(url, serverName, userId);
        return fvt.findGlossaries("").size();
    }

    public void run() throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Glossary> initialGlossaryState = this.findGlossaries(null);
        int initialGlossaryCount = 0;
        if (initialGlossaryState != null && initialGlossaryState.size() > 0) {
            initialGlossaryCount = initialGlossaryState.size();
        }
        System.out.println("Create a glossary");
        Glossary glossary = this.createGlossary(this.serverName + " Testglossary1");
        FVTUtils.validateNode((Node)glossary);
        Glossary glossary2 = this.createGlossary(this.serverName + " Testglossary2");
        FVTUtils.validateNode((Node)glossary2);
        List<Glossary> results = this.findGlossaries(null);
        if (results.size() != initialGlossaryCount + 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + initialGlossaryCount + "2 back on the find got " + results.size());
        }
        Glossary glossaryForUpdate = new Glossary();
        glossaryForUpdate.setName(this.serverName + " Testglossary3");
        System.out.println("Get the glossary");
        String guid = glossary.getSystemAttributes().getGUID();
        Glossary gotGlossary = this.getGlossaryByGUID(guid);
        System.out.println("Update the glossary");
        Glossary updatedGlossary = this.updateGlossary(guid, glossaryForUpdate);
        FVTUtils.validateNode((Node)updatedGlossary);
        System.out.println("Get the glossary again");
        gotGlossary = this.getGlossaryByGUID(guid);
        FVTUtils.validateNode((Node)gotGlossary);
        System.out.println("Delete the glossary");
        this.deleteGlossary(guid);
        System.out.println("restore the glossary");
        gotGlossary = this.restoreGlossary(guid);
        FVTUtils.validateNode((Node)gotGlossary);
        System.out.println("Delete the glossary again");
        this.deleteGlossary(guid);
        System.out.println("Create glossary with the same name as a deleted one");
        glossary = this.createGlossary(this.serverName + " Testglossary1");
        FVTUtils.validateNode((Node)glossary);
        System.out.println("create glossaries to find");
        Glossary glossaryForFind1 = this.getGlossaryForInput("qrs");
        glossaryForFind1.setQualifiedName("yyy");
        glossaryForFind1 = this.issueCreateGlossary(glossaryForFind1);
        FVTUtils.validateNode((Node)glossaryForFind1);
        Glossary glossaryForFind2 = this.createGlossary("yyy");
        FVTUtils.validateNode((Node)glossaryForFind2);
        Glossary glossaryForFind3 = this.createGlossary("zzz");
        FVTUtils.validateNode((Node)glossaryForFind3);
        Glossary glossaryForFind4 = this.createGlossary("This is a Glossary with spaces in name");
        FVTUtils.validateNode((Node)glossaryForFind4);
        results = this.findGlossaries("zzz");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        results = this.findGlossaries("yyy");
        if (results.size() != 2) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 2 back on the find got " + results.size());
        }
        this.deleteGlossary(glossaryForFind2.getSystemAttributes().getGUID());
        results = this.findGlossaries("yyy");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        results = this.findGlossaries("This is a Glossary with spaces in name");
        if (results.size() != 1) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        this.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        Glossary glossaryForUniqueQFN2 = this.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        if (glossaryForUniqueQFN2 == null || glossaryForUniqueQFN2.equals((Object)"")) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected qualified name to be set");
        }
    }

    void deleteRemainingGlossaries() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Iterator<String> iter = this.createdGlossariesSet.iterator();
        while (iter.hasNext()) {
            String guid = iter.next();
            iter.remove();
            this.deleteGlossary(guid);
        }
        List<Glossary> glossaries = this.findGlossaries("");
        if (glossaries.size() != this.existingGlossaryCount) {
            throw new SubjectAreaFVTCheckedException("ERROR: Expected " + this.existingGlossaryCount + " glossaries, got " + glossaries.size());
        }
    }

    public Glossary createGlossary(String glossaryName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = this.getGlossaryForInput(glossaryName);
        return this.issueCreateGlossary(glossary);
    }

    public Glossary issueCreateGlossary(Glossary glossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Glossary newGlossary = (Glossary)this.subjectAreaGlossary.create(this.userId, (Object)glossary);
        if (newGlossary != null) {
            String guid = newGlossary.getSystemAttributes().getGUID();
            System.out.println("Created Glossary " + newGlossary.getName() + " with userId " + guid);
            this.createdGlossariesSet.add(guid);
        }
        return newGlossary;
    }

    public Glossary getGlossaryForInput(String glossaryName) {
        Glossary glossary = new Glossary();
        glossary.setName(glossaryName);
        return glossary;
    }

    public Taxonomy getTaxonomyForInput(String glossaryName) {
        Taxonomy taxonomy = new Taxonomy();
        taxonomy.setName(glossaryName);
        return taxonomy;
    }

    public Glossary createPastToGlossary(long now, String name) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        glossary.setEffectiveToTime(Long.valueOf(new Date(now - 10L).getTime()));
        Glossary newGlossary = this.issueCreateGlossary(glossary);
        FVTUtils.validateNode((Node)newGlossary);
        System.out.println("Created Glossary " + newGlossary.getName() + " with GUID " + newGlossary.getSystemAttributes().getGUID());
        return newGlossary;
    }

    public Glossary createPastFromGlossary(long now, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        glossary.setEffectiveFromTime(Long.valueOf(new Date(now - 10L).getTime()));
        return this.issueCreateGlossary(glossary);
    }

    public Glossary createInvalidEffectiveDateGlossary(String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveFromTime(Long.valueOf(new Date(now - 10L).getTime()));
        glossary.setEffectiveToTime(Long.valueOf(new Date(now - 11L).getTime()));
        return this.issueCreateGlossary(glossary);
    }

    public Glossary createFutureGlossary(long now, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        glossary.setEffectiveFromTime(Long.valueOf(new Date(now + 86400000L).getTime()));
        glossary.setEffectiveToTime(Long.valueOf(new Date(now + 172800000L).getTime()));
        Glossary newGlossary = this.issueCreateGlossary(glossary);
        FVTUtils.validateNode((Node)newGlossary);
        System.out.println("Created Glossary " + newGlossary.getName() + " with userId " + newGlossary.getSystemAttributes().getGUID());
        return newGlossary;
    }

    public List<Glossary> findGlossaries(String criteria) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria(criteria);
        List glossaries = this.subjectAreaGlossary.find(this.userId, findRequest);
        return glossaries;
    }

    public Glossary getGlossaryByGUID(String guid) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = (Glossary)this.subjectAreaGlossary.getByGUID(this.userId, guid);
        FVTUtils.validateNode((Node)glossary);
        System.out.println("Got Glossary " + glossary.getName() + " with userId " + glossary.getSystemAttributes().getGUID() + " and status " + glossary.getSystemAttributes().getStatus());
        return glossary;
    }

    public Glossary updateGlossary(String guid, Glossary glossary) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary updatedGlossary = (Glossary)this.subjectAreaGlossary.update(this.userId, guid, (Object)glossary);
        FVTUtils.validateNode((Node)updatedGlossary);
        System.out.println("Updated Glossary name to " + updatedGlossary.getName());
        return updatedGlossary;
    }

    public void deleteGlossary(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.subjectAreaGlossary.delete(this.userId, guid);
        this.createdGlossariesSet.remove(guid);
        System.out.println("Delete succeeded");
    }

    public Glossary restoreGlossary(String guid) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary restoredGlossary = (Glossary)this.subjectAreaGlossary.restore(this.userId, guid);
        FVTUtils.validateNode((Node)restoredGlossary);
        this.createdGlossariesSet.add(restoredGlossary.getSystemAttributes().getGUID());
        System.out.println("Restored Glossary name is " + restoredGlossary.getName());
        return restoredGlossary;
    }

    public List<Relationship> getGlossaryRelationships(Glossary glossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.subjectAreaGlossary.getAllRelationships(this.userId, glossary.getSystemAttributes().getGUID());
    }

    public List<Category> getCategories(String glossaryGuid, FindRequest findRequest, boolean onlyTop) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.subjectAreaGlossaryClient.getCategories(this.userId, glossaryGuid, findRequest, Boolean.valueOf(onlyTop));
    }

    public List<Term> getTerms(String glossaryGuid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.subjectAreaGlossaryClient.getTerms(this.userId, glossaryGuid, findRequest);
    }
}

