/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.fvt;

import java.io.IOException;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.glossaries.SubjectAreaGlossaryClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.terms.SubjectAreaTermClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaRelationshipClients;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.accessservices.subjectarea.fvt.SubjectAreaFVTCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSerializationFVT {
    private final String userId;
    private final SubjectAreaRelationshipClients subjectAreaRelationship;
    private final SubjectAreaNodeClient<Term> subjectAreaTerm;
    private final SubjectAreaNodeClient<Glossary> subjectAreaGlossary;
    private static Logger log = LoggerFactory.getLogger(CheckSerializationFVT.class);

    public CheckSerializationFVT(String url, String serverName, String userId) throws InvalidParameterException {
        this.userId = userId;
        SubjectAreaRestClient client = new SubjectAreaRestClient(serverName, url);
        this.subjectAreaTerm = new SubjectAreaTermClient(client);
        this.subjectAreaGlossary = new SubjectAreaGlossaryClient(client);
        this.subjectAreaRelationship = new SubjectAreaRelationship(client);
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            CheckSerializationFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (SubjectAreaFVTCheckedException e) {
            log.error("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runWith2Servers(String url) throws SubjectAreaFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        CheckSerializationFVT.runIt(url, "cocoMDS4", "erinoverview");
        CheckSerializationFVT.runIt(url, "cocoMDS1", "erinoverview");
    }

    public static void runIt(String url, String serverName, String userId) throws InvalidParameterException, SubjectAreaFVTCheckedException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("CheckSerializationFVT runIt started");
            CheckSerializationFVT fvt = new CheckSerializationFVT(url, serverName, userId);
            fvt.run();
            System.out.println("CheckSerializationFVT runIt stopped");
        }
        catch (Exception error) {
            log.error("The FVT Encountered an Exception", (Throwable)error);
            throw error;
        }
    }

    private void run() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        Glossary glossary = new Glossary();
        glossary.setName("Test");
        Glossary gotGlossary = (Glossary)this.subjectAreaGlossary.create(this.userId, (Object)glossary);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(gotGlossary.getSystemAttributes().getGUID());
        Term termOne = new Term();
        termOne.setName("Test_term_a");
        termOne.setGlossary(glossarySummary);
        Term termTwo = new Term();
        termTwo.setName("Test_term_b");
        termTwo.setGlossary(glossarySummary);
        Term gotTermOne = (Term)this.subjectAreaTerm.create(this.userId, (Object)termOne);
        Term gotTermTwo = (Term)this.subjectAreaTerm.create(this.userId, (Object)termTwo);
        String oneTermGuid = gotTermOne.getSystemAttributes().getGUID();
        String twoTermGuid = gotTermTwo.getSystemAttributes().getGUID();
        this.checkChildrenSerialization(oneTermGuid, twoTermGuid);
        this.subjectAreaTerm.delete(this.userId, oneTermGuid);
        this.subjectAreaTerm.delete(this.userId, twoTermGuid);
        this.subjectAreaGlossary.delete(this.userId, gotGlossary.getSystemAttributes().getGUID());
    }

    public void checkChildrenSerialization(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, SubjectAreaFVTCheckedException {
        List termAnchors = this.subjectAreaTerm.getAllRelationships(this.userId, oneTermGuid);
        this.checkCastChild((Relationship)termAnchors.get(0), TermAnchor.class);
        if (log.isDebugEnabled()) {
            log.debug("TermAnchor is ok.");
        }
        this.createHasA(oneTermGuid, twoTermGuid);
        List hasAList = this.subjectAreaTerm.getAllRelationships(this.userId, oneTermGuid);
        hasAList.removeIf(line -> line instanceof TermAnchor);
        HasA hasA = this.checkCastChild((Relationship)hasAList.get(0), HasA.class);
        this.subjectAreaRelationship.hasA().delete(this.userId, hasA.getGuid());
        if (log.isDebugEnabled()) {
            log.debug("HasA is ok.");
        }
        this.createIsA(oneTermGuid, twoTermGuid);
        List isAList = this.subjectAreaTerm.getAllRelationships(this.userId, oneTermGuid);
        isAList.removeIf(line -> line instanceof TermAnchor);
        IsA isA = this.checkCastChild((Relationship)isAList.get(0), IsA.class);
        this.subjectAreaRelationship.isA().delete(this.userId, isA.getGuid());
        if (log.isDebugEnabled()) {
            log.debug("IsA is ok.");
        }
        this.createRelatedTerm(oneTermGuid, twoTermGuid);
        List relatedTerms = this.subjectAreaTerm.getAllRelationships(this.userId, oneTermGuid);
        relatedTerms.removeIf(line -> line instanceof TermAnchor);
        RelatedTerm relatedTerm = this.checkCastChild((Relationship)relatedTerms.get(0), RelatedTerm.class);
        this.subjectAreaRelationship.relatedTerm().delete(this.userId, relatedTerm.getGuid());
        if (log.isDebugEnabled()) {
            log.debug("RelatedTerm is ok.");
        }
        this.createTranslation(oneTermGuid, twoTermGuid);
        List translations = this.subjectAreaTerm.getAllRelationships(this.userId, oneTermGuid);
        translations.removeIf(line -> line instanceof TermAnchor);
        Translation translation = this.checkCastChild((Relationship)translations.get(0), Translation.class);
        this.subjectAreaRelationship.translation().delete(this.userId, translation.getGuid());
        if (log.isDebugEnabled()) {
            log.debug("Translation is ok.");
        }
        this.createPreferredTerm(oneTermGuid, twoTermGuid);
        List preferredTerms = this.subjectAreaTerm.getAllRelationships(this.userId, oneTermGuid);
        preferredTerms.removeIf(line -> line instanceof TermAnchor);
        PreferredTerm preferredTerm = this.checkCastChild((Relationship)preferredTerms.get(0), PreferredTerm.class);
        this.subjectAreaRelationship.preferredTerm().delete(this.userId, preferredTerm.getGuid());
        if (log.isDebugEnabled()) {
            log.debug("PreferredTerm is ok.");
        }
        this.createSynonym(oneTermGuid, twoTermGuid);
        List synonyms = this.subjectAreaTerm.getAllRelationships(this.userId, oneTermGuid);
        synonyms.removeIf(line -> line instanceof TermAnchor);
        Synonym synonym = this.checkCastChild((Relationship)synonyms.get(0), Synonym.class);
        this.subjectAreaRelationship.synonym().delete(this.userId, synonym.getGuid());
        if (log.isDebugEnabled()) {
            log.debug("Synonym is ok.");
        }
    }

    private <L extends Relationship, ForCast extends Relationship> ForCast checkCastChild(L line, Class<ForCast> lClass) throws SubjectAreaFVTCheckedException {
        try {
            return (ForCast)line;
        }
        catch (ClassCastException e) {
            throw new SubjectAreaFVTCheckedException("The class " + lClass.getSimpleName() + "was deserialized incorrectly, so it cannot be cast");
        }
    }

    private void createHasA(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        HasA hasA = new HasA();
        hasA.getEnd1().setNodeGuid(oneTermGuid);
        hasA.getEnd2().setNodeGuid(twoTermGuid);
        this.subjectAreaRelationship.hasA().create(this.userId, (Object)hasA);
    }

    private void createIsA(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        IsA isA = new IsA();
        isA.getEnd1().setNodeGuid(oneTermGuid);
        isA.getEnd2().setNodeGuid(twoTermGuid);
        this.subjectAreaRelationship.isA().create(this.userId, (Object)isA);
    }

    private void createRelatedTerm(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedTerm relatedTerm = new RelatedTerm();
        relatedTerm.getEnd1().setNodeGuid(oneTermGuid);
        relatedTerm.getEnd2().setNodeGuid(twoTermGuid);
        this.subjectAreaRelationship.relatedTerm().create(this.userId, (Object)relatedTerm);
    }

    private void createTranslation(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Translation translation = new Translation();
        translation.getEnd1().setNodeGuid(oneTermGuid);
        translation.getEnd2().setNodeGuid(twoTermGuid);
        this.subjectAreaRelationship.translation().create(this.userId, (Object)translation);
    }

    private void createPreferredTerm(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        PreferredTerm preferredTerm = new PreferredTerm();
        preferredTerm.getEnd1().setNodeGuid(oneTermGuid);
        preferredTerm.getEnd2().setNodeGuid(twoTermGuid);
        this.subjectAreaRelationship.preferredTerm().create(this.userId, (Object)preferredTerm);
    }

    private void createSynonym(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Synonym synonym = new Synonym();
        synonym.getEnd1().setNodeGuid(oneTermGuid);
        synonym.getEnd2().setNodeGuid(twoTermGuid);
        this.subjectAreaRelationship.synonym().create(this.userId, (Object)synonym);
    }
}

