/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.admin;

import org.odpi.openmetadata.accessservices.subjectarea.auditlog.SubjectAreaAuditCode;
import org.odpi.openmetadata.accessservices.subjectarea.listener.SubjectAreaOMRSTopicListener;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServices;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaAdmin
implements AccessServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaAdmin.class);
    private OMRSRepositoryConnector repositoryConnector = null;
    private OMRSTopicConnector omrsTopicConnector = null;
    private AccessServiceConfig accessServiceConfig = null;
    private OMRSAuditLog auditLog = null;
    private String serverUserName = null;
    private SubjectAreaOMRSTopicListener omrsTopicListener = null;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        String methodName = "initialize";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: initialize,userid=" + serverUserName);
        }
        SubjectAreaAuditCode auditCode = SubjectAreaAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.repositoryConnector = enterpriseOMRSRepositoryConnector;
        SubjectAreaRESTServices.setRepositoryConnector(accessServiceConfigurationProperties.getAccessServiceName(), this.repositoryConnector);
        this.accessServiceConfig = accessServiceConfigurationProperties;
        this.omrsTopicConnector = enterpriseOMRSTopicConnector;
        if (this.omrsTopicConnector != null) {
            auditCode = SubjectAreaAuditCode.SERVICE_REGISTERED_WITH_TOPIC;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.omrsTopicListener = new SubjectAreaOMRSTopicListener(this.accessServiceConfig.getAccessServiceOutTopic(), this.repositoryConnector.getRepositoryHelper(), this.repositoryConnector.getRepositoryValidator(), this.accessServiceConfig.getAccessServiceName());
            this.omrsTopicConnector.registerListener((OMRSTopicListener)this.omrsTopicListener);
        }
        this.auditLog = auditLog;
        this.serverUserName = serverUserName;
        auditCode = SubjectAreaAuditCode.SERVICE_INITIALIZED;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        if (log.isDebugEnabled()) {
            log.debug("<== Method: initialize,userid=" + serverUserName);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        SubjectAreaAuditCode auditCode = SubjectAreaAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

