/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.MetadataServer;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.MetadataServer;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataServerMapper {
    private static final Logger log = LoggerFactory.getLogger(MetadataServerMapper.class);
    private static final String className = MetadataServerMapper.class.getName();

    public static MetadataServer mapOmrsToOmas(Classification omrsClassification) throws InvalidParameterException {
        String classificationTypeName = omrsClassification.getName();
        if ("MetadataServer".equals(classificationTypeName)) {
            MetadataServer metadataServer = new MetadataServer();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsClassification.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsClassification.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsClassification.getUpdatedBy());
            systemAttributes.setCreateTime(omrsClassification.getCreateTime());
            systemAttributes.setUpdateTime(omrsClassification.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsClassification.getVersion()));
            metadataServer.setSystemAttributes(systemAttributes);
            InstanceProperties omrsClassificationProperties = omrsClassification.getProperties();
            Iterator omrsPropertyIterator = omrsClassificationProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsClassificationProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (MetadataServer.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("format")) {
                                metadataServer.setFormat((String)actualValue);
                            }
                            if (!name.equals("type")) break;
                            metadataServer.setType((String)actualValue);
                            break;
                        }
                        if (null == metadataServer.getExtraAttributes()) {
                            metadataServer.setExtraAttributes(new HashMap());
                        }
                        metadataServer.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (MetadataServer.ENUM_NAMES_SET.contains(name)) break;
                        if (null == metadataServer.getExtraAttributes()) {
                            metadataServer.setExtraAttributes(new HashMap());
                        }
                        metadataServer.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!MetadataServer.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
            return metadataServer;
        }
        return null;
    }

    public static Classification mapBeanToOmrs(MetadataServer metadataServer) {
        PrimitivePropertyValue primitivePropertyValue;
        Classification omrsClassification = new Classification();
        SystemAttributes systemAttributes = metadataServer.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsClassification.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsClassification.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsClassification.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (metadataServer.getFormat() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)metadataServer.getFormat());
            instanceProperties.setProperty("format", (InstancePropertyValue)primitivePropertyValue);
        }
        if (metadataServer.getType() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)metadataServer.getType());
            instanceProperties.setProperty("type", (InstancePropertyValue)primitivePropertyValue);
        }
        omrsClassification.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("MetadataServer");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsClassification.setType(instanceType);
        return omrsClassification;
    }
}

