/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaFile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MediaFile.MediaFile;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.server.properties.classifications.ClassificationFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaFileMapper {
    private static final Logger log = LoggerFactory.getLogger(MediaFileMapper.class);
    private static final String className = MediaFileMapper.class.getName();

    public static MediaFile mapOmrsEntityDetailToMediaFile(EntityDetail omrsEntityDetail) throws InvalidParameterException {
        String entityTypeName = omrsEntityDetail.getType().getTypeDefName();
        if ("MediaFile".equals(entityTypeName)) {
            MediaFile mediaFile = new MediaFile();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsEntityDetail.getStatus();
            Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omas_status);
            systemAttributes.setCreatedBy(omrsEntityDetail.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsEntityDetail.getUpdatedBy());
            systemAttributes.setCreateTime(omrsEntityDetail.getCreateTime());
            systemAttributes.setUpdateTime(omrsEntityDetail.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsEntityDetail.getVersion()));
            systemAttributes.setGUID(omrsEntityDetail.getGUID());
            mediaFile.setSystemAttributes(systemAttributes);
            InstanceProperties omrsEntityDetailProperties = omrsEntityDetail.getProperties();
            Iterator omrsPropertyIterator = omrsEntityDetailProperties.getPropertyNames();
            block5: while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsEntityDetailProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (MediaFile.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (!name.equals("qualifiedName")) break;
                            mediaFile.setQualifiedName((String)actualValue);
                            break;
                        }
                        if (null == mediaFile.getExtraAttributes()) {
                            mediaFile.setExtraAttributes(new HashMap<String, Object>());
                        }
                        mediaFile.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (MediaFile.ENUM_NAMES_SET.contains(name)) break;
                        if (null == mediaFile.getExtraAttributes()) {
                            mediaFile.setExtraAttributes(new HashMap<String, Object>());
                        }
                        mediaFile.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        String mapvalue;
                        PrimitivePropertyValue primitivePropertyMapValue;
                        String mapkey;
                        Iterator iter;
                        HashMap<String, String> actualMap;
                        if (!MediaFile.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                        if (name.equals("embeddedMetadata")) {
                            actualMap = new HashMap<String, String>();
                            iter = instancePropertyForMap.getPropertyNames();
                            while (iter.hasNext()) {
                                mapkey = (String)iter.next();
                                primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                                mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                                actualMap.put(mapkey, mapvalue);
                            }
                            mediaFile.setEmbeddedMetadata(actualMap);
                        }
                        if (!name.equals("additionalProperties")) continue block5;
                        actualMap = new HashMap();
                        iter = instancePropertyForMap.getPropertyNames();
                        while (iter.hasNext()) {
                            mapkey = (String)iter.next();
                            primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                            mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                            actualMap.put(mapkey, mapvalue);
                        }
                        mediaFile.setAdditionalProperties(actualMap);
                        break;
                    }
                }
            }
            List omrsclassifications = omrsEntityDetail.getClassifications();
            if (omrsclassifications != null && !omrsclassifications.isEmpty()) {
                for (Classification omrsClassification : omrsclassifications) {
                    String omrsClassificationName = omrsClassification.getName();
                    org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = ClassificationFactory.getClassification(omrsClassificationName, omrsClassification);
                    if (omasClassification != null) {
                        if (mediaFile.classifications == null) {
                            mediaFile.classifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
                        }
                        mediaFile.classifications.add(omasClassification);
                        continue;
                    }
                    if (null == mediaFile.getExtraClassifications()) {
                        mediaFile.setExtraClassifications(new HashMap<String, Classification>());
                    }
                    mediaFile.getExtraClassifications().put(omrsClassificationName, omrsClassification);
                }
            }
            return mediaFile;
        }
        return null;
    }

    public static EntityDetail mapMediaFileToOmrsEntityDetail(MediaFile mediaFile) {
        PrimitivePropertyValue primitivePropertyValue;
        MapPropertyValue mapPropertyValue;
        Map<String, String> map;
        EntityDetail omrsEntityDetail = new EntityDetail();
        SystemAttributes systemAttributes = mediaFile.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsEntityDetail.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsEntityDetail.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsEntityDetail.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsEntityDetail.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsEntityDetail.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsEntityDetail.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsEntityDetail.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (mediaFile.getQualifiedName() != null) {
            PrimitivePropertyValue primitivePropertyValue2 = new PrimitivePropertyValue();
            primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue2.setPrimitiveValue((Object)mediaFile.getQualifiedName());
            instanceProperties.setProperty("qualifiedName", (InstancePropertyValue)primitivePropertyValue2);
        }
        if (mediaFile.getEmbeddedMetadata() != null) {
            map = mediaFile.getEmbeddedMetadata();
            mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue((Object)map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue);
            }
            instanceProperties.setProperty("embeddedMetadata", (InstancePropertyValue)mapPropertyValue);
        }
        if (mediaFile.getAdditionalProperties() != null) {
            map = mediaFile.getAdditionalProperties();
            mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue((Object)map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue);
            }
            instanceProperties.setProperty("additionalProperties", (InstancePropertyValue)mapPropertyValue);
        }
        omrsEntityDetail.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("MediaFile");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsEntityDetail.setType(instanceType);
        MediaFileMapper.populateOmrsEntityWithBeanClassifications(omrsEntityDetail, mediaFile.getClassifications());
        return omrsEntityDetail;
    }

    private static void populateOmrsEntityWithBeanClassifications(EntityDetail omrsEntityDetail, List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> beanClassifications) {
        if (beanClassifications != null && beanClassifications.size() > 0) {
            ArrayList<Classification> omrsClassifications = new ArrayList<Classification>();
            for (org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification beanClassification : beanClassifications) {
                SystemAttributes systemAttributes = beanClassification.getSystemAttributes();
                Classification omrsClassification = new Classification();
                if (systemAttributes != null) {
                    if (systemAttributes.getCreatedBy() != null) {
                        omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
                    }
                    if (systemAttributes.getUpdatedBy() != null) {
                        omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
                    }
                    if (systemAttributes.getCreateTime() != null) {
                        omrsClassification.setCreateTime(systemAttributes.getCreateTime());
                    }
                    if (systemAttributes.getUpdateTime() != null) {
                        omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
                    }
                    if (systemAttributes.getVersion() != null) {
                        omrsClassification.setVersion(systemAttributes.getVersion().longValue());
                    }
                }
                omrsClassification.setName(beanClassification.getClassificationName());
                omrsClassification.setProperties(beanClassification.obtainInstanceProperties());
                omrsClassifications.add(omrsClassification);
            }
            omrsEntityDetail.setClassifications(omrsClassifications);
        }
    }
}

