/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Rating;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.RatingToReferenceable.RatedElementReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RatingReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RatingReferences.class);
    private static final String className = RatingReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"ratedElement", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"AttachedRating", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private RatedElementReference ratedElement;

    public RatingReferences(String entityGuid, List<Line> lines) throws InvalidParameterException {
        for (Line relationship : lines) {
            for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                String referenceName;
                if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i]) || !"ratedElement".equals(referenceName = REFERENCE_NAMES_SET_VALUES[i])) continue;
                AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                this.ratedElement = new RatedElementReference(entityGuid, attachedRating_relationship);
            }
        }
    }

    public RatedElementReference getRatedElementReference() {
        return this.ratedElement;
    }

    public void setRatedElementReference(RatedElementReference ratedElement) {
        this.ratedElement = ratedElement;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("RatingReferences{");
        sb.append("ratedElementReference='").append(this.ratedElement.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RatingReferences typedThat = (RatingReferences)o;
        if (this.ratedElement != null && !Objects.equals(this.ratedElement, typedThat.ratedElement)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ratedElement);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

