/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualConnection;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ConnectionToAsset.AssetReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ConnectionToConnectorType.ConnectorTypeReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ConnectionToEndpoint.ConnectionEndpointReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ConnectionToVirtualConnection.SupportingVirtualConnectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToActorProfile.ContributorsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCertificationType.CertificationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCollection.FoundInCollectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToComment.CommentsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCommunity.CommunityUsesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.AlsoKnownAsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.ManagedResourcesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalReference.ExternalReferenceReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToGlossaryTerm.MeaningReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToInformalTag.TagsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLicenseType.LicensesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLike.LikesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToMeeting.MeetingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToNoteLog.NoteLogsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPerson.StaffReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ProjectUseReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ProjectsImpactingAssetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPropertyFacet.FacetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRating.StarRatingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.ActionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.TodosReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.VirtualConnectionToConnection.EmbeddedConnectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CollectionMember.CollectionMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityResources.CommunityResources;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionConnectorType.ConnectionConnectorType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionEndpoint.ConnectionEndpoint;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAsset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Contributor.Contributor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.EmbeddedConnection.EmbeddedConnection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MeetingOnReferenceable.MeetingOnReferenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectResources.ProjectResources;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.StaffAssignment.StaffAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoOnReferenceable.ToDoOnReferenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VirtualConnectionReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(VirtualConnectionReferences.class);
    private static final String className = VirtualConnectionReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"embeddedConnections", "communityUses", "staff", "noteLogs", "tags", "asset", "comments", "likes", "externalReference", "projectsImpactingAssets", "relatedMedia", "connectorType", "supportingVirtualConnections", "todos", "meetings", "foundInCollections", "certifications", "licenses", "managedResources", "facets", "connectionEndpoint", "alsoKnownAs", "contributors", "actions", "starRatings", "projectUse", "meaning", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"EmbeddedConnection", "CommunityResources", "StaffAssignment", "AttachedNoteLog", "AttachedTag", "ConnectionToAsset", "AttachedComment", "AttachedLike", "ExternalReferenceLink", "ProjectScope", "MediaReference", "ConnectionConnectorType", "EmbeddedConnection", "ToDoOnReferenceable", "MeetingOnReferenceable", "CollectionMember", "Certification", "License", "ExternalIdScope", "ReferenceableFacet", "ConnectionEndpoint", "ExternalIdLink", "Contributor", "ToDoSource", "AttachedRating", "ProjectResources", "SemanticAssignment", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private AssetReference asset;
    private ConnectorTypeReference connectorType;
    private ConnectionEndpointReference connectionEndpoint;
    private Set<EmbeddedConnectionsReference> embeddedConnections;
    private Set<CommunityUsesReference> communityUses;
    private Set<StaffReference> staff;
    private Set<NoteLogsReference> noteLogs;
    private Set<TagsReference> tags;
    private Set<CommentsReference> comments;
    private Set<LikesReference> likes;
    private Set<ExternalReferenceReference> externalReference;
    private Set<ProjectsImpactingAssetsReference> projectsImpactingAssets;
    private Set<RelatedMediaReference> relatedMedia;
    private Set<SupportingVirtualConnectionsReference> supportingVirtualConnections;
    private Set<TodosReference> todos;
    private Set<MeetingsReference> meetings;
    private Set<FoundInCollectionsReference> foundInCollections;
    private Set<CertificationsReference> certifications;
    private Set<LicensesReference> licenses;
    private Set<ManagedResourcesReference> managedResources;
    private Set<FacetsReference> facets;
    private Set<AlsoKnownAsReference> alsoKnownAs;
    private Set<ContributorsReference> contributors;
    private Set<ActionsReference> actions;
    private Set<StarRatingsReference> starRatings;
    private Set<ProjectUseReference> projectUse;
    private Set<MeaningReference> meaning;

    public VirtualConnectionReferences(String entityGuid, List<Line> lines) throws InvalidParameterException {
        for (Line relationship : lines) {
            for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                EmbeddedConnection embeddedConnection_relationship;
                if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i])) continue;
                String referenceName = REFERENCE_NAMES_SET_VALUES[i];
                if ("embeddedConnections".equals(referenceName)) {
                    embeddedConnection_relationship = (EmbeddedConnection)relationship;
                    EmbeddedConnectionsReference embeddedConnectionsReference = new EmbeddedConnectionsReference(entityGuid, embeddedConnection_relationship);
                    if (this.embeddedConnections == null) {
                        this.embeddedConnections = new HashSet<EmbeddedConnectionsReference>();
                    }
                    this.embeddedConnections.add(embeddedConnectionsReference);
                }
                if ("communityUses".equals(referenceName)) {
                    CommunityResources communityResources_relationship = (CommunityResources)relationship;
                    CommunityUsesReference communityUsesReference = new CommunityUsesReference(entityGuid, communityResources_relationship);
                    if (this.communityUses == null) {
                        this.communityUses = new HashSet<CommunityUsesReference>();
                    }
                    this.communityUses.add(communityUsesReference);
                }
                if ("staff".equals(referenceName)) {
                    StaffAssignment staffAssignment_relationship = (StaffAssignment)relationship;
                    StaffReference staffReference = new StaffReference(entityGuid, staffAssignment_relationship);
                    if (this.staff == null) {
                        this.staff = new HashSet<StaffReference>();
                    }
                    this.staff.add(staffReference);
                }
                if ("noteLogs".equals(referenceName)) {
                    AttachedNoteLog attachedNoteLog_relationship = (AttachedNoteLog)relationship;
                    NoteLogsReference noteLogsReference = new NoteLogsReference(entityGuid, attachedNoteLog_relationship);
                    if (this.noteLogs == null) {
                        this.noteLogs = new HashSet<NoteLogsReference>();
                    }
                    this.noteLogs.add(noteLogsReference);
                }
                if ("tags".equals(referenceName)) {
                    AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                    TagsReference tagsReference = new TagsReference(entityGuid, attachedTag_relationship);
                    if (this.tags == null) {
                        this.tags = new HashSet<TagsReference>();
                    }
                    this.tags.add(tagsReference);
                }
                if ("comments".equals(referenceName)) {
                    AttachedComment attachedComment_relationship = (AttachedComment)relationship;
                    CommentsReference commentsReference = new CommentsReference(entityGuid, attachedComment_relationship);
                    if (this.comments == null) {
                        this.comments = new HashSet<CommentsReference>();
                    }
                    this.comments.add(commentsReference);
                }
                if ("likes".equals(referenceName)) {
                    AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                    LikesReference likesReference = new LikesReference(entityGuid, attachedLike_relationship);
                    if (this.likes == null) {
                        this.likes = new HashSet<LikesReference>();
                    }
                    this.likes.add(likesReference);
                }
                if ("externalReference".equals(referenceName)) {
                    ExternalReferenceLink externalReferenceLink_relationship = (ExternalReferenceLink)relationship;
                    ExternalReferenceReference externalReferenceReference = new ExternalReferenceReference(entityGuid, externalReferenceLink_relationship);
                    if (this.externalReference == null) {
                        this.externalReference = new HashSet<ExternalReferenceReference>();
                    }
                    this.externalReference.add(externalReferenceReference);
                }
                if ("projectsImpactingAssets".equals(referenceName)) {
                    ProjectScope projectScope_relationship = (ProjectScope)relationship;
                    ProjectsImpactingAssetsReference projectsImpactingAssetsReference = new ProjectsImpactingAssetsReference(entityGuid, projectScope_relationship);
                    if (this.projectsImpactingAssets == null) {
                        this.projectsImpactingAssets = new HashSet<ProjectsImpactingAssetsReference>();
                    }
                    this.projectsImpactingAssets.add(projectsImpactingAssetsReference);
                }
                if ("relatedMedia".equals(referenceName)) {
                    MediaReference mediaReference_relationship = (MediaReference)relationship;
                    RelatedMediaReference relatedMediaReference = new RelatedMediaReference(entityGuid, mediaReference_relationship);
                    if (this.relatedMedia == null) {
                        this.relatedMedia = new HashSet<RelatedMediaReference>();
                    }
                    this.relatedMedia.add(relatedMediaReference);
                }
                if ("supportingVirtualConnections".equals(referenceName)) {
                    embeddedConnection_relationship = (EmbeddedConnection)relationship;
                    SupportingVirtualConnectionsReference supportingVirtualConnectionsReference = new SupportingVirtualConnectionsReference(entityGuid, embeddedConnection_relationship);
                    if (this.supportingVirtualConnections == null) {
                        this.supportingVirtualConnections = new HashSet<SupportingVirtualConnectionsReference>();
                    }
                    this.supportingVirtualConnections.add(supportingVirtualConnectionsReference);
                }
                if ("todos".equals(referenceName)) {
                    ToDoOnReferenceable toDoOnReferenceable_relationship = (ToDoOnReferenceable)relationship;
                    TodosReference todosReference = new TodosReference(entityGuid, toDoOnReferenceable_relationship);
                    if (this.todos == null) {
                        this.todos = new HashSet<TodosReference>();
                    }
                    this.todos.add(todosReference);
                }
                if ("meetings".equals(referenceName)) {
                    MeetingOnReferenceable meetingOnReferenceable_relationship = (MeetingOnReferenceable)relationship;
                    MeetingsReference meetingsReference = new MeetingsReference(entityGuid, meetingOnReferenceable_relationship);
                    if (this.meetings == null) {
                        this.meetings = new HashSet<MeetingsReference>();
                    }
                    this.meetings.add(meetingsReference);
                }
                if ("foundInCollections".equals(referenceName)) {
                    CollectionMember collectionMember_relationship = (CollectionMember)relationship;
                    FoundInCollectionsReference foundInCollectionsReference = new FoundInCollectionsReference(entityGuid, collectionMember_relationship);
                    if (this.foundInCollections == null) {
                        this.foundInCollections = new HashSet<FoundInCollectionsReference>();
                    }
                    this.foundInCollections.add(foundInCollectionsReference);
                }
                if ("certifications".equals(referenceName)) {
                    Certification certification_relationship = (Certification)relationship;
                    CertificationsReference certificationsReference = new CertificationsReference(entityGuid, certification_relationship);
                    if (this.certifications == null) {
                        this.certifications = new HashSet<CertificationsReference>();
                    }
                    this.certifications.add(certificationsReference);
                }
                if ("licenses".equals(referenceName)) {
                    License license_relationship = (License)relationship;
                    LicensesReference licensesReference = new LicensesReference(entityGuid, license_relationship);
                    if (this.licenses == null) {
                        this.licenses = new HashSet<LicensesReference>();
                    }
                    this.licenses.add(licensesReference);
                }
                if ("managedResources".equals(referenceName)) {
                    ExternalIdScope externalIdScope_relationship = (ExternalIdScope)relationship;
                    ManagedResourcesReference managedResourcesReference = new ManagedResourcesReference(entityGuid, externalIdScope_relationship);
                    if (this.managedResources == null) {
                        this.managedResources = new HashSet<ManagedResourcesReference>();
                    }
                    this.managedResources.add(managedResourcesReference);
                }
                if ("facets".equals(referenceName)) {
                    ReferenceableFacet referenceableFacet_relationship = (ReferenceableFacet)relationship;
                    FacetsReference facetsReference = new FacetsReference(entityGuid, referenceableFacet_relationship);
                    if (this.facets == null) {
                        this.facets = new HashSet<FacetsReference>();
                    }
                    this.facets.add(facetsReference);
                }
                if ("alsoKnownAs".equals(referenceName)) {
                    ExternalIdLink externalIdLink_relationship = (ExternalIdLink)relationship;
                    AlsoKnownAsReference alsoKnownAsReference = new AlsoKnownAsReference(entityGuid, externalIdLink_relationship);
                    if (this.alsoKnownAs == null) {
                        this.alsoKnownAs = new HashSet<AlsoKnownAsReference>();
                    }
                    this.alsoKnownAs.add(alsoKnownAsReference);
                }
                if ("contributors".equals(referenceName)) {
                    Contributor contributor_relationship = (Contributor)relationship;
                    ContributorsReference contributorsReference = new ContributorsReference(entityGuid, contributor_relationship);
                    if (this.contributors == null) {
                        this.contributors = new HashSet<ContributorsReference>();
                    }
                    this.contributors.add(contributorsReference);
                }
                if ("actions".equals(referenceName)) {
                    ToDoSource toDoSource_relationship = (ToDoSource)relationship;
                    ActionsReference actionsReference = new ActionsReference(entityGuid, toDoSource_relationship);
                    if (this.actions == null) {
                        this.actions = new HashSet<ActionsReference>();
                    }
                    this.actions.add(actionsReference);
                }
                if ("starRatings".equals(referenceName)) {
                    AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                    StarRatingsReference starRatingsReference = new StarRatingsReference(entityGuid, attachedRating_relationship);
                    if (this.starRatings == null) {
                        this.starRatings = new HashSet<StarRatingsReference>();
                    }
                    this.starRatings.add(starRatingsReference);
                }
                if ("projectUse".equals(referenceName)) {
                    ProjectResources projectResources_relationship = (ProjectResources)relationship;
                    ProjectUseReference projectUseReference = new ProjectUseReference(entityGuid, projectResources_relationship);
                    if (this.projectUse == null) {
                        this.projectUse = new HashSet<ProjectUseReference>();
                    }
                    this.projectUse.add(projectUseReference);
                }
                if ("meaning".equals(referenceName)) {
                    SemanticAssignment semanticAssignment_relationship = (SemanticAssignment)relationship;
                    MeaningReference meaningReference = new MeaningReference(entityGuid, semanticAssignment_relationship);
                    if (this.meaning == null) {
                        this.meaning = new HashSet<MeaningReference>();
                    }
                    this.meaning.add(meaningReference);
                }
                if ("asset".equals(referenceName)) {
                    ConnectionToAsset connectionToAsset_relationship = (ConnectionToAsset)relationship;
                    this.asset = new AssetReference(entityGuid, connectionToAsset_relationship);
                }
                if ("connectorType".equals(referenceName)) {
                    ConnectionConnectorType connectionConnectorType_relationship = (ConnectionConnectorType)relationship;
                    this.connectorType = new ConnectorTypeReference(entityGuid, connectionConnectorType_relationship);
                }
                if (!"connectionEndpoint".equals(referenceName)) continue;
                ConnectionEndpoint connectionEndpoint_relationship = (ConnectionEndpoint)relationship;
                this.connectionEndpoint = new ConnectionEndpointReference(entityGuid, connectionEndpoint_relationship);
            }
        }
    }

    public AssetReference getAssetReference() {
        return this.asset;
    }

    public void setAssetReference(AssetReference asset) {
        this.asset = asset;
    }

    public ConnectorTypeReference getConnectorTypeReference() {
        return this.connectorType;
    }

    public void setConnectorTypeReference(ConnectorTypeReference connectorType) {
        this.connectorType = connectorType;
    }

    public ConnectionEndpointReference getConnectionEndpointReference() {
        return this.connectionEndpoint;
    }

    public void setConnectionEndpointReference(ConnectionEndpointReference connectionEndpoint) {
        this.connectionEndpoint = connectionEndpoint;
    }

    public Set<EmbeddedConnectionsReference> getEmbeddedConnectionsReferences() {
        return this.embeddedConnections;
    }

    public void setEmbeddedConnectionsReferences(Set<EmbeddedConnectionsReference> embeddedConnections) {
        this.embeddedConnections = embeddedConnections;
    }

    public Set<CommunityUsesReference> getCommunityUsesReferences() {
        return this.communityUses;
    }

    public void setCommunityUsesReferences(Set<CommunityUsesReference> communityUses) {
        this.communityUses = communityUses;
    }

    public Set<StaffReference> getStaffReferences() {
        return this.staff;
    }

    public void setStaffReferences(Set<StaffReference> staff) {
        this.staff = staff;
    }

    public Set<NoteLogsReference> getNoteLogsReferences() {
        return this.noteLogs;
    }

    public void setNoteLogsReferences(Set<NoteLogsReference> noteLogs) {
        this.noteLogs = noteLogs;
    }

    public Set<TagsReference> getTagsReferences() {
        return this.tags;
    }

    public void setTagsReferences(Set<TagsReference> tags) {
        this.tags = tags;
    }

    public Set<CommentsReference> getCommentsReferences() {
        return this.comments;
    }

    public void setCommentsReferences(Set<CommentsReference> comments) {
        this.comments = comments;
    }

    public Set<LikesReference> getLikesReferences() {
        return this.likes;
    }

    public void setLikesReferences(Set<LikesReference> likes) {
        this.likes = likes;
    }

    public Set<ExternalReferenceReference> getExternalReferenceReferences() {
        return this.externalReference;
    }

    public void setExternalReferenceReferences(Set<ExternalReferenceReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Set<ProjectsImpactingAssetsReference> getProjectsImpactingAssetsReferences() {
        return this.projectsImpactingAssets;
    }

    public void setProjectsImpactingAssetsReferences(Set<ProjectsImpactingAssetsReference> projectsImpactingAssets) {
        this.projectsImpactingAssets = projectsImpactingAssets;
    }

    public Set<RelatedMediaReference> getRelatedMediaReferences() {
        return this.relatedMedia;
    }

    public void setRelatedMediaReferences(Set<RelatedMediaReference> relatedMedia) {
        this.relatedMedia = relatedMedia;
    }

    public Set<SupportingVirtualConnectionsReference> getSupportingVirtualConnectionsReferences() {
        return this.supportingVirtualConnections;
    }

    public void setSupportingVirtualConnectionsReferences(Set<SupportingVirtualConnectionsReference> supportingVirtualConnections) {
        this.supportingVirtualConnections = supportingVirtualConnections;
    }

    public Set<TodosReference> getTodosReferences() {
        return this.todos;
    }

    public void setTodosReferences(Set<TodosReference> todos) {
        this.todos = todos;
    }

    public Set<MeetingsReference> getMeetingsReferences() {
        return this.meetings;
    }

    public void setMeetingsReferences(Set<MeetingsReference> meetings) {
        this.meetings = meetings;
    }

    public Set<FoundInCollectionsReference> getFoundInCollectionsReferences() {
        return this.foundInCollections;
    }

    public void setFoundInCollectionsReferences(Set<FoundInCollectionsReference> foundInCollections) {
        this.foundInCollections = foundInCollections;
    }

    public Set<CertificationsReference> getCertificationsReferences() {
        return this.certifications;
    }

    public void setCertificationsReferences(Set<CertificationsReference> certifications) {
        this.certifications = certifications;
    }

    public Set<LicensesReference> getLicensesReferences() {
        return this.licenses;
    }

    public void setLicensesReferences(Set<LicensesReference> licenses) {
        this.licenses = licenses;
    }

    public Set<ManagedResourcesReference> getManagedResourcesReferences() {
        return this.managedResources;
    }

    public void setManagedResourcesReferences(Set<ManagedResourcesReference> managedResources) {
        this.managedResources = managedResources;
    }

    public Set<FacetsReference> getFacetsReferences() {
        return this.facets;
    }

    public void setFacetsReferences(Set<FacetsReference> facets) {
        this.facets = facets;
    }

    public Set<AlsoKnownAsReference> getAlsoKnownAsReferences() {
        return this.alsoKnownAs;
    }

    public void setAlsoKnownAsReferences(Set<AlsoKnownAsReference> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public Set<ContributorsReference> getContributorsReferences() {
        return this.contributors;
    }

    public void setContributorsReferences(Set<ContributorsReference> contributors) {
        this.contributors = contributors;
    }

    public Set<ActionsReference> getActionsReferences() {
        return this.actions;
    }

    public void setActionsReferences(Set<ActionsReference> actions) {
        this.actions = actions;
    }

    public Set<StarRatingsReference> getStarRatingsReferences() {
        return this.starRatings;
    }

    public void setStarRatingsReferences(Set<StarRatingsReference> starRatings) {
        this.starRatings = starRatings;
    }

    public Set<ProjectUseReference> getProjectUseReferences() {
        return this.projectUse;
    }

    public void setProjectUseReferences(Set<ProjectUseReference> projectUse) {
        this.projectUse = projectUse;
    }

    public Set<MeaningReference> getMeaningReferences() {
        return this.meaning;
    }

    public void setMeaningReferences(Set<MeaningReference> meaning) {
        this.meaning = meaning;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("VirtualConnectionReferences{");
        sb.append("embeddedConnectionsReference='").append(this.embeddedConnections.toString());
        sb.append("communityUsesReference='").append(this.communityUses.toString());
        sb.append("staffReference='").append(this.staff.toString());
        sb.append("noteLogsReference='").append(this.noteLogs.toString());
        sb.append("tagsReference='").append(this.tags.toString());
        sb.append("commentsReference='").append(this.comments.toString());
        sb.append("likesReference='").append(this.likes.toString());
        sb.append("externalReferenceReference='").append(this.externalReference.toString());
        sb.append("projectsImpactingAssetsReference='").append(this.projectsImpactingAssets.toString());
        sb.append("relatedMediaReference='").append(this.relatedMedia.toString());
        sb.append("supportingVirtualConnectionsReference='").append(this.supportingVirtualConnections.toString());
        sb.append("todosReference='").append(this.todos.toString());
        sb.append("meetingsReference='").append(this.meetings.toString());
        sb.append("foundInCollectionsReference='").append(this.foundInCollections.toString());
        sb.append("certificationsReference='").append(this.certifications.toString());
        sb.append("licensesReference='").append(this.licenses.toString());
        sb.append("managedResourcesReference='").append(this.managedResources.toString());
        sb.append("facetsReference='").append(this.facets.toString());
        sb.append("alsoKnownAsReference='").append(this.alsoKnownAs.toString());
        sb.append("contributorsReference='").append(this.contributors.toString());
        sb.append("actionsReference='").append(this.actions.toString());
        sb.append("starRatingsReference='").append(this.starRatings.toString());
        sb.append("projectUseReference='").append(this.projectUse.toString());
        sb.append("meaningReference='").append(this.meaning.toString());
        sb.append("assetReference='").append(this.asset.toString());
        sb.append("connectorTypeReference='").append(this.connectorType.toString());
        sb.append("connectionEndpointReference='").append(this.connectionEndpoint.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VirtualConnectionReferences typedThat = (VirtualConnectionReferences)o;
        if (this.embeddedConnections != null && !Objects.equals(this.embeddedConnections, typedThat.embeddedConnections)) {
            return false;
        }
        if (this.communityUses != null && !Objects.equals(this.communityUses, typedThat.communityUses)) {
            return false;
        }
        if (this.staff != null && !Objects.equals(this.staff, typedThat.staff)) {
            return false;
        }
        if (this.noteLogs != null && !Objects.equals(this.noteLogs, typedThat.noteLogs)) {
            return false;
        }
        if (this.tags != null && !Objects.equals(this.tags, typedThat.tags)) {
            return false;
        }
        if (this.asset != null && !Objects.equals(this.asset, typedThat.asset)) {
            return false;
        }
        if (this.comments != null && !Objects.equals(this.comments, typedThat.comments)) {
            return false;
        }
        if (this.likes != null && !Objects.equals(this.likes, typedThat.likes)) {
            return false;
        }
        if (this.externalReference != null && !Objects.equals(this.externalReference, typedThat.externalReference)) {
            return false;
        }
        if (this.projectsImpactingAssets != null && !Objects.equals(this.projectsImpactingAssets, typedThat.projectsImpactingAssets)) {
            return false;
        }
        if (this.relatedMedia != null && !Objects.equals(this.relatedMedia, typedThat.relatedMedia)) {
            return false;
        }
        if (this.connectorType != null && !Objects.equals(this.connectorType, typedThat.connectorType)) {
            return false;
        }
        if (this.supportingVirtualConnections != null && !Objects.equals(this.supportingVirtualConnections, typedThat.supportingVirtualConnections)) {
            return false;
        }
        if (this.todos != null && !Objects.equals(this.todos, typedThat.todos)) {
            return false;
        }
        if (this.meetings != null && !Objects.equals(this.meetings, typedThat.meetings)) {
            return false;
        }
        if (this.foundInCollections != null && !Objects.equals(this.foundInCollections, typedThat.foundInCollections)) {
            return false;
        }
        if (this.certifications != null && !Objects.equals(this.certifications, typedThat.certifications)) {
            return false;
        }
        if (this.licenses != null && !Objects.equals(this.licenses, typedThat.licenses)) {
            return false;
        }
        if (this.managedResources != null && !Objects.equals(this.managedResources, typedThat.managedResources)) {
            return false;
        }
        if (this.facets != null && !Objects.equals(this.facets, typedThat.facets)) {
            return false;
        }
        if (this.connectionEndpoint != null && !Objects.equals(this.connectionEndpoint, typedThat.connectionEndpoint)) {
            return false;
        }
        if (this.alsoKnownAs != null && !Objects.equals(this.alsoKnownAs, typedThat.alsoKnownAs)) {
            return false;
        }
        if (this.contributors != null && !Objects.equals(this.contributors, typedThat.contributors)) {
            return false;
        }
        if (this.actions != null && !Objects.equals(this.actions, typedThat.actions)) {
            return false;
        }
        if (this.starRatings != null && !Objects.equals(this.starRatings, typedThat.starRatings)) {
            return false;
        }
        if (this.projectUse != null && !Objects.equals(this.projectUse, typedThat.projectUse)) {
            return false;
        }
        if (this.meaning != null && !Objects.equals(this.meaning, typedThat.meaning)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.embeddedConnections, this.communityUses, this.staff, this.noteLogs, this.tags, this.asset, this.comments, this.likes, this.externalReference, this.projectsImpactingAssets, this.relatedMedia, this.connectorType, this.supportingVirtualConnections, this.todos, this.meetings, this.foundInCollections, this.certifications, this.licenses, this.managedResources, this.facets, this.connectionEndpoint, this.alsoKnownAs, this.contributors, this.actions, this.starRatings, this.projectUse, this.meaning);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

