/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.VirtualContainer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToConnection.ConnectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToDataSet.SupportedDataSetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToGovernanceZone.ZonesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToSchemaType.SchemaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToSoftwareServerCapability.ConsumedByReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToHostCluster.HostClusterReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToLocation.LocationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToNetwork.NetworkConnectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToOperatingPlatform.PlatformReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToSoftwareServer.DeployedServersReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.HostToVirtualContainer.HostedContainersReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToActorProfile.ContributorsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCertificationType.CertificationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCollection.FoundInCollectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToComment.CommentsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCommunity.CommunityUsesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.AlsoKnownAsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.ManagedResourcesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalReference.ExternalReferenceReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToGlossaryTerm.MeaningReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToInformalTag.TagsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLicenseType.LicensesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLike.LikesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToMeeting.MeetingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToNoteLog.NoteLogsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPerson.StaffReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ProjectUseReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ProjectsImpactingAssetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPropertyFacet.FacetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRating.StarRatingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.ActionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.TodosReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.VirtualContainerToHost.HostsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetSchemaType.AssetSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetServerUse.AssetServerUse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CollectionMember.CollectionMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityResources.CommunityResources;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAsset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Contributor.Contributor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DataContentForDataSet.DataContentForDataSet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DeployedVirtualContainer.DeployedVirtualContainer;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostClusterMember.HostClusterMember;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostLocation.HostLocation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostNetwork.HostNetwork;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.HostOperatingPlatform.HostOperatingPlatform;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MeetingOnReferenceable.MeetingOnReferenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectResources.ProjectResources;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ServerDeployment.ServerDeployment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.StaffAssignment.StaffAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoOnReferenceable.ToDoOnReferenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ZoneMembership.ZoneMembership;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VirtualContainerReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(VirtualContainerReferences.class);
    private static final String className = VirtualContainerReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"hosts", "hostCluster", "networkConnections", "hostedContainers", "platform", "deployedServers", "locations", "communityUses", "staff", "supportedDataSets", "noteLogs", "tags", "comments", "zones", "likes", "connections", "externalReference", "projectsImpactingAssets", "relatedMedia", "schema", "todos", "meetings", "foundInCollections", "certifications", "licenses", "managedResources", "facets", "alsoKnownAs", "contributors", "actions", "starRatings", "projectUse", "meaning", "consumedBy", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"DeployedVirtualContainer", "HostClusterMember", "HostNetwork", "DeployedVirtualContainer", "HostOperatingPlatform", "ServerDeployment", "HostLocation", "CommunityResources", "StaffAssignment", "DataContentForDataSet", "AttachedNoteLog", "AttachedTag", "AttachedComment", "ZoneMembership", "AttachedLike", "ConnectionToAsset", "ExternalReferenceLink", "ProjectScope", "MediaReference", "AssetSchemaType", "ToDoOnReferenceable", "MeetingOnReferenceable", "CollectionMember", "Certification", "License", "ExternalIdScope", "ReferenceableFacet", "ExternalIdLink", "Contributor", "ToDoSource", "AttachedRating", "ProjectResources", "SemanticAssignment", "AssetServerUse", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private PlatformReference platform;
    private SchemaReference schema;
    private Set<HostsReference> hosts;
    private Set<HostClusterReference> hostCluster;
    private Set<NetworkConnectionsReference> networkConnections;
    private Set<HostedContainersReference> hostedContainers;
    private Set<DeployedServersReference> deployedServers;
    private Set<LocationsReference> locations;
    private Set<CommunityUsesReference> communityUses;
    private Set<StaffReference> staff;
    private Set<SupportedDataSetsReference> supportedDataSets;
    private Set<NoteLogsReference> noteLogs;
    private Set<TagsReference> tags;
    private Set<CommentsReference> comments;
    private Set<ZonesReference> zones;
    private Set<LikesReference> likes;
    private Set<ConnectionsReference> connections;
    private Set<ExternalReferenceReference> externalReference;
    private Set<ProjectsImpactingAssetsReference> projectsImpactingAssets;
    private Set<RelatedMediaReference> relatedMedia;
    private Set<TodosReference> todos;
    private Set<MeetingsReference> meetings;
    private Set<FoundInCollectionsReference> foundInCollections;
    private Set<CertificationsReference> certifications;
    private Set<LicensesReference> licenses;
    private Set<ManagedResourcesReference> managedResources;
    private Set<FacetsReference> facets;
    private Set<AlsoKnownAsReference> alsoKnownAs;
    private Set<ContributorsReference> contributors;
    private Set<ActionsReference> actions;
    private Set<StarRatingsReference> starRatings;
    private Set<ProjectUseReference> projectUse;
    private Set<MeaningReference> meaning;
    private Set<ConsumedByReference> consumedBy;

    public VirtualContainerReferences(String entityGuid, List<Line> lines) throws InvalidParameterException {
        for (Line relationship : lines) {
            for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                DeployedVirtualContainer deployedVirtualContainer_relationship;
                if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i])) continue;
                String referenceName = REFERENCE_NAMES_SET_VALUES[i];
                if ("hosts".equals(referenceName)) {
                    deployedVirtualContainer_relationship = (DeployedVirtualContainer)relationship;
                    HostsReference hostsReference = new HostsReference(entityGuid, deployedVirtualContainer_relationship);
                    if (this.hosts == null) {
                        this.hosts = new HashSet<HostsReference>();
                    }
                    this.hosts.add(hostsReference);
                }
                if ("hostCluster".equals(referenceName)) {
                    HostClusterMember hostClusterMember_relationship = (HostClusterMember)relationship;
                    HostClusterReference hostClusterReference = new HostClusterReference(entityGuid, hostClusterMember_relationship);
                    if (this.hostCluster == null) {
                        this.hostCluster = new HashSet<HostClusterReference>();
                    }
                    this.hostCluster.add(hostClusterReference);
                }
                if ("networkConnections".equals(referenceName)) {
                    HostNetwork hostNetwork_relationship = (HostNetwork)relationship;
                    NetworkConnectionsReference networkConnectionsReference = new NetworkConnectionsReference(entityGuid, hostNetwork_relationship);
                    if (this.networkConnections == null) {
                        this.networkConnections = new HashSet<NetworkConnectionsReference>();
                    }
                    this.networkConnections.add(networkConnectionsReference);
                }
                if ("hostedContainers".equals(referenceName)) {
                    deployedVirtualContainer_relationship = (DeployedVirtualContainer)relationship;
                    HostedContainersReference hostedContainersReference = new HostedContainersReference(entityGuid, deployedVirtualContainer_relationship);
                    if (this.hostedContainers == null) {
                        this.hostedContainers = new HashSet<HostedContainersReference>();
                    }
                    this.hostedContainers.add(hostedContainersReference);
                }
                if ("deployedServers".equals(referenceName)) {
                    ServerDeployment serverDeployment_relationship = (ServerDeployment)relationship;
                    DeployedServersReference deployedServersReference = new DeployedServersReference(entityGuid, serverDeployment_relationship);
                    if (this.deployedServers == null) {
                        this.deployedServers = new HashSet<DeployedServersReference>();
                    }
                    this.deployedServers.add(deployedServersReference);
                }
                if ("locations".equals(referenceName)) {
                    HostLocation hostLocation_relationship = (HostLocation)relationship;
                    LocationsReference locationsReference = new LocationsReference(entityGuid, hostLocation_relationship);
                    if (this.locations == null) {
                        this.locations = new HashSet<LocationsReference>();
                    }
                    this.locations.add(locationsReference);
                }
                if ("communityUses".equals(referenceName)) {
                    CommunityResources communityResources_relationship = (CommunityResources)relationship;
                    CommunityUsesReference communityUsesReference = new CommunityUsesReference(entityGuid, communityResources_relationship);
                    if (this.communityUses == null) {
                        this.communityUses = new HashSet<CommunityUsesReference>();
                    }
                    this.communityUses.add(communityUsesReference);
                }
                if ("staff".equals(referenceName)) {
                    StaffAssignment staffAssignment_relationship = (StaffAssignment)relationship;
                    StaffReference staffReference = new StaffReference(entityGuid, staffAssignment_relationship);
                    if (this.staff == null) {
                        this.staff = new HashSet<StaffReference>();
                    }
                    this.staff.add(staffReference);
                }
                if ("supportedDataSets".equals(referenceName)) {
                    DataContentForDataSet dataContentForDataSet_relationship = (DataContentForDataSet)relationship;
                    SupportedDataSetsReference supportedDataSetsReference = new SupportedDataSetsReference(entityGuid, dataContentForDataSet_relationship);
                    if (this.supportedDataSets == null) {
                        this.supportedDataSets = new HashSet<SupportedDataSetsReference>();
                    }
                    this.supportedDataSets.add(supportedDataSetsReference);
                }
                if ("noteLogs".equals(referenceName)) {
                    AttachedNoteLog attachedNoteLog_relationship = (AttachedNoteLog)relationship;
                    NoteLogsReference noteLogsReference = new NoteLogsReference(entityGuid, attachedNoteLog_relationship);
                    if (this.noteLogs == null) {
                        this.noteLogs = new HashSet<NoteLogsReference>();
                    }
                    this.noteLogs.add(noteLogsReference);
                }
                if ("tags".equals(referenceName)) {
                    AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                    TagsReference tagsReference = new TagsReference(entityGuid, attachedTag_relationship);
                    if (this.tags == null) {
                        this.tags = new HashSet<TagsReference>();
                    }
                    this.tags.add(tagsReference);
                }
                if ("comments".equals(referenceName)) {
                    AttachedComment attachedComment_relationship = (AttachedComment)relationship;
                    CommentsReference commentsReference = new CommentsReference(entityGuid, attachedComment_relationship);
                    if (this.comments == null) {
                        this.comments = new HashSet<CommentsReference>();
                    }
                    this.comments.add(commentsReference);
                }
                if ("zones".equals(referenceName)) {
                    ZoneMembership zoneMembership_relationship = (ZoneMembership)relationship;
                    ZonesReference zonesReference = new ZonesReference(entityGuid, zoneMembership_relationship);
                    if (this.zones == null) {
                        this.zones = new HashSet<ZonesReference>();
                    }
                    this.zones.add(zonesReference);
                }
                if ("likes".equals(referenceName)) {
                    AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                    LikesReference likesReference = new LikesReference(entityGuid, attachedLike_relationship);
                    if (this.likes == null) {
                        this.likes = new HashSet<LikesReference>();
                    }
                    this.likes.add(likesReference);
                }
                if ("connections".equals(referenceName)) {
                    ConnectionToAsset connectionToAsset_relationship = (ConnectionToAsset)relationship;
                    ConnectionsReference connectionsReference = new ConnectionsReference(entityGuid, connectionToAsset_relationship);
                    if (this.connections == null) {
                        this.connections = new HashSet<ConnectionsReference>();
                    }
                    this.connections.add(connectionsReference);
                }
                if ("externalReference".equals(referenceName)) {
                    ExternalReferenceLink externalReferenceLink_relationship = (ExternalReferenceLink)relationship;
                    ExternalReferenceReference externalReferenceReference = new ExternalReferenceReference(entityGuid, externalReferenceLink_relationship);
                    if (this.externalReference == null) {
                        this.externalReference = new HashSet<ExternalReferenceReference>();
                    }
                    this.externalReference.add(externalReferenceReference);
                }
                if ("projectsImpactingAssets".equals(referenceName)) {
                    ProjectScope projectScope_relationship = (ProjectScope)relationship;
                    ProjectsImpactingAssetsReference projectsImpactingAssetsReference = new ProjectsImpactingAssetsReference(entityGuid, projectScope_relationship);
                    if (this.projectsImpactingAssets == null) {
                        this.projectsImpactingAssets = new HashSet<ProjectsImpactingAssetsReference>();
                    }
                    this.projectsImpactingAssets.add(projectsImpactingAssetsReference);
                }
                if ("relatedMedia".equals(referenceName)) {
                    MediaReference mediaReference_relationship = (MediaReference)relationship;
                    RelatedMediaReference relatedMediaReference = new RelatedMediaReference(entityGuid, mediaReference_relationship);
                    if (this.relatedMedia == null) {
                        this.relatedMedia = new HashSet<RelatedMediaReference>();
                    }
                    this.relatedMedia.add(relatedMediaReference);
                }
                if ("todos".equals(referenceName)) {
                    ToDoOnReferenceable toDoOnReferenceable_relationship = (ToDoOnReferenceable)relationship;
                    TodosReference todosReference = new TodosReference(entityGuid, toDoOnReferenceable_relationship);
                    if (this.todos == null) {
                        this.todos = new HashSet<TodosReference>();
                    }
                    this.todos.add(todosReference);
                }
                if ("meetings".equals(referenceName)) {
                    MeetingOnReferenceable meetingOnReferenceable_relationship = (MeetingOnReferenceable)relationship;
                    MeetingsReference meetingsReference = new MeetingsReference(entityGuid, meetingOnReferenceable_relationship);
                    if (this.meetings == null) {
                        this.meetings = new HashSet<MeetingsReference>();
                    }
                    this.meetings.add(meetingsReference);
                }
                if ("foundInCollections".equals(referenceName)) {
                    CollectionMember collectionMember_relationship = (CollectionMember)relationship;
                    FoundInCollectionsReference foundInCollectionsReference = new FoundInCollectionsReference(entityGuid, collectionMember_relationship);
                    if (this.foundInCollections == null) {
                        this.foundInCollections = new HashSet<FoundInCollectionsReference>();
                    }
                    this.foundInCollections.add(foundInCollectionsReference);
                }
                if ("certifications".equals(referenceName)) {
                    Certification certification_relationship = (Certification)relationship;
                    CertificationsReference certificationsReference = new CertificationsReference(entityGuid, certification_relationship);
                    if (this.certifications == null) {
                        this.certifications = new HashSet<CertificationsReference>();
                    }
                    this.certifications.add(certificationsReference);
                }
                if ("licenses".equals(referenceName)) {
                    License license_relationship = (License)relationship;
                    LicensesReference licensesReference = new LicensesReference(entityGuid, license_relationship);
                    if (this.licenses == null) {
                        this.licenses = new HashSet<LicensesReference>();
                    }
                    this.licenses.add(licensesReference);
                }
                if ("managedResources".equals(referenceName)) {
                    ExternalIdScope externalIdScope_relationship = (ExternalIdScope)relationship;
                    ManagedResourcesReference managedResourcesReference = new ManagedResourcesReference(entityGuid, externalIdScope_relationship);
                    if (this.managedResources == null) {
                        this.managedResources = new HashSet<ManagedResourcesReference>();
                    }
                    this.managedResources.add(managedResourcesReference);
                }
                if ("facets".equals(referenceName)) {
                    ReferenceableFacet referenceableFacet_relationship = (ReferenceableFacet)relationship;
                    FacetsReference facetsReference = new FacetsReference(entityGuid, referenceableFacet_relationship);
                    if (this.facets == null) {
                        this.facets = new HashSet<FacetsReference>();
                    }
                    this.facets.add(facetsReference);
                }
                if ("alsoKnownAs".equals(referenceName)) {
                    ExternalIdLink externalIdLink_relationship = (ExternalIdLink)relationship;
                    AlsoKnownAsReference alsoKnownAsReference = new AlsoKnownAsReference(entityGuid, externalIdLink_relationship);
                    if (this.alsoKnownAs == null) {
                        this.alsoKnownAs = new HashSet<AlsoKnownAsReference>();
                    }
                    this.alsoKnownAs.add(alsoKnownAsReference);
                }
                if ("contributors".equals(referenceName)) {
                    Contributor contributor_relationship = (Contributor)relationship;
                    ContributorsReference contributorsReference = new ContributorsReference(entityGuid, contributor_relationship);
                    if (this.contributors == null) {
                        this.contributors = new HashSet<ContributorsReference>();
                    }
                    this.contributors.add(contributorsReference);
                }
                if ("actions".equals(referenceName)) {
                    ToDoSource toDoSource_relationship = (ToDoSource)relationship;
                    ActionsReference actionsReference = new ActionsReference(entityGuid, toDoSource_relationship);
                    if (this.actions == null) {
                        this.actions = new HashSet<ActionsReference>();
                    }
                    this.actions.add(actionsReference);
                }
                if ("starRatings".equals(referenceName)) {
                    AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                    StarRatingsReference starRatingsReference = new StarRatingsReference(entityGuid, attachedRating_relationship);
                    if (this.starRatings == null) {
                        this.starRatings = new HashSet<StarRatingsReference>();
                    }
                    this.starRatings.add(starRatingsReference);
                }
                if ("projectUse".equals(referenceName)) {
                    ProjectResources projectResources_relationship = (ProjectResources)relationship;
                    ProjectUseReference projectUseReference = new ProjectUseReference(entityGuid, projectResources_relationship);
                    if (this.projectUse == null) {
                        this.projectUse = new HashSet<ProjectUseReference>();
                    }
                    this.projectUse.add(projectUseReference);
                }
                if ("meaning".equals(referenceName)) {
                    SemanticAssignment semanticAssignment_relationship = (SemanticAssignment)relationship;
                    MeaningReference meaningReference = new MeaningReference(entityGuid, semanticAssignment_relationship);
                    if (this.meaning == null) {
                        this.meaning = new HashSet<MeaningReference>();
                    }
                    this.meaning.add(meaningReference);
                }
                if ("consumedBy".equals(referenceName)) {
                    AssetServerUse assetServerUse_relationship = (AssetServerUse)relationship;
                    ConsumedByReference consumedByReference = new ConsumedByReference(entityGuid, assetServerUse_relationship);
                    if (this.consumedBy == null) {
                        this.consumedBy = new HashSet<ConsumedByReference>();
                    }
                    this.consumedBy.add(consumedByReference);
                }
                if ("platform".equals(referenceName)) {
                    HostOperatingPlatform hostOperatingPlatform_relationship = (HostOperatingPlatform)relationship;
                    this.platform = new PlatformReference(entityGuid, hostOperatingPlatform_relationship);
                }
                if (!"schema".equals(referenceName)) continue;
                AssetSchemaType assetSchemaType_relationship = (AssetSchemaType)relationship;
                this.schema = new SchemaReference(entityGuid, assetSchemaType_relationship);
            }
        }
    }

    public PlatformReference getPlatformReference() {
        return this.platform;
    }

    public void setPlatformReference(PlatformReference platform) {
        this.platform = platform;
    }

    public SchemaReference getSchemaReference() {
        return this.schema;
    }

    public void setSchemaReference(SchemaReference schema) {
        this.schema = schema;
    }

    public Set<HostsReference> getHostsReferences() {
        return this.hosts;
    }

    public void setHostsReferences(Set<HostsReference> hosts) {
        this.hosts = hosts;
    }

    public Set<HostClusterReference> getHostClusterReferences() {
        return this.hostCluster;
    }

    public void setHostClusterReferences(Set<HostClusterReference> hostCluster) {
        this.hostCluster = hostCluster;
    }

    public Set<NetworkConnectionsReference> getNetworkConnectionsReferences() {
        return this.networkConnections;
    }

    public void setNetworkConnectionsReferences(Set<NetworkConnectionsReference> networkConnections) {
        this.networkConnections = networkConnections;
    }

    public Set<HostedContainersReference> getHostedContainersReferences() {
        return this.hostedContainers;
    }

    public void setHostedContainersReferences(Set<HostedContainersReference> hostedContainers) {
        this.hostedContainers = hostedContainers;
    }

    public Set<DeployedServersReference> getDeployedServersReferences() {
        return this.deployedServers;
    }

    public void setDeployedServersReferences(Set<DeployedServersReference> deployedServers) {
        this.deployedServers = deployedServers;
    }

    public Set<LocationsReference> getLocationsReferences() {
        return this.locations;
    }

    public void setLocationsReferences(Set<LocationsReference> locations) {
        this.locations = locations;
    }

    public Set<CommunityUsesReference> getCommunityUsesReferences() {
        return this.communityUses;
    }

    public void setCommunityUsesReferences(Set<CommunityUsesReference> communityUses) {
        this.communityUses = communityUses;
    }

    public Set<StaffReference> getStaffReferences() {
        return this.staff;
    }

    public void setStaffReferences(Set<StaffReference> staff) {
        this.staff = staff;
    }

    public Set<SupportedDataSetsReference> getSupportedDataSetsReferences() {
        return this.supportedDataSets;
    }

    public void setSupportedDataSetsReferences(Set<SupportedDataSetsReference> supportedDataSets) {
        this.supportedDataSets = supportedDataSets;
    }

    public Set<NoteLogsReference> getNoteLogsReferences() {
        return this.noteLogs;
    }

    public void setNoteLogsReferences(Set<NoteLogsReference> noteLogs) {
        this.noteLogs = noteLogs;
    }

    public Set<TagsReference> getTagsReferences() {
        return this.tags;
    }

    public void setTagsReferences(Set<TagsReference> tags) {
        this.tags = tags;
    }

    public Set<CommentsReference> getCommentsReferences() {
        return this.comments;
    }

    public void setCommentsReferences(Set<CommentsReference> comments) {
        this.comments = comments;
    }

    public Set<ZonesReference> getZonesReferences() {
        return this.zones;
    }

    public void setZonesReferences(Set<ZonesReference> zones) {
        this.zones = zones;
    }

    public Set<LikesReference> getLikesReferences() {
        return this.likes;
    }

    public void setLikesReferences(Set<LikesReference> likes) {
        this.likes = likes;
    }

    public Set<ConnectionsReference> getConnectionsReferences() {
        return this.connections;
    }

    public void setConnectionsReferences(Set<ConnectionsReference> connections) {
        this.connections = connections;
    }

    public Set<ExternalReferenceReference> getExternalReferenceReferences() {
        return this.externalReference;
    }

    public void setExternalReferenceReferences(Set<ExternalReferenceReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Set<ProjectsImpactingAssetsReference> getProjectsImpactingAssetsReferences() {
        return this.projectsImpactingAssets;
    }

    public void setProjectsImpactingAssetsReferences(Set<ProjectsImpactingAssetsReference> projectsImpactingAssets) {
        this.projectsImpactingAssets = projectsImpactingAssets;
    }

    public Set<RelatedMediaReference> getRelatedMediaReferences() {
        return this.relatedMedia;
    }

    public void setRelatedMediaReferences(Set<RelatedMediaReference> relatedMedia) {
        this.relatedMedia = relatedMedia;
    }

    public Set<TodosReference> getTodosReferences() {
        return this.todos;
    }

    public void setTodosReferences(Set<TodosReference> todos) {
        this.todos = todos;
    }

    public Set<MeetingsReference> getMeetingsReferences() {
        return this.meetings;
    }

    public void setMeetingsReferences(Set<MeetingsReference> meetings) {
        this.meetings = meetings;
    }

    public Set<FoundInCollectionsReference> getFoundInCollectionsReferences() {
        return this.foundInCollections;
    }

    public void setFoundInCollectionsReferences(Set<FoundInCollectionsReference> foundInCollections) {
        this.foundInCollections = foundInCollections;
    }

    public Set<CertificationsReference> getCertificationsReferences() {
        return this.certifications;
    }

    public void setCertificationsReferences(Set<CertificationsReference> certifications) {
        this.certifications = certifications;
    }

    public Set<LicensesReference> getLicensesReferences() {
        return this.licenses;
    }

    public void setLicensesReferences(Set<LicensesReference> licenses) {
        this.licenses = licenses;
    }

    public Set<ManagedResourcesReference> getManagedResourcesReferences() {
        return this.managedResources;
    }

    public void setManagedResourcesReferences(Set<ManagedResourcesReference> managedResources) {
        this.managedResources = managedResources;
    }

    public Set<FacetsReference> getFacetsReferences() {
        return this.facets;
    }

    public void setFacetsReferences(Set<FacetsReference> facets) {
        this.facets = facets;
    }

    public Set<AlsoKnownAsReference> getAlsoKnownAsReferences() {
        return this.alsoKnownAs;
    }

    public void setAlsoKnownAsReferences(Set<AlsoKnownAsReference> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public Set<ContributorsReference> getContributorsReferences() {
        return this.contributors;
    }

    public void setContributorsReferences(Set<ContributorsReference> contributors) {
        this.contributors = contributors;
    }

    public Set<ActionsReference> getActionsReferences() {
        return this.actions;
    }

    public void setActionsReferences(Set<ActionsReference> actions) {
        this.actions = actions;
    }

    public Set<StarRatingsReference> getStarRatingsReferences() {
        return this.starRatings;
    }

    public void setStarRatingsReferences(Set<StarRatingsReference> starRatings) {
        this.starRatings = starRatings;
    }

    public Set<ProjectUseReference> getProjectUseReferences() {
        return this.projectUse;
    }

    public void setProjectUseReferences(Set<ProjectUseReference> projectUse) {
        this.projectUse = projectUse;
    }

    public Set<MeaningReference> getMeaningReferences() {
        return this.meaning;
    }

    public void setMeaningReferences(Set<MeaningReference> meaning) {
        this.meaning = meaning;
    }

    public Set<ConsumedByReference> getConsumedByReferences() {
        return this.consumedBy;
    }

    public void setConsumedByReferences(Set<ConsumedByReference> consumedBy) {
        this.consumedBy = consumedBy;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("VirtualContainerReferences{");
        sb.append("hostsReference='").append(this.hosts.toString());
        sb.append("hostClusterReference='").append(this.hostCluster.toString());
        sb.append("networkConnectionsReference='").append(this.networkConnections.toString());
        sb.append("hostedContainersReference='").append(this.hostedContainers.toString());
        sb.append("deployedServersReference='").append(this.deployedServers.toString());
        sb.append("locationsReference='").append(this.locations.toString());
        sb.append("communityUsesReference='").append(this.communityUses.toString());
        sb.append("staffReference='").append(this.staff.toString());
        sb.append("supportedDataSetsReference='").append(this.supportedDataSets.toString());
        sb.append("noteLogsReference='").append(this.noteLogs.toString());
        sb.append("tagsReference='").append(this.tags.toString());
        sb.append("commentsReference='").append(this.comments.toString());
        sb.append("zonesReference='").append(this.zones.toString());
        sb.append("likesReference='").append(this.likes.toString());
        sb.append("connectionsReference='").append(this.connections.toString());
        sb.append("externalReferenceReference='").append(this.externalReference.toString());
        sb.append("projectsImpactingAssetsReference='").append(this.projectsImpactingAssets.toString());
        sb.append("relatedMediaReference='").append(this.relatedMedia.toString());
        sb.append("todosReference='").append(this.todos.toString());
        sb.append("meetingsReference='").append(this.meetings.toString());
        sb.append("foundInCollectionsReference='").append(this.foundInCollections.toString());
        sb.append("certificationsReference='").append(this.certifications.toString());
        sb.append("licensesReference='").append(this.licenses.toString());
        sb.append("managedResourcesReference='").append(this.managedResources.toString());
        sb.append("facetsReference='").append(this.facets.toString());
        sb.append("alsoKnownAsReference='").append(this.alsoKnownAs.toString());
        sb.append("contributorsReference='").append(this.contributors.toString());
        sb.append("actionsReference='").append(this.actions.toString());
        sb.append("starRatingsReference='").append(this.starRatings.toString());
        sb.append("projectUseReference='").append(this.projectUse.toString());
        sb.append("meaningReference='").append(this.meaning.toString());
        sb.append("consumedByReference='").append(this.consumedBy.toString());
        sb.append("platformReference='").append(this.platform.toString());
        sb.append("schemaReference='").append(this.schema.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VirtualContainerReferences typedThat = (VirtualContainerReferences)o;
        if (this.hosts != null && !Objects.equals(this.hosts, typedThat.hosts)) {
            return false;
        }
        if (this.hostCluster != null && !Objects.equals(this.hostCluster, typedThat.hostCluster)) {
            return false;
        }
        if (this.networkConnections != null && !Objects.equals(this.networkConnections, typedThat.networkConnections)) {
            return false;
        }
        if (this.hostedContainers != null && !Objects.equals(this.hostedContainers, typedThat.hostedContainers)) {
            return false;
        }
        if (this.platform != null && !Objects.equals(this.platform, typedThat.platform)) {
            return false;
        }
        if (this.deployedServers != null && !Objects.equals(this.deployedServers, typedThat.deployedServers)) {
            return false;
        }
        if (this.locations != null && !Objects.equals(this.locations, typedThat.locations)) {
            return false;
        }
        if (this.communityUses != null && !Objects.equals(this.communityUses, typedThat.communityUses)) {
            return false;
        }
        if (this.staff != null && !Objects.equals(this.staff, typedThat.staff)) {
            return false;
        }
        if (this.supportedDataSets != null && !Objects.equals(this.supportedDataSets, typedThat.supportedDataSets)) {
            return false;
        }
        if (this.noteLogs != null && !Objects.equals(this.noteLogs, typedThat.noteLogs)) {
            return false;
        }
        if (this.tags != null && !Objects.equals(this.tags, typedThat.tags)) {
            return false;
        }
        if (this.comments != null && !Objects.equals(this.comments, typedThat.comments)) {
            return false;
        }
        if (this.zones != null && !Objects.equals(this.zones, typedThat.zones)) {
            return false;
        }
        if (this.likes != null && !Objects.equals(this.likes, typedThat.likes)) {
            return false;
        }
        if (this.connections != null && !Objects.equals(this.connections, typedThat.connections)) {
            return false;
        }
        if (this.externalReference != null && !Objects.equals(this.externalReference, typedThat.externalReference)) {
            return false;
        }
        if (this.projectsImpactingAssets != null && !Objects.equals(this.projectsImpactingAssets, typedThat.projectsImpactingAssets)) {
            return false;
        }
        if (this.relatedMedia != null && !Objects.equals(this.relatedMedia, typedThat.relatedMedia)) {
            return false;
        }
        if (this.schema != null && !Objects.equals(this.schema, typedThat.schema)) {
            return false;
        }
        if (this.todos != null && !Objects.equals(this.todos, typedThat.todos)) {
            return false;
        }
        if (this.meetings != null && !Objects.equals(this.meetings, typedThat.meetings)) {
            return false;
        }
        if (this.foundInCollections != null && !Objects.equals(this.foundInCollections, typedThat.foundInCollections)) {
            return false;
        }
        if (this.certifications != null && !Objects.equals(this.certifications, typedThat.certifications)) {
            return false;
        }
        if (this.licenses != null && !Objects.equals(this.licenses, typedThat.licenses)) {
            return false;
        }
        if (this.managedResources != null && !Objects.equals(this.managedResources, typedThat.managedResources)) {
            return false;
        }
        if (this.facets != null && !Objects.equals(this.facets, typedThat.facets)) {
            return false;
        }
        if (this.alsoKnownAs != null && !Objects.equals(this.alsoKnownAs, typedThat.alsoKnownAs)) {
            return false;
        }
        if (this.contributors != null && !Objects.equals(this.contributors, typedThat.contributors)) {
            return false;
        }
        if (this.actions != null && !Objects.equals(this.actions, typedThat.actions)) {
            return false;
        }
        if (this.starRatings != null && !Objects.equals(this.starRatings, typedThat.starRatings)) {
            return false;
        }
        if (this.projectUse != null && !Objects.equals(this.projectUse, typedThat.projectUse)) {
            return false;
        }
        if (this.meaning != null && !Objects.equals(this.meaning, typedThat.meaning)) {
            return false;
        }
        if (this.consumedBy != null && !Objects.equals(this.consumedBy, typedThat.consumedBy)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hosts, this.hostCluster, this.networkConnections, this.hostedContainers, this.platform, this.deployedServers, this.locations, this.communityUses, this.staff, this.supportedDataSets, this.noteLogs, this.tags, this.comments, this.zones, this.likes, this.connections, this.externalReference, this.projectsImpactingAssets, this.relatedMedia, this.schema, this.todos, this.meetings, this.foundInCollections, this.certifications, this.licenses, this.managedResources, this.facets, this.alsoKnownAs, this.contributors, this.actions, this.starRatings, this.projectUse, this.meaning, this.consumedBy);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

