/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.references.BusinessCapabilityToTeam;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Team.Team;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Reference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SupportingTeamsReference
extends Reference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SupportingTeamsReference.class);
    private static final String className = SupportingTeamsReference.class.getName();
    protected String relationship_Type = "OrganizationalCapability";
    protected String name = "supportingTeams";
    protected Team team = null;

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public SupportingTeamsReference() {
        this(null, null, null);
    }

    public SupportingTeamsReference(String guid) {
        this(guid, null, null);
    }

    public SupportingTeamsReference(String guid, String relatedEndType) {
        this(guid, relatedEndType, null);
    }

    public SupportingTeamsReference(String relatedEndType, Map<String, Object> uniqueAttributes) {
        this(null, relatedEndType, uniqueAttributes);
    }

    public SupportingTeamsReference(String relatedEndType, final String attrName, final Object attrValue) {
        this(null, relatedEndType, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(attrName, attrValue);
            }
        });
    }

    public SupportingTeamsReference(String guid, String relatedEndType, Map<String, Object> uniqueAttributes) {
        this.setRelationshipGuid(guid);
        this.setRelatedEndType(relatedEndType);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public SupportingTeamsReference(Reference other) {
        if (other != null) {
            this.setRelationshipGuid(other.getRelationshipGuid());
            this.setRelatedEndGuid(other.getRelatedEndGuid());
            this.setRelatedEndType(other.getRelatedEndType());
            this.setUniqueAttributes(other.getUniqueAttributes());
        }
    }

    public SupportingTeamsReference(String entityGuid, Line line) {
        this.setRelationshipGuid(line.getGuid());
        if (entityGuid.equals(line.getEntity1Guid())) {
            this.setRelatedEndGuid(line.getEntity2Guid());
            this.setRelatedEndType(line.getEntity2Type());
        } else {
            this.setRelatedEndGuid(line.getEntity1Guid());
            this.setRelatedEndType(line.getEntity1Type());
        }
    }

    public SupportingTeamsReference(Map objIdMap) {
        if (objIdMap != null) {
            Object reg = objIdMap.get("relatedEndGuid");
            Object rg = objIdMap.get("RelationshipGuid");
            Object t = objIdMap.get("relatedEndType");
            Object u = objIdMap.get("uniqueAttributes");
            if (reg != null) {
                this.setRelatedEndGuid(reg.toString());
            }
            if (rg != null) {
                this.setRelationshipGuid(rg.toString());
            }
            if (t != null) {
                this.setRelatedEndType(t.toString());
            }
            if (u != null && u instanceof Map) {
                this.setUniqueAttributes((Map)u);
            }
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Reference{");
        sb.append("relatedEndGuid='").append(this.getRelatedEndGuid()).append('\'');
        sb.append("relationshipGuid='").append(this.getRelationshipGuid()).append('\'');
        sb.append("relatedEndType='").append(this.getRelatedEndType()).append('\'');
        sb.append(", uniqueAttributes={");
        sb.append("}");
        sb.append("{");
        sb.append('}');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference that = (Reference)o;
        if (this.relatedEndGuid != null && !Objects.equals(this.relatedEndGuid, that.getRelatedEndGuid())) {
            return false;
        }
        if (this.relationshipGuid != null && !Objects.equals(this.relationshipGuid, that.getRelationshipGuid())) {
            return false;
        }
        SupportingTeamsReference typedThat = (SupportingTeamsReference)that;
        return Objects.equals(this.relatedEndType, that.getRelatedEndType()) && Objects.equals(this.uniqueAttributes, that.getUniqueAttributes());
    }

    public int hashCode() {
        return this.relatedEndGuid != null ? Objects.hash(this.relatedEndGuid) : Objects.hash(this.relatedEndType, this.uniqueAttributes);
    }
}

