/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionConnectorType;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionConnectorType.ConnectionConnectorType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConnectorTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConnectorTypeMapper.class);
    private static final String className = ConnectionConnectorTypeMapper.class.getName();

    public static ConnectionConnectorType mapOmrsRelationshipToConnectionConnectorType(Relationship omrsRelationship) throws InvalidParameterException {
        if ("ConnectionConnectorType".equals(omrsRelationship.getType().getTypeDefName())) {
            ConnectionConnectorType connectionConnectorType = new ConnectionConnectorType(omrsRelationship);
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsRelationship.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
            systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
            systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
            systemAttributes.setGUID(omrsRelationship.getGUID());
            connectionConnectorType.setSystemAttributes(systemAttributes);
            InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (ConnectionConnectorType.ATTRIBUTE_NAMES_SET.contains(name)) break;
                        if (connectionConnectorType.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            connectionConnectorType.setExtraAttributes(extraAttributes);
                        }
                        connectionConnectorType.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (ConnectionConnectorType.ENUM_NAMES_SET.contains(name)) break;
                        if (connectionConnectorType.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            connectionConnectorType.setExtraAttributes(extraAttributes);
                        }
                        connectionConnectorType.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!ConnectionConnectorType.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
            return connectionConnectorType;
        }
        return null;
    }

    public static Relationship mapConnectionConnectorTypeToOmrsRelationship(ConnectionConnectorType connectionConnectorType) {
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)connectionConnectorType);
        SystemAttributes systemAttributes = connectionConnectorType.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

