/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SoftwareComponentDeployment;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SoftwareComponentDeployment.SoftwareComponentDeployment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftwareComponentDeploymentMapper {
    private static final Logger log = LoggerFactory.getLogger(SoftwareComponentDeploymentMapper.class);
    private static final String className = SoftwareComponentDeploymentMapper.class.getName();

    public static SoftwareComponentDeployment mapOmrsRelationshipToSoftwareComponentDeployment(Relationship omrsRelationship) throws InvalidParameterException {
        if ("SoftwareComponentDeployment".equals(omrsRelationship.getType().getTypeDefName())) {
            SoftwareComponentDeployment softwareComponentDeployment = new SoftwareComponentDeployment(omrsRelationship);
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsRelationship.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
            systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
            systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
            systemAttributes.setGUID(omrsRelationship.getGUID());
            softwareComponentDeployment.setSystemAttributes(systemAttributes);
            InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (SoftwareComponentDeployment.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("deploymentDate")) {
                                softwareComponentDeployment.setDeploymentDate((String)actualValue);
                            }
                            if (!name.equals("deploymentProcess")) break;
                            softwareComponentDeployment.setDeploymentProcess((String)actualValue);
                            break;
                        }
                        if (softwareComponentDeployment.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            softwareComponentDeployment.setExtraAttributes(extraAttributes);
                        }
                        softwareComponentDeployment.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (SoftwareComponentDeployment.ENUM_NAMES_SET.contains(name)) break;
                        if (softwareComponentDeployment.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            softwareComponentDeployment.setExtraAttributes(extraAttributes);
                        }
                        softwareComponentDeployment.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!SoftwareComponentDeployment.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
            return softwareComponentDeployment;
        }
        return null;
    }

    public static Relationship mapSoftwareComponentDeploymentToOmrsRelationship(SoftwareComponentDeployment softwareComponentDeployment) {
        PrimitivePropertyValue primitivePropertyValue;
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)softwareComponentDeployment);
        SystemAttributes systemAttributes = softwareComponentDeployment.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (softwareComponentDeployment.getDeploymentDate() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)softwareComponentDeployment.getDeploymentDate());
            instanceProperties.setProperty("deploymentDate", (InstancePropertyValue)primitivePropertyValue);
        }
        if (softwareComponentDeployment.getDeploymentProcess() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)softwareComponentDeployment.getDeploymentProcess());
            instanceProperties.setProperty("deploymentProcess", (InstancePropertyValue)primitivePropertyValue);
        }
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

