/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor;

import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermAnchorMapper {
    private static final Logger log = LoggerFactory.getLogger(TermAnchorMapper.class);
    private static final String className = TermAnchorMapper.class.getName();

    public static TermAnchor mapOmrsRelationshipToTermAnchor(Relationship omrsRelationship) throws InvalidParameterException {
        if ("TermAnchor".equals(omrsRelationship.getType().getTypeDefName())) {
            TermAnchor termAnchor = new TermAnchor(omrsRelationship);
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsRelationship.getStatus();
            Status omrsBeanStatus = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omrsBeanStatus);
            systemAttributes.setCreatedBy(omrsRelationship.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsRelationship.getUpdatedBy());
            systemAttributes.setCreateTime(omrsRelationship.getCreateTime());
            systemAttributes.setUpdateTime(omrsRelationship.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsRelationship.getVersion()));
            systemAttributes.setGUID(omrsRelationship.getGUID());
            termAnchor.setSystemAttributes(systemAttributes);
            InstanceProperties omrsRelationshipProperties = omrsRelationship.getProperties();
            Iterator omrsPropertyIterator = omrsRelationshipProperties.getPropertyNames();
            while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsRelationshipProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (TermAnchor.ATTRIBUTE_NAMES_SET.contains(name)) break;
                        if (termAnchor.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            termAnchor.setExtraAttributes(extraAttributes);
                        }
                        termAnchor.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (TermAnchor.ENUM_NAMES_SET.contains(name)) break;
                        if (termAnchor.getExtraAttributes() == null) {
                            HashMap extraAttributes = new HashMap();
                            termAnchor.setExtraAttributes(extraAttributes);
                        }
                        termAnchor.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!TermAnchor.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instanceProperties = mapPropertyValue.getMapValues();
                        break;
                    }
                }
            }
            return termAnchor;
        }
        return null;
    }

    public static Relationship mapTermAnchorToOmrsRelationship(TermAnchor termAnchor) {
        Relationship omrsRelationship = Line.createOmrsRelationship((Line)termAnchor);
        SystemAttributes systemAttributes = termAnchor.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsRelationship.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsRelationship.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsRelationship.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsRelationship.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsRelationship.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsRelationship.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        omrsRelationship.setProperties(instanceProperties);
        return omrsRelationship;
    }
}

