/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers;

import java.util.ArrayList;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.CanonicalVocabulary.CanonicalVocabulary;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Confidence.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Confidentiality.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Criticality.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Retention.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.generated.classifications.Taxonomy.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.node.NodeUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryMapper {
    private static final Logger log = LoggerFactory.getLogger(GlossaryMapper.class);
    private static final String className = GlossaryMapper.class.getName();

    public static Glossary mapGlossaryToOMRSBean(org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary glossary, OMRSAPIHelper oMRSAPIHelper) throws InvalidParameterException {
        NodeType nodeType;
        Glossary omrsBean = new Glossary();
        if (glossary.getSystemAttributes() != null) {
            omrsBean.setSystemAttributes(glossary.getSystemAttributes());
        }
        omrsBean.setDescription(glossary.getDescription());
        omrsBean.setDisplayName(glossary.getName());
        omrsBean.setUsage(glossary.getUsage());
        omrsBean.setAdditionalProperties(glossary.getAdditionalProperties());
        ArrayList<Classification> classifications = glossary.getClassifications();
        if (classifications == null) {
            classifications = new ArrayList<Classification>();
        }
        for (Classification classification : classifications) {
            String classificationName = classification.getClassificationName();
            if (classificationName.equals(new Confidentiality().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (classificationName.equals(new Confidence().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (classificationName.equals(new Criticality().getClassificationName())) {
                NodeUtils.foundGovernanceClassifications((String)classificationName);
                continue;
            }
            if (!classificationName.equals(new Retention().getClassificationName())) continue;
            NodeUtils.foundGovernanceClassifications((String)classificationName);
        }
        GovernanceActions governanceActions = glossary.getGovernanceActions();
        if (governanceActions == null) {
            governanceActions = new GovernanceActions();
            glossary.setGovernanceActions(governanceActions);
        }
        if (governanceActions.getRetention() != null) {
            classifications.add((Classification)governanceActions.getRetention());
        }
        if (governanceActions.getConfidence() != null) {
            classifications.add((Classification)governanceActions.getConfidence());
        }
        if (governanceActions.getConfidentiality() != null) {
            classifications.add((Classification)governanceActions.getConfidentiality());
        }
        if (governanceActions.getCriticality() != null) {
            classifications.add((Classification)governanceActions.getCriticality());
        }
        if ((nodeType = glossary.getNodeType()) != null) {
            CanonicalVocabulary canonicalVocabulary;
            if (nodeType == NodeType.CanonicalGlossary) {
                canonicalVocabulary = new CanonicalVocabulary();
                classifications.add(canonicalVocabulary);
            } else if (nodeType == NodeType.Taxonomy) {
                Taxonomy taxonomy = new Taxonomy();
                classifications.add(taxonomy);
            } else if (nodeType == NodeType.TaxonomyAndCanonicalGlossary) {
                canonicalVocabulary = new CanonicalVocabulary();
                classifications.add(canonicalVocabulary);
                Taxonomy taxonomy = new Taxonomy();
                classifications.add(taxonomy);
            }
        }
        omrsBean.setClassifications(classifications);
        return omrsBean;
    }

    public static org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary mapOMRSBeantoGlossary(Glossary omrsBean) {
        org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary glossary = new org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary();
        glossary.setClassifications(omrsBean.getClassifications());
        glossary.setDescription(omrsBean.getDescription());
        if (omrsBean.getSystemAttributes() != null) {
            glossary.setSystemAttributes(omrsBean.getSystemAttributes());
        }
        glossary.setName(omrsBean.getDisplayName());
        glossary.setQualifiedName(omrsBean.getQualifiedName());
        glossary.setUsage(omrsBean.getUsage());
        glossary.setAdditionalProperties(omrsBean.getAdditionalProperties());
        glossary.setClassifications(omrsBean.getClassifications());
        return glossary;
    }
}

