/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedNameException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryReferences;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnrecognizedNameExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.RestValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGlossaryRESTServices
extends SubjectAreaRESTServices {
    public static final String GLOSSARY_TYPE_GUID = "36f66863-9726-4b41-97ee-714fd0dc6fe4";
    public static final String TERM_ANCHOR_RELATIONSHIP_GUID = "1d43d661-bdc7-4a91-a996-3239b8f82e56";
    public static final String CATEGORY_ANCHOR_RELATIONSHIP_GUID = "c628938e-815e-47db-8d1c-59bb2e84e028";
    public static final String CATEGORY_HIERARCHY_LINK_GUID = "71e4b6fb-3412-4193-aff3-a16eccd87e8e";
    private static String accessServiceName = null;
    private static OMRSRepositoryConnector repositoryConnector = null;
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGlossaryRESTServices.class);
    private static final String className = SubjectAreaGlossaryRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse createGlossary(String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGlossary,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
        glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
        service.setOMRSAPIHelper(this.oMRSAPIHelper);
        org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary generatedGlossary = null;
        ArrayList classifications = new ArrayList();
        Object glossaryGuid = null;
        String suppliedGlossaryName = suppliedGlossary.getName();
        try {
            generatedGlossary = GlossaryMapper.mapGlossaryToOMRSBean(suppliedGlossary, this.oMRSAPIHelper);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            if (suppliedGlossaryName == null || suppliedGlossaryName.equals("")) {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CREATE_WITHOUT_NAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createGlossary"});
                log.error(errorMessage);
                InvalidParameterException e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createGlossary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)e);
            } else {
                SubjectAreaOMASAPIResponse getGlossaryResponse = glossaryRESTServices.getGlossaryByName(userId, suppliedGlossaryName);
                if (getGlossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                    GlossaryResponse glossaryResponse = (GlossaryResponse)getGlossaryResponse;
                    SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CREATE_FAILED_NAME_ALREADY_EXISTS;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{suppliedGlossaryName});
                    log.error(errorMessage);
                    InvalidParameterException e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createGlossary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)e);
                } else if (!getGlossaryResponse.getResponseCategory().equals((Object)ResponseCategory.UnrecognizedNameException)) {
                    response = getGlossaryResponse;
                }
            }
        }
        if (response == null) {
            org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary newGeneratedGlossary = null;
            try {
                newGeneratedGlossary = service.createGlossary(userId, generatedGlossary);
                Glossary newGlossary = GlossaryMapper.mapOMRSBeantoGlossary(newGeneratedGlossary);
                response = new GlossaryResponse(newGlossary);
            }
            catch (MetadataServerUncontactableException e) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
            }
            catch (UserNotAuthorizedException e) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            catch (ClassificationException e) {
                response = OMASExceptionToResponse.convertClassificationException((ClassificationException)e);
            }
            catch (StatusNotSupportedException e) {
                response = OMASExceptionToResponse.convertStatusNotsupportedException((StatusNotSupportedException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGlossary,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryByGuid(String userId, String guid) {
        String methodName = "getGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossary,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaBeansToAccessOMRS subjectAreaBeansToAccessOMRS = new SubjectAreaBeansToAccessOMRS();
        subjectAreaBeansToAccessOMRS.setOMRSAPIHelper(this.oMRSAPIHelper);
        org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary generatedGlossary = null;
        try {
            generatedGlossary = subjectAreaBeansToAccessOMRS.getGlossaryById(userId, guid);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        Glossary gotGlossary = null;
        List<Line> glossaryRelationships = null;
        if (response == null) {
            gotGlossary = GlossaryMapper.mapOMRSBeantoGlossary(generatedGlossary);
            List<Classification> classifications = generatedGlossary.getClassifications();
            gotGlossary.setClassifications(classifications);
            try {
                glossaryRelationships = subjectAreaBeansToAccessOMRS.getGlossaryRelationships(userId, guid);
            }
            catch (MetadataServerUncontactableException e) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
            }
            catch (UserNotAuthorizedException e) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            catch (FunctionNotSupportedException e) {
                response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
            }
            catch (UnrecognizedGUIDException e) {
                response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
            }
        }
        if (response == null) {
            GlossaryReferences generatedGlossaryReferences = null;
            try {
                generatedGlossaryReferences = new GlossaryReferences(guid, glossaryRelationships);
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            Set<RelatedMediaReference> relatedMediaReferenceSet = generatedGlossaryReferences.getRelatedMediaReferences();
            String iconUrl = "";
            if (iconUrl != null) {
                gotGlossary.setIcon(iconUrl);
            }
            response = new GlossaryResponse(gotGlossary);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossary,userId=" + userId + ", Node=" + gotGlossary);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateGlossary(String userId, String guid, Glossary suppliedGlossary, boolean isReplace) {
        String methodName = "updateGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossary,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
        service.setOMRSAPIHelper(this.oMRSAPIHelper);
        response = this.getGlossaryByGuid(userId, guid);
        if (response.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
            Status status;
            SubjectAreaOMASAPIResponse deleteCheckResponse;
            Glossary originalGlossary = ((GlossaryResponse)response).getGlossary();
            if (originalGlossary.getSystemAttributes() != null && (deleteCheckResponse = SubjectAreaUtils.checkStatusNotDeleted(status = originalGlossary.getSystemAttributes().getStatus(), SubjectAreaErrorCode.GLOSSARY_UPDATE_FAILED_ON_DELETED_GLOSSARY)) != null) {
                response = deleteCheckResponse;
            }
            if (suppliedGlossary.getSystemAttributes() != null && (deleteCheckResponse = SubjectAreaUtils.checkStatusNotDeleted(status = suppliedGlossary.getSystemAttributes().getStatus(), SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED)) != null) {
                response = deleteCheckResponse;
            }
            if (response != null) {
                Glossary updateGlossary = originalGlossary;
                if (isReplace) {
                    updateGlossary.setName(suppliedGlossary.getName());
                    updateGlossary.setQualifiedName(suppliedGlossary.getQualifiedName());
                    updateGlossary.setDescription(suppliedGlossary.getDescription());
                    updateGlossary.setUsage(suppliedGlossary.getUsage());
                    updateGlossary.setAdditionalProperties(suppliedGlossary.getAdditionalProperties());
                } else {
                    if (suppliedGlossary.getName() != null) {
                        updateGlossary.setName(suppliedGlossary.getName());
                    }
                    if (suppliedGlossary.getQualifiedName() != null) {
                        updateGlossary.setQualifiedName(suppliedGlossary.getQualifiedName());
                    }
                    if (suppliedGlossary.getDescription() != null) {
                        updateGlossary.setDescription(suppliedGlossary.getDescription());
                    }
                    if (suppliedGlossary.getUsage() != null) {
                        updateGlossary.setUsage(suppliedGlossary.getUsage());
                    }
                    if (suppliedGlossary.getAdditionalProperties() != null) {
                        updateGlossary.setAdditionalProperties(suppliedGlossary.getAdditionalProperties());
                    }
                }
                org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary generatedGlossary = null;
                try {
                    generatedGlossary = GlossaryMapper.mapGlossaryToOMRSBean(updateGlossary, this.oMRSAPIHelper);
                    org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary updatedGeneratedGlossary = null;
                    try {
                        updatedGeneratedGlossary = service.updateGlossary(userId, generatedGlossary);
                    }
                    catch (MetadataServerUncontactableException e) {
                        response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                    }
                    catch (UserNotAuthorizedException e) {
                        response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                    }
                    catch (UnrecognizedGUIDException e) {
                        response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                    }
                    Glossary updatedGlossary = GlossaryMapper.mapOMRSBeantoGlossary(updatedGeneratedGlossary);
                    response = new GlossaryResponse(updatedGlossary);
                }
                catch (InvalidParameterException e) {
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateGlossary,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryByName(String userId, String name) {
        String methodName = "getGlossaryByName";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossaryByName,userId=" + userId + ",name=" + name);
        }
        SubjectAreaOMASAPIResponse response = null;
        List<EntityDetail> omrsEntityDetails = null;
        try {
            RestValidator.validateUserIdNotNull(className, "getGlossaryByName", userId);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (response == null) {
            MatchCriteria matchCriteria = MatchCriteria.ALL;
            String entityTypeGUID = GLOSSARY_TYPE_GUID;
            InstanceProperties matchProperties = new InstanceProperties();
            PrimitivePropertyValue nameValue = new PrimitivePropertyValue();
            nameValue.setPrimitiveValue((Object)name);
            nameValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            matchProperties.setProperty("displayName", (InstancePropertyValue)nameValue);
            ArrayList<InstanceStatus> limitResultsByStatus = new ArrayList<InstanceStatus>();
            limitResultsByStatus.add(InstanceStatus.ACTIVE);
            limitResultsByStatus.add(InstanceStatus.DRAFT);
            limitResultsByStatus.add(InstanceStatus.PREPARED);
            limitResultsByStatus.add(InstanceStatus.PROPOSED);
            limitResultsByStatus.add(InstanceStatus.UNKNOWN);
            try {
                omrsEntityDetails = this.oMRSAPIHelper.callFindEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, 0, limitResultsByStatus, null, null, null, null, 0);
            }
            catch (MetadataServerUncontactableException e) {
                response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
            }
            catch (UserNotAuthorizedException e) {
                response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
            }
            catch (FunctionNotSupportedException e) {
                response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        Glossary gotGlossary = null;
        if (response == null) {
            if (omrsEntityDetails != null && omrsEntityDetails.size() > 0) {
                org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary gotGeneratedGlossary = null;
                try {
                    gotGeneratedGlossary = org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryMapper.mapOmrsEntityDetailToGlossary((EntityDetail)omrsEntityDetails.get(0));
                }
                catch (InvalidParameterException e) {
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                }
                if (response == null) {
                    gotGlossary = GlossaryMapper.mapOMRSBeantoGlossary(gotGeneratedGlossary);
                    response = new GlossaryResponse(gotGlossary);
                }
            } else {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_NAME_DOES_NOT_EXIST;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, name});
                UnrecognizedNameException e = new UnrecognizedNameException(errorCode.getHTTPErrorCode(), className, "getGlossaryByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), name);
                response = new UnrecognizedNameExceptionResponse((SubjectAreaCheckedExceptionBase)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossaryByName,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteGlossary(String userId, String guid, Boolean isPurge) {
        String methodName = "deleteGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossary,userId=" + userId + ", guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
        statusList.add(InstanceStatus.ACTIVE);
        statusList.add(InstanceStatus.DRAFT);
        statusList.add(InstanceStatus.PROPOSED);
        statusList.add(InstanceStatus.PREPARED);
        statusList.add(InstanceStatus.UNKNOWN);
        List<Relationship> terms = null;
        List<Relationship> categories = null;
        try {
            terms = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, guid, TERM_ANCHOR_RELATIONSHIP_GUID, 0, statusList, null, null, null, 1);
            categories = this.oMRSAPIHelper.callGetRelationshipsForEntity(userId, guid, CATEGORY_ANCHOR_RELATIONSHIP_GUID, 0, statusList, null, null, null, 1);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (UserNotAuthorizedException e) {
            response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (FunctionNotSupportedException e) {
            response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
        }
        catch (UnrecognizedGUIDException e) {
            response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
        }
        if (response == null) {
            SubjectAreaBeansToAccessOMRS service = new SubjectAreaBeansToAccessOMRS();
            service.setOMRSAPIHelper(this.oMRSAPIHelper);
            if ((terms == null || terms.isEmpty()) && (categories == null || categories.isEmpty())) {
                if (isPurge.booleanValue()) {
                    try {
                        service.purgeGlossaryByGuid(userId, guid);
                        response = new VoidResponse();
                    }
                    catch (MetadataServerUncontactableException e) {
                        response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                    }
                    catch (UserNotAuthorizedException e) {
                        response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                    }
                    catch (InvalidParameterException e) {
                        response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                    }
                    catch (UnrecognizedGUIDException e) {
                        response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                    }
                    catch (EntityNotDeletedException e) {
                        response = OMASExceptionToResponse.convertEntityNotDeletedException((EntityNotDeletedException)e);
                    }
                    catch (GUIDNotPurgedException e) {
                        response = OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)e);
                    }
                } else {
                    org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary deletedGeneratedGlossary = null;
                    try {
                        EntityDetail entityDetail = service.deleteGlossaryByGuid(userId, guid);
                        deletedGeneratedGlossary = org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.GlossaryMapper.mapOmrsEntityDetailToGlossary(entityDetail);
                        Glossary deletedGlossary = GlossaryMapper.mapOMRSBeantoGlossary(deletedGeneratedGlossary);
                        response = new GlossaryResponse(deletedGlossary);
                    }
                    catch (MetadataServerUncontactableException e) {
                        response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
                    }
                    catch (UserNotAuthorizedException e) {
                        response = OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)e);
                    }
                    catch (FunctionNotSupportedException e) {
                        response = OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)e);
                    }
                    catch (InvalidParameterException e) {
                        response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                    }
                    catch (UnrecognizedGUIDException e) {
                        response = OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)e);
                    }
                }
            } else {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CONTENT_PREVENTED_DELETE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "deleteGlossary", guid});
                log.error(errorMessage);
                InvalidParameterException e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "deleteGlossary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteGlossary,userId=" + userId);
        }
        return response;
    }
}

