/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utilities;

import java.util.ArrayList;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.RelatedMedia.RelatedMedia;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;

public class SubjectAreaUtils {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaUtils.class);
    private static final String className = SubjectAreaUtils.class.getName();

    public static boolean isTopLevelGlossaryObject(String entityName) {
        boolean isTopLevelGlossaryObject = false;
        if (entityName.equals("Glossary") || entityName.equals("Node") || entityName.equals("GlossaryCategory")) {
            isTopLevelGlossaryObject = true;
        }
        return isTopLevelGlossaryObject;
    }

    public static boolean isGovernanceActionClassification(String classificationName) {
        boolean isGovernanceActionClassification = false;
        if (classificationName.equals("Confidence") || classificationName.equals("Confidentiality") || classificationName.equals("Retention") || classificationName.equals("Criticality")) {
            isGovernanceActionClassification = true;
        }
        return isGovernanceActionClassification;
    }

    public static InstanceType createTemplateFromTypeDef(TypeDef typeDef) {
        InstanceType template = new InstanceType();
        template.setTypeDefName(typeDef.getName());
        template.setTypeDefCategory(typeDef.getCategory());
        template.setTypeDefDescription(typeDef.getDescription());
        template.setTypeDefDescriptionGUID(typeDef.getDescriptionGUID());
        template.setTypeDefGUID(typeDef.getGUID());
        ArrayList<TypeDefLink> supertypes = new ArrayList<TypeDefLink>();
        supertypes.add(typeDef.getSuperType());
        template.setTypeDefSuperTypes(supertypes);
        template.setTypeDefVersion(typeDef.getVersion());
        template.setValidStatusList(typeDef.getValidInstanceStatusList());
        return template;
    }

    public static boolean isTerm(String typeName) {
        return typeName.equals("GlossaryTerm");
    }

    public static boolean isCategory(String typeName) {
        return typeName.equals("GlossaryCategory");
    }

    public static boolean isGlossary(String typeName) {
        return typeName.equals("Glossary");
    }

    public static void addStringToInstanceProperty(String key, String value, InstanceProperties instanceProperties) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)value);
        instanceProperties.setProperty(key, (InstancePropertyValue)primitivePropertyValue);
    }

    public static String getIcon(@PathVariable String userId, Set<RelatedMediaReference> relatedMediaReferenceSet) {
        String iconUrl = null;
        if (relatedMediaReferenceSet != null && !relatedMediaReferenceSet.isEmpty()) {
            for (RelatedMediaReference relatedMediaReference : relatedMediaReferenceSet) {
                RelatedMedia relatedMedia = relatedMediaReference.getRelatedMedia();
            }
        }
        return iconUrl;
    }

    public static SubjectAreaOMASAPIResponse checkStatusNotDeleted(Status status, SubjectAreaErrorCode errorCode) {
        String methodName = "checkStatusNotDeleted";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: checkStatusNotDeleted");
        }
        SubjectAreaOMASAPIResponse response = null;
        if (status.equals((Object)Status.DELETED)) {
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "checkStatusNotDeleted"});
            log.error(errorMessage);
            InvalidParameterException invalidParameterException = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "checkStatusNotDeleted", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: checkStatusNotDeleted");
        }
        return response;
    }

    public static Status convertInstanceStatusToStatus(InstanceStatus instanceStatus) {
        Status status = null;
        if (instanceStatus == null) {
            status = Status.ACTIVE;
        } else {
            switch (instanceStatus) {
                case ACTIVE: {
                    status = Status.ACTIVE;
                    break;
                }
                case DELETED: {
                    status = Status.DELETED;
                }
            }
        }
        return status;
    }

    public static InstanceStatus convertStatusToStatusInstance(Status status) {
        InstanceStatus instanceStatus = null;
        if (status == null) {
            instanceStatus = InstanceStatus.ACTIVE;
        } else {
            switch (status) {
                case ACTIVE: {
                    instanceStatus = InstanceStatus.ACTIVE;
                    break;
                }
                case DELETED: {
                    instanceStatus = InstanceStatus.DELETED;
                }
            }
        }
        return instanceStatus;
    }
}

