/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceControl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GovernanceControl.GovernanceControl;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.GovernanceDomain;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.server.properties.classifications.ClassificationFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceControlMapper {
    private static final Logger log = LoggerFactory.getLogger(GovernanceControlMapper.class);
    private static final String className = GovernanceControlMapper.class.getName();

    public static GovernanceControl mapOmrsEntityDetailToGovernanceControl(EntityDetail omrsEntityDetail) throws InvalidParameterException {
        String entityTypeName = omrsEntityDetail.getType().getTypeDefName();
        if ("GovernanceControl".equals(entityTypeName)) {
            GovernanceControl governanceControl = new GovernanceControl();
            SystemAttributes systemAttributes = new SystemAttributes();
            InstanceStatus instanceStatus = omrsEntityDetail.getStatus();
            Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
            systemAttributes.setStatus(omas_status);
            systemAttributes.setCreatedBy(omrsEntityDetail.getCreatedBy());
            systemAttributes.setUpdatedBy(omrsEntityDetail.getUpdatedBy());
            systemAttributes.setCreateTime(omrsEntityDetail.getCreateTime());
            systemAttributes.setUpdateTime(omrsEntityDetail.getUpdateTime());
            systemAttributes.setVersion(Long.valueOf(omrsEntityDetail.getVersion()));
            systemAttributes.setGUID(omrsEntityDetail.getGUID());
            governanceControl.setSystemAttributes(systemAttributes);
            InstanceProperties omrsEntityDetailProperties = omrsEntityDetail.getProperties();
            Iterator omrsPropertyIterator = omrsEntityDetailProperties.getPropertyNames();
            block5: while (omrsPropertyIterator.hasNext()) {
                String name = (String)omrsPropertyIterator.next();
                InstancePropertyValue value = omrsEntityDetailProperties.getPropertyValue(name);
                switch (value.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                        Object actualValue = primitivePropertyValue.getPrimitiveValue();
                        if (GovernanceControl.ATTRIBUTE_NAMES_SET.contains(name)) {
                            if (name.equals("implementationDescription")) {
                                governanceControl.setImplementationDescription((String)actualValue);
                            }
                            if (name.equals("title")) {
                                governanceControl.setTitle((String)actualValue);
                            }
                            if (name.equals("summary")) {
                                governanceControl.setSummary((String)actualValue);
                            }
                            if (name.equals("description")) {
                                governanceControl.setDescription((String)actualValue);
                            }
                            if (name.equals("scope")) {
                                governanceControl.setScope((String)actualValue);
                            }
                            if (name.equals("priority")) {
                                governanceControl.setPriority((String)actualValue);
                            }
                            if (!name.equals("qualifiedName")) break;
                            governanceControl.setQualifiedName((String)actualValue);
                            break;
                        }
                        if (null == governanceControl.getExtraAttributes()) {
                            governanceControl.setExtraAttributes(new HashMap<String, Object>());
                        }
                        governanceControl.getExtraAttributes().put(name, primitivePropertyValue);
                        break;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                        String symbolicName = enumPropertyValue.getSymbolicName();
                        if (GovernanceControl.ENUM_NAMES_SET.contains(name)) {
                            if (!name.equals("domain")) break;
                            GovernanceDomain domain = GovernanceDomain.valueOf((String)symbolicName);
                            governanceControl.setDomain(domain);
                            break;
                        }
                        if (null == governanceControl.getExtraAttributes()) {
                            governanceControl.setExtraAttributes(new HashMap<String, Object>());
                        }
                        governanceControl.getExtraAttributes().put(name, enumPropertyValue);
                        break;
                    }
                    case MAP: {
                        if (!GovernanceControl.MAP_NAMES_SET.contains(name)) break;
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                        InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                        if (!name.equals("additionalProperties")) continue block5;
                        HashMap<String, String> actualMap = new HashMap<String, String>();
                        Iterator iter = instancePropertyForMap.getPropertyNames();
                        while (iter.hasNext()) {
                            String mapkey = (String)iter.next();
                            PrimitivePropertyValue primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                            String mapvalue = (String)primitivePropertyMapValue.getPrimitiveValue();
                            actualMap.put(mapkey, mapvalue);
                        }
                        governanceControl.setAdditionalProperties(actualMap);
                        break;
                    }
                }
            }
            List omrsclassifications = omrsEntityDetail.getClassifications();
            if (omrsclassifications != null && !omrsclassifications.isEmpty()) {
                for (Classification omrsClassification : omrsclassifications) {
                    String omrsClassificationName = omrsClassification.getName();
                    org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = ClassificationFactory.getClassification(omrsClassificationName, omrsClassification);
                    if (omasClassification != null) {
                        if (governanceControl.classifications == null) {
                            governanceControl.classifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
                        }
                        governanceControl.classifications.add(omasClassification);
                        continue;
                    }
                    if (null == governanceControl.getExtraClassifications()) {
                        governanceControl.setExtraClassifications(new HashMap<String, Classification>());
                    }
                    governanceControl.getExtraClassifications().put(omrsClassificationName, omrsClassification);
                }
            }
            return governanceControl;
        }
        return null;
    }

    public static EntityDetail mapGovernanceControlToOmrsEntityDetail(GovernanceControl governanceControl) {
        PrimitivePropertyValue primitivePropertyValue;
        EntityDetail omrsEntityDetail = new EntityDetail();
        SystemAttributes systemAttributes = governanceControl.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsEntityDetail.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsEntityDetail.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsEntityDetail.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsEntityDetail.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsEntityDetail.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsEntityDetail.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToStatusInstance(systemAttributes.getStatus());
                omrsEntityDetail.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        if (governanceControl.getImplementationDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceControl.getImplementationDescription());
            instanceProperties.setProperty("implementationDescription", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceControl.getTitle() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceControl.getTitle());
            instanceProperties.setProperty("title", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceControl.getSummary() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceControl.getSummary());
            instanceProperties.setProperty("summary", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceControl.getDescription() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceControl.getDescription());
            instanceProperties.setProperty("description", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceControl.getScope() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceControl.getScope());
            instanceProperties.setProperty("scope", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceControl.getPriority() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceControl.getPriority());
            instanceProperties.setProperty("priority", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceControl.getQualifiedName() != null) {
            primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)governanceControl.getQualifiedName());
            instanceProperties.setProperty("qualifiedName", (InstancePropertyValue)primitivePropertyValue);
        }
        if (governanceControl.getDomain() != null) {
            GovernanceDomain enumType = governanceControl.getDomain();
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(enumType.ordinal());
            enumPropertyValue.setSymbolicName(enumType.name());
            instanceProperties.setProperty("domain", (InstancePropertyValue)enumPropertyValue);
        }
        if (governanceControl.getAdditionalProperties() != null) {
            Map<String, String> map = governanceControl.getAdditionalProperties();
            MapPropertyValue mapPropertyValue = new MapPropertyValue();
            for (String key : map.keySet()) {
                PrimitivePropertyValue primitivePropertyValue2 = new PrimitivePropertyValue();
                primitivePropertyValue2.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue2.setPrimitiveValue((Object)map.get(key));
                mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue2);
            }
            instanceProperties.setProperty("additionalProperties", (InstancePropertyValue)mapPropertyValue);
        }
        omrsEntityDetail.setProperties(instanceProperties);
        OMRSArchiveAccessor archiveAccessor = OMRSArchiveAccessor.getInstance();
        EntityDef typeDef = archiveAccessor.getEntityDefByName("GovernanceControl");
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsEntityDetail.setType(instanceType);
        GovernanceControlMapper.populateOmrsEntityWithBeanClassifications(omrsEntityDetail, governanceControl.getClassifications());
        return omrsEntityDetail;
    }

    private static void populateOmrsEntityWithBeanClassifications(EntityDetail omrsEntityDetail, List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> beanClassifications) {
        if (beanClassifications != null && beanClassifications.size() > 0) {
            ArrayList<Classification> omrsClassifications = new ArrayList<Classification>();
            for (org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification beanClassification : beanClassifications) {
                SystemAttributes systemAttributes = beanClassification.getSystemAttributes();
                Classification omrsClassification = new Classification();
                if (systemAttributes != null) {
                    if (systemAttributes.getCreatedBy() != null) {
                        omrsClassification.setCreatedBy(systemAttributes.getCreatedBy());
                    }
                    if (systemAttributes.getUpdatedBy() != null) {
                        omrsClassification.setUpdatedBy(systemAttributes.getUpdatedBy());
                    }
                    if (systemAttributes.getCreateTime() != null) {
                        omrsClassification.setCreateTime(systemAttributes.getCreateTime());
                    }
                    if (systemAttributes.getUpdateTime() != null) {
                        omrsClassification.setUpdateTime(systemAttributes.getUpdateTime());
                    }
                    if (systemAttributes.getVersion() != null) {
                        omrsClassification.setVersion(systemAttributes.getVersion().longValue());
                    }
                }
                omrsClassification.setName(beanClassification.getClassificationName());
                omrsClassification.setProperties(beanClassification.obtainInstanceProperties());
                omrsClassifications.add(omrsClassification);
            }
            omrsEntityDetail.setClassifications(omrsClassifications);
        }
    }
}

