/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generated.entities.MetadataCollection;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToConnection.ConnectionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToDataSet.SupportedDataSetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToSchemaType.SchemaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.AssetToSoftwareServerCapability.ConsumedByReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.DataSetToAsset.DataContentReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.DataSetToGovernanceMetric.MetricsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.DataSetToProcess.ConsumedByProcessReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.DataSetToProcess.ProducedByProcessReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.MetadataCollectionToCohortMember.CohortMemberReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToActorProfile.ContributorsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCertificationType.CertificationsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToComment.CommentsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToCommunity.CommunityUsesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.AlsoKnownAsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalId.ManagedResourcesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToExternalReference.ExternalReferenceReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToGlossaryTerm.MeaningReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToInformalTag.TagsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLicenseType.LicensesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToLike.LikesReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToMeeting.MeetingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToNoteLog.NoteLogsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPerson.StaffReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ProjectUseReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToProject.ProjectsImpactingAssetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToPropertyFacet.FacetsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRating.StarRatingsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToRelatedMedia.RelatedMediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.ActionsReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.references.ReferenceableToToDo.TodosReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetSchemaType.AssetSchemaType;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AssetServerUse.AssetServerUse;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedComment.AttachedComment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedLike.AttachedLike;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedNoteLog.AttachedNoteLog;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedRating.AttachedRating;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.AttachedTag.AttachedTag;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Certification.Certification;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CohortMemberMetadataCollection.CohortMemberMetadataCollection;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CommunityResources.CommunityResources;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ConnectionToAsset.ConnectionToAsset;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Contributor.Contributor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.DataContentForDataSet.DataContentForDataSet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdLink.ExternalIdLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalIdScope.ExternalIdScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ExternalReferenceLink.ExternalReferenceLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.GovernanceResults.GovernanceResults;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.License.License;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MeetingOnReferenceable.MeetingOnReferenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessInput.ProcessInput;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProcessOutput.ProcessOutput;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectResources.ProjectResources;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ProjectScope.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReferenceableFacet.ReferenceableFacet;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.StaffAssignment.StaffAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoOnReferenceable.ToDoOnReferenceable;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ToDoSource.ToDoSource;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.line.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MetadataCollectionReferences
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MetadataCollectionReferences.class);
    private static final String className = MetadataCollectionReferences.class.getName();
    public static final String[] REFERENCE_NAMES_SET_VALUES = new String[]{"cohortMember", "communityUses", "meaning", "projectUse", "producedByProcess", "externalReference", "relatedMedia", "consumedBy", "consumedByProcess", "actions", "projectsImpactingAssets", "alsoKnownAs", "managedResources", "noteLogs", "staff", "meetings", "starRatings", "schema", "likes", "tags", "dataContent", "metrics", "facets", "certifications", "contributors", "connections", "comments", "licenses", "supportedDataSets", "todos", null};
    public static final String[] RELATIONSHIP_NAMES_SET_VALUES = new String[]{"CohortMemberMetadataCollection", "CommunityResources", "SemanticAssignment", "ProjectResources", "ProcessOutput", "ExternalReferenceLink", "MediaReference", "AssetServerUse", "ProcessInput", "ToDoSource", "ProjectScope", "ExternalIdLink", "ExternalIdScope", "AttachedNoteLog", "StaffAssignment", "MeetingOnReferenceable", "AttachedRating", "AssetSchemaType", "AttachedLike", "AttachedTag", "DataContentForDataSet", "GovernanceResults", "ReferenceableFacet", "Certification", "Contributor", "ConnectionToAsset", "AttachedComment", "License", "DataContentForDataSet", "ToDoOnReferenceable", null};
    public static final Set<String> REFERENCE_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(REFERENCE_NAMES_SET_VALUES)));
    public static final Set<String> RELATIONSHIP_NAMES_SET = new HashSet<String>(new HashSet<String>(Arrays.asList(RELATIONSHIP_NAMES_SET_VALUES)));
    private CohortMemberReference cohortMember;
    private SchemaReference schema;
    private Set<CommunityUsesReference> communityUses;
    private Set<MeaningReference> meaning;
    private Set<ProjectUseReference> projectUse;
    private Set<ProducedByProcessReference> producedByProcess;
    private Set<ExternalReferenceReference> externalReference;
    private Set<RelatedMediaReference> relatedMedia;
    private Set<ConsumedByReference> consumedBy;
    private Set<ConsumedByProcessReference> consumedByProcess;
    private Set<ActionsReference> actions;
    private Set<ProjectsImpactingAssetsReference> projectsImpactingAssets;
    private Set<AlsoKnownAsReference> alsoKnownAs;
    private Set<ManagedResourcesReference> managedResources;
    private Set<NoteLogsReference> noteLogs;
    private Set<StaffReference> staff;
    private Set<MeetingsReference> meetings;
    private Set<StarRatingsReference> starRatings;
    private Set<LikesReference> likes;
    private Set<TagsReference> tags;
    private Set<DataContentReference> dataContent;
    private Set<MetricsReference> metrics;
    private Set<FacetsReference> facets;
    private Set<CertificationsReference> certifications;
    private Set<ContributorsReference> contributors;
    private Set<ConnectionsReference> connections;
    private Set<CommentsReference> comments;
    private Set<LicensesReference> licenses;
    private Set<SupportedDataSetsReference> supportedDataSets;
    private Set<TodosReference> todos;

    public MetadataCollectionReferences(String entityGuid, Set<Line> lines) throws InvalidParameterException {
        if (lines != null) {
            for (Line relationship : lines) {
                for (int i = 0; i < RELATIONSHIP_NAMES_SET_VALUES.length; ++i) {
                    DataContentForDataSet dataContentForDataSet_relationship;
                    if (!relationship.getName().equals(RELATIONSHIP_NAMES_SET_VALUES[i])) continue;
                    String referenceName = REFERENCE_NAMES_SET_VALUES[i];
                    if ("communityUses".equals(referenceName)) {
                        CommunityResources communityResources_relationship = (CommunityResources)relationship;
                        CommunityUsesReference communityUsesReference = new CommunityUsesReference(entityGuid, communityResources_relationship);
                        if (this.communityUses == null) {
                            this.communityUses = new HashSet<CommunityUsesReference>();
                        }
                        this.communityUses.add(communityUsesReference);
                    }
                    if ("meaning".equals(referenceName)) {
                        SemanticAssignment semanticAssignment_relationship = (SemanticAssignment)relationship;
                        MeaningReference meaningReference = new MeaningReference(entityGuid, semanticAssignment_relationship);
                        if (this.meaning == null) {
                            this.meaning = new HashSet<MeaningReference>();
                        }
                        this.meaning.add(meaningReference);
                    }
                    if ("projectUse".equals(referenceName)) {
                        ProjectResources projectResources_relationship = (ProjectResources)relationship;
                        ProjectUseReference projectUseReference = new ProjectUseReference(entityGuid, projectResources_relationship);
                        if (this.projectUse == null) {
                            this.projectUse = new HashSet<ProjectUseReference>();
                        }
                        this.projectUse.add(projectUseReference);
                    }
                    if ("producedByProcess".equals(referenceName)) {
                        ProcessOutput processOutput_relationship = (ProcessOutput)relationship;
                        ProducedByProcessReference producedByProcessReference = new ProducedByProcessReference(entityGuid, processOutput_relationship);
                        if (this.producedByProcess == null) {
                            this.producedByProcess = new HashSet<ProducedByProcessReference>();
                        }
                        this.producedByProcess.add(producedByProcessReference);
                    }
                    if ("externalReference".equals(referenceName)) {
                        ExternalReferenceLink externalReferenceLink_relationship = (ExternalReferenceLink)relationship;
                        ExternalReferenceReference externalReferenceReference = new ExternalReferenceReference(entityGuid, externalReferenceLink_relationship);
                        if (this.externalReference == null) {
                            this.externalReference = new HashSet<ExternalReferenceReference>();
                        }
                        this.externalReference.add(externalReferenceReference);
                    }
                    if ("relatedMedia".equals(referenceName)) {
                        MediaReference mediaReference_relationship = (MediaReference)relationship;
                        RelatedMediaReference relatedMediaReference = new RelatedMediaReference(entityGuid, mediaReference_relationship);
                        if (this.relatedMedia == null) {
                            this.relatedMedia = new HashSet<RelatedMediaReference>();
                        }
                        this.relatedMedia.add(relatedMediaReference);
                    }
                    if ("consumedBy".equals(referenceName)) {
                        AssetServerUse assetServerUse_relationship = (AssetServerUse)relationship;
                        ConsumedByReference consumedByReference = new ConsumedByReference(entityGuid, assetServerUse_relationship);
                        if (this.consumedBy == null) {
                            this.consumedBy = new HashSet<ConsumedByReference>();
                        }
                        this.consumedBy.add(consumedByReference);
                    }
                    if ("consumedByProcess".equals(referenceName)) {
                        ProcessInput processInput_relationship = (ProcessInput)relationship;
                        ConsumedByProcessReference consumedByProcessReference = new ConsumedByProcessReference(entityGuid, processInput_relationship);
                        if (this.consumedByProcess == null) {
                            this.consumedByProcess = new HashSet<ConsumedByProcessReference>();
                        }
                        this.consumedByProcess.add(consumedByProcessReference);
                    }
                    if ("actions".equals(referenceName)) {
                        ToDoSource toDoSource_relationship = (ToDoSource)relationship;
                        ActionsReference actionsReference = new ActionsReference(entityGuid, toDoSource_relationship);
                        if (this.actions == null) {
                            this.actions = new HashSet<ActionsReference>();
                        }
                        this.actions.add(actionsReference);
                    }
                    if ("projectsImpactingAssets".equals(referenceName)) {
                        ProjectScope projectScope_relationship = (ProjectScope)relationship;
                        ProjectsImpactingAssetsReference projectsImpactingAssetsReference = new ProjectsImpactingAssetsReference(entityGuid, projectScope_relationship);
                        if (this.projectsImpactingAssets == null) {
                            this.projectsImpactingAssets = new HashSet<ProjectsImpactingAssetsReference>();
                        }
                        this.projectsImpactingAssets.add(projectsImpactingAssetsReference);
                    }
                    if ("alsoKnownAs".equals(referenceName)) {
                        ExternalIdLink externalIdLink_relationship = (ExternalIdLink)relationship;
                        AlsoKnownAsReference alsoKnownAsReference = new AlsoKnownAsReference(entityGuid, externalIdLink_relationship);
                        if (this.alsoKnownAs == null) {
                            this.alsoKnownAs = new HashSet<AlsoKnownAsReference>();
                        }
                        this.alsoKnownAs.add(alsoKnownAsReference);
                    }
                    if ("managedResources".equals(referenceName)) {
                        ExternalIdScope externalIdScope_relationship = (ExternalIdScope)relationship;
                        ManagedResourcesReference managedResourcesReference = new ManagedResourcesReference(entityGuid, externalIdScope_relationship);
                        if (this.managedResources == null) {
                            this.managedResources = new HashSet<ManagedResourcesReference>();
                        }
                        this.managedResources.add(managedResourcesReference);
                    }
                    if ("noteLogs".equals(referenceName)) {
                        AttachedNoteLog attachedNoteLog_relationship = (AttachedNoteLog)relationship;
                        NoteLogsReference noteLogsReference = new NoteLogsReference(entityGuid, attachedNoteLog_relationship);
                        if (this.noteLogs == null) {
                            this.noteLogs = new HashSet<NoteLogsReference>();
                        }
                        this.noteLogs.add(noteLogsReference);
                    }
                    if ("staff".equals(referenceName)) {
                        StaffAssignment staffAssignment_relationship = (StaffAssignment)relationship;
                        StaffReference staffReference = new StaffReference(entityGuid, staffAssignment_relationship);
                        if (this.staff == null) {
                            this.staff = new HashSet<StaffReference>();
                        }
                        this.staff.add(staffReference);
                    }
                    if ("meetings".equals(referenceName)) {
                        MeetingOnReferenceable meetingOnReferenceable_relationship = (MeetingOnReferenceable)relationship;
                        MeetingsReference meetingsReference = new MeetingsReference(entityGuid, meetingOnReferenceable_relationship);
                        if (this.meetings == null) {
                            this.meetings = new HashSet<MeetingsReference>();
                        }
                        this.meetings.add(meetingsReference);
                    }
                    if ("starRatings".equals(referenceName)) {
                        AttachedRating attachedRating_relationship = (AttachedRating)relationship;
                        StarRatingsReference starRatingsReference = new StarRatingsReference(entityGuid, attachedRating_relationship);
                        if (this.starRatings == null) {
                            this.starRatings = new HashSet<StarRatingsReference>();
                        }
                        this.starRatings.add(starRatingsReference);
                    }
                    if ("likes".equals(referenceName)) {
                        AttachedLike attachedLike_relationship = (AttachedLike)relationship;
                        LikesReference likesReference = new LikesReference(entityGuid, attachedLike_relationship);
                        if (this.likes == null) {
                            this.likes = new HashSet<LikesReference>();
                        }
                        this.likes.add(likesReference);
                    }
                    if ("tags".equals(referenceName)) {
                        AttachedTag attachedTag_relationship = (AttachedTag)relationship;
                        TagsReference tagsReference = new TagsReference(entityGuid, attachedTag_relationship);
                        if (this.tags == null) {
                            this.tags = new HashSet<TagsReference>();
                        }
                        this.tags.add(tagsReference);
                    }
                    if ("dataContent".equals(referenceName)) {
                        dataContentForDataSet_relationship = (DataContentForDataSet)relationship;
                        DataContentReference dataContentReference = new DataContentReference(entityGuid, dataContentForDataSet_relationship);
                        if (this.dataContent == null) {
                            this.dataContent = new HashSet<DataContentReference>();
                        }
                        this.dataContent.add(dataContentReference);
                    }
                    if ("metrics".equals(referenceName)) {
                        GovernanceResults governanceResults_relationship = (GovernanceResults)relationship;
                        MetricsReference metricsReference = new MetricsReference(entityGuid, governanceResults_relationship);
                        if (this.metrics == null) {
                            this.metrics = new HashSet<MetricsReference>();
                        }
                        this.metrics.add(metricsReference);
                    }
                    if ("facets".equals(referenceName)) {
                        ReferenceableFacet referenceableFacet_relationship = (ReferenceableFacet)relationship;
                        FacetsReference facetsReference = new FacetsReference(entityGuid, referenceableFacet_relationship);
                        if (this.facets == null) {
                            this.facets = new HashSet<FacetsReference>();
                        }
                        this.facets.add(facetsReference);
                    }
                    if ("certifications".equals(referenceName)) {
                        Certification certification_relationship = (Certification)relationship;
                        CertificationsReference certificationsReference = new CertificationsReference(entityGuid, certification_relationship);
                        if (this.certifications == null) {
                            this.certifications = new HashSet<CertificationsReference>();
                        }
                        this.certifications.add(certificationsReference);
                    }
                    if ("contributors".equals(referenceName)) {
                        Contributor contributor_relationship = (Contributor)relationship;
                        ContributorsReference contributorsReference = new ContributorsReference(entityGuid, contributor_relationship);
                        if (this.contributors == null) {
                            this.contributors = new HashSet<ContributorsReference>();
                        }
                        this.contributors.add(contributorsReference);
                    }
                    if ("connections".equals(referenceName)) {
                        ConnectionToAsset connectionToAsset_relationship = (ConnectionToAsset)relationship;
                        ConnectionsReference connectionsReference = new ConnectionsReference(entityGuid, connectionToAsset_relationship);
                        if (this.connections == null) {
                            this.connections = new HashSet<ConnectionsReference>();
                        }
                        this.connections.add(connectionsReference);
                    }
                    if ("comments".equals(referenceName)) {
                        AttachedComment attachedComment_relationship = (AttachedComment)relationship;
                        CommentsReference commentsReference = new CommentsReference(entityGuid, attachedComment_relationship);
                        if (this.comments == null) {
                            this.comments = new HashSet<CommentsReference>();
                        }
                        this.comments.add(commentsReference);
                    }
                    if ("licenses".equals(referenceName)) {
                        License license_relationship = (License)relationship;
                        LicensesReference licensesReference = new LicensesReference(entityGuid, license_relationship);
                        if (this.licenses == null) {
                            this.licenses = new HashSet<LicensesReference>();
                        }
                        this.licenses.add(licensesReference);
                    }
                    if ("supportedDataSets".equals(referenceName)) {
                        dataContentForDataSet_relationship = (DataContentForDataSet)relationship;
                        SupportedDataSetsReference supportedDataSetsReference = new SupportedDataSetsReference(entityGuid, dataContentForDataSet_relationship);
                        if (this.supportedDataSets == null) {
                            this.supportedDataSets = new HashSet<SupportedDataSetsReference>();
                        }
                        this.supportedDataSets.add(supportedDataSetsReference);
                    }
                    if ("todos".equals(referenceName)) {
                        ToDoOnReferenceable toDoOnReferenceable_relationship = (ToDoOnReferenceable)relationship;
                        TodosReference todosReference = new TodosReference(entityGuid, toDoOnReferenceable_relationship);
                        if (this.todos == null) {
                            this.todos = new HashSet<TodosReference>();
                        }
                        this.todos.add(todosReference);
                    }
                    if ("cohortMember".equals(referenceName)) {
                        CohortMemberMetadataCollection cohortMemberMetadataCollection_relationship = (CohortMemberMetadataCollection)relationship;
                        this.cohortMember = new CohortMemberReference(entityGuid, cohortMemberMetadataCollection_relationship);
                    }
                    if (!"schema".equals(referenceName)) continue;
                    AssetSchemaType assetSchemaType_relationship = (AssetSchemaType)relationship;
                    this.schema = new SchemaReference(entityGuid, assetSchemaType_relationship);
                }
            }
        }
    }

    public CohortMemberReference getCohortMemberReference() {
        return this.cohortMember;
    }

    public void setCohortMemberReference(CohortMemberReference cohortMember) {
        this.cohortMember = cohortMember;
    }

    public SchemaReference getSchemaReference() {
        return this.schema;
    }

    public void setSchemaReference(SchemaReference schema) {
        this.schema = schema;
    }

    public Set<CommunityUsesReference> getCommunityUsesReferences() {
        return this.communityUses;
    }

    public void setCommunityUsesReferences(Set<CommunityUsesReference> communityUses) {
        this.communityUses = communityUses;
    }

    public Set<MeaningReference> getMeaningReferences() {
        return this.meaning;
    }

    public void setMeaningReferences(Set<MeaningReference> meaning) {
        this.meaning = meaning;
    }

    public Set<ProjectUseReference> getProjectUseReferences() {
        return this.projectUse;
    }

    public void setProjectUseReferences(Set<ProjectUseReference> projectUse) {
        this.projectUse = projectUse;
    }

    public Set<ProducedByProcessReference> getProducedByProcessReferences() {
        return this.producedByProcess;
    }

    public void setProducedByProcessReferences(Set<ProducedByProcessReference> producedByProcess) {
        this.producedByProcess = producedByProcess;
    }

    public Set<ExternalReferenceReference> getExternalReferenceReferences() {
        return this.externalReference;
    }

    public void setExternalReferenceReferences(Set<ExternalReferenceReference> externalReference) {
        this.externalReference = externalReference;
    }

    public Set<RelatedMediaReference> getRelatedMediaReferences() {
        return this.relatedMedia;
    }

    public void setRelatedMediaReferences(Set<RelatedMediaReference> relatedMedia) {
        this.relatedMedia = relatedMedia;
    }

    public Set<ConsumedByReference> getConsumedByReferences() {
        return this.consumedBy;
    }

    public void setConsumedByReferences(Set<ConsumedByReference> consumedBy) {
        this.consumedBy = consumedBy;
    }

    public Set<ConsumedByProcessReference> getConsumedByProcessReferences() {
        return this.consumedByProcess;
    }

    public void setConsumedByProcessReferences(Set<ConsumedByProcessReference> consumedByProcess) {
        this.consumedByProcess = consumedByProcess;
    }

    public Set<ActionsReference> getActionsReferences() {
        return this.actions;
    }

    public void setActionsReferences(Set<ActionsReference> actions) {
        this.actions = actions;
    }

    public Set<ProjectsImpactingAssetsReference> getProjectsImpactingAssetsReferences() {
        return this.projectsImpactingAssets;
    }

    public void setProjectsImpactingAssetsReferences(Set<ProjectsImpactingAssetsReference> projectsImpactingAssets) {
        this.projectsImpactingAssets = projectsImpactingAssets;
    }

    public Set<AlsoKnownAsReference> getAlsoKnownAsReferences() {
        return this.alsoKnownAs;
    }

    public void setAlsoKnownAsReferences(Set<AlsoKnownAsReference> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public Set<ManagedResourcesReference> getManagedResourcesReferences() {
        return this.managedResources;
    }

    public void setManagedResourcesReferences(Set<ManagedResourcesReference> managedResources) {
        this.managedResources = managedResources;
    }

    public Set<NoteLogsReference> getNoteLogsReferences() {
        return this.noteLogs;
    }

    public void setNoteLogsReferences(Set<NoteLogsReference> noteLogs) {
        this.noteLogs = noteLogs;
    }

    public Set<StaffReference> getStaffReferences() {
        return this.staff;
    }

    public void setStaffReferences(Set<StaffReference> staff) {
        this.staff = staff;
    }

    public Set<MeetingsReference> getMeetingsReferences() {
        return this.meetings;
    }

    public void setMeetingsReferences(Set<MeetingsReference> meetings) {
        this.meetings = meetings;
    }

    public Set<StarRatingsReference> getStarRatingsReferences() {
        return this.starRatings;
    }

    public void setStarRatingsReferences(Set<StarRatingsReference> starRatings) {
        this.starRatings = starRatings;
    }

    public Set<LikesReference> getLikesReferences() {
        return this.likes;
    }

    public void setLikesReferences(Set<LikesReference> likes) {
        this.likes = likes;
    }

    public Set<TagsReference> getTagsReferences() {
        return this.tags;
    }

    public void setTagsReferences(Set<TagsReference> tags) {
        this.tags = tags;
    }

    public Set<DataContentReference> getDataContentReferences() {
        return this.dataContent;
    }

    public void setDataContentReferences(Set<DataContentReference> dataContent) {
        this.dataContent = dataContent;
    }

    public Set<MetricsReference> getMetricsReferences() {
        return this.metrics;
    }

    public void setMetricsReferences(Set<MetricsReference> metrics) {
        this.metrics = metrics;
    }

    public Set<FacetsReference> getFacetsReferences() {
        return this.facets;
    }

    public void setFacetsReferences(Set<FacetsReference> facets) {
        this.facets = facets;
    }

    public Set<CertificationsReference> getCertificationsReferences() {
        return this.certifications;
    }

    public void setCertificationsReferences(Set<CertificationsReference> certifications) {
        this.certifications = certifications;
    }

    public Set<ContributorsReference> getContributorsReferences() {
        return this.contributors;
    }

    public void setContributorsReferences(Set<ContributorsReference> contributors) {
        this.contributors = contributors;
    }

    public Set<ConnectionsReference> getConnectionsReferences() {
        return this.connections;
    }

    public void setConnectionsReferences(Set<ConnectionsReference> connections) {
        this.connections = connections;
    }

    public Set<CommentsReference> getCommentsReferences() {
        return this.comments;
    }

    public void setCommentsReferences(Set<CommentsReference> comments) {
        this.comments = comments;
    }

    public Set<LicensesReference> getLicensesReferences() {
        return this.licenses;
    }

    public void setLicensesReferences(Set<LicensesReference> licenses) {
        this.licenses = licenses;
    }

    public Set<SupportedDataSetsReference> getSupportedDataSetsReferences() {
        return this.supportedDataSets;
    }

    public void setSupportedDataSetsReferences(Set<SupportedDataSetsReference> supportedDataSets) {
        this.supportedDataSets = supportedDataSets;
    }

    public Set<TodosReference> getTodosReferences() {
        return this.todos;
    }

    public void setTodosReferences(Set<TodosReference> todos) {
        this.todos = todos;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("MetadataCollectionReferences{");
        sb.append("communityUsesReference='").append(this.communityUses.toString());
        sb.append("meaningReference='").append(this.meaning.toString());
        sb.append("projectUseReference='").append(this.projectUse.toString());
        sb.append("producedByProcessReference='").append(this.producedByProcess.toString());
        sb.append("externalReferenceReference='").append(this.externalReference.toString());
        sb.append("relatedMediaReference='").append(this.relatedMedia.toString());
        sb.append("consumedByReference='").append(this.consumedBy.toString());
        sb.append("consumedByProcessReference='").append(this.consumedByProcess.toString());
        sb.append("actionsReference='").append(this.actions.toString());
        sb.append("projectsImpactingAssetsReference='").append(this.projectsImpactingAssets.toString());
        sb.append("alsoKnownAsReference='").append(this.alsoKnownAs.toString());
        sb.append("managedResourcesReference='").append(this.managedResources.toString());
        sb.append("noteLogsReference='").append(this.noteLogs.toString());
        sb.append("staffReference='").append(this.staff.toString());
        sb.append("meetingsReference='").append(this.meetings.toString());
        sb.append("starRatingsReference='").append(this.starRatings.toString());
        sb.append("likesReference='").append(this.likes.toString());
        sb.append("tagsReference='").append(this.tags.toString());
        sb.append("dataContentReference='").append(this.dataContent.toString());
        sb.append("metricsReference='").append(this.metrics.toString());
        sb.append("facetsReference='").append(this.facets.toString());
        sb.append("certificationsReference='").append(this.certifications.toString());
        sb.append("contributorsReference='").append(this.contributors.toString());
        sb.append("connectionsReference='").append(this.connections.toString());
        sb.append("commentsReference='").append(this.comments.toString());
        sb.append("licensesReference='").append(this.licenses.toString());
        sb.append("supportedDataSetsReference='").append(this.supportedDataSets.toString());
        sb.append("todosReference='").append(this.todos.toString());
        sb.append("cohortMemberReference='").append(this.cohortMember.toString());
        sb.append("schemaReference='").append(this.schema.toString());
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataCollectionReferences typedThat = (MetadataCollectionReferences)o;
        if (this.cohortMember != null && !Objects.equals(this.cohortMember, typedThat.cohortMember)) {
            return false;
        }
        if (this.communityUses != null && !Objects.equals(this.communityUses, typedThat.communityUses)) {
            return false;
        }
        if (this.meaning != null && !Objects.equals(this.meaning, typedThat.meaning)) {
            return false;
        }
        if (this.projectUse != null && !Objects.equals(this.projectUse, typedThat.projectUse)) {
            return false;
        }
        if (this.producedByProcess != null && !Objects.equals(this.producedByProcess, typedThat.producedByProcess)) {
            return false;
        }
        if (this.externalReference != null && !Objects.equals(this.externalReference, typedThat.externalReference)) {
            return false;
        }
        if (this.relatedMedia != null && !Objects.equals(this.relatedMedia, typedThat.relatedMedia)) {
            return false;
        }
        if (this.consumedBy != null && !Objects.equals(this.consumedBy, typedThat.consumedBy)) {
            return false;
        }
        if (this.consumedByProcess != null && !Objects.equals(this.consumedByProcess, typedThat.consumedByProcess)) {
            return false;
        }
        if (this.actions != null && !Objects.equals(this.actions, typedThat.actions)) {
            return false;
        }
        if (this.projectsImpactingAssets != null && !Objects.equals(this.projectsImpactingAssets, typedThat.projectsImpactingAssets)) {
            return false;
        }
        if (this.alsoKnownAs != null && !Objects.equals(this.alsoKnownAs, typedThat.alsoKnownAs)) {
            return false;
        }
        if (this.managedResources != null && !Objects.equals(this.managedResources, typedThat.managedResources)) {
            return false;
        }
        if (this.noteLogs != null && !Objects.equals(this.noteLogs, typedThat.noteLogs)) {
            return false;
        }
        if (this.staff != null && !Objects.equals(this.staff, typedThat.staff)) {
            return false;
        }
        if (this.meetings != null && !Objects.equals(this.meetings, typedThat.meetings)) {
            return false;
        }
        if (this.starRatings != null && !Objects.equals(this.starRatings, typedThat.starRatings)) {
            return false;
        }
        if (this.schema != null && !Objects.equals(this.schema, typedThat.schema)) {
            return false;
        }
        if (this.likes != null && !Objects.equals(this.likes, typedThat.likes)) {
            return false;
        }
        if (this.tags != null && !Objects.equals(this.tags, typedThat.tags)) {
            return false;
        }
        if (this.dataContent != null && !Objects.equals(this.dataContent, typedThat.dataContent)) {
            return false;
        }
        if (this.metrics != null && !Objects.equals(this.metrics, typedThat.metrics)) {
            return false;
        }
        if (this.facets != null && !Objects.equals(this.facets, typedThat.facets)) {
            return false;
        }
        if (this.certifications != null && !Objects.equals(this.certifications, typedThat.certifications)) {
            return false;
        }
        if (this.contributors != null && !Objects.equals(this.contributors, typedThat.contributors)) {
            return false;
        }
        if (this.connections != null && !Objects.equals(this.connections, typedThat.connections)) {
            return false;
        }
        if (this.comments != null && !Objects.equals(this.comments, typedThat.comments)) {
            return false;
        }
        if (this.licenses != null && !Objects.equals(this.licenses, typedThat.licenses)) {
            return false;
        }
        if (this.supportedDataSets != null && !Objects.equals(this.supportedDataSets, typedThat.supportedDataSets)) {
            return false;
        }
        if (this.todos != null && !Objects.equals(this.todos, typedThat.todos)) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cohortMember, this.communityUses, this.meaning, this.projectUse, this.producedByProcess, this.externalReference, this.relatedMedia, this.consumedBy, this.consumedByProcess, this.actions, this.projectsImpactingAssets, this.alsoKnownAs, this.managedResources, this.noteLogs, this.staff, this.meetings, this.starRatings, this.schema, this.likes, this.tags, this.dataContent, this.metrics, this.facets, this.certifications, this.contributors, this.connections, this.comments, this.licenses, this.supportedDataSets, this.todos);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

